-- 公共SQL：生成调价指令（适用V2，用于直接使用气价明细调价的情况）
-- 必选参数
-- f_meter_brand：表具品牌别名
-- setPriceSync：调价记录同步状态字段

SELECT
    -- 业务记录ID
    setinfo.id,
    -- 表档案ID
    setinfo.userid,
    -- 表档案编号
    setinfo.f_user_id,
    -- 表号
    setinfo.f_meternumber,
    -- 户编号
    setinfo.f_userinfo_id,
    -- 卡号
    setinfo.f_card_id,
    -- 余额
    setinfo.f_balance_amount balance_amount,
    -- 气价ID
    setinfo.stairid,
    -- 旧气价ID
    setinfo.oldstairid,
    -- 阶梯开始时间
    setinfo.start_date,
    -- 价格生效时间
    setinfo.f_perform_date,
    -- 阶梯周期（月）
    setinfo.f_stairmonths,
    -- 是否采暖气价
    setinfo.f_isheat,
    -- 调价类型
    setinfo.type,
    -- 气价方案编号
    setinfo.f_price_id,
    -- 价格版本
    setinfo.priceversion,
    -- 结算类型（按金额，按气量）
    setinfo.f_collection_type,
    -- 气表型号
    setinfo.f_meter_style,
    --价格名称
    setinfo.f_price_name
FROM (
    SELECT p.id                                           id,
           u.f_user_id                                    userid,
           u.f_user_id,
           u.f_userinfo_id,
           u.f_balance_amount,
           u.f_meternumber,
           ISNULL(u.f_card_id, u.f_meternumber)           f_card_id,
           s.id                                           stairId,
           p.f_oldprice_id                                oldstairid,
           u.f_price_id,
           s.f_version + u.f_price_version                priceversion,
           ISNULL(s.f_stair_start_date, s.f_perform_date) start_date,
           p.f_perform_date                               f_perform_date,
           ISNULL(s.f_stairmonths, 1)                     f_stairmonths,
           m.f_meter_style                                f_meter_style,
           0 f_isheat,
           g.f_collection_type,
           s.f_price_name,
           '批量调价'                                      type
    FROM t_pricechange p
        LEFT JOIN t_stairprice s ON s.id = p.f_newprice_id
        INNER JOIN t_userfiles u ON u.f_price_id = s.f_price_id and u.f_filialeids = s.f_filialeids
        LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
        LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
    WHERE s.f_state = '有效'
      AND getdate() >= s.f_perform_date
      and getdate() <= s.f_end_date
      AND (p.${setPriceSync} = '未同步' or p.${setPriceSync} IS NULL)
      AND p.f_change_type = '批量'
      AND u.f_sendsuccess = '成功'
      AND u.f_table_state IN ('正常' ,'停用')
      AND u.f_gasbrand_id IN (${gasBrandIds})
    UNION ALL
    SELECT p.id                                           id,
           u.f_user_id                                    userid,
           u.f_user_id,
           u.f_userinfo_id,
           u.f_balance_amount,
           u.f_meternumber,
           ISNULL(u.f_card_id, u.f_meternumber)           f_card_id,
           s.id                                           stairId,
           p.f_oldprice_id                                oldstairid,
           u.f_price_id,
           s.f_version + u.f_price_version                priceversion,
           ISNULL(s.f_stair_start_date, s.f_perform_date) start_date,
           p.f_perform_date                               f_perform_date,
           ISNULL(s.f_stairmonths, 1)                     f_stairmonths,
           m.f_meter_style                                f_meter_style,
           0 f_isheat,
           g.f_collection_type,
           s.f_price_name,
           '单表调价'                                      type
    FROM t_pricechange p
        INNER JOIN t_userfiles u ON u.f_userinfo_id = p.f_userinfo_id
        LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
        LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
        LEFT JOIN t_stairprice s ON s.id = p.f_newprice_id and u.f_filialeids = s.f_filialeids
    WHERE s.f_state = '有效'
      AND getdate() >= s.f_perform_date
      and getdate() <= s.f_end_date
      AND (p.${setPriceSync} = '未同步' or p.${setPriceSync} IS NULL)
      AND p.f_change_type = '单户'
      AND u.f_sendsuccess = '成功'
      AND u.f_table_state IN ('正常' ,'停用')
      AND u.f_gasbrand_id IN (${gasBrandIds})
) setinfo
