package com.aote.webmeter.tools.iot.ctwing;

import com.aote.webmeter.enums.CTWingPlatformType;

/**
 * 中国电信天翼物联网CTWing平台接口Api(OC/OC2/OC兼容AEP模式)
 *
 * @apiNote 仅作为对OC/AEP兼容OC模式的兼容
 * @see <a href="https://www.ctwing.cn/developer/">中国电信天翼物联网CTWing门户网站</a>
 */
public class CTWingApi {
    // OC版本基础地址
    private static final String OC_URL = "https://device.api.ct10649.com:8743";
    // AEP版本基础地址
    private static final String AEP_URL = "http://ag-api.ctwing.cn";
    /**
     * 鉴权接口
     */
    private static final String AUTH_URL = "/iocm/app/sec/v1.1.0/login";
    /**
     * 刷新鉴权接口
     */
    private static final String REFRESH_AUTH_URL = "/iocm/app/sec/v1.1.0/refreshToken";
    /**
     * 创建设备接口
     */
    private static final String DEVICE_CREATE_URL = "/iocm/app/reg/v1.1.0/deviceCredentials";
    /**
     * 更新设备接口
     */
    private static final String DEVICE_UPDATE_URL = "/iocm/app/dm/v1.4.0/devices";
    /**
     * 命令下发接口
     */
    private static final String SEND_INSTRUCT_URL = "/iocm/app/cmd/v1.4.0/deviceCommands";
    /**
     * 消息订阅接口
     */
    private static final String SUBSCRIPTIONS_URL = "/iocm/app/sub/v1.2.0/subscriptions";

    public static String getAuthUrl() {
        return getAuthUrl(null);
    }

    public static String getAuthUrl(String baseUrl) {
        return getUrl(baseUrl) + AUTH_URL;
    }

    public static String getRefreshAuthUrl() {
        return getRefreshAuthUrl(null);
    }

    public static String getRefreshAuthUrl(String baseUrl) {
        return getUrl(baseUrl) + REFRESH_AUTH_URL;
    }

    public static String getDeviceCreateUrl() {
        return getDeviceCreateUrl(null);
    }

    public static String getDeviceCreateUrl(String baseUrl) {
        return getUrl(baseUrl) + DEVICE_CREATE_URL;
    }

    public static String getDeviceUpdateUrl() {
        return getDeviceUpdateUrl(null);
    }

    public static String getDeviceUpdateUrl(String baseUrl) {
        return getUrl(baseUrl) + DEVICE_UPDATE_URL;
    }

    public static String getSendInstructUrl() {
        return getSendInstructUrl(null);
    }

    public static String getSendInstructUrl(String baseUrl) {
        return getUrl(baseUrl) + SEND_INSTRUCT_URL;
    }

    public static String getSubscriptionsUrl() {
        return getSubscriptionsUrl(null);
    }

    public static String getSubscriptionsUrl(String baseUrl) {
        return getUrl(baseUrl) + SUBSCRIPTIONS_URL;
    }

    private static String getUrl() {
        return getUrl(null);
    }

    private static String getUrl(String baseUrl) {
        if (baseUrl != null) {
            return baseUrl;
        }
        CTWingPlatformType platformType = CTWingApiService.getPlatformType();
        if (platformType == CTWingPlatformType.OC) {
            return OC_URL;
        } else if (platformType == CTWingPlatformType.AEP) {
            return AEP_URL;
        } else {
            throw new RuntimeException("平台类型:" + CTWingPlatformType.OC2.name() + "必须指定自定义URL");
        }
    }
}
