package com.aote.webmeter.server.udp;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;

/**
 * UDP服务
 *
 * @author Mrriver
 */
@Deprecated
public class UdpServer extends Thread {
    private static Logger log = Logger.getLogger(UdpServer.class);
    /**
     * UDP服务名称
     */
    private final String name;
    /**
     * UDP通道
     */
    private Selector selector;
    /**
     * UDP端口
     */
    private int port;
    /**
     * logic对象
     */
    private LogicServer service;
    /**
     * logic名称
     */
    private String logicName;
    /**
     * UDP接收消息类型
     */
    private MsgTypeEnum msgReceiveType;
    /**
     * UDP发送消息类型
     */
    private MsgTypeEnum msgSendType;

    public UdpServer(String name, String logicName, int port, LogicServer service, MsgTypeEnum msgReceiveType, MsgTypeEnum msgSendType) {
        this.name = name;
        this.logicName = logicName;
        this.port = port;
        this.service = service;
        this.msgReceiveType = msgReceiveType;
        this.msgSendType = msgSendType;
    }

    /**
     * 获得一个ServerSocket通道，并对该通道做一些初始化的工作  
     */
    private void initServer() {
        try {
            // 获得一个ServerSocket通道
            DatagramChannel serverChannel = DatagramChannel.open();
            // 设置通道为非阻塞
            serverChannel.configureBlocking(false);
            // 将该通道对应的ServerSocket绑定到port端口
            serverChannel.socket().bind(new InetSocketAddress(port));
            // 获得一个通道管理器
            this.selector = Selector.open();
            // 注册事件
            serverChannel.register(selector, SelectionKey.OP_READ);
            // 监听事件
            listen();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listen() {
        log.debug("UDP服务端【" + name + "】的【" + port + "】端口启动成功！");
        // 轮询访问selector
        while (true) {
            try {
                //当注册的事件到达时，方法返回；否则,该方法会一直阻塞
                selector.select();
                //获得selector中选中的项的迭代器，选中的项为注册的事件
                Iterator<SelectionKey> ite = this.selector.selectedKeys().iterator();
                while (ite.hasNext()) {
                    SelectionKey key = ite.next();
                    // 删除已选的key,以防重复处理
                    ite.remove();
                    // 获得了可读的事件
                    if (key.isReadable()) {
                        read(key);
                    }
                }
            } catch (Exception e) {
                log.error("UDP服务器发生错误：", e);
            }
        }
    }

    private void read(SelectionKey key) throws IOException {
        // 服务器可读取消息:得到事件发生的Socket通道
        DatagramChannel channel = (DatagramChannel) key.channel();
        // 设置成非阻塞
        channel.configureBlocking(false);
        // 创建读取的缓冲区
        ByteBuffer buffer = ByteBuffer.allocate(512);
        SocketAddress client;
        try {
            client = channel.receive(buffer);
        } catch (IOException e) {
            log.debug(channel.getRemoteAddress() + "断开连接...");
            channel.close();
            log.debug("清除缓存...");
            buffer.clear();
            return;
        }
        byte[] data = buffer.array();
        String msg;
        switch (msgReceiveType) {
            case NORMAL:
            default:
                msg = ConvertTools.bytesToStr(data);
                break;
            case HEX:
                msg = ConvertTools.byteToHexStr(data);
                break;
        }
        // 去除空格，尾部0，转大写 (该写法原用于处理一些地方由于缓冲区写入的数据尾部带有0导致解析异常的问题，
        // 但该写法得到的数据在莱德UDP表中出现了解析失败的情况，因在此处取消)
        // msg = msg.trim().replaceAll("0*$","").toUpperCase();
        // log.debug("服务端收到处理后信息："+msg);
        //去除空格
        msg = msg.trim();
        log.debug("服务端收到信息：" + msg);
        JSONObject params = new JSONObject();
        params.put("data", new JSONObject().put("value", msg));
        try {
            String result = String.valueOf(service.run(logicName, params));
            log.debug("服务端返回信息：" + result);
            if (result != null && !result.equals("ok")) {
                byte[] sendMsgBytes;
                ByteBuffer outBuffer;
                switch (msgSendType) {
                    case NORMAL:
                    default:
                        sendMsgBytes = result.getBytes();
                        break;
                    case BASE64:
                        sendMsgBytes = ConvertTools.base64Decode(result.getBytes());
                        break;
                    case HEX:
                        sendMsgBytes = ConvertTools.hexStrToByte(result);
                        break;
                    case HEX_BASE64:
                        sendMsgBytes = ConvertTools.base64Decode(ConvertTools.hexStrToByte(result));
                        break;
                }
                outBuffer = ByteBuffer.wrap(sendMsgBytes);
                channel.send(outBuffer, client);
            }
        } catch (Exception e) {
            log.error("出现异常：", e);
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        initServer();
    }
}
