package com.aote.webmeter.mapper;

import com.aote.redis.RedisUtil;
import com.aote.rs.SqlService;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * 物联网告警策略映射器
 *
 * @author Mrriver
 * @date 2023/2/14
 */
@Component
public class AlarmStrategyMapper {
    public static final String IS_LOADED_KEY = "ALARM_STRATEGY_IS_LOADED";
    public static final String NO_LOAD_FLAG = "0";
    public static final String LOADED_FLOG = "1";
    public static final String ALARM_STRATEGY_KEY = "IOT_SY";
    private static final Logger LOGGER = Logger.getLogger(AlarmStrategyMapper.class);
    private static final String QUERY_SQL = "SELECT * FROM t_iot_device_alarm_strategy WHERE f_state = 1 ORDER BY f_alarm_brand_id";

    private static final String DEVICE_BRAND_QUERY_SQL = "SELECT id, f_alias FROM t_iot_device_brand";

    @Autowired
    private SqlService sqlService;

    @PostConstruct
    public void load() {
        RedisUtil redisUtil = RedisUtil.getInstance();
        if (redisUtil != null) {
            redisUtil.syncLock(IS_LOADED_KEY, 300, () -> {
                Object isLoaded = redisUtil.get(IS_LOADED_KEY);
                if (isLoaded == null || NO_LOAD_FLAG.equals(isLoaded)) {
                    JSONArray result = null;
                    try {
                        result = new JSONArray(sqlService.txQuery(QUERY_SQL));
                    } catch (Exception e) {
                        LOGGER.warn("物联网告警策略(t_iot_device_alarm_strategy)查询失败，不再加载告警策略配置");
                    }
                    if (result != null) {
                        Map<Integer, String> deviceBrandMap;
                        try {
                            JSONArray deviceBrandList = new JSONArray(sqlService.txQuery(DEVICE_BRAND_QUERY_SQL));
                            deviceBrandMap = new HashMap<>(deviceBrandList.length());
                            for (Object item : deviceBrandList) {
                                JSONObject itemObj = (JSONObject) item;
                                deviceBrandMap.put(itemObj.getInt("id"), itemObj.getString("f_alias"));
                            }
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        JSONObject data = new JSONObject();
                        for (Object o : result) {
                            JSONArray valueArray;
                            JSONObject item = (JSONObject) o;
                            String alias = deviceBrandMap.get(item.getInt("f_alarm_brand_id"));
                            if (data.has(alias)) {
                                valueArray = data.getJSONArray(alias);
                            } else {
                                valueArray = new JSONArray();
                                data.put(alias, valueArray);
                            }
                            valueArray.put(item);
                        }
                        //存储数据
                        redisUtil.set(ALARM_STRATEGY_KEY, data);
                        //修改加载标识
                        redisUtil.set(IS_LOADED_KEY, LOADED_FLOG);
                        LOGGER.debug("物联网告警策略预加载完成");
                    }
                } else {
                    LOGGER.debug("跳过加载物联网告警策略表");
                }
            });
        }
    }

    public void clearCache() {
        RedisUtil redisUtil = RedisUtil.getInstance();
        if (redisUtil != null) {
            redisUtil.syncLock(AlarmStrategyMapper.IS_LOADED_KEY, 20, () -> redisUtil.set(AlarmStrategyMapper.IS_LOADED_KEY, AlarmStrategyMapper.NO_LOAD_FLAG));
            load();
        }
    }
}
