/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.sc.ssp.uc.client.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static Logger logger = LoggerFactory.getLogger(SignUtil.class);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String encodingAlgorithm = "MD5";
    private static String characterEncoding;

    private static String getFormattedText(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int j = 0; j < bytes.length; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }

    public static String md5Encode(String password) {
        if (password == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(encodingAlgorithm);
            if (!StringUtils.isEmpty((String)characterEncoding)) {
                messageDigest.update(password.getBytes(characterEncoding));
            } else {
                messageDigest.update(password.getBytes());
            }
            byte[] digest = messageDigest.digest();
            return SignUtil.getFormattedText(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptAES(String content, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] byteContent = content.getBytes("UTF-8");
        byte[] enCodeFormat = key.getBytes();
        SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, "AES");
        byte[] initParam = key.getBytes();
        IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        byte[] encryptedBytes = cipher.doFinal(byteContent);
        Base64 base64 = new Base64();
        return base64.encodeAsString(encryptedBytes);
    }

    public static String decryptAES(String content, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException {
        Base64 base64 = new Base64();
        byte[] encryptedBytes = base64.decode(content);
        byte[] enCodeFormat = key.getBytes();
        SecretKeySpec secretKey = new SecretKeySpec(enCodeFormat, "AES");
        byte[] initParam = key.getBytes();
        IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretKey, ivParameterSpec);
        byte[] result = cipher.doFinal(encryptedBytes);
        return new String(result, "UTF-8");
    }

    public static String produceData(Map<String, String> params) {
        StringBuilder data = new StringBuilder();
        Set<String> keyset = params.keySet();
        ArrayList<String> list = new ArrayList<String>(keyset);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            data.append((String)list.get(i) + "=" + params.get(list.get(i)));
            if (i == list.size() - 1) continue;
            data.append("&");
        }
        String p = null;
        try {
            p = URLEncoder.encode(data.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        System.out.println(p);
        return p;
    }

    public static void main(String[] args) throws NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, IOException, InvalidKeyException {
        String appCode = "test";
        String appSecret = "1234567812345678";
        String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("time", time);
        params.put("appCode", appCode);
        params.put("token", "3f3b65a22d7942a4ad44bd38c0d646b9");
        String paramStr = SignUtil.produceData(params);
        String dataStr = paramStr + appSecret;
        String sign = SignUtil.md5Encode(dataStr);
        System.out.println("\u7b7e\u540dsign:" + sign);
        System.out.println("=========AES\u89e3\u5bc6\u793a\u4f8b=========");
        String encryptAES = SignUtil.encryptAES("\u609f\u7a7a123", appSecret);
        System.out.println("\u5bc6\u6587\uff1a" + encryptAES);
        String decryptAES = SignUtil.decryptAES(encryptAES, appSecret);
        System.out.println("\u660e\u6587\uff1a" + decryptAES);
    }
}

