/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.sc.ssp.uc.client.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATESTR_FORMATTER_GA = "yyyyMMddHHmmss";

    public static DateFormat getDateFormat() {
        return DateFormat.getDateInstance(1, Locale.CHINA);
    }

    public static String formatYearMonth(Date date) {
        return DateUtils.doFormatDate(date, "yyyy-MM");
    }

    public static int getSeasons(Date date) {
        int m = DateUtils.getMonth(date);
        if (m <= 0) {
            return 0;
        }
        if (m < 4) {
            return 1;
        }
        if (m < 7) {
            return 2;
        }
        if (m < 10) {
            return 3;
        }
        if (m < 13) {
            return 4;
        }
        return 0;
    }

    public static Date getNowSeasonsFirstDay(Date date) {
        int m = DateUtils.getSeasons(date);
        if (m > 0) {
            if (m == 1) {
                return DateUtils.stringToDate(DateUtils.getYear(date) + "-01-01");
            }
            if (m == 2) {
                return DateUtils.stringToDate(DateUtils.getYear(date) + "-04-01");
            }
            if (m == 3) {
                return DateUtils.stringToDate(DateUtils.getYear(date) + "-07-01");
            }
            return DateUtils.stringToDate(DateUtils.getYear(date) + "-10-01");
        }
        return null;
    }

    public static Date getYearLastDay(String year) {
        if (year == null || "".equals(year)) {
            return null;
        }
        Date nd = DateUtils.stringToDate(year + "-01-01");
        return DateUtils.addDay(DateUtils.addYear(nd, 1), -1);
    }

    public static Date getNextMonthFirstDay(String year, String month) {
        if (year == null || "".equals(year) || month == null || "".equals(month)) {
            return null;
        }
        Date nd = DateUtils.stringToDate(year + "-" + month + "-01");
        return DateUtils.addMonth(nd, 1);
    }

    public static Date getMonthLastDay(String year, String month) {
        if (year == null || "".equals(year) || month == null || "".equals(month)) {
            return null;
        }
        Date nd = DateUtils.stringToDate(year + "-" + month + "-01");
        return DateUtils.addDay(DateUtils.addMonth(nd, 1), -1);
    }

    public static Date addSecond(Date startDate, int addnos) {
        if (startDate == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(startDate);
        cc.add(13, addnos);
        return cc.getTime();
    }

    public static Date addMinute(Date startDate, int addnos) {
        if (startDate == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(startDate);
        cc.add(12, addnos);
        return cc.getTime();
    }

    public static Date addHour(Date startDate, int addnos) {
        if (startDate == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(startDate);
        cc.add(10, addnos);
        return cc.getTime();
    }

    public static Date addDay(Date startDate, int addnos) {
        if (startDate == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(startDate);
        cc.add(5, addnos);
        return cc.getTime();
    }

    public static Date addMonth(Date startDate, int addnos) {
        if (startDate == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(startDate);
        cc.add(2, addnos);
        return cc.getTime();
    }

    public static Date addYear(Date startDate, int addnos) {
        if (startDate == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(startDate);
        cc.add(1, addnos);
        return cc.getTime();
    }

    public static int compareMonth(Date st, Date end) {
        int y = Math.abs((DateUtils.getYear(end) < 0 ? 0 : DateUtils.getYear(end)) - (DateUtils.getYear(st) < 0 ? 0 : DateUtils.getYear(st)));
        int m = 0;
        if (y > 0) {
            --y;
            m = Math.abs(12 - DateUtils.getMonth(st) + DateUtils.getMonth(end));
        } else {
            m = Math.abs(DateUtils.getMonth(end) - DateUtils.getMonth(st));
        }
        return y * 12 + m;
    }

    public static long compare(Date start, Date end) {
        if (start != null && end != null) {
            return end.getTime() - start.getTime();
        }
        return 0L;
    }

    public static boolean compareDate(Date date) {
        if (date != null) {
            return date.before(DateUtils.stringToDate(DateUtils.doFormatDate(new Date(), false)));
        }
        return false;
    }

    public static String doFormatDate(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static Date strToDate(String strDate, String formate) {
        SimpleDateFormat formatter = new SimpleDateFormat(formate);
        Date strtodate = null;
        try {
            strtodate = formatter.parse(strDate);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return strtodate;
    }

    public static String doFormatDate(Date date, boolean b) {
        if (date == null) {
            return null;
        }
        if (b) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static Date stringToDate(String datestr) {
        if (datestr != null && !"".equals(datestr)) {
            SimpleDateFormat sdf = datestr.indexOf(":") != -1 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA) : new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
            Date date = null;
            try {
                date = sdf.parse(datestr);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return date;
        }
        return null;
    }

    public static String getDates(boolean b) {
        return DateUtils.doFormatDate(new Date(), b);
    }

    public static int getYear() {
        return DateUtils.getYear(new Date());
    }

    public static int getYear(Date date) {
        if (date == null) {
            return -1;
        }
        return DateUtils.DateToCalendar(date).get(1);
    }

    public static int getMonth() {
        return DateUtils.getMonth(new Date());
    }

    public static int getMonth(Date date) {
        if (date == null) {
            return 0;
        }
        return DateUtils.DateToCalendar(date).get(2) + 1;
    }

    public static int getDay() {
        return DateUtils.getDay(new Date());
    }

    public static int getDay(Date da) {
        if (da == null) {
            return 0;
        }
        return DateUtils.DateToCalendar(da).get(5);
    }

    public static Calendar DateToCalendar(Date dd) {
        Calendar cc = Calendar.getInstance();
        cc.setTime(dd);
        return cc;
    }

    public static Date longToDate(long datenum) {
        Calendar cc = Calendar.getInstance();
        cc.setTimeInMillis(datenum);
        return cc.getTime();
    }

    public static String longToDateString(long datenum) {
        return DateUtils.doFormatDate(DateUtils.longToDate(datenum), true);
    }

    public static Date getUpWeekDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(date);
        int week = cc.get(7);
        return DateUtils.addDay(date, 1 - week);
    }

    public static Date getMonday(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(date);
        int week = cc.get(7);
        return DateUtils.addDay(date, 2 - week);
    }

    public static int getWeek(Date date) {
        if (date == null) {
            return -1;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(date);
        int week = cc.get(7);
        week = week == 1 ? 7 : --week;
        return week;
    }

    public static String getRandNum(int lo) {
        if (lo < 1) {
            lo = 4;
        }
        StringBuffer temp = new StringBuffer();
        Random rand = new Random();
        for (int i = 0; i < lo; ++i) {
            temp.append(String.valueOf(rand.nextInt(10)));
        }
        return temp.toString();
    }

    public static String getDataName() {
        return DateUtils.doFormatDate(new Date(), DATESTR_FORMATTER_GA) + DateUtils.getRandNum(4);
    }

    public static Timestamp dateToTime(Date dt) {
        if (dt == null) {
            return null;
        }
        return new Timestamp(dt.getTime());
    }

    public static Timestamp string2Time(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.SSS", Locale.ENGLISH);
        dateFormat.setLenient(false);
        Date ywybirt = DateFormat.getDateInstance().parse(dateString);
        Timestamp dateTime = new Timestamp(ywybirt.getTime());
        return dateTime;
    }

    public static java.sql.Date dateToSqlDate(Date de) {
        return new java.sql.Date(de.getTime());
    }

    public static String formatDS(String date) {
        if (date == null) {
            return "";
        }
        return date.replace("-", "").replace(":", "").replace(" ", "");
    }

    public static Date strTdate(String datestr) {
        if (datestr != null && !"".equals(datestr)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
            Date date = null;
            try {
                date = sdf.parse(datestr);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return date;
        }
        return null;
    }

    public static String getGabDate() {
        return DateUtils.doFormatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String str2StrDate(String datestr) {
        Date dd = DateUtils.strTdate(datestr);
        if (dd != null) {
            return DateUtils.doFormatDate(dd, true);
        }
        return null;
    }

    public static String DateAddYear(String datetime, int year) {
        String rtnVal = "";
        Date date = null;
        date = DateUtils.addYear(DateUtils.strTdate(datetime), year);
        rtnVal = DateUtils.formatDS(DateUtils.doFormatDate(date, true));
        return rtnVal;
    }

    public static String DateAddMonth(String date, int month, String time) {
        String rtnVal = "";
        date = DateUtils.formatDS(date);
        Date datetime = null;
        String temp = DateUtils.formatDS(date) + time;
        datetime = DateUtils.addMonth(DateUtils.strTdate(temp), month);
        temp = DateUtils.doFormatDate(datetime, true);
        rtnVal = DateUtils.formatDS(temp);
        return rtnVal;
    }

    public static String timeFormate(String time) {
        if (time == null || time.length() < 14) {
            return time;
        }
        StringBuilder str = new StringBuilder();
        str.append(time.substring(0, 4)).append("-").append(time.substring(4, 6)).append("-").append(time.substring(6, 8)).append(" ").append(time.substring(8, 10)).append(":").append(time.substring(10, 12)).append(":").append(time.substring(12, 14));
        return str.toString();
    }

    public static String datetimeFormate(String time) {
        if (StringUtils.isBlank((String)time)) {
            return time;
        }
        if (time.length() == 14 || time.length() == 8) {
            StringBuilder str = new StringBuilder();
            str.append(time.substring(0, 4)).append("-").append(time.substring(4, 6)).append("-").append(time.substring(6, 8));
            return str.toString();
        }
        return time;
    }

    public static String getCurrentGaDate() {
        return DateUtils.doFormatDate(new Date(), DATESTR_FORMATTER_GA);
    }
}

