/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.sc.ssp.uc.client.util;

import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherUtil {
    public static Logger logger = LoggerFactory.getLogger(CipherUtil.class);
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String generatePassword(String inputString) {
        return CipherUtil.encodeByMD5(inputString);
    }

    public static boolean validatePassword(String password, String inputString) {
        return password.equals(CipherUtil.encodeByMD5(inputString));
    }

    private static String encodeByMD5(String originString) {
        if (originString != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] results = md.digest(originString.getBytes());
                String resultString = CipherUtil.byteArrayToHexString(results);
                return resultString.toUpperCase();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(CipherUtil.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}

