/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.sc.ssp.uc.client.filter;

import com.iflytek.sc.ssp.uc.client.filter.FilterInvocation;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFilterChain
implements FilterChain {
    Logger logger = LoggerFactory.getLogger(VirtualFilterChain.class);
    private FilterInvocation fi;
    private Filter[] additionalFilters;
    private int currentPosition = 0;

    public VirtualFilterChain(FilterInvocation filterInvocation, Filter[] additionalFilters) {
        this.fi = filterInvocation;
        this.additionalFilters = additionalFilters;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.currentPosition == this.additionalFilters.length) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.fi.getRequestUrl() + " reached end of additional filter chain; proceeding with original chain");
            }
            this.fi.getChain().doFilter(request, response);
        } else {
            ++this.currentPosition;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.fi.getRequestUrl() + " at position " + this.currentPosition + " of " + this.additionalFilters.length + " in additional filter chain; firing Filter: '" + this.additionalFilters[this.currentPosition - 1] + "'");
            }
            this.additionalFilters[this.currentPosition - 1].doFilter(request, response, (FilterChain)this);
        }
    }
}

