/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.sc.ssp.uc.client.filter;

import com.iflytek.sc.ssp.uc.client.filter.FilterInvocation;
import javax.servlet.http.HttpServletRequest;

public class UrlUtils {
    private static String buildFullRequestUrl(String scheme, String serverName, int serverPort, String contextPath, String requestUrl, String servletPath, String requestURI, String pathInfo, String queryString) {
        boolean includePort = true;
        if ("http".equals(scheme.toLowerCase()) && serverPort == 80) {
            includePort = false;
        }
        if ("https".equals(scheme.toLowerCase()) && serverPort == 443) {
            includePort = false;
        }
        return scheme + "://" + serverName + (includePort ? ":" + serverPort : "") + contextPath + UrlUtils.buildRequestUrl(servletPath, requestURI, contextPath, pathInfo, queryString);
    }

    private static String buildRequestUrl(String servletPath, String requestURI, String contextPath, String pathInfo, String queryString) {
        String uri = servletPath;
        if (uri == null) {
            uri = requestURI;
            uri = uri.substring(contextPath.length());
        }
        return uri + (pathInfo != null ? pathInfo : "") + (queryString != null ? "?" + queryString : "");
    }

    public static String getFullRequestUrl(FilterInvocation fi) {
        HttpServletRequest r = fi.getHttpRequest();
        return UrlUtils.buildFullRequestUrl(r.getScheme(), r.getServerName(), r.getServerPort(), r.getContextPath(), r.getRequestURL().toString(), r.getServletPath(), r.getRequestURI(), r.getPathInfo(), r.getQueryString());
    }

    public static String getRequestUrl(FilterInvocation fi) {
        HttpServletRequest r = fi.getHttpRequest();
        return UrlUtils.buildRequestUrl(r.getServletPath(), r.getRequestURI(), r.getContextPath(), r.getPathInfo(), r.getQueryString());
    }
}

