/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.sc.ssp.uc.client.filter;

import com.iflytek.sc.ssp.uc.client.constant.SslUtils;
import com.iflytek.sc.ssp.uc.client.constant.UCConstant;
import com.iflytek.sc.ssp.uc.client.context.UCCasServiceContext;
import com.iflytek.sc.ssp.uc.client.filter.AuthenticationFilter;
import com.iflytek.sc.ssp.uc.client.filter.FilterInvocation;
import com.iflytek.sc.ssp.uc.client.filter.VirtualFilterChain;
import com.iflytek.sc.ssp.uc.client.util.RegexUrlPathMatcher;
import com.iflytek.sc.ssp.uc.client.util.UrlMatcher;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashSet;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.util.AbstractConfigurationFilter;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChainProxy
extends AbstractConfigurationFilter {
    Logger logger = LoggerFactory.getLogger(FilterChainProxy.class);
    private Filter[] filters;
    private UrlMatcher urlMatcher = new RegexUrlPathMatcher();
    private UCConstant ucConstant;
    private String casAuthAjaxContext;
    private int sessionTimeOut = 30;

    public void destroy() {
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i] == null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Destroying Filter defined in ApplicationContext: '" + this.filters[i].toString() + "'");
            }
            this.filters[i].destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.logger.debug("\u8fdb\u5165FilterChainProxy\u8fdb\u884c\u62e6\u622a...");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session != null && this.sessionTimeOut > 0) {
            session.setMaxInactiveInterval(this.sessionTimeOut * 60);
        }
        if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).setHeader("P3P", "CP=CAO PSA OUR IDC DSP COR ADM DEVi TAIi PSD IVAi IVDi CONi HIS IND CNT");
        }
        String ticket = request.getParameter("ticket");
        String url = httpRequest.getServletPath();
        String pathInfo = httpRequest.getPathInfo();
        if (StringUtils.isNotBlank((String)pathInfo)) {
            url = url + pathInfo;
        }
        this.logger.debug("\u8bbf\u95ee\u7684url:{}", (Object)url);
        if (!this.isResource(url) && StringUtils.isBlank((String)ticket)) {
            chain.doFilter(request, response);
            return;
        }
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        if (this.filters.length == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(fi.getRequestUrl() + " has an empty filter list");
            }
            chain.doFilter(request, response);
            return;
        }
        VirtualFilterChain virtualFilterChain = new VirtualFilterChain(fi, this.filters);
        virtualFilterChain.doFilter(fi.getRequest(), fi.getResponse());
    }

    private boolean isResource(String url) {
        String[] urls;
        if (StringUtils.isNotBlank((String)this.ucConstant.getNoAuthorizationUrls())) {
            for (String url1 : urls = StringUtils.split((String)this.ucConstant.getNoAuthorizationUrls(), (String)",")) {
                if (!this.urlMatcher.pathMatchesUrl(this.urlMatcher.compile(url1), url)) continue;
                return false;
            }
        }
        if (StringUtils.isNotBlank((String)this.ucConstant.getAuthorizationUrls())) {
            for (String url1 : urls = StringUtils.split((String)this.ucConstant.getAuthorizationUrls(), (String)",")) {
                if (!this.urlMatcher.pathMatchesUrl(this.urlMatcher.compile(url1), url)) continue;
                return true;
            }
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.logger.info("\u5355\u70b9\u767b\u5f55\u914d\u7f6e\u521d\u59cb\u5316\u5f00\u59cb...");
        try {
            SslUtils.ignoreSsl();
        }
        catch (Exception e1) {
            this.logger.error(e1.getMessage(), (Throwable)e1);
        }
        String timeOut = filterConfig.getInitParameter("timeOut");
        if (StringUtils.isNumeric((String)timeOut)) {
            this.sessionTimeOut = Integer.parseInt(timeOut);
        }
        this.casAuthAjaxContext = filterConfig.getInitParameter("casAuthAjaxContext");
        UCConstant ucConstant = null;
        if (this.ucConstant == null) {
            URL url;
            this.logger.info("\u8bfb\u53d6\u5e38\u89c4\u7684\u914d\u7f6e\u6587\u4ef6uc-client...");
            Properties p = new Properties();
            ucConstant = new UCConstant();
            String ucConfig = filterConfig.getInitParameter("uc-config");
            this.logger.info("ucConfig=" + ucConfig);
            String moduleName = filterConfig.getInitParameter("moduleName");
            if (StringUtils.isNotBlank((String)ucConfig)) {
                try {
                    if (ucConfig.endsWith("xml")) {
                        p.loadFromXML(new FileInputStream(ucConfig));
                    } else if (ucConfig.endsWith("properties")) {
                        p.load(new FileInputStream(ucConfig));
                    } else {
                        ucConfig = System.getenv(ucConfig);
                        String configFilePath = ucConfig + "/" + moduleName + "/uc-client.properties";
                        p.load(new FileInputStream(configFilePath));
                    }
                }
                catch (InvalidPropertiesFormatException e) {
                    this.logger.warn("\u5916\u90e8\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef:{}", (Object)ucConfig);
                }
                catch (FileNotFoundException e) {
                    this.logger.warn("\u5916\u90e8\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)ucConfig);
                }
                catch (IOException e) {
                    this.logger.warn("\u5916\u90e8\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef:{}", (Object)ucConfig);
                }
            }
            if (p.isEmpty()) {
                url = ((Object)((Object)this)).getClass().getClassLoader().getResource("/config/uc-client.xml");
                try {
                    if (url != null) {
                        p.loadFromXML(new FileInputStream(url.getFile()));
                    }
                }
                catch (InvalidPropertiesFormatException e) {
                    this.logger.warn("\u7c7b\u8def\u5f84\u4e2d\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1auc-client.xml");
                }
                catch (FileNotFoundException e) {
                    this.logger.warn("\u7c7b\u8def\u5f84\u4e2d\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff1auc-client.xml");
                }
                catch (IOException e) {
                    this.logger.warn("\u7c7b\u8def\u5f84\u4e2d\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff1auc-client.xml");
                }
                catch (Exception e) {
                    this.logger.warn("\u7c7b\u8def\u5f84\u4e2d\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff1auc-client.xml");
                }
            }
            if (p.isEmpty()) {
                url = ((Object)((Object)this)).getClass().getClassLoader().getResource("/config/uc-client.properties");
                try {
                    if (url != null) {
                        p.load(new FileInputStream(url.getFile()));
                    }
                }
                catch (InvalidPropertiesFormatException e) {
                    this.logger.warn("\u7c7b\u8def\u5f84\u4e2d\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef:uc-client.properties");
                }
                catch (FileNotFoundException e) {
                    this.logger.warn("\u7c7b\u8def\u5f84\u4e2d\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728:uc-client.properties");
                }
                catch (IOException e) {
                    this.logger.warn("\u7c7b\u8def\u5f84\u4e2d\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef:uc-client.properties");
                }
                catch (Exception e) {
                    this.logger.warn("\u7c7b\u8def\u5f84\u4e2d\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef:uc-client.properties");
                }
            }
            if (p.isEmpty()) {
                this.logger.error("uc-client\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff01");
            }
            ucConstant.setAppCode(p.getProperty("uccp.client.appCode"));
            ucConstant.setAppSecret(p.getProperty("uccp.client.appSecret"));
            ucConstant.setCasClientContext(p.getProperty("cas.client.context"));
            ucConstant.setCasContext(p.getProperty("cas.context"));
            ucConstant.setCasValidContext(p.getProperty("cas.valid.context"));
            ucConstant.setCasContextLogin(p.getProperty("cas.context.login", "/login"));
            ucConstant.setCasContextLogout(p.getProperty("cas.context.logout", "/logout"));
            ucConstant.setAuthorizationUrls(p.getProperty("uccp.authorizationUrls"));
            ucConstant.setNoAuthorizationUrls(p.getProperty("uccp.noAuthorizationUrls"));
            ucConstant.setResturl(p.getProperty("uccp.service.url"));
            this.ucConstant = ucConstant;
        } else {
            ucConstant = this.ucConstant;
        }
        UCCasServiceContext.init(ucConstant);
        this.filters = this.obtainAllDefinedFilters(ucConstant);
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i] == null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initializing Filter defined in ApplicationContext: '" + this.filters[i].toString() + "'");
            }
            this.filters[i].init(filterConfig);
        }
    }

    private Filter[] obtainAllDefinedFilters(UCConstant ucConstant) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        SingleSignOutFilter ssof = new SingleSignOutFilter();
        ssof.setCasServerUrlPrefix(ucConstant.getCasContext());
        ssof.setIgnoreInitConfiguration(true);
        list.add(ssof);
        AuthenticationFilter authenticationFilter = new AuthenticationFilter();
        authenticationFilter.setCasServerLoginUrl(ucConstant.getLoginUrlWithAppCode());
        authenticationFilter.setServerName(ucConstant.getCasClientContext());
        authenticationFilter.setCasAuthAjaxContext(this.casAuthAjaxContext);
        authenticationFilter.setIgnoreInitConfiguration(true);
        list.add((Object)authenticationFilter);
        Cas20ProxyReceivingTicketValidationFilter validationFilter = new Cas20ProxyReceivingTicketValidationFilter();
        validationFilter.setUseSession(true);
        validationFilter.setServerName(ucConstant.getCasClientContext());
        validationFilter.setRedirectAfterValidation(true);
        validationFilter.setMillisBetweenCleanUps(60000);
        validationFilter.setIgnoreInitConfiguration(true);
        Cas20ServiceTicketValidator cas20ServiceTicketValidator = null;
        cas20ServiceTicketValidator = StringUtils.isNotBlank((String)ucConstant.getCasValidContext()) ? new Cas20ServiceTicketValidator(ucConstant.getCasValidContext()) : new Cas20ServiceTicketValidator(ucConstant.getCasContext());
        validationFilter.setTicketValidator((TicketValidator)cas20ServiceTicketValidator);
        list.add(validationFilter);
        list.add(new AssertionThreadLocalFilter());
        list.add(new HttpServletRequestWrapperFilter());
        return list.toArray(new Filter[0]);
    }

    public UCConstant getUCConstant() {
        return this.ucConstant;
    }

    public void setUaacConstant(UCConstant ucConstant) {
        this.ucConstant = ucConstant;
        UCCasServiceContext.init(ucConstant);
        this.filters = this.obtainAllDefinedFilters(ucConstant);
    }

    public void setUcConstant(UCConstant ucConstant) {
        this.logger.info("\u81ea\u5b9a\u4e49UCConstant");
        this.ucConstant = ucConstant;
    }
}

