package com.aote.rs;

import com.af.plugins.RSAUtil;

import com.af.plugins.timeoutReturn.TimeCache;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

@Component
@Path("login")
@Singleton
@Transactional
public class LoginCheck {

    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private TimeCache timeCache;

    static Logger log = Logger.getLogger(LoginCheck.class);
    @POST
    @Path("obtainAccess")
    public String obtainAccess(String params){
        if(params == null || "".equals(params)){
            throw new WebException(403,"参数不合法！！");
        }
        JSONObject resultobj = new JSONObject();
        System.out.println(params.toString());
        String name = "";
        try {
            params = RSAUtil.descrypt(params.toString());
            System.out.println("结果"+params.toString());
            JSONObject data = new JSONObject(params);
            name =  data.get("username") + "";
        }catch(Exception e) {
            throw new WebException(403,"参数不合法！！");
        }
        if(name == null || "".equals(name)){
            throw new WebException(403,"参数不合法！！");
        }
        log.debug("解密完成：name=" + name );
        JSONArray query = new JSONArray();
        try {
            query = sqlServer.query("select * from t_user where ename='"+name+"'");
        } catch (Exception e) {
            throw new WebException(504,"获取失败！！");
        }
        if(query.length() == 1){
            JSONObject userinfo = (JSONObject)query.get(0);
            resultobj.put("password",userinfo.getString("password"));
            resultobj.put("code",200);
        }else{
            throw new WebException(504,"获取失败！！");
        }
        return  RSAUtil.encrypt(resultobj.toString());
    }

    @POST
    @Path("security_check")
    public String security_check(String params){
        if(params == null || "".equals(params)){
            throw new WebException(403,"参数不合法！！");
        }
        JSONObject resultobj = new JSONObject();
        String username= "";
        String password = "";
        JSONArray query = new JSONArray();
        System.out.println(params.toString());
        try{
            params = RSAUtil.descrypt(params.toString());
            System.out.println("结果"+params.toString());
            JSONObject data = new JSONObject(params);
            username =  data.get("ename") + "";
            password  =  data.get("password") + "";
        }catch(Exception e){
            throw new WebException(403,"参数不合法！！");
        }
        if(username == null || "".equals(username) || password==null || "".equals(password) ){
            throw new WebException(403,"参数不合法！！");
        }
        try {
            query = sqlServer.query("select * from t_user where ename='"+username+"' and password='"+password+"'"  );

        } catch (Exception e) {
            throw new WebException(601,"校验失败，请检查账号密码！！");
        }
        if(query.length() == 1){
            JSONObject userinfo = (JSONObject)query.get(0);
            JSONObject saveObject = new JSONObject();
            saveObject.put("ename",userinfo.getString("ename"));
            saveObject.put("password",userinfo.getString("password"));
            try {
                timeCache.setCahce(userinfo.getString("ename"),saveObject,-1);
            } catch (Exception e) {
                throw new WebException(602,"登录失败，请联系管理员！");
            }
        }else{
            throw new WebException(601,"校验失败，请检查账号密码！！");
        }
        resultobj.put("code",200);
        resultobj.put("msg","登录成功");
        return resultobj.toString();
    }


}
