package com.aote.rs;

import com.aote.ImageService;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import java.io.IOException;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 18:25 2021/1/26
 */
@Component
@Path("home")
@Singleton
@Transactional
public class HomePageForward {

    static Logger log = Logger.getLogger(HomePageForward.class);

    /**
     *  systemConfig参数对象
     */
    public static PropertiesConfiguration systemConfig;

    static {
        try {
            systemConfig = new PropertiesConfiguration("systemConfig.properties");
            // 自动重新加载
            systemConfig.setReloadingStrategy(new FileChangedReloadingStrategy());
        } catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取真实的首页地址
     * @param response
     * @return
     */
    @GET
    public void home(@Context HttpServletResponse response) {
       try {
           response.sendRedirect(this.systemConfig.getString("homeUrl"));
       } catch (Exception e) {
           log.debug("转发首页异常", e);
       }
    }

}
