select distinct *
from (
         select s.id,
                info.F_USERINFO_CODE,
                s.F_USER_NAME,
                s.F_ADDRESS,
                F_USER_PHONE,
                s.F_TYPE,
                F_COLLECTION,
                s.F_OPERATOR,
                s.F_DEPNAME,
                s.f_orgid,
                case when mid.count > 0 and F_BILL_STATE != '开票失败' and F_BILL_STATE != '冲正' and F_BILL_STATE != '撤销' then '是' else '否' end is_bill,
                s.F_OPERATE_DATE
         from T_SELLINGGAS s
                  left join T_USERINFO info on info.F_USERINFO_ID = s.F_USERINFO_ID
                  left join T_USER_ADDRESS ad on ad.F_USERINFO_ID = s.F_USERINFO_ID
                  left join (select F_SELL_ID, count(F_SELL_ID) count from T_TICKETRELATED group by F_SELL_ID) mid
                            on mid.F_SELL_ID = s.ID
                  left join T_TICKETRELATED ed on ed.F_SELL_ID = mid.F_SELL_ID
                  left join T_ETICKET e on e.id = ed.F_ETICKET_ID
         where  { condition } and s.f_state = '有效' and s.F_TYPE = '物联网收费'
     ) s
order by F_OPERATE_DATE desc
