select * from (
  select
    u.f_userinfo_code,
    u.f_olduserinfo_code,
    u.f_userinfo_id,
    u.version,
    f.f_adjustable_id,
    f.f_user_id,
    f.f_userfiles_id,
    u.f_user_name,
    u.f_filialeid,
    u.f_balance,
    u.f_createfile_date,
    u.f_user_phone,
    a.id addressid,
    a.f_address,
    u.f_user_state,
    f.f_user_type,
    f.f_gasproperties,
    f.f_table_state,
    f.f_meternumber,
    gb.f_meter_brand,
    gm.f_meter_style,
    case up.f_parameter_state when '正常' then '是' else '否' end f_blacklist_state
  from
    t_userinfo u
    LEFT JOIN t_userfiles f on f.f_userinfo_id = u.f_userinfo_id
    LEFT JOIN t_user_address a on f.f_useraddress_id = a.id
    left join t_gasbrand gb on f.f_gasbrand_id = gb.id
    left join t_gasmodel gm on f.f_gasmodel_id = gm.id
    left join t_userparameter up on f.f_userinfo_id = up.f_userinfo_id and f_parameter_key ='backlist' and f_parameter_state ='正常'
) u
where {condition} and (f_table_state in('正常','待开通', '停用') or f_table_state is null)
ORDER by f_userinfo_id desc