
select * from (
  SELECT
    info.f_userinfo_code,
    info.f_userinfo_id,
    info.f_user_name,
    info.f_user_state,
    info.f_idnumber,
    info.f_user_phone,
    info.f_orgid,
    info.f_balance,
    info.f_orgname,
    uf.f_meter_classify,
    uf.f_gongye_type,
    uf.f_userfiles_id,
    isnull(up.f_price_id, uf.f_price_id) f_price_id,
    isnull(up.id, sp.id) f_stairprice_id,
    isnull(up.f_price_type, sp.f_price_type) f_price_type,
    isnull(up.f_price_name, sp.f_price_name) f_price_name,
    isnull(up.f_user_type, sp.f_user_type) f_user_type,
    isnull(up.f_gasproperties, sp.f_gasproperties) f_gasproperties,
    address.f_address,
    address.f_residential_area_id,
    uf.f_meternumber,
    mb.f_book_state,
    uf.f_table_state,
    uf.f_gasproperties_second,
    uf.f_gasbrand_id
  FROM
     t_userfiles uf
  LEFT JOIN t_userinfo info ON info.f_userinfo_id = uf.f_userinfo_id
  LEFT JOIN t_user_address address ON info.f_userinfo_id = address.f_userinfo_id
  LEFT JOIN t_meter_book mb ON mb.id= address.id
  left join
	  (
	    select * from t_stairprice where getdate() between f_perform_date  and  f_end_date and f_state = '有效'
	  ) sp on uf.f_price_id=sp.f_price_id
  left join
  (
      select * from (
        select
            {entity.findDialect() == $SqlServer$:
            $ DATEDIFF(day,getdate(),f_parameter_value) days$,
            $ floor( to_date(f_parameter_value,'yyyy-mm-dd hh24:mi:ss') - sysdate) days$},
            b.f_userinfo_id,b.f_userfiles_id,sp.*
        from t_userproperties p left join t_basicliving b on p.f_userinfo_id = b.f_userinfo_id
        LEFT JOIN
        (select * from  t_stairprice where getdate()>=f_perform_date and getdate()<=f_end_date and f_state = '有效')
        sp on b.f_price_id = sp.f_price_id
        where p.f_state='有效' and p.f_parameter_key = 'dibaohu_endDate' and b.f_state = '有效'
    ) up where days > 0
  ) up on uf.f_userinfo_id = up.f_userinfo_id
  where uf.f_table_state='正常' and info.f_user_state = '正常' and info.f_createfile_date is not null
) t_
WHERE
	{condition}
order by f_userinfo_id desc
