/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.af.plugins.JsonTools;
import com.alibaba.druid.util.StringUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class FTPUtil {
    private static final Logger log = Logger.getLogger(FTPUtil.class);
    private static int BUFFER_SIZE = 0x400000;
    private static String LOCAL_CHARSET = "GBK";
    private static final String CHARSET_CHARSET = "UTF-8";
    private static final String OPTS_UTF8 = "OPTS UTF-8";
    private static final String SERVER_CHARSET = "ISO-8859-1";
    private static FTPClient ftpClient = null;
    private static final JSONObject PATH = JsonTools.readJsonFile((String)"bankDown.json").getJSONObject("path");
    private static final String FILE_LOCAL_SAVE_PATH = String.valueOf(PATH.get("fileLocalSavePath"));
    private static final String FTP_FILE_DIR_PATH = String.valueOf(PATH.get("ftpFileDirPath"));
    private static final String FTP_UP_FILE_DIR_PATH = String.valueOf(PATH.get("ftpUpFileDirPath"));

    public static void login() {
        JSONObject ft = JsonTools.readJsonFile((String)"bankDown.json").getJSONObject("FTPInfo");
        ftpClient = new FTPClient();
        try {
            ftpClient.connect(String.valueOf(ft.get("ip")), Integer.parseInt(String.valueOf(ft.get("port"))));
            ftpClient.login(String.valueOf(ft.get("userName")), String.valueOf(ft.get("passWord")));
            ftpClient.setBufferSize(BUFFER_SIZE);
            ftpClient.setFileType(2);
            log.info((Object)"FTP\u670d\u52a1\u8fde\u63a5\u6210\u529f\uff01");
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPUtil.closeConnect();
            }
        }
        catch (Exception e) {
            log.error((Object)("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u8fde\u63a5\u73af\u5883\u3002" + e));
            throw new RuntimeException(e);
        }
    }

    public static void closeConnect() {
        if (ftpClient != null && ftpClient.isConnected()) {
            try {
                ftpClient.logout();
            }
            catch (Exception var) {
                log.error((Object)"FTP\u670d\u52a1\u5f02\u5e38\uff01", (Throwable)var);
            }
        }
    }

    public static String changeEncoding(String ftpPath) {
        String directory = null;
        try {
            if (FTPReply.isPositiveCompletion((int)ftpClient.sendCommand(OPTS_UTF8, "ON"))) {
                LOCAL_CHARSET = CHARSET_CHARSET;
            }
            directory = new String(ftpPath.getBytes(LOCAL_CHARSET), SERVER_CHARSET);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return directory;
    }

    public static void changeAndMakeWorkingDir(String path) {
        try {
            String[] path_array;
            ftpClient.changeWorkingDirectory("/");
            path = path.replaceAll("\\\\", "/");
            for (String s : path_array = path.split("/")) {
                boolean b = ftpClient.changeWorkingDirectory(s);
                if (b) continue;
                ftpClient.makeDirectory(s);
                ftpClient.changeWorkingDirectory(s);
            }
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upLoad(String fileName, String filePath) {
        FTPUtil.login();
        FileInputStream in = null;
        if (!ftpClient.isConnected()) {
            return false;
        }
        boolean isSuccess = false;
        if (ftpClient != null) {
            try {
                in = new FileInputStream(filePath + "\\" + fileName);
                if (FTPReply.isPositiveCompletion((int)ftpClient.sendCommand("OPTS_UTF8", "ON"))) {
                    LOCAL_CHARSET = CHARSET_CHARSET;
                }
                ftpClient.setControlEncoding(LOCAL_CHARSET);
                String path = FTPUtil.changeEncoding(FTP_UP_FILE_DIR_PATH);
                FTPUtil.changeAndMakeWorkingDir(FTP_FILE_DIR_PATH);
                isSuccess = ftpClient.storeFile(new String(fileName.getBytes(), SERVER_CHARSET), (InputStream)in);
            }
            catch (Exception var) {
                log.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)var);
            }
            finally {
                FTPUtil.closeConnect();
            }
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoad(String filename) {
        FTPUtil.login();
        FileOutputStream out = null;
        if (ftpClient != null) {
            try {
                String[] fileNames;
                out = new FileOutputStream(FILE_LOCAL_SAVE_PATH + "\\" + filename);
                String path = FTPUtil.changeEncoding(FTP_FILE_DIR_PATH);
                if (!ftpClient.changeWorkingDirectory(path)) {
                    log.error((Object)("\u8be5\u76ee\u5f55\u4e0d\u5b58\u5728,filePath=" + FTP_FILE_DIR_PATH));
                }
                if ((fileNames = ftpClient.listNames()) == null || fileNames.length == 0) {
                    return;
                }
                for (String fileName : fileNames) {
                    String ftpName = new String(fileName.getBytes(SERVER_CHARSET), LOCAL_CHARSET);
                    if (!StringUtils.equals((String)ftpName, (String)filename)) continue;
                    InputStream in = ftpClient.retrieveFileStream(fileName);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
            catch (Exception var) {
                log.error((Object)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01", (Throwable)var);
            }
            finally {
                FTPUtil.closeConnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryFile(String date) {
        FTPFile[] files = null;
        String fileName = "";
        try {
            FTPUtil.login();
            if (!ftpClient.changeWorkingDirectory(FTP_FILE_DIR_PATH)) {
                log.error((Object)("\u8be5\u76ee\u5f55\u4e0d\u5b58\u5728,filePath=" + FTP_FILE_DIR_PATH));
            }
            ftpClient.enterLocalPassiveMode();
            files = ftpClient.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().contains(date)) continue;
                fileName = files[i].getName();
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8bfb\u53d6FTP\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            FTPUtil.closeConnect();
        }
        return fileName;
    }
}

