select * from(
     select
            h.*,
            case when (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) < 0 then 0
                 else (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) end f_actualtablebase,
            isnull(uf.f_initial_base, 0) f_initial_base,
            isnull(uf.f_total_fee, 0) total_fee,
            isnull(uf.f_total_gas, 0) total_gas,
            uf.version,
            u.f_balance balance,
            u.f_user_level,
            address.f_residential_area,
            address.f_slice_area f_zones,
            address.f_small_area,
            address.f_building,
            address.f_unit,
            address.f_floor,
            address.f_room,
            substring(convert(varchar(100),h.f_hand_date,23),0,8) belongmonth
     from  t_cardhand h
         left join t_userfiles uf on h.f_userfiles_id=uf.f_userfiles_id
         LEFT JOIN t_userinfo u ON h.f_userinfo_id = u.f_userinfo_id
         left join t_user_address address on uf.f_useraddress_id = address.id
     where f_hand_state='有效'  AND  (h.f_meter_classify='气量卡表' or h.f_meter_classify='金额卡表')
     AND f_table_state = '正常' and f_user_state='正常'
)t
where {condition}
order by {orderitem}
