/*
 * Decompiled with CFR 0.152.
 */
package pay;

import java.io.UnsupportedEncodingException;

public class HexStringUtil {
    public static String toHexString(String str) throws UnsupportedEncodingException {
        byte[] byteArray = str.getBytes("UTF-8");
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static int toByte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("Invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        byte[] buffer = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            buffer[i / 2] = (byte)(HexStringUtil.toByte(hexString.charAt(i)) << 4 | HexStringUtil.toByte(hexString.charAt(i + 1)));
        }
        return buffer;
    }

    public static String toHex(String str) throws UnsupportedEncodingException {
        byte[] data = str.getBytes("UTF-8");
        String ret = null;
        if (data != null && data.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (byte b : data) {
                int h = b >> 4 & 0xF;
                int l = b & 0xF;
                char ch = h > 9 ? (char)(65 + (h - 10)) : (char)(48 + h);
                char cl = l > 9 ? (char)(65 + (l - 10)) : (char)(48 + l);
                sb.append(ch).append(cl);
            }
            ret = sb.toString();
        }
        return ret;
    }

    public static String bytetoHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString();
    }
}

