/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugin;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.aote.plugin.ModelDataListener;
import com.aote.plugin.OperateMaterial;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReadExcel {
    private static final Logger logger = Logger.getLogger(ReadExcel.class);
    @Autowired
    private OperateMaterial operateMaterial;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject readExcelData(String data) throws Exception {
        JSONObject jsonObject = new JSONObject(data);
        ExcelReader excelReader = null;
        InputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(jsonObject.getString("filepath"));
            ModelDataListener modelDataListener = new ModelDataListener();
            excelReader = EasyExcel.read((InputStream)fileInputStream, (ReadListener)modelDataListener).build();
            ReadSheet readSheet = EasyExcel.readSheet((Integer)0).build();
            excelReader.read(new ReadSheet[]{readSheet});
            ReadSheet readDetailSheet = EasyExcel.readSheet((Integer)1).build();
            excelReader.read(new ReadSheet[]{readDetailSheet});
            List<Map<Integer, String>> headList = modelDataListener.getHeadList();
            List<Map<Integer, Object>> dataList = modelDataListener.getDataList();
            JSONObject jSONObject = this.operateMaterial.saveData(headList, dataList);
            return jSONObject;
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            JSONObject result = new JSONObject();
            result.put("code", (Object)"500");
            result.put("msg", (Object)"\u5bfc\u5165\u5931\u8d25\uff01\uff01\uff01");
            JSONObject jSONObject = result;
            return jSONObject;
        }
        finally {
            fileInputStream.close();
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }
}

