SELECT *
FROM ((SELECT
u2.f_table_remaining,
    u2.f_filialeid,
	u4.f_userinfo_id,
	u4.f_userinfo_code,
	u4.f_user_name,
	u4.f_user_phone,
	u3.f_address,
	u2.f_user_type,
	u2.f_gasproperties,
	u2.f_total_gas,
	u2.f_user_id,
	u2.f_userfiles_id,
	u2.f_meter_base,
	u1.f_source,
	u1.f_meter_type,
	u1.f_stairprice_id,
	u1.f_handplan_id,
	u1.f_meter_brand,
	u1.f_meter_style,
   u1.f_input_date,
	u2.f_price_id,
	u2.f_meternumber,
	u1.pregas as pregas,
	sp.f_price_name,
	dp.f_price,
	isnull(f_old_price,0) f_old_price,
	isnull(u1.f_new_price,0) f_new_price,
	u1.f_change_price,
	u1.f_surplus_fee,
	u1.f_last_tablebase,
	u1.f_tablebase
FROM
	(
		SELECT
		  id as f_handplan_id,
			f_userfiles_id,
			f_userinfo_id,
			f_meter_brand,
			f_input_date,
			f_meter_style,
			f_stairprice_id,
			f_meter_classify f_meter_type,
			f_oughtamount as pregas,
			'机表抄表' f_source,
			isnull(f_new_price,0) f_new_price,
			f_change_price,
			f_surplus_fee,
			f_last_tablebase,
			f_tablebase
		FROM
			t_handplan
		WHERE
			f_input_date BETWEEN '{startDate} 00:00:00'
		AND '{endDate} 23:59:59'
		AND f_meter_state = '已抄表'
		AND f_hand_state = '有效'
	) u1
LEFT JOIN t_userfiles u2 ON u1.f_userfiles_id = u2.f_userfiles_id
LEFT JOIN t_user_address u3 ON u2.f_useraddress_id = u3.id
LEFT JOIN t_stairprice sp ON u1.f_stairprice_id = sp.id
left join t_detailprice dp on sp.id=dp.f_stairprice_id
LEFT JOIN t_userinfo u4 ON u3.f_userinfo_id = u4.f_userinfo_id
left join (select f_handplan_id,f_old_price,f_userinfo_id from t_surplus_detail where f_state='有效') s
on u1.f_handplan_id = s.f_handplan_id and u1.f_userinfo_id=s.f_userinfo_id
WHERE
	{condition} and sp.f_price_type='固定气价' AND u2.f_table_remaining > 0)
	union ALL
       (SELECT
       u2.f_table_remaining,
          u2.f_filialeid,
          u4.f_userinfo_id,
          u4.f_userinfo_code,
          u4.f_user_name,
          u4.f_user_phone,
          u3.f_address,
          u2.f_user_type,
          u2.f_gasproperties,
          u2.f_total_gas,
          u2.f_user_id,
          u2.f_userfiles_id,
          u2.f_meter_base,
          u1.f_source,
          u1.f_meter_type,
          u1.f_stairprice_id,
          u1.f_handplan_id,
          u1.f_meter_brand,
          u1.f_meter_style,
          u1.f_input_date,
          u2.f_price_id,
          u2.f_meternumber,
           u1.pregas as 'pregas',
          sp.f_price_name,
          dp.f_price,
          {entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(f_old_price,0) f_old_price,
          {entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(u1.f_new_price,0) f_new_price,
           u1.f_change_price,
          u1.f_surplus_fee,
          u1.f_last_tablebase,
          u1.f_tablebase
        FROM
          (
            SELECT
              ch.id as f_handplan_id,
              ch.f_userfiles_id,
              ch.f_userinfo_id,
              ch.f_meter_brand,
              ch.f_input_date,
              ch.f_meter_style,
              '' f_stairprice_id,
              ch.f_meter_classify f_meter_type,
               f_real_amount as 'pregas',
              '卡表抄表' f_source,
              {entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(ch.f_new_price,0) f_new_price,
             f_change_price,
              ch.f_surplus_fee,
              ch.f_last_tablebase,
              ch.f_tablebase,
              ch.f_adjustment_volume
            FROM
              t_cardhand ch
            WHERE
              ch.f_hand_date BETWEEN '{startDate} 00:00:00'
                AND '{endDate} 23:59:59'
              AND ch.f_meter_state = '已抄表'
          ) u1
            LEFT JOIN t_userfiles u2 ON u1.f_userfiles_id = u2.f_userfiles_id
            LEFT JOIN (select id,f_address,f_userinfo_id from t_user_address) u3 ON u2.f_useraddress_id = u3.id
            LEFT JOIN (
            SELECT
              id,f_price_name,f_price_type,f_price_id
            FROM
              t_stairprice
            where f_state = '有效'
              and f_perform_date <= getdate()
              and f_end_date >= getdate()
          ) sp ON u2.f_price_id = sp.f_price_id
            left join (select f_stairprice_id,f_price from t_detailprice where f_price_name= '1') dp on sp.id=dp.f_stairprice_id
            LEFT JOIN (select
                        f_userinfo_id,f_userinfo_code,f_user_name,f_user_phone
                        from t_userinfo) u4 ON u3.f_userinfo_id = u4.f_userinfo_id
            left join (select f_handplan_id,f_old_price,f_userinfo_id from t_surplus_detail where f_state='有效') s
                      on u1.f_handplan_id = s.f_handplan_id and u1.f_userinfo_id=s.f_userinfo_id
        WHERE
            {condition}
          and sp.f_price_type='固定气价'
         and u2.f_table_remaining > 0
         )
     ) a
ORDER BY
  f_handplan_id asc
