package com.aote.user;

import com.aote.rs.LogicService;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

@Component
//@EnableScheduling
@Lazy(false)
public class UserSettle {



    @Autowired
    private LogicService logicService;

//    @Scheduled(cron = "*/50 * * * * *")
//    @Scheduled(cron = "59 59 23 L * ? ")//每月最后一天的最后一秒执行
    public void doSettle() throws Exception {
        String firstDay = LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String lastDay = LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String lastMonthDay = LocalDateTime.of(LocalDateTime.now().minusMonths(1).with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        JSONObject data = new JSONObject();
        data.put("begin",firstDay);
        data.put("end",lastDay);
        data.put("lastEnd",lastMonthDay);
        logicService.xtSave("accountSettlement",new JSONObject().put("data",data).toString());
    }
}
