package com.af.timingJob;

import com.aote.rs.LogicService;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component
@EnableScheduling
@Lazy(false)
public class Intermediate {

    static Logger log = Logger.getLogger(Intermediate.class);

    private static List<String> day = new ArrayList<String>();

    private static List<String> month = new ArrayList<String>();

    static {
        String[] dayArr = {"IntermediateTableUseGas","IntermediateTableSellGas","IntermediateTableDayIncome","IntermediateTableUserAddShut","IntermediateTableUserCount"};
        String[] yearArr = {"IntermediateTableHandCount"};
        day.addAll(Arrays.asList(dayArr));
        month.addAll(Arrays.asList(yearArr));
    }

    @Autowired
    private LogicService logicService;

    @Scheduled(cron = "0 10 0 * * ?")
    public void everyDay(){
        log.debug(LocalDateTime.now()+"开始执行中间表【每日】定时器");
        day.forEach((v)->{
            try {
                logicService.xtSave(v,new JSONObject().put("data",new JSONObject()).toString());
            } catch (Exception e) {
                log.error("日执行定时器->"+v+"  Logic执行异常！！");
                e.printStackTrace();
            }
        });

    }
    @Scheduled(cron = "0 5 0 1 * ? ")
    public void everyMonth(){
        log.debug(LocalDateTime.now()+"开始执行中间表【月初】定时器");
        day.forEach((v)->{
            try {
                logicService.xtSave(v,new JSONObject().put("data",new JSONObject()).toString());
            } catch (Exception e) {
                log.error("月执行定时器->"+v+"  Logic执行异常！！");
                e.printStackTrace();
            }
        });
    }
}
