package util.price;

import util.price.util.AES;
import util.price.util.Arith;
import util.price.util.CodeFormat;

import android.util.Log;

import java.util.Locale;
import java.util.zip.CRC32;

public class PriceData {
	// Debugging
	private static final String TAG = "Test_PriceData";
	private static final boolean D = false;

	private static final String KEY = "123456789abcdef00000000000000000";

	/**
	 * 获取价格体系信息[调价方式1byte(未加密) + 加密后的价格体系32byte + 随机数后4byte(未加密)]
	 *
	 * @param random
	 *            随机数(8byte)
	 * @param type
	 *            调价方式(1byte)
	 * @param priceData
	 *            价格体系[阶梯气价1 2BYTE 阶梯气量1 4BYTE 阶梯气价2 2BYTE 阶梯气量2 4BYTE 阶梯气价3
	 *            2BYTE 价格启用时间 3BYTE 阶梯价版本号 1BYTE 结算周期(月数) 1BYTE 周期启用时间（年月日）
	 *            4BYTE 清价格周期累计用气量标记 1BYTE ]
	 * @return
	 * @throws Exception
	 */
	public static String getEncryptPriceData(String random, String type, String[] priceData) throws Exception {
		// 价格体系24byte
		String pData = getPriceData(priceData);
		if (D) {
			Log.i(TAG, "价格体系：" + pData.toUpperCase(Locale.US));
		}
		// MAC值为价格体系明文数据24字节算出来的CRC32(小端)
		CRC32 crc32 = new CRC32();
		crc32.update(CodeFormat.hexStr2ByteArr(pData));
		String pCrc32 = CodeFormat.hexHigh2Low(CodeFormat.addZeroString(Long.toHexString(crc32.getValue()), 4));
		if (D) {
			Log.i(TAG, "MAC：" + pCrc32.toUpperCase(Locale.US));
		}
		// 未加密数据
		String data = pData + pCrc32 + random.substring(0, 8);
		if (D) {
			Log.i(TAG, "明文：" + data.toUpperCase(Locale.US));
		}
		// 分散因子
		String factor = random.substring(8, 16) + "0102030405060708090A0B0C";
		if (D) {
			Log.i(TAG, "分散因子：" + factor.toUpperCase(Locale.US));
		}
		// 新密钥
		String newKey = AES.encrypt(factor, KEY);
		if (D) {
			Log.i(TAG, "新密钥：" + newKey.toUpperCase(Locale.US));
		}
		// 加密数据
		String pEptData = AES.encrypt(data.substring(0, 32), newKey) + AES.encrypt(data.substring(32, 64), newKey);
		if (D) {
			Log.i(TAG, "密文：" + pEptData.toUpperCase(Locale.US));
		}
		// 价格数据
		String eptPriceData = type + pEptData + random.substring(8, 16);
		if (D) {
			Log.i(TAG, "价格数据：" + eptPriceData.toUpperCase(Locale.US));
		}

		return eptPriceData;
	}

	/**
	 * 获取价格体系信息
	 *
	 * @param priceData
	 *            价格体系[阶梯气价1 2BYTE 阶梯气量1 4BYTE 阶梯气价2 2BYTE 阶梯气量2 4BYTE 阶梯气价3
	 *            2BYTE 价格启用时间 3BYTE 阶梯价版本号 1BYTE 结算周期(月数) 1BYTE 周期启用时间（年月日）
	 *            4BYTE 清价格周期累计用气量标记 1BYTE ]
	 * @return
	 */
	private static String getPriceData(String[] priceData) {
		StringBuilder sBuilder = new StringBuilder();
		// 调价方式(不包含在加密区域中)
		// sBuilder.append(CodeFormat.addZeroString(priceData[0], 1));
		// 阶梯价格1
		sBuilder.append(CodeFormat.hexHigh2Low(CodeFormat.addZeroString(Integer.toHexString((int) Arith.mul(Double.valueOf(priceData[0]), 100)), 2)));
		// 阶梯用量1
		sBuilder.append(CodeFormat.hexHigh2Low(CodeFormat.addZeroString(Integer.toHexString((int) (Integer.valueOf(priceData[1].substring(0,priceData[1].indexOf("."))))), 4)));
		// 阶梯价格2
		sBuilder.append(CodeFormat.hexHigh2Low(CodeFormat.addZeroString(Integer.toHexString((int) Arith.mul(Double.valueOf(priceData[2]), 100)), 2)));
		// 阶梯用量2
		sBuilder.append(CodeFormat.hexHigh2Low(CodeFormat.addZeroString(Integer.toHexString((int) (Integer.valueOf(priceData[3].substring(0,priceData[3].indexOf("."))))), 4)));
		// 阶梯价格3
		sBuilder.append(CodeFormat.hexHigh2Low(CodeFormat.addZeroString(Integer.toHexString((int) Arith.mul(Double.valueOf(priceData[4]), 100)), 2)));
		// 价格启用时间HEX
		sBuilder.append(CodeFormat.dateStr2HexStr(CodeFormat.checkDate(priceData[5])));
		// 阶梯价版本号
		sBuilder.append(CodeFormat.addZeroString(CodeFormat.Integer2HexStr(Integer.valueOf(priceData[6])), 1));
		// 结算周期(月数)
		sBuilder.append(CodeFormat.addZeroString(CodeFormat.Integer2HexStr(Integer.valueOf(priceData[7])), 1));
		// 周期启用时间BCD(YYMMDDHH)
		sBuilder.append(CodeFormat.checkDateWithHour(priceData[8]));
		// 清价格周期累计用气量标记
		sBuilder.append(CodeFormat.addZeroString(priceData[9], 1));

		return sBuilder.toString();
	}
}
