SELECT
	f_userfiles_id,
	f_userinfo_id,
	f_userinfo_code,
	f_user_id,
	f_user_name,
	f_ventilation_state,
	f_slice_area,
	f_address,
	f_user_phone,
	f_gasproperties,
	f_meternumber,
	f_inputtor,
	f_total_fee,
	f_total_gas,
	f_last_tablebase,
	f_tablebase,
	f_actualtablebase,
	f_real_amount,
	f_real_fee,
	f_surplus_fee,
	f_hand_date,
	f_meter_state,
	f_type,
	f_user_type,
	f_meter_classify,
	f_remanent_money,
	f_correct_state,
	id,
	f_meter_base,
	f_price_name,
	f_filiale,
	f_card_reason,
	f_special_user,
	f_last_hand_date,
	f_gasbrand_id,f_residential_area,f_unit,f_building,f_floor,f_room
FROM
	(
	SELECT
		f_userfiles_id,
		f_userinfo_id,
		f_userinfo_code,
		f_user_id,
		f_user_name,
		f_ventilation_state,
		f_slice_area,
		f_address,
		f_user_phone,
		f_gasproperties,
		meternumbers f_meternumber,
		f_inputtor,
		f_total_fee,
		f_total_gas,
		f_last_tablebase,
		f_tablebase,
		case when (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) < 0 then 0
		else (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) end f_actualtablebase,
		f_real_amount,
		isnull( f_real_fee, 0 ) f_real_fee,
		f_surplus_fee,
		f_hand_date,
		f_meter_state,
		f_type,
		f_user_type,
		f_meter_classify,
		isnull( f_remanent_money, 0 ) f_remanent_money,
		f_correct_state,
		id,
		f_meter_base,
		f_price_name,
		f_filiale,
		'' f_card_reason,
		f_special_user,
	CASE
			WHEN f_last_hand_date IS NULL THEN
			f_last_hand_date_u ELSE f_last_hand_date
		END f_last_hand_date,
	f_gasbrand_id,f_residential_area,f_unit,f_building,f_floor,f_room
FROM
	(
	SELECT
		*,
	CASE

			WHEN f_meter_state != '未抄表' THEN
			1 ELSE (
			CASE

					WHEN maxdate IS NULL THEN
					0 ELSE (
					CASE

							WHEN maxdate >'{startDate}'  THEN
							0 ELSE ( CASE WHEN f_hand_date IS NULL THEN 0 ELSE ( CASE WHEN maxdate > f_hand_date THEN 0 ELSE 1 END ) END )
							END
							)
						END
						)
					END f_state,
CASE

	WHEN f_meter_state != '已抄表' THEN
	1 ELSE ( CASE WHEN maxdate != f_hand_date THEN 1 ELSE 0 END )
	END f_correct_state
FROM
	(
	SELECT
		u.*,
--首先判断卡表用户是否有最大日期的抄表记录
--第二判断用户当前归属期内有无抄表记录
--第三判断用户抄表周期前是否有抄表记录
--第四判断用户是否有换表记录
--第五判断用户最大换表时间是否大于最大抄表时间
	CASE

			WHEN c.meternumber IS NULL THEN
			u.f_meternumber ELSE c.meternumber
		END meternumbers,
CASE

	WHEN c.f_last_tablebase IS NULL THEN
	u.f_meter_base ELSE c.f_last_tablebase
	END f_last_tablebase,
CASE

	WHEN t.f_tablebase IS NULL
	AND c.f_tablebase IS NULL THEN
	0
	WHEN c.f_tablebase IS NOT NULL THEN
	c.f_tablebase
	WHEN t.f_tablebase IS NOT NULL
	AND c.f_tablebase IS NULL THEN
	0
	END f_tablebase,
	c.f_real_amount,
	c.f_real_fee,
	isnull( c.f_surplus_fee, 0 ) AS f_surplus_fee,
	c.f_hand_date,
	c.f_last_hand_date,
	c.id,
CASE

		WHEN c.id IS NULL THEN
		'未抄表' ELSE c.f_meter_state
	END f_meter_state,
	c.f_type,
	maxdate
FROM
	(--查询所有卡表抄表用户
	SELECT
		u.f_userfiles_id,
		u1.f_special_user,
		u.f_card_id,
		u.f_userinfo_id,
		u1.f_ventilation_state,
		u.f_meternumber,
		u.f_total_fee,
		u.f_total_gas,
		u.f_meter_base,
		u.f_user_type,
		u.f_gasproperties,
		ad.f_address,
		u1.f_user_phone,
		u.f_initial_base,
		f_user_id,
		f_userinfo_code,
		u.f_meter_classify,
		u1.f_user_name,
		s.f_price_name,
		u1.f_slice_area,
		u.f_inputtor,
		u.f_filiale,
		u.f_outlets,
		u.f_remanent_money,
		u.f_hand_date f_last_hand_date_u,
		u.f_gasbrand_id,f_residential_area,f_unit,f_building,f_floor,f_room
	FROM
		(
		SELECT
			f_userfiles_id,
			f_card_id,
			f_userinfo_id,
			f_meternumber,
			f_hand_date,
			f_total_fee,
			f_total_gas,
			f_meter_base,
			f_user_type,
			f_gasproperties,
			f_initial_base,
			f_user_id,
			f_meter_classify,
			f_inputtor,
			f_filiale,
			f_gasbrand_id,
			f_outlets,
			f_remanent_money,
			f_price_id
		FROM
			t_userfiles
		WHERE
			f_table_state = '正常'
			AND f_meter_classify LIKE '%卡表%'
		) u
		JOIN ( SELECT f_userinfo_code, f_userinfo_id, f_special_user, '' f_address, f_user_name, '' f_slice_area, f_user_phone, f_ventilation_state FROM t_userinfo WHERE f_user_state = '正常' ) u1 ON u.f_userinfo_id= u1.f_userinfo_id
		LEFT JOIN ( SELECT f_userinfo_id, f_address,f_residential_area,f_unit,f_building,f_floor,f_room FROM t_user_address ) ad ON u.f_userinfo_id= ad.f_userinfo_id
		LEFT JOIN ( SELECT * FROM t_stairprice WHERE f_state = '有效' AND f_end_date > GETDATE( ) ) s ON u.f_price_id = s.f_price_id
	) u
	LEFT JOIN (--查询归属期内有抄表的用户抄表记录
	SELECT
		ch.f_tablebase,
		ch.f_last_tablebase,
		ch.f_user_id,
		ch.f_last_hand_date,
		ch.f_real_amount,
		ch.f_real_fee,
		ch.f_hand_date,
		ch.id,
		ch.f_meter_state,
		s.f_surplus_fee,
		s.f_type,
		ch.f_meternumber meternumber
	FROM
		dbo.t_cardhand ch
		LEFT JOIN ( SELECT f_hand_id, f_type, SUM ( f_surplus_fee ) f_surplus_fee FROM t_surplus_detail WHERE f_surplus_fee > 0 AND f_type = '金额表补差' GROUP BY f_hand_id, f_type ) s ON ch.id = s.f_hand_id
	WHERE
		ch.f_hand_date>= '{startDate} 00:00:00'
		AND ch.f_hand_date<= '{endDate} 23:59:59'
		AND f_meter_state != '冲正'
	) c ON u.f_user_id= c.f_user_id
	LEFT JOIN (--查询卡表抄表的用户的查询日期前的最大抄表底数
	SELECT DISTINCT MAX
		( c.f_tablebase ) f_tablebase,
		c.f_user_id
	FROM
		( SELECT f_user_id, MAX ( f_hand_date ) f_hand_date FROM dbo.t_cardhand WHERE f_hand_date < '{endDate} 23:59:59' AND f_meter_state != '冲正' GROUP BY f_user_id ) t
		LEFT JOIN dbo.t_cardhand c ON t.f_user_id= c.f_user_id
		AND t.f_hand_date= c.f_hand_date
	WHERE
		f_meter_state != '冲正'
	GROUP BY
		c.f_user_id
	) t ON u.f_user_id= t.f_user_id
	LEFT JOIN ( --查询卡表用户最大抄表时间
	SELECT f_user_id, MAX ( f_hand_date ) maxdate FROM dbo.t_cardhand WHERE f_meter_state != '冲正' GROUP BY f_user_id ) t1 ON u.f_user_id= t1.f_user_id
	LEFT JOIN ( --查询换表用户的换表时间
	SELECT f_user_id, MAX ( f_operate_date ) f_maxdate FROM t_changetables WHERE f_state = '有效' GROUP BY f_user_id ) cm ON u.f_user_id= cm.f_user_id
	LEFT JOIN ( SELECT f_user_id cms_userid, f_operate_date cms_date, f_initial_base_new FROM t_changetables WHERE f_state = '有效' ) cms ON cm.f_user_id = cms.cms_userid
	AND cm.f_maxdate = cms.cms_date
	) t
	) t UNION ALL--查询卡表冲正记录
SELECT
	uf.f_userfiles_id,
	c.f_userinfo_id,
	f_userinfo_code,
	f_user_id,
	f_user_name,
	'' f_ventilation_state,
	'' f_slice_area,
	ad.f_address,
	f_user_phone,
	f_gasproperties,
	f_meternumber f_meternumber,
	f_inputtor,
	0 f_total_fee,
	0 f_total_gas,
	f_last_tablebase,
	f_tablebase,
  case when (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) < 0 then 0
  else (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) end f_actualtablebase,
	f_real_amount,
	isnull( f_real_fee, 0 ) f_real_fee,
	f_surplus_fee,
	f_hand_date,
	'冲正' f_meter_state,
	'' f_type,
	f_user_type,
	'' f_meter_classify,
	0 f_remanent_money,
	1 f_correct_state,
	id,
	0 f_meter_base,
	'' f_price_name,
	f_filiale,
	isnull( f_card_reason, '' ) f_card_reason,
	u.f_special_user,
	f_last_hand_date,
	uf.f_gasbrand_id,f_residential_area,f_unit,f_building,f_floor,f_room
FROM
	( SELECT * FROM t_cardhand WHERE f_hand_date >= '{startDate} 00:00:00' AND f_hand_date <= '{endDate} 23:59:59' AND f_meter_state = '冲正' ) c
	LEFT JOIN ( SELECT f_userinfo_code, f_userinfo_id, f_special_user, f_user_phone FROM t_userinfo ) u ON c.f_userinfo_id= u.f_userinfo_id
	LEFT JOIN ( SELECT f_userinfo_id, f_address,f_residential_area,f_unit,f_building,f_floor,f_room FROM t_user_address ) ad ON u.f_userinfo_id= ad.f_userinfo_id
	LEFT JOIN ( SELECT f_userinfo_id, f_gasbrand_id,f_userfiles_id FROM t_userfiles ) uf ON u.f_userinfo_id= uf.f_userinfo_id
	) s
WHERE
	{condition}
