select * from
(
   select
        d.version,            -- 表版本，更新使用
		d.f_userinfo_code,
		d.userinfo_version,	  --户版本
		d.f_user_name,	      --用户姓名
		d.f_user_phone,	      --用户姓名
		d.f_address,		  --用户地址
		d.f_meter_classify,	  -- 气表分类
		d.f_area,
		d.f_residential_area,
		d.f_building,
		d.f_unit,
		d.f_floor,
		d.f_room,
		case when d.f_last_tablebase IS null then d.f_meter_base
		else d.f_last_tablebase end f_meter_base,			--上期指数
	    d.f_price_type,		  --气价类型
		d.f_price_name,		  --气价名称
		d.f_user_id,		  --气表编号
		d.f_userinfo_id,	  --分公司
		d.f_meter_type,		--气表类型id
		d.f_price_id,			--气价编号
		d.f_stairprice_id, --气价表主键
		d.f_hand_date,			--下发日期
		d.f_input_date,			--录入日期
		d.f_orgid,			--分公司
		case when d.inputtor is null then d.f_inputtor else d.inputtor end as f_inputtor,		--抄表员
		d.f_user_type,			--用户类型（自动下账时，产生收费记录时使用）
		d.f_user_state,
		d.f_gasproperties,      --用气性质（自动下账时，产生收费记录时使用）
		d.f_meter_brand,        --气表品牌（自动下账时，产生收费记录时使用）
		d.f_meter_style,        --气表型号（自动下账时，产生收费记录时使用）
		d.f_meternumber,         --表号（自动下账时，产生收费记录时使用）
		case when (d.f_meternumber = '' or d.f_meternumber is null) then '无表号' else '有表号' end as  meternumber_state,
		d.f_fire_state,
		d.f_remanent_gas,        -- 剩余补气量
		d.h_user_id,				--气表编号
		d.id,						--抄表id
		d.f_sell_id,			--对应的收费记录
		d.f_tablebase,			--本期指数
		d.f_whether_pay,		--是否缴费
		d.f_oughtamount,		--应交气量
		d.f_oughtfee,
    '' f_notes,    --导出备注
		d.f_surplus_gas,
		d.f_haircut_gas,
		d.f_totalsplit_type,
		d.f_share_ratio,
		d.f_share_gas,
		d.f_hand_state,
		isnull(d.f_meter_source, '手动录入') f_meter_source,
		isnull(d.f_issued_state, '手动下发') f_issued_state,
		isnull(d.f_meter_state,'未下发') f_meter_state,
		 case when h1.f_hand_date =d.f_hand_date  then 1 else
                        0 end as states,  --抄表单状态
        case when d.f_hand_date <= d.f_operate_date then f_meterstate
        else '正常' end f_oper_state			-- 是否是换表
from (
  select
		u.*,
		h.*
   from
   (
       select t.*,
	    case when v.f_operat_type= '换表' then '换表'
	 	else '正常' end f_meterState, v.f_operate_date
       from
          (
			  select
          uf.version,
          uf.f_user_id,
          uf.f_userinfo_id,
          uf.f_meter_classify,

          f_meter_base,

          uf.f_inputtor,
          uf.f_meternumber,
          uf.f_fire_state,
          uf.f_remanent_gas,
          uf.f_initial_base,
          uf.f_totalsplit_type,
          uf.f_share_ratio,
          uf.f_price_id,
          uf.f_user_type,
          uf.f_gasproperties,

          u.f_userinfo_code,
          u.version userinfo_version,
          u.f_user_name,
          u.f_user_phone,
          u.f_user_state,
          u.f_orgid,

          address.f_address,
          address.f_area,
          address.f_residential_area,
          address.f_building,
          address.f_unit,
          address.f_floor,
          address.f_room,

          t_gasbrand.f_meter_brand,
          t_gasbrand.f_meter_type,
          t_gasmodel.f_meter_style,

          s.f_price_type,
          s.id f_stairprice_id,
          s.f_price_name
        from t_userfiles uf
          left join t_user_address address
            on uf.f_useraddress_id = address.id
          left join t_userinfo u
            on uf.f_userinfo_id=u.f_userinfo_id
          left join t_gasbrand ON t_gasbrand.id = uf.f_gasbrand_id
          left join t_gasmodel ON t_gasmodel.id = uf.f_gasmodel_id
          left join (
                      select * from t_stairprice where getdate()>=f_perform_date and getdate()<=f_end_date and f_state = '有效'
                    ) s on uf.f_price_id = s.f_price_id and s.f_filialeid = uf.f_orgid
        where uf.f_table_state = '正常'
		  )  t
          left join
		  (
			  select
				r1.f_operat_type,
				r1.f_user_id,
				r1.f_state,
				r1.f_operate_date
			  from (
			  select max(id) maxid,f_user_id from t_record group by f_user_id)
			  r left join t_record r1 on r.maxid=r1.id
		   ) v on v.f_user_id=t.f_user_id and v.f_state = '有效'
 ) u
  left join
  (
	   select
		h.f_user_id h_user_id,
        f_last_tablebase,
        h.id id,
        f_tablebase,
        f_whether_pay,
        f_sell_id,
        f_oughtamount,
        f_oughtfee,
        f_hand_date,
        h.f_input_date,
        h.f_meter_state,
        h.f_inputtor inputtor,
        h.f_share_gas,
        f_meter_source,
        f_issued_state,
        f_surplus_gas,
        f_haircut_gas,
		f_hand_state
	   from t_handplan h
	   where f_hand_date>='{startDate} 00:00:00'
   and f_hand_date<='{endDate} 23:59:59'
		   and f_hand_state != '冲正'
		   and  f_hand_state != '作废'
   ) h on h.h_user_id=u.f_user_id
) d
left join
(
    select
		MAX(f_hand_date) f_hand_date,
		max(f_tablebase) f_tablebase,
		f_user_id
	from t_handplan
	where f_hand_state != '冲正' and  f_hand_state != '作废'
    group by f_user_id
) h1 on h1.f_user_id=d.f_user_id
) u
where  u.f_user_state = '正常' and {condition}
order by f_residential_area, f_building, f_unit,f_floor,f_room,f_address
