 select * from (
 select
       f_userinfo_id,          		//用户编号
       f_userinfo_code,
       f_user_name,            		//用户姓名
       f_user_phone,           		//用户电话
       f_area,						//区域
       f_address,              		//地址
       f_balance,          	 		//用户账户结余
       f_contract_id,          	 	//合同编号
       f_filiale,                   //分公司
       min(f_last_tablebase) f_last_tablebase,		 		//上次抄表底数
       max(f_tablebase) f_tablebase,			     		//本次抄表底数
       min(f_input_date) f_input_date,
       case when min(f_hand_date)=max(f_hand_date)
       then  cast(
       { entity.findDialect() == $SqlServer$: $year(min(f_hand_date))$,$to_char( (MIN(f_hand_date)),'yyyy')$} as
       { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$})
       { entity.findDialect() == $SqlServer$: $+$,$||$}'年'{ entity.findDialect() == $SqlServer$: $+$,$||$}cast(
       { entity.findDialect() == $SqlServer$: $MONTH(min(f_hand_date))$,$to_char( (MIN(f_hand_date)),'mm')$} as
       { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$}){ entity.findDialect() == $SqlServer$: $+$,$||$}'月'
       else  cast(
       { entity.findDialect() == $SqlServer$: $year(min(f_hand_date))$,$to_char( (MIN(f_hand_date)),'yyyy')$} as
       { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$}){ entity.findDialect() == $SqlServer$: $+$,$||$}'年'
       { entity.findDialect() == $SqlServer$: $+$,$||$}cast(
       { entity.findDialect() == $SqlServer$: $MONTH(min(f_hand_date))$,$to_char( (MIN(f_hand_date)),'mm')$} as
       { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$}){ entity.findDialect() == $SqlServer$: $+$,$||$}'月到'
       { entity.findDialect() == $SqlServer$: $+$,$||$} cast(
       { entity.findDialect() == $SqlServer$: $year(max(f_hand_date))$,$to_char( (max(f_hand_date)),'yyyy')$} as
       { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$}){ entity.findDialect() == $SqlServer$: $+$,$||$}'年'
       { entity.findDialect() == $SqlServer$: $+$,$||$}cast(
       { entity.findDialect() == $SqlServer$: $MONTH(max(f_hand_date))$,$to_char( (max(f_hand_date)),'mm')$} as
       { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$}){ entity.findDialect() == $SqlServer$: $+$,$||$}'月'
       end f_hand_date,
       sum(f_oughtamount) f_oughtamount,			 		//应交气量
       sum(f_oughtfee) f_oughtfee, 		     	 		//应交金额
       case when sum(f_oughtfee)=0 then 0 else sum(f_oughtfee)-f_balance end qianfei,//欠费金额
       sum({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(overdue,0)) overdue,					 		//滞纳金
       min(f_end_date) f_end_date				 		//截止日期
  from
  (
 	 select
		 handplan_id,											//抄表记录id
		 f_last_tablebase,										//上期指数
		 f_tablebase,											//本期指数
		 h.f_input_date,											//抄表日期
		 { entity.findDialect() == $SqlServer$: $convert(decimal(18,2),f_oughtamount)$,$round(f_oughtamount,2)$} f_oughtamount,	//应交气量
		 { entity.findDialect() == $SqlServer$: $convert(decimal(18,2),f_oughtfee)$,$round(f_oughtfee,2)$} f_oughtfee,			//应交金额
		 f_whether_pay,											//是否缴费
		 h.f_end_date,											//截止日期
		 f_hand_date,
		 overduedays,											//滞纳天数
		 h.f_user_id,                                           //用户编号
		 u.f_userinfo_id,          		//用户编号
		 u.f_userinfo_code,             //用户编号
         u.f_user_name,            		//用户姓名
         u.f_user_phone,           		//用户电话
         u2.f_address,              		//地址
         u.f_balance,          	 		//用户账户结余
         u.f_contract_id,          	 	//合同编号
         u2.f_area,						//区域
         u.f_filiale,					//分公司
	  u1.f_meter_classify,
		 case
		 when overduedays<=0 then 0
		 when  last_tablebase =f_last_tablebase then
		(case when overduedays*zhinajinbilv*(f_oughtfee-u.f_balance)>=f_oughtfee
	    then { entity.findDialect() == $SqlServer$: $convert(decimal(18,2),f_oughtfee)$,$round(f_oughtfee,2)$}
	    else { entity.findDialect() == $SqlServer$: $convert(decimal(18,2),overduedays*zhinajinbilv*(f_oughtfee-u.f_balance))$,$round(overduedays*zhinajinbilv*(f_oughtfee-u.f_balance),2)$} end)
	    else
	    (case when overduedays*zhinajinbilv*f_oughtfee>=f_oughtfee
	    then { entity.findDialect() == $SqlServer$: $convert(decimal(18,2),f_oughtfee)$,$round(f_oughtfee,2)$}
	    else { entity.findDialect() == $SqlServer$: $convert(decimal(18,2),overduedays*zhinajinbilv*f_oughtfee)$,$round(overduedays*zhinajinbilv*f_oughtfee,2)$} end)
	    end as overdue
   from(
		  select
		  h.id as handplan_id,
		  h1.last_tablebase,
		  f_last_tablebase,
		  f_tablebase,
		  f_input_date,
		  f_hand_date,
		  f_oughtamount,
		  f_oughtfee,
		  f_whether_pay,
		  f_end_date,
		  h.f_user_id,
		  f_userinfo_id,
		  { entity.findDialect() == $SqlServer$: $DATEDIFF(dd,f_end_date,getdate())+1$,$trunc(sysdate-f_end_date+1)$} overduedays, //滞纳天数
		  case when f_user_type='民用' then (select cast(value as float) from  t_singlevalue where name='民用违约金' AND f_filialeids = h.f_filialeids) else
		  (select cast(value as float) from  t_singlevalue where name='非民用违约金' AND f_filialeids = h.f_filialeids) end zhinajinbilv							   //滞纳金比率
          from
			 (
			 select * from { entity.findDialect() == $SqlServer$: $V_handplan$,${sql.call($VHandPlan$,{})}$}
			 where f_whether_pay='否' and f_meter_state = '已抄表'
			 ) h
			 left join
			 (
			  select MIN(f_last_tablebase) last_tablebase,f_user_id from { entity.findDialect() == $SqlServer$: $V_handplan$,${sql.call($VHandPlan$,{})}$}
			  group by f_user_id
			 ) h1 on h.f_user_id=h1.f_user_id
		 ) h
	   left join
	   t_userinfo u on h.f_userinfo_id=u.f_userinfo_id
           left join
	   t_userfiles u1 on h.f_user_id=u1.f_user_id
	   LEFT JOIN t_user_address u2 ON h.f_userinfo_id = u2.f_userinfo_id
	 ) u
	 where  {condition}
	 group by  f_userinfo_id,f_user_name,f_user_phone,f_address,f_balance,f_contract_id,f_area,f_filiale,f_userinfo_code
	 ) t
	 where t.f_balance<0
	 order by f_hand_date desc
