/*
 * Decompiled with CFR 0.152.
 */
package bank;

import com.af.plugins.sms.PropertiesReaderPlugin;
import com.aote.logic.LogicServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BankFileDeal {
    @Autowired
    private LogicServer logicServer;
    private String path;
    private PropertiesReaderPlugin prop = new PropertiesReaderPlugin();
    static Logger log = Logger.getLogger(BankFileDeal.class);

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void getSource() {
        File files = new File(this.path);
        for (File file : files.listFiles()) {
            if (file.isDirectory()) continue;
            String filename = file.getName();
            try {
                if (!filename.startsWith("2007") && !filename.startsWith("1003")) continue;
                this.dealFile(file);
                File bfile = new File(this.path + "\\bak\\" + filename);
                this.moveFile(file, bfile);
            }
            catch (Exception e) {
                this.writeToNewPath(file, "error");
            }
        }
    }

    private void moveFile(File aFile, File bFile) {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            int length;
            inStream = new FileInputStream(aFile);
            outStream = new FileOutputStream(bFile);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
            ((InputStream)inStream).close();
            ((OutputStream)outStream).close();
            aFile.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToNewPath(File file, String target) {
        String newpath = this.path + "\\" + target + "\\" + file.getName();
        BufferedReader read = null;
        OutputStreamWriter write = null;
        try {
            String temp;
            read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
            write = new FileWriter(new File(newpath), true);
            while ((temp = read.readLine()) != null) {
                write.write(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                read.close();
                write.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void dealFile(File file) throws Exception {
        String str = null;
        BufferedReader bf = null;
        bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
        int i = 0;
        while ((str = bf.readLine()) != null) {
            log.debug((Object)("\u8bfb\u53d6\u7b2c" + i + "\u884c\u6570\u636e\u4e3a\uff1a" + new JSONObject(str)));
            this.logicServer.run("bankFileDeal", new JSONObject(str));
            ++i;
        }
        bf.close();
    }

    public boolean deleteFile(File file) {
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return true;
    }

    private Date convertToDate(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

