package securityCheckGas;

import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author xjx@zxq.com
 * @description 安检售气系统取数据接口 工具类
 * @since 2021/8/13 11:25
 **/
public class CheckGasUtils {

    public String calculationTime(String endDate,String startDate) throws ParseException {
//        int month = Integer.parseInt(m);
//        int len = Integer.parseInt(l);
//        if (month>len){
//            month = len;
//        }
//        endDate="2021-8-13 13:50:12";
//        startDate = "2019-7-15 13:50:25";

        SimpleDateFormat format =  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date e = format.parse(endDate);
        Date s = format.parse(startDate);

        Calendar start = Calendar.getInstance();//得到日历
        Calendar end = Calendar.getInstance();
        end.setTime(e);//把时间赋给日历
        start.setTime(s);
        //判断相隔几个月
        int result = end.get(Calendar.MONTH) - start.get(Calendar.MONTH);
        int month = (end.get(Calendar.YEAR) - start.get(Calendar.YEAR)) * 12;
        if (result+month<=4 && result+month>=0){
            return startDate;
        }
        end.add(end.MONTH, -4); //设置为前4月
        s = end.getTime();//获取4个月前的时间
        startDate = format.format(s);
        return startDate;
    }
    public JSONObject years(String endDate){
        endDate = endDate.trim().substring(0,4)+"-10-25 00:00:00";
        String startDate = (Integer.parseInt(endDate.substring(0,4))-1)+"-10-25 00:00:00";
        JSONObject jo = new JSONObject();
        jo.put("startDate",startDate);
        jo.put("endDate",endDate);
        return jo;
    }
}
