package meter;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

import java.util.ArrayList;
import java.util.List;

public class MeterManage {
    static Logger log = Logger.getLogger(EntityServer.class);

    // 入库
    public void meterJoin(SqlServer sql, EntityServer entity, JSONObject data) throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_distribution_state = '已入库',f_warehouse_id = "+f_warehouse_id+" where id in "+ids);
        log.debug("更新meterinfo成功:"+n);
        // 更新仓库库存
        n = sql.runSQL("update t_warehouse set f_warehouse_number = ISNULL(f_warehouse_number, 0)+"+rowsdata.length()+",f_notreceive_number=ISNULL(f_notreceive_number, 0)+"+rowsdata.length()+" where id = "+f_warehouse_id);
        log.debug("更新t_warehouse库存成功:"+n);
    }

    public void meterJoin1(SqlServer sql, EntityServer entity, JSONObject data) throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        int f_warehouse_id = model.getInt("f_warehouse_id");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        int n=0;
        int id;
        for (int i=0;i<rowsdata.length();i++){
            JSONArray a=sql.query("select * from t_stock where f_material_class_id = "+rowsdata.getJSONObject(i).getInt("f_material_class_id")+" and f_warehouse_id = "+f_warehouse_id);
            if (a.length()>0){
                n=sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)+"+rowsdata.getJSONObject(i).getInt("number")+" where id = "+a.getJSONObject(0).getInt("id"));
                id=a.getJSONObject(0).getInt("id");
            }else{
                JSONObject stock =new JSONObject();
                stock.put("f_material_class_id",rowsdata.getJSONObject(i).getInt("f_material_class_id"));
                stock.put("f_warehouse_id",f_warehouse_id);
                stock.put("f_number",rowsdata.getJSONObject(i).getInt("number"));
                stock.put("f_isinfo",rowsdata.getJSONObject(i).getString("f_isinfo"));
                JsonTools jsonTools=new JsonTools();
                id=jsonTools.convertToJson(entity.partialSave("t_stock",stock)).getInt("id");

            }
            if (rowsdata.getJSONObject(i).getString("f_isinfo").equals("是")){
                JSONArray meterinfo = rowsdata.getJSONObject(i).getJSONArray("info");
                for (int j=0;j<meterinfo.length();j++){
                    n=sql.runSQL("update t_meterinfo set f_distribution_state = '已入库' where id = "+meterinfo.getJSONObject(j).getInt("id"));
                    n=sql.runSQL("update t_meterinfo set f_stock_id = "+id+" where id = "+meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_meterinfo_id",meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_stock_id",id);
                    model.put("f_number", 1);
                    model.remove("id");
                    entity.partialSave("t_meter_record",model);
                }
            }else{
                model.put("f_stock_id",id);
                model.put("f_number",rowsdata.getJSONObject(i).getInt("number"));
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record",model);
            }
            n=sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)-"+rowsdata.getJSONObject(i).getInt("number")+" where id = "+rowsdata.getJSONObject(i).getInt("id"));
        }
    }
    public void meterAllocate1(SqlServer sql, EntityServer entity,JSONObject data)throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        int f_warehouse_id = model.getInt("f_warehouse_id");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date", nowDate);
        int n = 0;
        int id;
        for (int i = 0; i < rowsdata.length(); i++) {
            JSONArray a = sql.query("select * from t_stock where f_material_class_id = " + rowsdata.getJSONObject(i).getInt("f_material_class_id") + " and f_warehouse_id = " + f_warehouse_id);
            if (a.length() > 0) {
                n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)+" + rowsdata.getJSONObject(i).getInt("number") + " where id = " + a.getJSONObject(0).getInt("id"));
                id = a.getJSONObject(0).getInt("id");
            } else {
                JSONObject stock = new JSONObject();
                stock.put("f_material_class_id", rowsdata.getJSONObject(i).getInt("f_material_class_id"));
                stock.put("f_warehouse_id", f_warehouse_id);
                stock.put("f_number", rowsdata.getJSONObject(i).getInt("number"));
                stock.put("f_isinfo", rowsdata.getJSONObject(i).getString("f_isinfo"));
                JsonTools jsonTools = new JsonTools();
                id = jsonTools.convertToJson(entity.partialSave("t_stock", stock)).getInt("id");

            }
            if (rowsdata.getJSONObject(i).getString("f_isinfo").equals("是")) {
                JSONArray meterinfo = rowsdata.getJSONObject(i).getJSONArray("info");
                for (int j = 0; j < meterinfo.length(); j++) {
                    n=sql.runSQL("update t_meterinfo set f_stock_id = "+id+" where id = "+meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_meterinfo_id", meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_stock_id", id);
                    model.put("f_number", 1);
                    model.remove("id");
                    entity.partialSave("t_meter_record", model);
                }
            } else {
                model.put("f_stock_id", id);
                model.put("f_number", rowsdata.getJSONObject(i).getInt("number"));
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", model);
            }
            n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)-" + rowsdata.getJSONObject(i).getInt("number") + " where id = " + rowsdata.getJSONObject(i).getInt("id"));
        }
    }
    public void meterReturn1(SqlServer sql, EntityServer entity,JSONObject data)throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date", nowDate);
        int n = 0;
        int a =0;
        for(int i=0;i<rowsdata.length();i++){
            a=rowsdata.getJSONObject(i).getInt("f_meteroperate_id");
            n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)+" + rowsdata.getJSONObject(i).getInt("number") + " where id = " + rowsdata.getJSONObject(i).getInt("f_stock_id"));
            model.put("f_stock_id", rowsdata.getJSONObject(i).getInt("f_stock_id"));
            model.put("f_number", rowsdata.getJSONObject(i).getInt("number"));
            if (rowsdata.getJSONObject(i).get("f_meterinfo_id")!=null){
                n = sql.runSQL("update t_meterinfo set f_distribution_state = '已入库' where id = "+rowsdata.getJSONObject(i).get("f_meterinfo_id"));
                model.put("f_meterinfo_id", rowsdata.getJSONObject(i).get("f_meterinfo_id"));
                model.remove("id");
                entity.partialSave("t_meter_record", model);

            }else {
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", model);
            }
        }
        n = sql.runSQL("update t_meter_operate set f_returnstate = '已归还' where id = "+a);


    }

    public void meterReceive1(SqlServer sql, EntityServer entity,JSONObject data)throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date", nowDate);
        int n = 0;
        for(int i=0;i<rowsdata.length();i++){
            n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)-" + rowsdata.getJSONObject(i).getInt("number") + " where id = " + rowsdata.getJSONObject(i).getInt("id"));
            if (rowsdata.getJSONObject(i).getString("f_isinfo").equals("是")){
                JSONArray meterinfo = rowsdata.getJSONObject(i).getJSONArray("info");
                for (int j=0;j<meterinfo.length();j++){
                    n = sql.runSQL("update t_meterinfo set f_distribution_state = '已领用' where id = "+meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_meterinfo_id", meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_stock_id", rowsdata.getJSONObject(i).getInt("id"));
                    model.put("f_number", 1);
                    model.remove("id");
                    entity.partialSave("t_meter_record", model);
                }
            }else {
                model.put("f_stock_id", rowsdata.getJSONObject(i).getInt("id"));
                model.put("f_number", rowsdata.getJSONObject(i).getInt("number"));
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", model);
            }
        }

    }
    // 表具领用
    public void meterReceive(SqlServer sql, EntityServer entity, JSONObject data) throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_distribution_state = '已领用' where id in "+ids);
        log.debug("更新meterinfo成功:"+n);
        // 更新仓库库存
        n = sql.runSQL("update t_warehouse set f_receive_number=ISNULL(f_receive_number, 0)+"+rowsdata.length()+",f_notreceive_number=ISNULL(f_notreceive_number, 0)-"+rowsdata.length()+" where id = "+f_warehouse_id);
        log.debug("更新t_warehouse库存成功:"+n);
    }

    //库存调拨
    public void meterAllocate(SqlServer sql, EntityServer entity,JSONObject data)throws Exception{
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        int f_warehouse_id_old=model.getInt("f_warehouse_id_old");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_warehouse_id = "+f_warehouse_id+" where id in "+ids);
        log.debug("更新meterinfo成功:"+n);

        int number=rowsdata.length();
        int m=sql.runSQL("update t_warehouse set f_warehouse_number = f_warehouse_number-"+number+", f_notreceive_number = f_notreceive_number-"+number+" where id = "+f_warehouse_id_old);
        int p=sql.runSQL("update t_warehouse set f_warehouse_number = f_warehouse_number+"+number+", f_notreceive_number = f_notreceive_number+"+number+" where id = "+f_warehouse_id);
    }

    
    public void stockImport(SqlServer sql, EntityServer entity,JSONArray datas)  throws Exception {
        JSONArray array =sql.query("select id from t_material_class");

        int a= 0;
        for (int i=0;i<datas.length();i++) {

            for (int j=0;j<array.length();j++){
                if (datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id")==array.getJSONObject(j).getInt("id")){
                    a=1;
                }
            }
            if (a==0){
                throw new Exception();
            }
            if (datas.getJSONObject(i).getJSONObject("stock").getInt("f_number") <= 0){
                throw new Exception();
            }
            if (datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo")==null){
                throw new Exception();
            }
        }
        for (int i=0;i<datas.length();i++) {
            if (datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo").equals("否")){
                int mcid=datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id");
                JSONArray array2 =sql.query("select * from t_stock where f_warehouse_id is null and f_material_class_id = "+mcid);
                if (array2.length()>0){
                    int n = sql.runSQL("update t_stock set f_number=ISNULL(f_number, 0)+"+datas.getJSONObject(i).getJSONObject("stock").getInt("f_number")+" where id = "+array2.getJSONObject(0).getInt("id"));
                }else{
                    JSONObject model = new JSONObject();
                    model.put("f_material_class_id",datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id"));
                    model.put("f_number",datas.getJSONObject(i).getJSONObject("stock").getInt("f_number"));
                    model.put("f_isinfo",datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo"));
                    entity.partialSave("t_stock",model);
                }
            }else if(datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo").equals("是")){
                int mcid=datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id");
                JSONArray array2 =sql.query("select * from t_stock where f_warehouse_id is null and f_material_class_id = "+mcid);
                if (array2.length()==0){
                    JSONObject model = new JSONObject();
                    model.put("f_material_class_id",datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id"));
                    model.put("f_number",0);
                    model.put("f_isinfo",datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo"));
                    entity.partialSave("t_stock",model);
                }
            }

        }
        
    }
    //表具退回
    public void meterReturn(SqlServer sql, EntityServer entity,JSONObject data)throws Exception{
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_distribution_state = '已入库' where id in "+ids);
        log.debug("更新meterinfo成功:"+n);

        int number=rowsdata.length();
        int m=sql.runSQL("update t_warehouse set f_receive_number = f_receive_number-"+number+", f_notreceive_number = f_notreceive_number+"+number+" where id = "+f_warehouse_id);
    }

    /**
     * 通过插件执行Logic
     * 不能通过单元测试,因为单元测试并没有定义上下文，所以取不到Bean工厂
     * 依旧会被回滚,没时间去找原因了。下次再说吧，方法先留着。
     */
    private static Logger logger = Logger.getLogger(MeterManage.class);
    public JSONObject runLogic(JSONObject ja) {
        // 获取Spring的Bean生产工厂
        WebApplicationContext cl = ContextLoaderListener.getCurrentWebApplicationContext();
        LogicServer ls = cl.getBean(LogicServer.class);
        JSONObject param = new JSONObject().put("instructType", "阀门控制")
                .put("inputtor", ja.getString("inputtor"))
                .put("contentData", new JSONObject().put("isOpen", ja.getInt("contentData")));
        JSONArray jarray = ja.getJSONArray("userid");
        JSONObject result = new JSONObject();
        List<Integer> cg = new ArrayList<>();
        List<Integer> sb = new ArrayList<>();
        for (int i = 0; i < jarray.length(); i++) {
            JSONObject p = jarray.getJSONObject(i);
            try {
                // 组织saveInstruct的数据
                param.put("condition", "t_userfiles.f_user_id= '" + p.getInt("f_user_id") + "'");
                param.put("meterBrandName", p.getString("f_alias"));
                // 组织updateNetWorkValve的数据
                param.put("f_user_id", p.getInt("f_user_id"))
                        .put("f_userinfo_id", p.getInt("f_userinfo_id"));
                param.put("state", 1);
                ls.run("saveInstruct", param, null);
                ls.run("updateNetWorkValve", param, null);
                cg.add(p.getInt("f_user_id"));
            } catch (Exception e) {
                logger.error("f_user_id为:" + p.getInt("f_user_id") + "在保存指令时出错", e);
                sb.add(p.getInt("f_user_id"));
            }
        }
        return result.put("cg", cg).put("sb", sb);
    }
    /**
     * 删除jsonArray中的key值
     */
    public JSONArray deleteName(JSONArray ja, String name) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < ja.length(); i++) {
            result.put(ja.getJSONObject(i).get(name));
        }
        System.out.println(result);
        return result;
    }
}
