package com.aote.rs.aes;

import com.aote.rs.utils.ReadFile;
import org.json.JSONObject;

import java.security.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class FileReadConfig {

    /**
     * 获取json配置文件内容
     * @param filename  配置文件名 位置:applicationConfig下
     */
    public static JSONObject getjsonfromfile(String filename) throws Exception {
        JSONObject returnjson = new JSONObject();
        if(filename == null || "".equals(filename) ){
            return returnjson;
        }
        ReadFile file =new ReadFile();
        try{
            String configFilePath = "";
            String path  =file.GetResourceURL("applicationConfig/"+filename);
            returnjson = file.Read(path);

        }catch(Exception e){
            throw new Exception("当前组织未进行配置,请联系管理人员!");
        }
        return returnjson;
    }
    public static HashMap getJudgeArray(Map map){
        if(map == null) return  null;
        HashMap<String, String> reslutmap = new HashMap<>();
        Iterator<String> it = map.keySet().iterator();
        while(it.hasNext()){
            String next = it.next();
            Object o = map.get(next);
            if(map.get(next) instanceof Timestamp){
                reslutmap.put(next,new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(next)));
            }else{
                reslutmap.put(next,map.get(next).toString());
            }
        }
        return reslutmap;
    }

}
