package com.aote.redis;

import com.aote.rs.LogicService;
import com.aote.rs.SqlService;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

@Component
public class CacheUtil {

    private static final Logger LOGGER = Logger.getLogger(CacheUtil.class);

    @Autowired
    private SqlService sqlService;

    @Autowired
    private LogicService logicService;

    public JSONArray getAndCache(String sqlName, JSONObject params, Integer pageSize){
        return getAndCache(sqlName,params, pageSize, 60*60*6);
    }

    /**
     * 缓存并获取数据
     * @param sqlName SQL名称
     * @param params SQL查询参数
     * @param time 缓存时间（秒，默认6小时）
     * @return 数据
     */
    public JSONArray getAndCache(String sqlName, JSONObject params, Integer pageSize, Integer time){
        TreeMap<String, Object> treeMap = new TreeMap<>(params.toMap());
        String treeString = treeMap.toString();
        String keyName = sqlName + "@" + treeString;

        LOGGER.info("获取并缓存的SQL名称：" + sqlName + "，参数：" + treeString+"，缓存时间：" + time + "秒");

        NewRedisUtil redisUtil = NewRedisUtil.getInstance();
        Object data = redisUtil.get(keyName);
        if(data != null){
            LOGGER.info(sqlName + "获取缓存数据");
            return new JSONArray(redisUtil.get(keyName).toString());
        } else {
            AtomicReference<JSONArray> result = new AtomicReference<>();
            redisUtil.lock(keyName + "_LOCK", ()->{
                Object cacheData = redisUtil.get(keyName);
                if(cacheData != null) {
                    result.set(new JSONArray(cacheData.toString()));
                    return;
                }
                try {
                    LOGGER.info(sqlName + "无缓存，进行缓存");
                    // pageSize小于0，纠正成1, 解除1000限制
                    int realPageSize = pageSize;
                    if (realPageSize < 1) {
                        realPageSize = 9999999;
                    }
                    result.set(new JSONArray(
                            sqlService.txExecute(sqlName, 1, realPageSize,
                                    new JSONObject().put("data", params).toString()))
                    );
                    redisUtil.set(keyName, result.toString(), time);
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            return result.get();
        }
    }

    public String runAndCache(String logicName, JSONObject params, Integer time){
        TreeMap<String, Object> treeMap = new TreeMap<>(params.toMap());
        String treeString = treeMap.toString();
        String keyName = logicName + "@" + treeString;

        LOGGER.info("获取并缓存的Logic名称：" + logicName + "，参数：" + treeString+"，缓存时间：" + time + "秒");

        NewRedisUtil redisUtil = NewRedisUtil.getInstance();

        LOGGER.info("获取并缓存的Logic名称：" + logicName + "，参数：" + treeString+"，缓存时间：" + time + "秒");
        Object data = redisUtil.get(keyName);
        if(data != null){
            LOGGER.info(logicName + "获取缓存数据");
            return redisUtil.get(keyName).toString();
        } else {
            AtomicReference<String> result = new AtomicReference<>();
            redisUtil.lock(keyName + "_LOCK", ()->{
                LOGGER.info(redisUtil.get(keyName) + "获取redisUtil");
                Object cacheData = redisUtil.get(keyName);
                if(cacheData != null) {
                    result.set(cacheData.toString());
                    return;
                }
                try {
                    LOGGER.info(logicName + "无缓存，进行缓存");
                    params.put("isCache", "1");
                    result.set(logicService.xtSave(logicName,params.toString()));
                    redisUtil.set(keyName, result.get(), time);
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            return result.get();
        }
    }
    public String runAndCache(String logicName, JSONObject params){
        return runAndCache(logicName, params, 60*60*6);
    }
}
