select * from (
  select
    u.f_userinfo_code,
    u.f_olduserinfo_code,
    u.f_userinfo_id,
    u.version,
    f.f_adjustable_id,
    f.f_user_id,
    f.f_userfiles_id,
    f.f_price_id,
    u.f_user_name,
    u.f_filialeid,
    u.f_createfile_date,
    u.f_user_phone,
    a.id addressid,
    a.f_address,
    u.f_user_state,
    f.f_user_type,
    f.f_gasproperties,
    f.f_table_state,
    f.f_meternumber,
    gb.f_meter_brand,
    gb.f_collection_type,
    gb.f_calculation,
    gm.f_meter_style,
    sp.f_price_name,
    sp.f_price_type
  from
    t_userfiles f
    LEFT JOIN t_userinfo u on f.f_userinfo_id = u.f_userinfo_id
    LEFT JOIN t_user_address a on f.f_useraddress_id = a.id
    left join t_gasbrand gb on f.f_gasbrand_id = gb.id
    left join t_gasmodel gm on f.f_gasmodel_id = gm.id
    LEFT JOIN (
			SELECT
				*
			FROM
				t_stairprice
			WHERE
				((getdate() >= f_perform_date
			AND getdate() <= f_end_date) or (getdate()<f_perform_date) )
			AND f_state = '有效'
		) sp ON sp.f_price_id = f.f_price_id
) u
where {condition} and  f_table_state in('正常','待开通')
ORDER by f_userinfo_id desc
