/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class AesUtils {
    private static final int KEY_SIZE = 128;
    private static final String ALGORITHM = "AES";
    private static final String RNG_ALGORITHM = "SHA1PRNG";

    private static SecretKey generateKey(byte[] key) throws Exception {
        SecureRandom random = SecureRandom.getInstance(RNG_ALGORITHM);
        random.setSeed(key);
        KeyGenerator gen = KeyGenerator.getInstance(ALGORITHM);
        gen.init(128, random);
        return gen.generateKey();
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] key) throws Exception {
        SecretKey secKey = AesUtils.generateKey(key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, secKey);
        byte[] cipherBytes = cipher.doFinal(plainBytes);
        return cipherBytes;
    }

    public static byte[] decrypt(byte[] cipherBytes, byte[] key) throws Exception {
        SecretKey secKey = AesUtils.generateKey(key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, secKey);
        byte[] plainBytes = cipher.doFinal(cipherBytes);
        return plainBytes;
    }

    public static void encryptFile(File plainIn, File cipherOut, byte[] key) throws Exception {
        AesUtils.aesFile(plainIn, cipherOut, key, true);
    }

    public static void decryptFile(File cipherIn, File plainOut, byte[] key) throws Exception {
        AesUtils.aesFile(plainOut, cipherIn, key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void aesFile(File plainFile, File cipherFile, byte[] key, boolean isEncrypt) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        SecretKey secKey = AesUtils.generateKey(key);
        cipher.init(isEncrypt ? 1 : 2, secKey);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            if (isEncrypt) {
                in = new FileInputStream(plainFile);
                out = new FileOutputStream(cipherFile);
            } else {
                in = new FileInputStream(cipherFile);
                out = new FileOutputStream(plainFile);
            }
            byte[] buf = new byte[1024];
            int len = -1;
            while ((len = ((InputStream)in).read(buf)) != -1) {
                ((OutputStream)out).write(cipher.update(buf, 0, len));
            }
            ((OutputStream)out).write(cipher.doFinal());
            out.flush();
        }
        catch (Throwable throwable) {
            AesUtils.close(in);
            AesUtils.close(out);
            throw throwable;
        }
        AesUtils.close(in);
        AesUtils.close(out);
    }

    private static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String aesencirypt(String content, String key) throws Exception {
        if (content == null || key == null) {
            return "";
        }
        if ("".equals(content) || "".equals(key)) {
            return "";
        }
        byte[] encrypt = AesUtils.encrypt(content.getBytes(), key.getBytes());
        byte[] bytes = Base64.encodeBase64((byte[])encrypt);
        return new String(bytes);
    }

    public static String aesdecrypt(String encrypt, String key) throws Exception {
        if (encrypt == null || key == null) {
            return "";
        }
        if ("".equals(encrypt) || "".equals(key)) {
            return "";
        }
        byte[] encryptbytes = Base64.decodeBase64((byte[])encrypt.getBytes());
        byte[] decrypt = AesUtils.decrypt(encryptbytes, key.getBytes());
        return new String(decrypt);
    }

    public static void main(String[] args) throws Exception {
        String aesencirypt = AesUtils.aesencirypt("{\"appid\":{\"name\":\"123\"}}", "123456");
        System.out.println(aesencirypt);
    }
}

