/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.json.JSONObject;

public class ParameterRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, Object> params = new HashMap<String, Object>();

    public ParameterRequestWrapper(HttpServletRequest request) {
        super(request);
        this.params.putAll(request.getParameterMap());
    }

    public ParameterRequestWrapper(HttpServletRequest request, Map<String, Object> extendParams) {
        this(request);
    }

    public void addAllParameters(Map<String, Object> otherParams) {
        for (Map.Entry<String, Object> entry : otherParams.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            String values = "";
            if (value instanceof String) {
                try {
                    values = new String(((String)value).getBytes("UTF-8"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                this.params.put(name, values);
            } else {
                try {
                    values = new String(String.valueOf(value).getBytes("UTF-8"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                this.params.put(name, values);
            }
        }
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getBody() {
        String s = this.params.toString();
        return new String(s.getBytes(), StandardCharsets.UTF_8);
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(new JSONObject(this.params).toString().getBytes("UTF-8"));
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }
        };
    }
}

