package webservice;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.json.JSONObject;

import java.util.Date;

public class SafeCheck_aode {

    public static void main(String[] args) throws Exception {
        String url = "http://ssl.odc.hk:8026/hsms/services/wsResidentService?wsdl";

        String methodName = "selectResidentWithTaskSimple";

//        String parameters = "{\"residentNo\":\"60010007346\"}";
        JSONObject parameter = new JSONObject();
        parameter.put("residentNo", "1051002498");

        JSONObject result = getService(url,parameter.toString(),methodName);

        System.out.println(result);
    }

    public static JSONObject getService(String url,String parameters,String methodName) throws Exception {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(url);

        HTTPConduit conduit = (HTTPConduit) client.getConduit();
        HTTPClientPolicy policy = new HTTPClientPolicy();
        long timeout = 10 * 1000;
        policy.setConnectionTimeout(timeout);
        policy.setReceiveTimeout(timeout);
        conduit.setClient(policy);
        //动态invoke方法
        Object[] getReturn = client.invoke(methodName,parameters);
        if (getReturn[0] != null) {
            return new JSONObject(getReturn[0].toString());
        } else {
            return new JSONObject();
        }
    }
}
