package util;


import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class HttpPlugin {

	private static Logger log = Logger.getLogger(HttpPlugin.class);
	/**
	 * 普通post请求，参数和返回值均为json格式
	 * @param url
	 * @param data
	 * @return
	 * @throws Exception
	 */
	public JSONObject post(String url, JSONObject data){
		log.debug("url :" + url);
		log.debug("data :" + data);

		try {
			HttpPost hp = new HttpPost(url);
			hp.setHeader("Content-Type", "application/JSON");
			hp.setEntity(new StringEntity(data.toString(), "UTF-8"));

			HttpClient httpClient = new DefaultHttpClient();
			HttpResponse response = httpClient.execute(hp);

			int code = response.getStatusLine().getStatusCode();
			log.debug("状态码"+code);
			if (code == 200) {
				log.debug("返回数据"+response.getEntity());
				String result;
				result = EntityUtils.toString(response.getEntity(), "UTF-8");
				log.debug("返回内容"+result);
				return new JSONObject(result);

			}else {
				throw new RuntimeException("status = " + code);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			throw new RuntimeException(e);
		}
	}

	public JSONObject postByRequestBody(String url, String data){
        log.debug("url :" + url);
        log.debug("data :" + data);
        try {
        PostMethod postMethod = new PostMethod(url) ;
        postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8") ;
        NameValuePair[] datas = {
                new NameValuePair("data",data),

        };
        postMethod.setRequestBody(datas);
        org.apache.commons.httpclient.HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
        int response = httpClient.executeMethod(postMethod); // 执行POST方法
        BufferedReader reader = new BufferedReader(new InputStreamReader(postMethod.getResponseBodyAsStream()));
        StringBuffer stringBuffer = new StringBuffer();
        String str = "";
        while((str = reader.readLine())!=null){
            stringBuffer.append(str);
        }
        String 	result=stringBuffer.toString();

        log.debug("状态码"+response);
        if (response == 200) {
            log.debug("返回内容"+result);
            return new JSONObject(result);
        }else {
            throw new RuntimeException("status = " + response);
        }

    } catch (Exception e) {
        // TODO Auto-generated catch block
        throw new RuntimeException(e);
    }

    }

	/**
	 * 普通post请求，参数和返回值均为json格式
	 * @param url
	 * @param data
	 * @return
	 * @throws Exception
	 */
	public JSONObject doPost(String url, JSONObject data){
		log.debug("url :" + url);
		log.debug("data :" + data);
		JSONObject ret = new JSONObject();
		try {

			HttpPost hp = new HttpPost(url);
			hp.setHeader("Content-Type", "application/JSON");
			hp.setEntity(new StringEntity(data.toString(), "UTF-8"));

			HttpClient httpClient = new DefaultHttpClient();
			HttpResponse response = httpClient.execute(hp);

			int code = response.getStatusLine().getStatusCode();
			log.debug("状态码"+code);
			if (code == 200) {
				log.debug("返回数据"+response.getEntity());
				String result;
				result = EntityUtils.toString(response.getEntity(), "UTF-8");
				log.debug("返回内容"+result);
				if (result.startsWith("{"))
					return new JSONObject(result);
			}else {
				ret.put("code",code);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			ret.put("code",501);
			ret.put("msg",e.getMessage());
		}
		return ret;
	}
	/**
	 * 普通post请求，参数和返回值均为json格式
	 * @param url
	 * @param data
	 * @return
	 * @throws Exception
	 */
	public JSONArray sqlpost(String url, JSONObject data){
		log.debug("url :" + url);
		log.debug("data :" + data);
		JSONArray array = new JSONArray();
		try {
			JSONObject ret = new JSONObject();
			HttpPost hp = new HttpPost(url);
			hp.setHeader("Content-Type", "application/JSON");
			hp.setEntity(new StringEntity(data.toString(), "UTF-8"));

			HttpClient httpClient = new DefaultHttpClient();
			HttpResponse response = httpClient.execute(hp);

			int code = response.getStatusLine().getStatusCode();
			log.debug("状态码"+code);
			if (code == 200) {
				log.debug("返回数据"+response.getEntity());
				String result;
				result = EntityUtils.toString(response.getEntity(), "UTF-8");
				log.debug("返回内容"+result);
				if (result.startsWith("["))
					return new JSONArray(result);
				if (result.startsWith("{"))
					array.put(new JSONObject(result)) ;

				return array;
			}else {
				throw new RuntimeException("status = " + code);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			throw new RuntimeException(e);
		}

	}
	/**
	 * 	get请求，返回json
	 * @param path
	 * @return
	 */
	public static JSONObject get(String path) {
		JSONObject accob = null ;
		log.debug("url===>" +path);
		try {
			DefaultHttpClient httpclient = new DefaultHttpClient();
			HttpGet getReqacc = new HttpGet(path);
			HttpResponse httpResacc = httpclient.execute(getReqacc);
			int code = httpResacc.getStatusLine().getStatusCode();
			if (code == 200) {
				HttpEntity accent = httpResacc.getEntity();
				if (accent !=null) {
					String accentstr = EntityUtils.toString(accent, "utf-8");
					accob = new JSONObject(accentstr);
					return accob;
				}else {
					return new JSONObject();
				}
			}else {
				return new JSONObject();
			}
		} catch (Exception e) {

			throw new RuntimeException(e);
		}
	}
	/**
	 * 发送https请求,
	 * @param url
	 * @return
	 */
	public static String post(String url,String data){
		try {
			HttpClient httpclient = new SSLClient();
			HttpPost postRequest = new HttpPost(url);//
			postRequest.setEntity(new StringEntity(data, "UTF-8"));
			HttpResponse httpResponse = httpclient.execute(postRequest);

			int StatusCode = httpResponse.getStatusLine().getStatusCode();

			if (StatusCode != 200) {//
				throw new RuntimeException("发送请求失败，错误代码:" + StatusCode);
			}
			HttpEntity entity = httpResponse.getEntity();
			String rs = EntityUtils.toString(entity, "UTF-8");

			return rs;
		}catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

    /**
     * 获取URL.
     * @param url
     * @param jsonObject
     * @return
     */
	public static String getUrl(String url,JSONObject jsonObject){
	    StringBuilder sb = new StringBuilder(url);
	    sb.append("?");
	    int i = 0;
	    try {
			for (String key : jsonObject.keySet()) {
				if (jsonObject.get(key) != null && !"".equals(jsonObject.get(key)))
					sb.append(key).append("=").append(URLEncoder.encode(jsonObject.get(key).toString(),"UTF8"));
				i++;
				if (i < jsonObject.length()) {
					sb.append("&");
				}
			}
		}catch (Exception e){
			throw new RuntimeException(e);
		}
        return sb.toString().replaceAll("\\+","%20").replaceAll("%3A",":");

    }

    public  static Map<String,String>  parseRequestParamMap(Map<String,String[]>map){
		Map<String,String> returnMap = new HashMap<String,String>();
		Iterator entries = map.entrySet().iterator();
		Map.Entry entry;
		String name ="";
		String value=null;
		while (entries.hasNext()){
			entry=(Map.Entry)entries.next();
			name = (String) entry.getKey();
			if(name!=null && !"".equals(name.trim())){
				Object objvalue = entry.getValue();
				if(objvalue == null){
					value = null;
				}else if(objvalue instanceof String[]){
					String[] values = (String[]) objvalue;
					for(int i=0;i<values.length;i++){
						value = values[i]+",";
					}
					value = value.substring(0,value.length()-1);//截掉最后一个逗号。
				}else{
					value = objvalue.toString();
				}
				returnMap.put(name , value);
			}
		}
		return returnMap;

	}

}
