package bank;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import com.af.plugins.sms.PropertiesReaderPlugin;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;

@Transactional
public class BankFileDealAK {

	@Autowired
	private LogicServer logicServer;
	
    static Logger log = Logger.getLogger(EntityServer.class);

	private String path;

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public void getSource() {

		File files = new File(path);

		File[] file = files.listFiles();

		for (int i = 0; i < file.length; i++) {
			if (file[i].isFile()) {
				// 获取文件名，判断文件名是否符合格式
				if (isLegitimacy(file[i].getAbsolutePath())) {
					// 对文件内容进行解析返回jsonArray
					try {
						dealFile(file[i]);
						writeToNewPath(file[i], "bak");
					} catch (Exception e) {
						writeToNewPath(file[i], "error");
						log.debug("出错。。：" + e);
					}
				}

			}
		}
	}

	/**
	 * 判断文件名是否合法(以nx和yz开头为合法)
	 * 
	 * @param path
	 * @return
	 */
	private boolean isLegitimacy(String path) {
		String new_path = path.replace("\\", "/");
		String filename = new_path.split("/")[new_path.split("/").length - 1];
		return (filename.startsWith("2004"));

	}

	private void dealFile(File file) throws Exception {
		String str = null;
		BufferedReader bf = null;
		bf = new BufferedReader(new InputStreamReader(new FileInputStream(
				file), "GBK"));
		int i = 0;
		while ((str = bf.readLine()) != null) {
			log.debug("读取第" + i + "行数据为：" + new JSONObject(str));
			logicServer.run("bankFileDealAK", new JSONObject(str));
			i++;
		}
		bf.close();
	}

	private void writeToNewPath(File file, String target) {

		// 获取新的路径
		String newpath = path + "\\" + target + "\\" + file.getName();
		BufferedReader read = null;
		FileWriter write = null;
		try {
			read = new BufferedReader(new InputStreamReader(
					new FileInputStream(file), "GBK"));
			write = new FileWriter(new File(newpath), true);

			String temp;
			while ((temp = read.readLine()) != null) {
				write.write(temp + "\r\n");
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				read.close();
				write.close();
				deleteFile(file);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public boolean deleteFile(File file) {
		if (file.exists() && file.isFile()) {
			return file.delete();
		}
		return true;
	}

	private Date convertToDate(String str) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

		Date date = null;
		try {
			date = sdf.parse(str);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return date;
	}
//	public static void main(String[] args) {
//		BankFileDeal file = new BankFileDeal();
//		file.path = "E:\\奥枫\\新产品\\test\\";
//		file.getSource();
//	}
}
