/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.ListType;
import org.hibernate.type.LongType;
import org.hibernate.type.SetType;
import org.hibernate.type.TimeType;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate4.HibernateTemplate;

public class JSONHelper {
    static Logger log = Logger.getLogger(JSONHelper.class);

    public static HashMap<String, Object> toHashMap(JSONObject jsonObject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            Object value;
            String key = String.valueOf(it.next());
            try {
                value = jsonObject.get(key);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            result.put(key, value);
        }
        return result;
    }

    public static HashMap<String, Object> toHashMap(JSONObject object, HibernateTemplate hibernateTemplate, String entityName) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = object.keys();
        ClassMetadata classData = hibernateTemplate.getSessionFactory().getClassMetadata(entityName);
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = object.get(key);
            Type propType = null;
            try {
                propType = classData.getPropertyType(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object.isNull(key)) {
                if (key.equals("id")) continue;
                map.put(key, null);
                continue;
            }
            if (value instanceof JSONArray && propType instanceof SetType) {
                Set<Map<String, Object>> set = JSONHelper.saveSet(hibernateTemplate, (JSONArray)value);
                map.put(key, set);
                continue;
            }
            if (value instanceof JSONArray && propType instanceof ListType) {
                List<Map<String, Object>> set = JSONHelper.saveList(hibernateTemplate, (JSONArray)value);
                map.put(key, set);
                continue;
            }
            if (value instanceof JSONObject) {
                JSONObject obj = (JSONObject)value;
                String type = (String)obj.get("EntityType");
                Map<String, Object> set = JSONHelper.saveWithoutExp(hibernateTemplate, type, (JSONObject)value);
                map.put(key, set);
                continue;
            }
            if (propType != null && (propType instanceof DateType || propType instanceof TimeType)) {
                long l = 0L;
                if (value instanceof Double) {
                    l = ((Double)value).longValue();
                } else if (value instanceof Long) {
                    l = (Long)value;
                } else if (value instanceof Integer) {
                    l = ((Integer)value).intValue();
                }
                Date d = new Date(l);
                map.put(key, d);
                continue;
            }
            if (value instanceof Integer && propType instanceof DoubleType) {
                Integer v = (Integer)value;
                map.put(key, v.doubleValue());
                continue;
            }
            if (value instanceof Integer && propType instanceof LongType) {
                Long v = Long.valueOf(value.toString());
                map.put(key, (long)v);
                continue;
            }
            if (!(value instanceof String) || value.toString().indexOf("#") != -1) {
                // empty if block
            }
            map.put(key, value);
        }
        return map;
    }

    private static Set<Map<String, Object>> saveSet(HibernateTemplate hibernateTemplate, JSONArray array) throws JSONException {
        HashSet<Map<String, Object>> set = new HashSet<Map<String, Object>>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            String type = (String)obj.get("EntityType");
            Map<String, Object> map = JSONHelper.saveWithoutExp(hibernateTemplate, type, obj);
            set.add(map);
        }
        return set;
    }

    private static List<Map<String, Object>> saveList(HibernateTemplate hibernateTemplate, JSONArray array) throws JSONException {
        ArrayList<Map<String, Object>> set = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            String type = (String)obj.get("EntityType");
            Map<String, Object> map = JSONHelper.saveWithoutExp(hibernateTemplate, type, obj);
            set.add(map);
        }
        return set;
    }

    private static Map<String, Object> saveWithoutExp(HibernateTemplate hibernateTemplate, String entityName, JSONObject object) throws JSONException {
        ClassMetadata classData = hibernateTemplate.getSessionFactory().getClassMetadata(entityName);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = object.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Type propType = null;
            try {
                propType = classData.getPropertyType(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object value = object.get(key);
            if (object.isNull(key)) {
                if (key.equals("id")) continue;
                map.put(key, null);
                continue;
            }
            if (value instanceof JSONArray) {
                Set<Map<String, Object>> set = JSONHelper.saveSet(hibernateTemplate, (JSONArray)value);
                map.put(key, set);
                continue;
            }
            if (propType != null && (propType instanceof DateType || propType instanceof TimeType)) {
                long l = 0L;
                if (value instanceof Double) {
                    l = ((Double)value).longValue();
                } else if (value instanceof Long) {
                    l = (Long)value;
                }
                Date d = new Date(l);
                map.put(key, d);
                continue;
            }
            if (value instanceof Integer && propType instanceof DoubleType) {
                Integer v = (Integer)value;
                map.put(key, v.doubleValue());
                continue;
            }
            if (value instanceof JSONObject) {
                JSONObject obj = (JSONObject)value;
                String type = (String)obj.get("EntityType");
                Map<String, Object> set = JSONHelper.saveWithoutExp(hibernateTemplate, type, (JSONObject)value);
                map.put(key, set);
                continue;
            }
            map.put(key, value);
        }
        hibernateTemplate.saveOrUpdate(entityName, map);
        return map;
    }
}

