/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.helper.BSCalendar;
import com.aote.helper.FilePath;
import com.aote.helper.StringHelper;
import com.aote.logic.LogicServer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="XABank")
@Component
@Transactional
public class XABankService {
    static Logger log = Logger.getLogger(XABankService.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private HibernateTemplate hibernateTemplate;

    @POST
    @Transactional
    @Produces(value={"application/json"})
    public String xtSavebusiness(String values) {
        try {
            String result = "";
            values = values.replace("%7C", "|");
            values = values.replace("%3B", ";");
            values = values.replace("%3A", ":");
            values = values.replace("+", " ");
            log.info((Object)("\u897f\u94f6\u6536\u5230\u8bf7\u6c42:" + values));
            Iterator iter = this.getDataIter(values);
            double oper = Double.parseDouble((String)iter.next());
            if (oper == 1.0) {
                log.info((Object)"\u897f\u94f6\u67e5\u8be2\u5904\u7406..........................");
                result = this.query(iter);
                log.info((Object)("\u897f\u94f6\u67e5\u8be2\u8fd4\u56de" + result));
            } else if (oper == 2.0) {
                log.info((Object)"\u897f\u94f6\u9636\u68af\u8fd0\u7b97...........................");
                result = this.stairPrice(iter);
                log.info((Object)("\u897f\u94f6\u9636\u68af\u8fd4\u56de" + result));
            } else if (oper == 3.0) {
                log.info((Object)"\u897f\u94f6\u552e\u6c14\u5904\u7406..........................");
                result = this.sale(iter);
                log.info((Object)("\u897f\u94f6\u552e\u6c14\u8fd4\u56de" + result));
            } else if (oper == 4.0) {
                log.info((Object)"\u897f\u94f6\u51b2\u8d26\u5904\u7406..........................");
                result = this.chongzhang(iter);
                log.info((Object)("\u897f\u94f6\u51b2\u8d26\u8fd4\u56de" + result));
            } else if (oper == 5.0) {
                log.info((Object)"\u897f\u94f6\u53d6\u5bc6\u7801.........................");
                result = this.encryp(iter);
                log.info((Object)("\u897f\u94f6\u53d6\u5bc6\u7801\u8fd4\u56de" + result));
            } else if (oper == 6.0) {
                log.info((Object)"\u897f\u94f6\u5bf9\u8d26\u5904\u7406..........................");
                result = this.duizhang(iter);
                log.info((Object)("\u897f\u94f6\u5bf9\u8d26\u8fd4\u56de" + result));
            }
            String len = String.format("%04d", result.getBytes("gbk").length);
            result = len + result;
            return URLEncoder.encode(result, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)("\u897f\u94f6\u5904\u7406\u4e1a\u52a1\u51fa\u9519" + e.getMessage()));
            return "000499|;";
        }
    }

    private Iterator getDataIter(String data) {
        String str = (String)StringHelper.stringToLinkedList(data, '=').get(1);
        Iterator iter = StringHelper.stringToLinkedList(str, '|').iterator();
        return iter;
    }

    private List<Object> executeSQL(final String sql) {
        List list = (List)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                SQLQuery query = session.createSQLQuery(sql);
                return query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
            }
        });
        return list;
    }

    private Object callcommonCal(String card_id, BigDecimal value, int isGasValue) throws Exception {
        JSONObject data = new JSONObject();
        JSONObject model = new JSONObject();
        model.put("f_card_id", (Object)card_id);
        data.put("model", (Object)model);
        data.put("isGasValue", isGasValue);
        data.put("value", (Object)value);
        return this.logicServer.run("commonCal", data.toString());
    }

    private BigDecimal KeepDecimal(BigDecimal a, int i) {
        if (a.scale() > i) {
            return a.setScale(i, 4);
        }
        return a;
    }

    private JSONObject dealprice(JSONObject json) {
        JSONObject result = new JSONObject();
        JSONArray chargeprice = json.getJSONArray("chargeprice");
        if (chargeprice.length() == 1) {
            result.put("nowprice", (Object)this.KeepDecimal(chargeprice.getJSONObject(0).getBigDecimal("f_price"), 2));
            result.put("qijia", (Object)this.KeepDecimal(chargeprice.getJSONObject(0).getBigDecimal("f_price_name"), 2));
        } else {
            if (json.getInt("f_surplus1amount") != 0) {
                result.put("nowprice", (Object)json.getBigDecimal("f_stair1price"));
            } else if (json.getInt("f_surplus1amount") == 0 && json.getInt("f_surplus2amount") != 0) {
                result.put("nowprice", (Object)json.getBigDecimal("f_stair2price"));
            } else {
                result.put("nowprice", (Object)json.getBigDecimal("f_stair3price"));
            }
            String qijiamsg = json.getBigDecimal("f_stair1price") + "/" + json.getBigDecimal("f_stair1ceiling") + "/" + json.getBigDecimal("f_stair2price") + "/" + json.getBigDecimal("f_stair2ceiling") + "/" + json.getBigDecimal("f_stair3price");
            result.put("qijia", (Object)qijiamsg);
        }
        return result;
    }

    private String query(Iterator iter) throws Exception {
        String errorStr = "01|1|\u6c11\u7528|2.60|0|0|0|0|;";
        String cardId = (String)iter.next();
        cardId = cardId.trim();
        String port = (String)iter.next();
        port = port.trim();
        String isMoney = (String)iter.next();
        isMoney = isMoney.trim();
        String cardInfo = (String)iter.next();
        cardInfo = cardInfo.trim();
        String portHql = "from t_ic_sellspot where SELLSPOT_ID='" + port + "'";
        List portlist = this.hibernateTemplate.find(portHql, new Object[0]);
        if (portlist.size() != 1) {
            return errorStr;
        }
        String userSql = "SELECT\n\tU .f_card_id,\n\tsp.F_PRICE_TYPE,\n\tsp.F_PRICE_NAME,\n\ti.F_USER_NAME,\n\ti.f_userinfo_id,\n\tU .alarm,\n\tU .f_table_state,\n\tU .f_user_id,\n\tU . CONSTANT,\n\tU .f_card_password,\n\tU .f_times,\n\tdp.f_price PRICE,\n\tU .f_jb_table_code,\n\tU .pricenew,\n\tU .pricemodify,\n\tU .pricedate,\n\tU .f_price_id,\n\tU .f_gasproperties,\n\tU .f_initial_base,\n\tU .is_close,\n\tU .is_close_one,\n\tU .is_close_two,\n\tU .is_tablelimit,\n\tU .is_tablelimit_gas,\n\tU .price_type,\n\tU .f_whether_hairpin,\n\tU .anjianyear,\n\tU .baofeiyear,\n\tU .onealarm,\n\tU .twoalarm,\n\tgb.f_meter_brand,\n\tsp.F_SPRICE_PROGRAMME JTPLAN,\n\tsp.F_SPRICE_CODE JTPLANSTR\nFROM\n\tt_userfiles U\nLEFT JOIN t_userinfo i ON U .f_userinfo_id = i.f_userinfo_id\nLEFT JOIN t_gasbrand gb ON U .f_gasbrand_id = gb. ID\nLEFT JOIN (\n\tSELECT\n\t\t*\n\tFROM\n\t\tT_STAIRPRICE\n\tWHERE\n\t\tf_state = '\u6709\u6548'\n) sp ON U .f_price_id = sp.f_price_id\nLEFT JOIN (\n\tSELECT\n\t\t*\n\tFROM\n\t\tt_detailprice\n\tWHERE\n\t\tF_PRICE_NAME = '1'\n) dp ON sp. ID = dp.f_stairprice_id\nWHERE\n\tf_card_id = '" + cardId + "'";
        List<Object> userlist = this.executeSQL(userSql);
        if (userlist.size() != 1) {
            return errorStr;
        }
        Map userMap = (Map)userlist.get(0);
        String isIssue = (String)userMap.get("F_TABLE_STATE");
        if (!isIssue.equals("\u6b63\u5e38")) {
            return errorStr;
        }
        String MTN = (String)userMap.get("F_METER_BRAND");
        if (MTN.equals("\u79e6\u6e2f\u5de5\u4e1a\u65e0\u7ebf") || MTN.equals("\u79e6\u6e2f\u5de5\u4e1a") || MTN.equals("\u8d5b\u798f\u5de5\u4e1a") || MTN.equals("\u5929\u7136\u6c14\u65e0\u7ebf")) {
            return errorStr;
        }
        String limitGas = "14900.00";
        String wfgStr = "0|0|0|12";
        StringBuffer sb = new StringBuffer();
        sb.append("00").append("|");
        String userName = (String)userMap.get("F_USER_NAME");
        if (userName == null || userName.equals("")) {
            userName = "0";
        }
        sb.append(userName).append("|");
        String userType = (String)userMap.get("F_GASPROPERTIES");
        sb.append(userType).append("|");
        JSONObject pricemsg = this.dealprice((JSONObject)this.callcommonCal(cardId, new BigDecimal(0), 0));
        sb.append(pricemsg.getBigDecimal("nowprice")).append("|");
        String pricename = userMap.get("F_PRICE_NAME").toString();
        sb.append(pricename);
        sb.append(pricemsg.getString("qijia")).append("|");
        sb.append(limitGas).append("|");
        sb.append(wfgStr).append("|");
        if ("1".equals(isMoney)) {
            cardInfo = cardInfo.replaceAll("%25", "%");
            cardInfo = cardInfo.replaceAll("%40", "@");
            cardInfo = cardInfo.replaceAll("%0D", "=");
            cardInfo = cardInfo.replaceAll("%0A", ":");
            cardInfo = cardInfo.replaceAll("%00", "0");
            String result = this.saveRFInfo(cardInfo);
            log.info((Object)("\u5c04\u9891\u5361\u4fe1\u606f\u5b58\u50a8" + result));
        }
        if ("0".equals(isMoney)) {
            sb.append("0|");
        } else if ("1".equals(isMoney) || "2".equals(isMoney)) {
            String cardParams = this.queryForRF(userMap, isMoney);
            if (cardParams.equals("01|;")) {
                return errorStr;
            }
            sb.append(cardParams);
        }
        sb.append(";");
        return sb.toString();
    }

    private String saveRFInfo(String values) {
        try {
            String str = values.substring(values.indexOf("=") + 1, values.length());
            if (!str.startsWith("9999") && !str.startsWith("8888")) {
                str = str.indexOf("8888") != -1 ? "8888|" + str : "9999|" + str;
            }
            log.info((Object)("\u4fdd\u5b58\u5c04\u9891\u5361\u56de\u8bfb\u4fe1\u606f:" + str));
            String[] strs = str.split("@");
            String firstStr = strs[0];
            JSONObject sale = null;
            if (firstStr.startsWith("8888")) {
                sale = XABankService.parseRF8888(strs);
            } else if (firstStr.startsWith("9999")) {
                sale = this.parseRF9999(strs);
            }
            this.entityServer.partialSave("t_rf_info", sale);
            return "00|;";
        }
        catch (Exception e) {
            log.error((Object)("\u4fdd\u5b58\u5c04\u9891\u5361\u4fe1\u606f\u9519\u8bef" + e.toString()));
            return "01|;";
        }
    }

    private static JSONObject parseRF8888(String[] strs) {
        String priceModifyDate;
        String str1 = strs[0];
        Iterator iter = StringHelper.stringToLinkedList(str1, '|').iterator();
        iter.next();
        String priceCopy = "";
        String priceOneCopy = "";
        String gasOneCopy = "";
        String priceTwoCopy = "";
        String gasTwoCopy = "";
        String priceThreeCopy = "";
        String monthTotalCopy = "";
        String newPriceCopy = "";
        String priceModifyDateCopy = "";
        String newPriceOneCopy = "";
        String newGasOneCopy = "";
        String newPriceTwoCopy = "";
        String newGasTwoCopy = "";
        String newPriceThreeCopy = "";
        String zhye = (String)iter.next();
        zhye = zhye.trim();
        String totalGas = (String)iter.next();
        totalGas = totalGas.trim();
        String totalGasAccount = (String)iter.next();
        totalGasAccount = totalGasAccount.trim();
        String buyTimes = (String)iter.next();
        buyTimes = buyTimes.trim();
        String gasPrice = (String)iter.next();
        gasPrice = gasPrice.trim();
        String meterTime = (String)iter.next();
        meterTime = meterTime.trim();
        String notUseDay = (String)iter.next();
        notUseDay = notUseDay.trim();
        String notUseSecond = (String)iter.next();
        notUseSecond = notUseSecond.trim();
        String avoidDeadMeter = (String)iter.next();
        avoidDeadMeter = avoidDeadMeter.trim();
        String deadMeterDayOne = (String)iter.next();
        deadMeterDayOne = deadMeterDayOne.trim();
        String deadMeterDayTwo = (String)iter.next();
        deadMeterDayTwo = deadMeterDayTwo.trim();
        String restriction = (String)iter.next();
        restriction = restriction.trim();
        String restrictionAccount = (String)iter.next();
        restrictionAccount = restrictionAccount.trim();
        String card = (String)iter.next();
        card = card.trim();
        String meterState = (String)iter.next();
        meterState = meterState.trim();
        String accountFlag = (String)iter.next();
        accountFlag = accountFlag.trim();
        String priceType = (String)iter.next();
        priceType = priceType.trim();
        double type = Double.parseDouble(priceType);
        if (type == 0.0) {
            String price = (String)iter.next();
            priceCopy = price = price.trim();
        } else {
            String priceOne = (String)iter.next();
            priceOneCopy = priceOne = priceOne.trim();
            String gasOne = (String)iter.next();
            gasOneCopy = gasOne = gasOne.trim();
            String priceTwo = (String)iter.next();
            priceTwoCopy = priceTwo = priceTwo.trim();
            String gasTwo = (String)iter.next();
            gasTwoCopy = gasTwo = gasTwo.trim();
            String priceThree = (String)iter.next();
            priceThreeCopy = priceThree = priceThree.trim();
        }
        String priceModifyFlag = (String)iter.next();
        priceModifyFlag = priceModifyFlag.trim();
        double type1 = Double.parseDouble(priceModifyFlag);
        if (type == 0.0 && type1 == 1.0) {
            priceModifyDate = (String)iter.next();
            priceModifyDateCopy = priceModifyDate = priceModifyDate.trim();
            String newPrice = (String)iter.next();
            newPriceCopy = newPrice = newPrice.trim();
        } else if (type == 1.0 && type1 == 1.0) {
            priceModifyDate = (String)iter.next();
            priceModifyDateCopy = priceModifyDate = priceModifyDate.trim();
            String newPriceOne = (String)iter.next();
            newPriceOneCopy = newPriceOne = newPriceOne.trim();
            String newGasOne = (String)iter.next();
            newGasOneCopy = newGasOne = newGasOne.trim();
            String newPriceTwo = (String)iter.next();
            newPriceTwoCopy = newPriceTwo = newPriceTwo.trim();
            String newGasTwo = (String)iter.next();
            newGasTwoCopy = newGasTwo = newGasTwo.trim();
            String newPriceThree = (String)iter.next();
            newPriceThreeCopy = newPriceThree = newPriceThree.trim();
        }
        if (type == 1.0) {
            String monthTotal = (String)iter.next();
            monthTotalCopy = monthTotal = monthTotal.trim();
        }
        String str2 = strs[1];
        iter = StringHelper.stringToLinkedList(str2, '|').iterator();
        String belongToMonth = (String)iter.next();
        belongToMonth = belongToMonth.trim();
        String monthOne = (String)iter.next();
        monthOne = monthOne.trim();
        String monthTwo = (String)iter.next();
        monthTwo = monthTwo.trim();
        String monthThree = (String)iter.next();
        monthThree = monthThree.trim();
        String monthFour = (String)iter.next();
        monthFour = monthFour.trim();
        String monthFive = (String)iter.next();
        monthFive = monthFive.trim();
        String monthSix = (String)iter.next();
        monthSix = monthSix.trim();
        String monthSeven = (String)iter.next();
        monthSeven = monthSeven.trim();
        String monthEight = (String)iter.next();
        monthEight = monthEight.trim();
        String monthNine = (String)iter.next();
        monthNine = monthNine.trim();
        String monthTen = (String)iter.next();
        monthTen = monthTen.trim();
        String monthEleven = (String)iter.next();
        monthEleven = monthEleven.trim();
        String monthTwelve = (String)iter.next();
        monthTwelve = monthTwelve.trim();
        String monthThirteen = (String)iter.next();
        monthThirteen = monthThirteen.trim();
        String monthFourteen = (String)iter.next();
        monthFourteen = monthFourteen.trim();
        String monthFifteen = (String)iter.next();
        monthFifteen = monthFifteen.trim();
        String monthSixteen = (String)iter.next();
        monthSixteen = monthSixteen.trim();
        String monthSeventeen = (String)iter.next();
        monthSeventeen = monthSeventeen.trim();
        String monthEighteen = (String)iter.next();
        monthEighteen = monthEighteen.trim();
        String monthNineteen = (String)iter.next();
        monthNineteen = monthNineteen.trim();
        String monthTwenty = (String)iter.next();
        monthTwenty = monthTwenty.trim();
        String monthTwentyOne = (String)iter.next();
        monthTwentyOne = monthTwentyOne.trim();
        String monthTwentyTwo = (String)iter.next();
        monthTwentyTwo = monthTwentyTwo.trim();
        String monthTwentyThree = (String)iter.next();
        monthTwentyThree = monthTwentyThree.trim();
        String monthTwentyFour = (String)iter.next();
        monthTwentyFour = monthTwentyFour.trim();
        JSONObject sale = new JSONObject();
        sale.put("f_zhye", (Object)zhye);
        sale.put("f_total_gas", (Object)totalGas);
        sale.put("f_total_gas_account", (Object)totalGasAccount);
        sale.put("f_buy_times", (Object)buyTimes);
        sale.put("f_gas_price", (Object)gasPrice);
        sale.put("f_meter_time", (Object)meterTime);
        sale.put("f_not_use_day", (Object)notUseDay);
        sale.put("f_not_use_second", (Object)notUseSecond);
        sale.put("f_avoid_dead_meter", (Object)avoidDeadMeter);
        sale.put("f_dead_meter_day_one", (Object)deadMeterDayOne);
        sale.put("f_dead_meter_day_two", (Object)deadMeterDayTwo);
        sale.put("f_restriction", (Object)restriction);
        sale.put("f_restriction_account", (Object)restrictionAccount);
        sale.put("f_card", (Object)card);
        sale.put("f_meter_state", (Object)meterState);
        sale.put("f_account_flag", (Object)accountFlag);
        sale.put("f_price_type", (Object)priceType);
        sale.put("f_price", (Object)priceCopy);
        sale.put("f_price_one", (Object)priceOneCopy);
        sale.put("f_gas_one", (Object)gasOneCopy);
        sale.put("f_price_two", (Object)priceTwoCopy);
        sale.put("f_gas_two", (Object)gasTwoCopy);
        sale.put("f_price_three", (Object)priceThreeCopy);
        sale.put("f_price_modify_flag", (Object)priceModifyFlag);
        sale.put("f_price_modify_date", (Object)priceModifyDateCopy);
        sale.put("f_new_price", (Object)newPriceCopy);
        sale.put("f_new_price_one", (Object)newPriceOneCopy);
        sale.put("f_new_gas_one", (Object)newGasOneCopy);
        sale.put("f_new_price_two", (Object)newPriceTwoCopy);
        sale.put("f_new_gas_two", (Object)newGasTwoCopy);
        sale.put("f_new_price_three", (Object)newPriceThreeCopy);
        sale.put("f_month_total", (Object)monthTotalCopy);
        sale.put("f_belong_to_month", (Object)belongToMonth);
        sale.put("f_month_one", (Object)monthOne);
        sale.put("f_month_two", (Object)monthTwo);
        sale.put("f_month_three", (Object)monthThree);
        sale.put("f_month_four", (Object)monthFour);
        sale.put("f_month_five", (Object)monthFive);
        sale.put("f_month_six", (Object)monthSix);
        sale.put("f_month_seven", (Object)monthSeven);
        sale.put("f_month_eight", (Object)monthEight);
        sale.put("f_month_nine", (Object)monthNine);
        sale.put("f_month_ten", (Object)monthTen);
        sale.put("f_month_eleven", (Object)monthEleven);
        sale.put("f_month_twelve", (Object)monthTwelve);
        sale.put("f_month_thirteen", (Object)monthThirteen);
        sale.put("f_month_fourteen", (Object)monthFourteen);
        sale.put("f_month_fifteen", (Object)monthFifteen);
        sale.put("f_month_sixteen", (Object)monthSixteen);
        sale.put("f_month_seventeen", (Object)monthSeventeen);
        sale.put("f_month_eighteen", (Object)monthEighteen);
        sale.put("f_month_nineteen", (Object)monthNineteen);
        sale.put("f_month_twenty", (Object)monthTwenty);
        sale.put("f_month_twenty_one", (Object)monthTwentyOne);
        sale.put("f_month_twenty_two", (Object)monthTwentyTwo);
        sale.put("f_month_twenty_three", (Object)monthTwentyThree);
        sale.put("f_month_twenty_four", (Object)monthTwentyFour);
        return sale;
    }

    private JSONObject parseRF9999(String[] strs) {
        String str1 = strs[0];
        String[] allStr1s = str1.split("\\|");
        Iterator iter = StringHelper.stringToLinkedList(str1, '|').iterator();
        iter.next();
        JSONObject sale = new JSONObject();
        iter.next();
        String zhye = (String)iter.next();
        zhye = zhye.trim();
        String totalGas = (String)iter.next();
        totalGas = totalGas.trim();
        String totalGasAccount = (String)iter.next();
        totalGasAccount = totalGasAccount.trim();
        String buyTimes = (String)iter.next();
        buyTimes = buyTimes.trim();
        String gasPrice = (String)iter.next();
        gasPrice = gasPrice.trim();
        String meterTime = (String)iter.next();
        meterTime = meterTime.trim();
        String notUseDay = (String)iter.next();
        notUseDay = notUseDay.trim();
        String notUseSecond = (String)iter.next();
        notUseSecond = notUseSecond.trim();
        String avoidDeadMeter = (String)iter.next();
        avoidDeadMeter = avoidDeadMeter.trim();
        String deadMeterDayOne = "";
        String deadMeterDayTwo = "";
        deadMeterDayOne = (String)iter.next();
        deadMeterDayOne = deadMeterDayOne.trim();
        deadMeterDayTwo = (String)iter.next();
        deadMeterDayTwo = deadMeterDayTwo.trim();
        String restriction = (String)iter.next();
        restriction = restriction.trim();
        String restrictionAccount = (String)iter.next();
        restrictionAccount = restrictionAccount.trim();
        String card = (String)iter.next();
        card = card.trim();
        String meterState = (String)iter.next();
        meterState = meterState.trim();
        String accountFlag = (String)iter.next();
        accountFlag = accountFlag.trim();
        String priceType = (String)iter.next();
        priceType = priceType.trim();
        double type = Double.parseDouble(priceType);
        String priceModifyFlag = (String)iter.next();
        priceModifyFlag = priceModifyFlag.trim();
        double type1 = Double.parseDouble(priceModifyFlag);
        String priceModifyDate = (String)iter.next();
        priceModifyDate = priceModifyDate.trim();
        sale.put("f_meter_state", (Object)meterState);
        sale.put("f_account_flag", (Object)accountFlag);
        sale.put("f_price_type", (Object)priceType);
        sale.put("f_price_modify_flag", (Object)priceModifyFlag);
        sale.put("f_price_modify_date", (Object)priceModifyDate);
        String price = "";
        String newprice = "";
        if (type == 0.0 && type1 == 0.0) {
            price = (String)iter.next();
            price = price.trim();
        } else if (type == 0.0 && type1 == 1.0) {
            price = (String)iter.next();
            price = price.trim();
            newprice = (String)iter.next();
            newprice = newprice.trim();
        } else if (type == 1.0) {
            int jtQiYongNum = Integer.parseInt(iter.next().toString(), 16);
            for (int i = 1; i <= jtQiYongNum; ++i) {
                String str = (String)iter.next();
                sale.put("f_date_" + i, (Object)str);
            }
            int count = Integer.parseInt(iter.next() + "");
            for (int i = 1; i <= count; ++i) {
                if (i == 1) {
                    sale.put("f_price_one", iter.next());
                    sale.put("f_gas_one", iter.next());
                    sale.put("f_price_two", iter.next());
                    sale.put("f_gas_two", iter.next());
                    sale.put("f_price_three", iter.next());
                    if (type1 != 1.0) continue;
                    sale.put("f_new_price_one", iter.next());
                    sale.put("f_new_gas_one", iter.next());
                    sale.put("f_new_price_two", iter.next());
                    sale.put("f_new_gas_two", iter.next());
                    sale.put("f_new_price_three", iter.next());
                    continue;
                }
                sale.put("f_price_one" + i, iter.next());
                sale.put("f_gas_one" + i, iter.next());
                sale.put("f_price_two" + i, iter.next());
                sale.put("f_gas_two" + i, iter.next());
                sale.put("f_price_three" + i, iter.next());
                if (type1 != 1.0) continue;
                sale.put("f_new_price_one" + i, iter.next());
                sale.put("f_new_gas_one" + i, iter.next());
                sale.put("f_new_price_two" + i, iter.next());
                sale.put("f_new_gas_two" + i, iter.next());
                sale.put("f_new_price_three" + i, iter.next());
            }
            sale.put("f_month_total", iter.next());
        }
        String str2 = strs[1];
        iter = StringHelper.stringToLinkedList(str2, '|').iterator();
        String belongToMonth = (String)iter.next();
        belongToMonth = belongToMonth.trim();
        String monthOne = (String)iter.next();
        monthOne = monthOne.trim();
        String monthTwo = (String)iter.next();
        monthTwo = monthTwo.trim();
        String monthThree = (String)iter.next();
        monthThree = monthThree.trim();
        String monthFour = (String)iter.next();
        monthFour = monthFour.trim();
        String monthFive = (String)iter.next();
        monthFive = monthFive.trim();
        String monthSix = (String)iter.next();
        monthSix = monthSix.trim();
        String monthSeven = (String)iter.next();
        monthSeven = monthSeven.trim();
        String monthEight = (String)iter.next();
        monthEight = monthEight.trim();
        String monthNine = (String)iter.next();
        monthNine = monthNine.trim();
        String monthTen = (String)iter.next();
        monthTen = monthTen.trim();
        String monthEleven = (String)iter.next();
        monthEleven = monthEleven.trim();
        String monthTwelve = (String)iter.next();
        monthTwelve = monthTwelve.trim();
        String monthThirteen = (String)iter.next();
        monthThirteen = monthThirteen.trim();
        String monthFourteen = (String)iter.next();
        monthFourteen = monthFourteen.trim();
        String monthFifteen = (String)iter.next();
        monthFifteen = monthFifteen.trim();
        String monthSixteen = (String)iter.next();
        monthSixteen = monthSixteen.trim();
        String monthSeventeen = (String)iter.next();
        monthSeventeen = monthSeventeen.trim();
        String monthEighteen = (String)iter.next();
        monthEighteen = monthEighteen.trim();
        String monthNineteen = (String)iter.next();
        monthNineteen = monthNineteen.trim();
        String monthTwenty = (String)iter.next();
        monthTwenty = monthTwenty.trim();
        String monthTwentyOne = (String)iter.next();
        monthTwentyOne = monthTwentyOne.trim();
        String monthTwentyTwo = (String)iter.next();
        monthTwentyTwo = monthTwentyTwo.trim();
        String monthTwentyThree = (String)iter.next();
        monthTwentyThree = monthTwentyThree.trim();
        String monthTwentyFour = (String)iter.next();
        monthTwentyFour = monthTwentyFour.trim();
        sale.put("f_zhye", (Object)zhye);
        sale.put("f_total_gas", (Object)totalGas);
        sale.put("f_total_gas_account", (Object)totalGasAccount);
        sale.put("f_buy_times", (Object)buyTimes);
        sale.put("f_gas_price", (Object)gasPrice);
        sale.put("f_meter_time", (Object)meterTime);
        sale.put("f_not_use_day", (Object)notUseDay);
        sale.put("f_not_use_second", (Object)notUseSecond);
        sale.put("f_avoid_dead_meter", (Object)avoidDeadMeter);
        sale.put("f_dead_meter_day_one", (Object)deadMeterDayOne);
        sale.put("f_dead_meter_day_two", (Object)deadMeterDayTwo);
        sale.put("f_restriction", (Object)restriction);
        sale.put("f_restriction_account", (Object)restrictionAccount);
        sale.put("f_card", (Object)card);
        sale.put("f_price", (Object)price);
        sale.put("f_new_price", (Object)newprice);
        sale.put("f_belong_to_month", (Object)belongToMonth);
        sale.put("f_month_one", (Object)monthOne);
        sale.put("f_month_two", (Object)monthTwo);
        sale.put("f_month_three", (Object)monthThree);
        sale.put("f_month_four", (Object)monthFour);
        sale.put("f_month_five", (Object)monthFive);
        sale.put("f_month_six", (Object)monthSix);
        sale.put("f_month_seven", (Object)monthSeven);
        sale.put("f_month_eight", (Object)monthEight);
        sale.put("f_month_nine", (Object)monthNine);
        sale.put("f_month_ten", (Object)monthTen);
        sale.put("f_month_eleven", (Object)monthEleven);
        sale.put("f_month_twelve", (Object)monthTwelve);
        sale.put("f_month_thirteen", (Object)monthThirteen);
        sale.put("f_month_fourteen", (Object)monthFourteen);
        sale.put("f_month_fifteen", (Object)monthFifteen);
        sale.put("f_month_sixteen", (Object)monthSixteen);
        sale.put("f_month_seventeen", (Object)monthSeventeen);
        sale.put("f_month_eighteen", (Object)monthEighteen);
        sale.put("f_month_nineteen", (Object)monthNineteen);
        sale.put("f_month_twenty", (Object)monthTwenty);
        sale.put("f_month_twenty_one", (Object)monthTwentyOne);
        sale.put("f_month_twenty_two", (Object)monthTwentyTwo);
        sale.put("f_month_twenty_three", (Object)monthTwentyThree);
        sale.put("f_month_twenty_four", (Object)monthTwentyFour);
        return sale;
    }

    private String queryForRF(Map<String, Object> userMap, String isMoney) {
        try {
            String priceModify = "";
            if (userMap.containsKey("PRICEMODIFY") && null != userMap.get("PRICEMODIFY")) {
                priceModify = (String)userMap.get("PRICEMODIFY");
            }
            String priceDate = "";
            if (userMap.containsKey("PRICEDATE") && null != userMap.get("PRICEDATE")) {
                priceDate = userMap.get("PRICEDATE").toString();
            }
            priceDate = priceDate.replace("-", "");
            priceDate = priceDate.replace(" ", "");
            priceDate = priceDate.replace(":", "");
            if ((priceDate = priceDate.replace(".", "")).length() < 14) {
                priceDate = priceDate + "000000";
            }
            if (priceDate.length() > 14) {
                priceDate = priceDate.substring(0, 14);
            }
            String priceNew = "";
            if (userMap.containsKey("PRICENEW") && null != userMap.get("PRICENEW")) {
                priceNew = userMap.get("PRICENEW").toString();
            }
            String isClose = "";
            if (userMap.containsKey("IS_CLOSE") && null != userMap.get("IS_CLOSE")) {
                isClose = userMap.get("IS_CLOSE").toString();
            }
            isClose = isClose.replace("\u662f", "1");
            isClose = isClose.replace("\u5426", "0");
            String isCloseOne = "";
            if (userMap.containsKey("IS_CLOSE_ONE") && null != userMap.get("IS_CLOSE_ONE")) {
                isCloseOne = userMap.get("IS_CLOSE_ONE").toString();
            }
            String isCloseTwo = "";
            if (userMap.containsKey("IS_CLOSE_TWO") && null != userMap.get("IS_CLOSE_TWO")) {
                isCloseTwo = userMap.get("IS_CLOSE_TWO").toString();
            }
            String isTableLimit = "";
            if (userMap.containsKey("IS_TABLELIMIT") && null != userMap.get("IS_TABLELIMIT")) {
                isTableLimit = (String)userMap.get("IS_TABLELIMIT");
            }
            isTableLimit = isTableLimit.replace("\u662f", "1");
            isTableLimit = isTableLimit.replace("\u5426", "0");
            String isTableLimitGas = "";
            if (userMap.containsKey("IS_TABLELIMIT_GAS") && null != userMap.get("IS_TABLELIMIT_GAS")) {
                isTableLimitGas = userMap.get("IS_TABLELIMIT_GAS").toString();
            }
            String priceType = (String)userMap.get("PRICE_TYPE");
            StringBuilder para = new StringBuilder();
            para.append(priceModify).append("|").append(priceDate).append("|").append(priceNew).append("|");
            if ("2".equals(isMoney)) {
                return para.toString();
            }
            para.append(isClose).append("|").append(isCloseOne).append("|").append(isCloseTwo).append("|").append(isTableLimit).append("|").append(isTableLimitGas).append("|");
            if ("\u666e\u901a\u5355\u4ef7".equals(priceType)) {
                para.append("0").append("|");
            } else if ("\u9636\u68af\u5355\u4ef7".equals(priceType)) {
                para.append("1").append("|");
                String JTPlan = "";
                if (userMap.containsKey("JTPLAN") && null != userMap.get("JTPLAN")) {
                    JTPlan = (String)userMap.get("JTPLAN");
                }
                String jtplanstr = "";
                if (userMap.containsKey("JTPLANSTR") && null != userMap.get("JTPLANSTR")) {
                    jtplanstr = (String)userMap.get("JTPLANSTR");
                }
                Map<String, Object> jtdateAndCount = this.getJTPlanDateAndCOunt(JTPlan);
                para.append(jtdateAndCount.get("usecount").toString()).append("|");
                para.append(jtdateAndCount.get("usedate").toString()).append("|");
                para.append("4").append("|");
                Map<String, Object> jtprice = this.getJTPrice(jtplanstr);
                para.append(jtprice.get("jtprice1") + "|");
                para.append(jtprice.get("jtprice2") + "|");
                para.append(jtprice.get("jtprice3") + "|");
                para.append(jtprice.get("jtprice4") + "|");
            } else {
                return "01|;";
            }
            return para.toString();
        }
        catch (Exception e) {
            log.error((Object)("\u5c04\u9891\u5361\u5199\u5361\u3001\u51b2\u6b63\u53c2\u6570\u67e5\u8be2\u51fa\u9519" + e.getMessage()));
            return "01|;";
        }
    }

    private Map<String, Object> getJTPrice(String str) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = "SELECT\n\t*\nFROM\n\t(\n\t\tSELECT\n\t\t\tJT_CODE,\n\t\t\tdbms_lob. SUBSTR (\n\t\t\t\twm_concat (\n\t\t\t\t\tD .JT_OLD_PRICE_ONE || '|' || D .JT_OLD_GAS_ONE || '|' || D .JT_OLD_PRICE_TWO || '|' || D .JT_OLD_GAS_TWO || '|' || D .JT_OLD_PRICE_THREE || '|' || D .JT_NEW_PRICE_ONE || '|' || D .JT_NEW_GAS_ONE || '|' || D .JT_NEW_PRICE_TWO || '|' || D .JT_NEW_GAS_TWO || '|' || D .JT_NEW_PRICE_THREE\n\t\t\t\t)\n\t\t\t) AS pricestr,\n\t\t\tCOUNT (*) AS c\n\t\tFROM\n\t\t\tT_IC_JT_TYPE D\n\t\tGROUP BY\n\t\t\tJT_CODE\n\t)\nWHERE\n\tJT_CODE IN ( " + str + " )";
        List<Object> jtlist = this.executeSQL(sql);
        String[] arr = str.split(",");
        if (arr.length == 4 && jtlist.size() == 4) {
            HashMap jtmap = new HashMap();
            for (int i = 0; i < jtlist.size(); ++i) {
                Map one = (Map)jtlist.get(i);
                jtmap.put(one.get("JT_CODE").toString(), one.get("PRICESTR"));
            }
            result.put("jtprice1", jtmap.get(arr[0].toString()));
            result.put("jtprice2", jtmap.get(arr[1].toString()));
            result.put("jtprice3", jtmap.get(arr[2].toString()));
            result.put("jtprice4", jtmap.get(arr[3].toString()));
        }
        return result;
    }

    private Map<String, Object> getJTPlanDateAndCOunt(String planName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        final String sql = "select usedate_code,  replace( max(a) ,',','|')  as dstr ,count(*) from (select usedate_code, dbms_lob.substr(wm_concat(usedate || '-' ||  JT_CODE)  over(partition BY usedate_code order by usedate))  a  from t_ic_jt_uesdate where usedate_code='" + planName + "' )  group by usedate_code";
        List gasSumlist = (List)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createSQLQuery(sql).list();
            }
        });
        Object[] c = (Object[])gasSumlist.get(0);
        result.put("usedate", c[1] + "");
        result.put("usecount", c[2] + "");
        return result;
    }

    public String getWGF(Map user) {
        String result = "0|0|0|12";
        String useClass = (String)user.get("USER_CLASS");
        if (useClass.equals("\u975e\u6c11\u7528")) {
            result = "0|0|0|12";
            return result;
        }
        String wgfType = (String)user.get("ISPAY_WGF");
        if (wgfType != null && wgfType.equals("\u5426")) {
            result = "0|0|0|12";
            return result;
        }
        String wgfPrice = (String)user.get("WGFUSERTYPE");
        Date wgflastDate = (Date)user.get("WGFLASTDATE");
        String wgflastDateStr = "";
        wgflastDateStr = wgflastDate == null ? "2009-04-10" : wgflastDate.toString();
        String nowDateStr = BSCalendar.now().toString("yyyy-mm-dd");
        if (nowDateStr.compareTo(wgflastDateStr) > 0) {
            BSCalendar lastDate = BSCalendar.now();
            int year = Integer.parseInt(wgflastDateStr.substring(0, 4));
            int month = Integer.parseInt(wgflastDateStr.substring(5, 7));
            int day = Integer.parseInt(wgflastDateStr.substring(8, 10));
            lastDate.setYear(year);
            lastDate.setMonth(month);
            lastDate.setDay(day);
            BSCalendar nowDate = BSCalendar.now();
            int yearCount = nowDate.getYearDispersion(lastDate);
            String endDateStr = lastDate.getCalendarAfterYear(yearCount).toString("yyyy-mm-dd");
            if (nowDateStr.compareTo(endDateStr) > 0) {
                BSCalendar bEndDaet = lastDate.getCalendarAfterYear(++yearCount);
                endDateStr = bEndDaet.toString("yyyy-mm-dd");
                result = wgflastDateStr + "|" + endDateStr + "|" + yearCount + "|" + wgfPrice;
            } else {
                result = nowDateStr.compareTo(endDateStr) <= 0 && yearCount > 0 ? wgflastDateStr + "|" + endDateStr + "|" + yearCount + "|" + wgfPrice : "0|0|" + yearCount + "|" + wgfPrice;
            }
        }
        return result;
    }

    private String stairPrice(Iterator iter) {
        StringBuilder result = new StringBuilder();
        try {
            String cardid = (String)iter.next();
            cardid = cardid.trim();
            String type = (String)iter.next();
            int flag = 0;
            if (type.equals("0")) {
                type = "\u6c14\u91cf";
                flag = 0;
            }
            if (type.equals("1")) {
                type = "\u91d1\u989d";
                flag = 1;
            }
            if (type.equals("2")) {
                type = "\u91d1\u989d";
                flag = 1;
            }
            String userSql = "SELECT\n\tgb.f_alias\nFROM\n\tt_userfiles U\nLEFT JOIN t_gasbrand gb ON U .f_gasbrand_id = gb. ID\nWHERE\n\tU .F_CARD_ID = '" + cardid + "'";
            List<Object> userlist = this.executeSQL(userSql);
            Map userMap = (Map)userlist.get(0);
            String gas = (String)iter.next();
            String money = (String)iter.next();
            JSONObject pricingobj = new JSONObject();
            pricingobj = flag == 0 ? (JSONObject)this.callcommonCal(cardid, new BigDecimal(gas), flag) : (JSONObject)this.callcommonCal(cardid, new BigDecimal(money), flag);
            log.info((Object)pricingobj);
            result.append("00").append("|");
            BSCalendar now = BSCalendar.now();
            result.append(now.getYear() + "-01-01").append("|");
            result.append(now.getCalendarAfterYear(1).getYear() + "-01-01").append("|");
            result.append(this.delagasPrice(pricingobj, flag, userMap));
        }
        catch (Exception e) {
            return "02|;";
        }
        return result.toString();
    }

    private String delagasPrice(JSONObject pricingobj, int flag, Map<String, Object> user) {
        StringBuilder pricemsg = new StringBuilder();
        BigDecimal hisamount = this.KeepDecimal(pricingobj.getBigDecimal("hisamount"), 2);
        BigDecimal nowfee = this.KeepDecimal(pricingobj.getBigDecimal("nowfee"), 2);
        BigDecimal nowamont = this.KeepDecimal(pricingobj.getBigDecimal("nowamont"), 2);
        BigDecimal f_stair1ceiling = this.KeepDecimal(pricingobj.getBigDecimal("f_stair1ceiling"), 2);
        BigDecimal f_stair2ceiling = this.KeepDecimal(pricingobj.getBigDecimal("f_stair2ceiling"), 2);
        BigDecimal f_surplus1amount = this.KeepDecimal(pricingobj.getBigDecimal("f_surplus1amount"), 2);
        BigDecimal f_surplus2amount = this.KeepDecimal(pricingobj.getBigDecimal("f_surplus2amount"), 2);
        BigDecimal f_stair1amount = this.KeepDecimal(pricingobj.getBigDecimal("f_stair1amount"), 2);
        BigDecimal f_stair2amount = this.KeepDecimal(pricingobj.getBigDecimal("f_stair2amount"), 2);
        BigDecimal f_stair3amount = this.KeepDecimal(pricingobj.getBigDecimal("f_stair3amount"), 2);
        BigDecimal f_stair1fee = this.KeepDecimal(pricingobj.getBigDecimal("f_stair1fee"), 2);
        BigDecimal f_stair2fee = this.KeepDecimal(pricingobj.getBigDecimal("f_stair2fee"), 2);
        BigDecimal f_stair3fee = this.KeepDecimal(pricingobj.getBigDecimal("f_stair3fee"), 2);
        BigDecimal f_stair1price = this.KeepDecimal(pricingobj.getBigDecimal("f_stair1price"), 2);
        BigDecimal f_stair2price = this.KeepDecimal(pricingobj.getBigDecimal("f_stair2price"), 2);
        BigDecimal f_stair3price = this.KeepDecimal(pricingobj.getBigDecimal("f_stair3price"), 2);
        pricemsg.append(hisamount + "").append("|");
        pricemsg.append(f_stair1ceiling + "").append("|");
        pricemsg.append(f_stair2ceiling + "").append("|");
        BigDecimal f_stair1use = f_stair1ceiling.subtract(f_surplus1amount).subtract(f_stair1amount);
        pricemsg.append(f_stair1use + "").append("|");
        BigDecimal f_stair2use = f_stair2ceiling.subtract(f_stair1ceiling).subtract(f_surplus2amount).subtract(f_stair2amount);
        pricemsg.append(f_stair2use + "").append("|");
        if (hisamount.compareTo(f_stair2ceiling) < 1) {
            pricemsg.append(new BigDecimal("0")).append("|");
        } else {
            BigDecimal f_stair3use = hisamount.subtract(f_stair2ceiling);
            pricemsg.append(f_stair3use + "").append("|");
        }
        pricemsg.append(f_stair1amount + "").append("|");
        pricemsg.append(f_stair2amount + "").append("|");
        pricemsg.append(f_stair3amount + "").append("|");
        pricemsg.append(f_stair1price + "").append("|");
        pricemsg.append(f_stair2price + "").append("|");
        pricemsg.append(f_stair3price + "").append("|");
        pricemsg.append(f_stair1fee + "").append("|");
        pricemsg.append(f_stair2fee + "").append("|");
        pricemsg.append(f_stair3fee + "").append("|");
        pricemsg.append(nowamont + "").append("|");
        pricemsg.append(nowfee + "").append("|");
        if (f_surplus1amount.compareTo(BigDecimal.ZERO) == 0 && (user.get("F_ALIAS").equals("21") || user.get("F_ALIAS").equals("15"))) {
            pricemsg.append(f_stair1price.multiply(nowamont) + "").append("|;");
        } else {
            pricemsg.append("0").append("|;");
        }
        return pricemsg.toString();
    }

    private Object callthirdPay(Map<String, Object> user, String card_id, String lsId, BigDecimal f_pregas, BigDecimal f_preamount, String f_terminal_num, String opid, String f_actualamount) throws Exception {
        JSONObject data = new JSONObject();
        data.put("f_user_id", user.get("f_user_id"));
        data.put("f_card_id", (Object)card_id);
        data.put("f_terminal_num", (Object)f_terminal_num);
        data.put("opid", (Object)opid);
        data.put("f_pregas", (Object)f_pregas);
        data.put("f_preamount", (Object)f_preamount);
        data.put("f_unit", (Object)"yuan");
        data.put("f_serial_id", (Object)lsId);
        data.put("f_collection", (Object)f_preamount);
        data.put("f_actualamount", (Object)f_actualamount);
        data.put("isGasValue", 0);
        return this.logicServer.run("thirdPay", data.toString());
    }

    private String sale(Iterator iter) {
        try {
            String errorStr = "03|;";
            String lsId = (String)iter.next();
            lsId = lsId.trim();
            String cardId = (String)iter.next();
            cardId = cardId.trim();
            String gas = (String)iter.next();
            gas = gas.trim();
            String money = (String)iter.next();
            money = money.trim();
            String opDate = (String)iter.next();
            opDate = opDate.trim();
            String port = (String)iter.next();
            port = port.trim();
            String opId = (String)iter.next();
            opId = opId.trim();
            String startDate = (String)iter.next();
            startDate = startDate.trim();
            String endDate = (String)iter.next();
            endDate = endDate.trim();
            String wgfMoney = (String)iter.next();
            wgfMoney = wgfMoney.trim();
            String jt1price = (String)iter.next();
            jt1price = jt1price.trim();
            String jt1gas = (String)iter.next();
            jt1gas = jt1gas.trim();
            String jt1money = (String)iter.next();
            jt1money = jt1money.trim();
            String jt2price = (String)iter.next();
            jt2price = jt2price.trim();
            String jt2gas = (String)iter.next();
            jt2gas = jt2gas.trim();
            String jt2money = (String)iter.next();
            jt2money = jt2money.trim();
            String jt3price = (String)iter.next();
            jt3price = jt3price.trim();
            String jt3gas = (String)iter.next();
            jt3gas = jt3gas.trim();
            String jt3money = (String)iter.next();
            jt3money = jt3money.trim();
            String invermoney = (String)iter.next();
            invermoney = invermoney.trim();
            String userSql = "from t_userfiles where F_CARD_ID='" + cardId + "'";
            List userlist = this.hibernateTemplate.find(userSql, new Object[0]);
            if (userlist.size() != 1) {
                return errorStr;
            }
            Map userMap = (Map)userlist.get(0);
            JSONObject selllogic = (JSONObject)this.callthirdPay(userMap, cardId, lsId, new BigDecimal(gas), new BigDecimal(money), port, opId, invermoney);
            log.info((Object)("\u552e\u6c14\u6210\u529f\uff0c\u552e\u6c14\u8bb0\u5f55id\u662f:" + selllogic.getString("id")));
            return "00|;";
        }
        catch (Exception e) {
            log.error((Object)("\u5904\u7406\u552e\u6c14\u4e1a\u52a1\u51fa\u9519" + e.getMessage()));
            return "03|;";
        }
    }

    private Object callcommonCancel(String f_serial_id, String f_serial_id_new) throws Exception {
        JSONObject data = new JSONObject();
        data.put("f_serial_id", (Object)f_serial_id);
        data.put("f_serial_id_new", (Object)f_serial_id_new);
        return this.logicServer.run("commonCancel", data.toString());
    }

    private String chongzhang(Iterator iter) {
        try {
            String errorStr = "04|;";
            String lsId = (String)iter.next();
            lsId = lsId.trim();
            String cardId = (String)iter.next();
            cardId = cardId.trim();
            String gas = (String)iter.next();
            gas = gas.trim();
            String money = (String)iter.next();
            money = money.trim();
            String opDate = (String)iter.next();
            opDate = opDate.trim();
            String port = (String)iter.next();
            port = port.trim();
            String opId = (String)iter.next();
            opId = opId.trim();
            String startDate = (String)iter.next();
            startDate = startDate.trim();
            String endDate = (String)iter.next();
            endDate = endDate.trim();
            String wgfMoney = (String)iter.next();
            wgfMoney = wgfMoney.trim();
            String chongzhangType = "\u6709\u5361\u51b2\u8d26 ";
            String oldLsid = (String)iter.next();
            oldLsid = oldLsid.trim();
            String userSql = "from t_userfiles where F_CARD_ID='" + cardId + "'";
            List userlist = this.hibernateTemplate.find(userSql, new Object[0]);
            if (userlist.size() != 1) {
                return errorStr;
            }
            JSONObject selllogic = (JSONObject)this.callcommonCancel(oldLsid, lsId);
            log.info((Object)"\u51b2\u6b63\u6210\u529f,");
            return "00|;";
        }
        catch (Exception e) {
            log.error((Object)("\u5904\u7406\u552e\u6c14\u4e1a\u52a1\u51fa\u9519" + e.getMessage()));
            return "04|;";
        }
    }

    private String encryp(Iterator iter) {
        String code = (String)iter.next();
        code = code.trim();
        String password = (String)iter.next();
        password = password.trim();
        try {
            Socket socket = new Socket("192.168.2.59", 5000);
            OutputStream os = socket.getOutputStream();
            String encrypStr = code + "|" + password + "|;";
            os.write(encrypStr.getBytes());
            os.flush();
            byte[] bs = new byte[1000];
            int len = socket.getInputStream().read(bs);
            password = new String(bs, 0, len);
            if (password.equals("55AA")) {
                return "05|;";
            }
            return password;
        }
        catch (IOException ex) {
            return "05|;";
        }
    }

    public boolean isExist(String FileName) {
        String fPath = FilePath.GetPath("xabankfilepath") + "" + FileName;
        File fr = new File(fPath);
        return fr.exists();
    }

    private String duizhang(Iterator iter) {
        try {
            String fileName = (String)iter.next();
            fileName = fileName.trim();
            if (this.isExist(fileName)) {
                sendDataXA thread = new sendDataXA();
                thread.setFilepath(fileName);
                thread.start();
                return "00|;";
            }
            return "06|\u672a\u627e\u5230\u540d\u79f0\u4e3a" + fileName + "\u7684\u6587\u4ef6|;";
        }
        catch (Exception e) {
            log.error((Object)("\u5904\u7406\u5bf9\u8d26\u51fa\u9519" + e.getMessage()));
            return "06|;";
        }
    }

    public class sendDataXA
    extends Thread {
        String filepath;

        public void setFilepath(String name) {
            this.filepath = name;
        }

        @Override
        public void run() {
            String result = RestTools.post((String)"http://127.0.0.1:5004/rs/XABankDuizhang", (String)this.filepath);
        }
    }
}

