/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.helper.FilePath;
import com.aote.helper.NumberHelper;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="HTDuizhang")
@Component
public class SpaceFlightFileEntity {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private HibernateTemplate hibernateTemplate;
    private static final Logger log = Logger.getLogger(SpaceFlightFileEntity.class);
    private static final long serialVersionUID = -1404439164923599184L;
    private BufferedWriter bw = null;
    private String Path;
    public String FileName;

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public void readfile() throws Exception {
        this.Path = FilePath.GetPath("spaceflightfilepath") + "" + this.FileName;
        FileReader fr = new FileReader(this.Path);
        BufferedReader br = new BufferedReader(fr);
        String content = "";
        log.info((Object)("\u5f00\u59cb\u5bf9\u8d26,\u6587\u4ef6\u540d:" + this.FileName));
        while ((content = br.readLine()) != null) {
            try {
                this.xtSavedisposeData(content);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage().toString());
            }
        }
        if (this.bw != null) {
            this.bw.close();
        }
        if (br != null) {
            br.close();
        }
        if (fr != null) {
            fr.close();
        }
        this.SetNotExistFileInvaild(this.FileName);
        this.copyFile(this.Path, FilePath.GetOldFilePath("spaceflightfilepath") + this.FileName);
        this.delete();
        log.info((Object)("\u5bf9\u8d26\u7ed3\u675f,\u6587\u4ef6\u540d:" + this.FileName));
    }

    public void SetNotExistFileInvaild(String fileName) {
        String date = fileName.substring(2, 10);
        String con = " F_BANK_NAME='\u822a\u5929\u4ee3\u552e'  and TRUNC (f_operate_date)=to_date('" + date + "','yyyy-mm-dd') and  (f_isduizhang <>'\u5df2\u5bf9\u8d26' or f_isduizhang is null) and f_state='\u6709\u6548' ";
        String t_recordsql = "update t_record set f_state='\u65e0\u6548' where id in (select id from t_sellinggas where " + con + " )";
        this.sqlServer.run(t_recordsql);
        String t_chargepricesql = "update t_chargeprice set f_state='\u65e0\u6548' where f_charge_id in (select id from t_sellinggas where " + con + " )";
        this.sqlServer.run(t_chargepricesql);
        String t_sellinggassql = "update t_sellinggas set f_state='\u65e0\u6548' where " + con;
        this.sqlServer.run(t_sellinggassql);
        log.info((Object)("\u66f4\u65b0" + date + "\u672a\u5bf9\u8d26\u7684\u822a\u5929\u4ee3\u552e\u6570\u636e\u4e3a\u65e0\u6548,sql:"));
    }

    private boolean isRepeate(String filename) {
        try {
            String sql = "from t_revicebankfile where filename='" + filename + "'";
            List list = this.hibernateTemplate.find(sql, new Object[0]);
            return list.size() > 1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void xtSavedisposeData(String content) throws Exception {
        log.info((Object)"<--------------------------------------->");
        log.info((Object)("\u822a\u5929\u4ee3\u552e\u8bb0\u5f55:" + content));
        String[] str = content.split("\\|");
        try {
            if (str.length == 12 || str.length == 21) {
                log.info((Object)"\u5f00\u59cb\u5bf9\u8d26------");
                String LSID = str[0].trim();
                String sql = "from t_sellinggas where f_serial_id='" + LSID + "' and  (f_isduizhang <> '\u5df2\u5bf9\u8d26' or f_isduizhang is null)";
                log.info((Object)("\u67e5\u627e\u7cfb\u7edf\u6536\u8d39\u6570\u636e" + sql));
                List list = this.hibernateTemplate.find(sql, new Object[0]);
                Map<String, Object> data = this.getmap(str);
                if (list.size() != 1) {
                    log.info((Object)"\u627e\u5230\u6536\u8d39\u6570\u636e");
                    if (!this.hasDuiZhang(LSID)) {
                        log.info((Object)("\u672a\u627e\u5230\u8bb0\u5f55\u63d2\u5165\u822a\u5929\u4ee3\u552e\u6570\u636e:" + content));
                        Map<String, Object> sellgas = this.getSellInfos(data);
                        if (sellgas == null) {
                            log.info((Object)("\u672a\u627e\u5230\u7528\u6237\u6863\u6848\u65e0\u6cd5\u63d2\u5165\u552e\u6c14\u6570\u636e:" + content));
                            return;
                        }
                        JSONObject selllogic = (JSONObject)this.callthirdPay(sellgas);
                        String yiduizhang = "update t_sellinggas set f_isduizhang='\u5df2\u5bf9\u8d26' where f_serial_id='" + LSID + "' and id= '" + selllogic.getString("id") + "'";
                        this.hibernateTemplate.bulkUpdate(yiduizhang, new Object[0]);
                        String czType = (String)sellgas.get("CHONGZHANGTYPE");
                        if (czType != null && czType.indexOf("\u51b2\u8d26") != -1) {
                            Map<String, Object> fuso = this.getFuSellInfos(data);
                            this.hibernateTemplate.save("T_IC_SELLGAS", fuso);
                        }
                        data.put("f_biaoshi", "\u63d2\u5165\u822a\u5929\u4ee3\u552e\u6570\u636e");
                        data.put("ldata", content);
                        data.put("localdata", "\u672c\u5730\u65e0\u6b64\u8bb0\u5f55");
                        this.hibernateTemplate.save("t_ic_checking", data);
                    }
                } else {
                    HashMap localht = (HashMap)list.get(0);
                    String laformatdata = this.dataFromatla(localht);
                    HashMap<String, String> savenewHt = new HashMap<String, String>();
                    savenewHt.putAll(localht);
                    StringBuilder differStr = new StringBuilder();
                    boolean f = this.dui(str, localht, savenewHt, differStr);
                    if (!f) {
                        log.info((Object)"\u8bb0\u5f55\u4e0d\u4e00\u81f4:");
                        log.info((Object)("\u822a\u5929\u4ee3\u552e\u6570\u636e:" + content));
                        log.info((Object)("\u672c\u5730\u6570\u636e:" + laformatdata));
                        data.put("f_biaoshi", "\u6570\u636e\u4e0d\u4e00\u81f4");
                        data.put("ladata", content);
                        data.put("localdata", laformatdata);
                        data.put("diffs", differStr.toString());
                        this.hibernateTemplate.save("t_ic_checking", data);
                        savenewHt.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
                        this.hibernateTemplate.saveOrUpdate("t_sellinggas", savenewHt);
                    } else {
                        log.info((Object)("\u8bb0\u5f55\u76f8\u540c:" + content));
                        localht.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
                        this.hibernateTemplate.saveOrUpdate("t_sellinggas", (Object)localht);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("\u6838\u5bf9\u822a\u5929\u4ee3\u552e\u6570\u636e\u62a5\u9519" + e.getMessage()));
        }
    }

    private Object callthirdPay(Map<String, Object> user) throws Exception {
        JSONObject data = new JSONObject();
        data.put("f_user_id", user.get("f_user_id"));
        data.put("f_card_id", user.get("CARD_ID"));
        data.put("f_terminal_num", user.get("OP_SPOT"));
        data.put("opid", user.get("OP_ID"));
        data.put("f_unit", (Object)"yuan");
        data.put("f_preamount", (Object)new BigDecimal(user.get("MONEY").toString()));
        data.put("f_serial_id", user.get("LSID"));
        data.put("f_collection", (Object)new BigDecimal(user.get("MONEY").toString()));
        data.put("f_pregas", (Object)new BigDecimal(user.get("SELLGAS_GAS").toString()));
        data.put("isGasValue", 0);
        return this.logicServer.run("thirdPay", data.toString());
    }

    public String dataFromatla(Map localht) {
        String lsid = (String)localht.get("F_SERIAL_ID");
        String cardId = (String)localht.get("F_CARD_ID");
        String gas = localht.get("F_PREGAS").toString();
        String money = localht.get("F_COLLECTION").toString();
        Date d = (Date)localht.get("F_OPERATE_DATE");
        String op_spot = (String)localht.get("F_TERMINAL_NUM");
        String op_id = (String)localht.get("F_OPERATOR");
        String chongzhangtype = (String)localht.get("F_STATE");
        String write_card = (String)localht.get("F_WRITE_CARD");
        if (chongzhangtype == null || chongzhangtype.equals("\u6709\u6548")) {
            chongzhangtype = "0";
        } else if (chongzhangtype.equals("\u65e0\u5361\u51b2\u8d26") && write_card != null) {
            chongzhangtype = "1";
        } else if (chongzhangtype.equals("\u6709\u5361\u51b2\u8d26") && write_card == null) {
            chongzhangtype = "2";
        }
        String wgfStartDate = "0";
        String wgfEndDate = "0";
        String wgfMoney = "0";
        StringBuilder sb = new StringBuilder();
        sb.append(lsid).append("|");
        sb.append(cardId).append("|");
        sb.append(gas).append("|");
        sb.append(money).append("|");
        sb.append(d).append("|");
        sb.append(op_spot).append("|");
        sb.append(op_id).append("|");
        sb.append(chongzhangtype).append("|");
        sb.append(wgfStartDate).append("|");
        sb.append(wgfEndDate).append("|");
        sb.append(wgfMoney).append("|");
        return sb.toString();
    }

    public String dataWGFFromatla(Map localht) {
        String lsid = (String)localht.get("LSID");
        String cardId = (String)localht.get("CARD_ID");
        String money = localht.get("MONEY").toString();
        Date opdate = (Date)localht.get("OPERATE_DATE");
        Date optime = (Date)localht.get("OPERATE_TIME");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String operate_date = sdf.format(opdate);
        String operate_time = sdf.format(optime);
        String d = operate_date.substring(0, 10) + " " + operate_time.substring(11, operate_time.length());
        String op_spot = (String)localht.get("OP_SPOT");
        String op_id = (String)localht.get("OP_ID");
        String chongzhangtype = (String)localht.get("CHONGZHANGTYPE");
        if (chongzhangtype == null || chongzhangtype.equals("\u6210\u529f")) {
            chongzhangtype = "0";
        } else if (chongzhangtype.equals("\u65e0\u5361\u51b2\u8d26")) {
            chongzhangtype = "1";
        } else if (chongzhangtype.equals("\u6709\u5361\u51b2\u8d26")) {
            chongzhangtype = "2";
        }
        SimpleDateFormat ddf1 = new SimpleDateFormat("yyyy-MM-dd");
        Date wgfStartDate = (Date)localht.get("STARTDATE");
        String startStr = ddf1.format(wgfStartDate);
        Date wgfEndDate = (Date)localht.get("ENDDATE");
        String endStr = ddf1.format(wgfEndDate);
        double wgfMoney = Double.parseDouble(localht.get("MONEY").toString());
        StringBuilder sb = new StringBuilder();
        sb.append(lsid).append("|");
        sb.append(cardId).append("|");
        sb.append(money).append("|");
        sb.append(d).append("|");
        sb.append(op_spot).append("|");
        sb.append(op_id).append("|");
        sb.append(chongzhangtype).append("|");
        sb.append(startStr).append("|");
        sb.append(endStr).append("|");
        sb.append(wgfMoney + "").append("|");
        return sb.toString();
    }

    public boolean hasDuiZhang(String lsid) {
        String sql = "from t_sellinggas where f_serial_id='" + lsid + "' and  f_isduizhang = '\u5df2\u5bf9\u8d26'";
        List list = this.hibernateTemplate.find(sql, new Object[0]);
        return list.size() >= 1;
    }

    public boolean hasWgfDuiZhang(String lsid) {
        String sql = "from T_IC_MYWGF where LSID='" + lsid + "' and  f_isduizhang = '\u5df2\u5bf9\u8d26'";
        List list = this.hibernateTemplate.find(sql, new Object[0]);
        return list.size() >= 1;
    }

    public Map<String, Object> getSellInfos(Map data) {
        String cardId = (String)data.get("CARD_ID");
        String userSql = "from t_userfiles where F_CARD_ID='" + cardId + "'";
        List userlist = this.hibernateTemplate.find(userSql, new Object[0]);
        if (userlist.size() != 1) {
            return null;
        }
        Map userMap = (Map)userlist.get(0);
        HashMap<String, Object> sale = new HashMap<String, Object>();
        sale.put("LSID", data.get("LSID"));
        sale.put("CARD_ID", data.get("CARD_ID"));
        sale.put("OP_DATE", data.get("OPERATE_DATE"));
        sale.put("OP_TIME", data.get("OPERATE_DATE"));
        sale.put("OPERATE_DATE", data.get("OPERATE_DATE"));
        sale.put("OPERATE_TIME", data.get("OPERATE_DATE"));
        sale.put("SELLGAS_GAS", data.get("SELLGAS_GAS"));
        sale.put("MONEY", data.get("MONEY"));
        sale.put("OP_ID", data.get("OP_ID"));
        sale.put("OP_SPOT", data.get("OP_SPOT"));
        sale.put("CHONGZHANGTYPE", data.get("f_success"));
        sale.put("COME", "\u822a\u5929\u4ee3\u552e");
        sale.put("COME_DEP", "\u81ea\u52a9\u8bbe\u5907");
        sale.put("SUBUNIT", userMap.get("SUBUNIT"));
        sale.put("USER_NATURE", userMap.get("USER_NATURE"));
        sale.put("USER_TYPE", userMap.get("USER_TYPE"));
        sale.put("USER_EQUIPMENT", userMap.get("USER_EQUIPMENT"));
        sale.put("PRICE", userMap.get("PRICE"));
        sale.put("METER_TYPES_NAME", userMap.get("METER_TYPES_NAME"));
        sale.put("DATA_VAILD", "\u662f");
        sale.put("IS_BILL", "\u662f");
        String meterTypes = (String)userMap.get("METER_TYPES_ID");
        if (meterTypes != null && (meterTypes.equals("15") || meterTypes.equals("16"))) {
            sale.put("measure_way", "\u91d1\u989d");
        } else {
            sale.put("measure_way", "\u6c14\u91cf");
        }
        sale.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
        return sale;
    }

    public Map<String, Object> getFuSellInfos(Map data) {
        String cardId = (String)data.get("CARD_ID");
        String userSql = "from T_IC_USERFILE where CARD_ID='" + cardId + "'";
        List userlist = this.hibernateTemplate.find(userSql, new Object[0]);
        if (userlist.size() != 1) {
            return null;
        }
        Map userMap = (Map)userlist.get(0);
        HashMap<String, Object> sale = new HashMap<String, Object>();
        sale.put("LSID", data.get("LSID"));
        sale.put("CARD_ID", data.get("CARD_ID"));
        sale.put("OP_DATE", data.get("OPERATE_DATE"));
        sale.put("OP_TIME", data.get("OPERATE_DATE"));
        sale.put("OPERATE_DATE", data.get("OPERATE_DATE"));
        sale.put("OPERATE_TIME", data.get("OPERATE_DATE"));
        double d = Double.parseDouble(data.get("SELLGAS_GAS").toString());
        sale.put("SELLGAS_GAS", -d);
        double m = Double.parseDouble(data.get("MONEY").toString());
        sale.put("MONEY", -m);
        sale.put("OP_ID", data.get("OP_ID"));
        sale.put("OP_SPOT", data.get("OP_SPOT"));
        sale.put("CHONGZHANGTYPE", data.get("f_success"));
        sale.put("COME", "\u822a\u5929\u4ee3\u552e");
        sale.put("COME_DEP", "\u81ea\u52a9\u8bbe\u5907");
        sale.put("SUBUNIT", userMap.get("SUBUNIT"));
        sale.put("USER_NATURE", userMap.get("USER_NATURE"));
        sale.put("USER_TYPE", userMap.get("USER_TYPE"));
        sale.put("USER_EQUIPMENT", userMap.get("USER_EQUIPMENT"));
        sale.put("PRICE", userMap.get("PRICE"));
        sale.put("METER_TYPES_NAME", userMap.get("METER_TYPES_NAME"));
        sale.put("DATA_VAILD", "\u662f");
        sale.put("IS_BILL", "\u662f");
        String meterTypes = (String)userMap.get("METER_TYPES_ID");
        if (meterTypes != null && (meterTypes.equals("15") || meterTypes.equals("16"))) {
            sale.put("measure_way", "\u91d1\u989d");
        } else {
            sale.put("measure_way", "\u6c14\u91cf");
        }
        sale.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
        return sale;
    }

    private void checkWGF(String content, Map<String, Object> data) {
        log.info((Object)("\u6bd4\u5bf9\u7ef4\u7ba1\u8d39" + content));
        String lsid = (String)data.get("LSID");
        String sql = "from T_IC_MYWGF where LSID='" + data.get("LSID") + "'  and  (f_isduizhang <> '\u5df2\u5bf9\u8d26' or f_isduizhang is null)";
        List list = this.hibernateTemplate.find(sql, new Object[0]);
        if (list.size() != 1) {
            if (!this.hasWgfDuiZhang(lsid)) {
                log.info((Object)("\u7ef4\u7ba1\u8d39\u65e0\u8bb0\u5f55,\u63d2\u5165" + content));
                data.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
                Map<String, Object> wgfinfo = this.getWgfInfo(data);
                this.hibernateTemplate.save("T_IC_MYWGF", wgfinfo);
                String czType = (String)wgfinfo.get("CHONGZHANGTYPE");
                if (czType != null && czType.indexOf("\u51b2\u8d26") != -1) {
                    Map<String, Object> fuso = this.getFuWgfInfo(data);
                    this.hibernateTemplate.save("T_IC_MYWGF", fuso);
                }
                data.put("f_biaoshi", "\u63d2\u5165");
                data.put("f_biaoshi", "\u63d2\u5165\u822a\u5929\u4ee3\u552e\u6570\u636e");
                data.put("ladata", content);
                data.put("localdata", "\u672c\u5730\u65e0\u6b64\u8bb0\u5f55");
                this.hibernateTemplate.save("T_IC_WGFCHECKING", data);
            }
        } else {
            HashMap ht = (HashMap)list.get(0);
            String wgfLaFormat = this.dataWGFFromatla(ht);
            HashMap<String, String> newHt = new HashMap<String, String>();
            newHt.putAll(ht);
            StringBuilder diffs = new StringBuilder();
            boolean f = this.wgfdui(data, ht, newHt, diffs);
            if (!f) {
                String laformatdata = this.dataWGFFromatla(ht);
                log.info((Object)"\u7ef4\u7ba1\u8d39\u8bb0\u5f55\u4e0d\u4e00\u81f4:");
                log.info((Object)("\u822a\u5929\u4ee3\u552e\u6570\u636e:" + content));
                log.info((Object)("\u672c\u5730\u6570\u636e:" + laformatdata));
                ht.put("f_biaoshi", "\u6570\u636e\u4e0d\u4e00\u81f4");
                ht.put("ladata", content);
                ht.put("localdata", laformatdata);
                ht.put("diffs", diffs.toString());
                this.hibernateTemplate.save("T_IC_WGFCHECKING", (Object)ht);
                newHt.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
                this.hibernateTemplate.saveOrUpdate("T_IC_MYWGF", newHt);
            } else {
                log.info((Object)("\u7ef4\u7ba1\u8d39\u76f8\u540c" + content));
                ht.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
                this.hibernateTemplate.saveOrUpdate("T_IC_MYWGF", (Object)ht);
            }
        }
    }

    public void updateUserWGFDate(String card_id, Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String wdate = sdf.format(d);
        String sql = "update T_IC_USERFILE set WGFLASTDATE=to_date('" + wdate + "','yyyy-mm-dd') where CARD_ID='" + card_id + "'";
        log.info((Object)("\u7528\u6237\u6863\u6848\u7ef4\u7ba1\u8d39\u65e5\u671f\u56de\u64a4\u66f4\u65b0,\u6267\u884csql" + sql));
        this.hibernateTemplate.bulkUpdate(sql, new Object[0]);
    }

    public Map<String, Object> getWgfInfo(Map data) {
        HashMap<String, Object> wgf = new HashMap<String, Object>();
        wgf.put("LSID", data.get("LSID"));
        wgf.put("CARD_ID", data.get("CARD_ID"));
        wgf.put("OP_DATE", data.get("OPERATE_TIME"));
        wgf.put("OP_TIME", data.get("OPERATE_TIME"));
        wgf.put("OPERATE_DATE", data.get("OPERATE_TIME"));
        wgf.put("OPERATE_TIME", data.get("OPERATE_TIME"));
        wgf.put("MONEY", data.get("WGFMONEY"));
        wgf.put("OP_ID", data.get("OP_ID"));
        wgf.put("OP_SPOT", data.get("OP_SPOT"));
        wgf.put("STARTDATE", data.get("WGFLASTDATE"));
        wgf.put("ENDDATE", data.get("WGFLASTDATE2"));
        wgf.put("COME", "\u822a\u5929\u4ee3\u552e");
        wgf.put("COME_DEP", "\u81ea\u52a9\u8bbe\u5907");
        wgf.put("DATA_VAILD", "\u662f");
        wgf.put("IS_BILL", "\u662f");
        wgf.put("CHONGZHANGTYPE", data.get("f_success"));
        wgf.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
        return wgf;
    }

    public Map<String, Object> getFuWgfInfo(Map data) {
        HashMap<String, Object> wgf = new HashMap<String, Object>();
        wgf.put("LSID", data.get("LSID"));
        wgf.put("CARD_ID", data.get("CARD_ID"));
        wgf.put("OP_DATE", data.get("OPERATE_TIME"));
        wgf.put("OP_TIME", data.get("OPERATE_TIME"));
        wgf.put("OPERATE_DATE", data.get("OPERATE_TIME"));
        wgf.put("OPERATE_TIME", data.get("OPERATE_TIME"));
        double d = Double.parseDouble(data.get("WGFMONEY").toString());
        wgf.put("MONEY", -d);
        wgf.put("OP_ID", data.get("OP_ID"));
        wgf.put("OP_SPOT", data.get("OP_SPOT"));
        wgf.put("STARTDATE", data.get("WGFLASTDATE"));
        wgf.put("ENDDATE", data.get("WGFLASTDATE2"));
        wgf.put("COME", "\u822a\u5929\u4ee3\u552e");
        wgf.put("COME_DEP", "\u81ea\u52a9\u8bbe\u5907");
        wgf.put("DATA_VAILD", "\u662f");
        wgf.put("IS_BILL", "\u662f");
        wgf.put("CHONGZHANGTYPE", data.get("f_success"));
        wgf.put("f_isduizhang", "\u5df2\u5bf9\u8d26");
        return wgf;
    }

    private boolean wgfdui(Map<String, Object> wgf, Map<String, Object> ht, Map newHt, StringBuilder diffs) {
        String f_success;
        double moneyCa;
        double moneyLA;
        String eDataCa;
        Date sd2;
        String sDataCa;
        Date sd1;
        SimpleDateFormat formatDate;
        String sDateLA;
        boolean result = true;
        if (!wgf.get("LSID").equals(ht.get("LSID"))) {
            log.info((Object)("\u6d41\u6c34\u53f7\uff1a\u6570\u636e\uff1a" + ht.get("LSID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("LSID")));
            diffs.append("\u6d41\u6c34\u53f7\uff1a\u6570\u636e\uff1a" + ht.get("LSID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("LSID")).append("|");
            result = false;
        }
        if (!wgf.get("CARD_ID").equals(ht.get("CARD_ID"))) {
            log.info((Object)("\u5361\u53f7\uff1a\u6570\u636e\u503c\uff1a" + ht.get("CARD_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("CARD_ID")));
            diffs.append("\u5361\u53f7\uff1a\u6570\u636e\uff1a" + ht.get("CARD_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("CARD_ID")).append("|");
            newHt.put("CARD_ID", wgf.get("CARD_ID"));
            result = false;
        }
        String wgfDateCA = ht.get("OPERATE_DATE").toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date d = (Date)wgf.get("OPERATE_DATE");
        String wgfDateLA = sdf.format(d);
        if (!wgfDateLA.equals(wgfDateCA)) {
            log.info((Object)("\u64cd\u4f5c\u65e5\u671f\uff1a\u6570\u636e\uff1a" + ht.get("OP_DATE") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgfDateLA));
            diffs.append("\u64cd\u4f5c\u65e5\u671f\uff1a\u6570\u636e\uff1a" + ht.get("OP_DATE") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgfDateLA).append("|");
            newHt.put("OPERATE_DATE", wgf.get("OP_DATE"));
            result = false;
        }
        if (!wgf.get("OP_SPOT").equals(ht.get("OP_SPOT"))) {
            log.info((Object)("\u64cd\u4f5c\u5730\u70b9\uff1a\u6570\u636e\uff1a" + ht.get("OP_SPOT") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("OP_SPOT")));
            diffs.append("\u64cd\u4f5c\u5730\u70b9\uff1a\u6570\u636e\uff1a" + ht.get("OP_SPOT") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("OP_SPOT")).append("|");
            newHt.put("OP_SPOT", wgf.get("OP_SPOT"));
            result = false;
        }
        if (!wgf.get("OP_ID").equals(ht.get("OP_ID"))) {
            log.debug((Object)("\u64cd\u4f5c\u5458\u7f16\u53f7\uff1a\u6570\u636e\uff1a" + ht.get("OP_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("OP_ID")));
            diffs.append("\u64cd\u4f5c\u5458\u7f16\u53f7\uff1a\u6570\u636e\uff1a" + ht.get("OP_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("OP_ID")).append("|");
            newHt.put("OP_ID", wgf.get("OP_ID"));
            result = false;
        }
        if (!(sDateLA = (formatDate = new SimpleDateFormat("yyyy-MM-dd")).format(sd1 = (Date)wgf.get("WGFLASTDATE"))).equals(sDataCa = formatDate.format(sd2 = (Date)ht.get("STARTDATE")))) {
            log.info((Object)("\u5f00\u59cb\u65e5\u671f\uff1a\u6570\u636e\uff1a" + ht.get("STARTDATE") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("STARTDATE")));
            diffs.append("\u5f00\u59cb\u65e5\u671f\uff1a\u6570\u636e\uff1a" + ht.get("STARTDATE") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("STARTDATE")).append("|");
            ht.put("STARTDATE", wgf.get("STARTDATE"));
            result = false;
        }
        Date ed1 = (Date)wgf.get("WGFLASTDATE2");
        Date ed2 = (Date)ht.get("ENDDATE");
        String eDateLA = formatDate.format(ed1);
        if (!eDateLA.equals(eDataCa = formatDate.format(ed2))) {
            log.info((Object)("\u7ed3\u675f\u65e5\u671f\uff1a\u6570\u636e\uff1a" + ht.get("ENDDATE") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("ENDDATE")));
            diffs.append("\u7ed3\u675f\u65e5\u671f\uff1a\u6570\u636e\uff1a" + ht.get("ENDDATE") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("ENDDATE")).append("|");
            newHt.put("ENDDATE", wgf.get("ENDDATE"));
            result = false;
        }
        if ((moneyLA = Double.parseDouble(wgf.get("WGFMONEY").toString())) != (moneyCa = Double.parseDouble(ht.get("MONEY").toString()))) {
            log.info((Object)("\u91d1\u989d\uff1a\u6570\u636e\uff1a" + ht.get("MONEY") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("MONEY")));
            diffs.append("\u91d1\u989d\uff1a\u6570\u636e\uff1a" + ht.get("MONEY") + ";\u822a\u5929\u4ee3\u552e\uff1a" + wgf.get("MONEY")).append("|");
            newHt.put("MONEY", moneyLA);
            result = false;
        }
        if ((f_success = (String)wgf.get("f_success")) != null && (f_success.equals("\u65e0\u5361\u51b2\u8d26") || f_success.equals("\u6709\u5361\u51b2\u8d26"))) {
            result = false;
        }
        return result;
    }

    private Map<String, Object> getWGF(Map<String, Object> data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LSID", data.get("LSID"));
        map.put("CARD_ID", data.get("CARD_ID"));
        map.put("OP_DATE", data.get("OPERATE_DATE"));
        map.put("OPERATE_DATE", data.get("OPERATE_DATE"));
        map.put("OP_SPOT", data.get("OP_SPOT"));
        map.put("OP_ID", data.get("OP_CODE"));
        map.put("DATA_VAILD", "\u662f");
        map.put("STARTDATE", data.get("WGFLASTDATE"));
        map.put("ENDDATE", data.get("WGFLASTDATE2"));
        map.put("MONEY", data.get("WGFMONEY"));
        map.put("CHONGZHANGTYPE", data.get("f_success"));
        return map;
    }

    private Map<String, Object> getmap(String[] str) throws ParseException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LSID", str[0].trim());
        map.put("CARD_ID", str[1].trim());
        map.put("SELLGAS_GAS", Double.parseDouble(str[2].trim()));
        map.put("MONEY", Double.parseDouble(str[3].trim()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d1 = sdf.parse(str[4].trim());
        map.put("OPERATE_DATE", d1);
        map.put("OPERATE_TIME", d1);
        map.put("OP_SPOT", str[5].trim());
        map.put("OP_ID", str[6].trim());
        String temp = str[7].trim();
        if (temp.equals("0")) {
            map.put("f_success", "\u6210\u529f");
        } else if (temp.equals("1")) {
            map.put("f_success", "\u65e0\u5361\u51b2\u8d26");
        } else if (temp.equals("2")) {
            map.put("f_success", "\u6709\u5361\u51b2\u8d26");
        }
        temp = str[8].trim();
        map.put("WGFMONEY", Double.parseDouble(str[10].trim()));
        if (str.length > 12) {
            map.put("f_stair1amount", NumberHelper.strToDouble(str[11]));
            map.put("f_stair2amount", NumberHelper.strToDouble(str[12]));
            map.put("f_stair3amount", NumberHelper.strToDouble(str[13]));
            map.put("f_stair1price", NumberHelper.strToDouble(str[14]));
            map.put("f_stair2price", NumberHelper.strToDouble(str[15]));
            map.put("f_stair3price", NumberHelper.strToDouble(str[16]));
            map.put("f_stair1fee", NumberHelper.strToDouble(str[17]));
            map.put("f_stair2fee", NumberHelper.strToDouble(str[18]));
            map.put("f_stair3fee", NumberHelper.strToDouble(str[19]));
        }
        return map;
    }

    private boolean dui(String[] str, Map<String, Object> map, Map newht, StringBuilder sb) {
        String temp;
        double moneyCa;
        double moneyLA;
        double gasCa;
        double gasLA;
        String cardId;
        boolean result = true;
        String lsid = str[0].trim();
        if (!lsid.equals(map.get("F_SERIAL_ID"))) {
            log.info((Object)("\u6d41\u6c34\u53f7\uff1a\u6570\u636e\u503c\uff1a" + map.get("F_SERIAL_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[0]));
            sb.append("\u6d41\u6c34\u53f7\uff1a\u6570\u636e\u503c\uff1a" + map.get("F_SERIAL_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[0]).append("|");
            newht.put("F_SERIAL_ID", str[0]);
            result = false;
        }
        if (!(cardId = str[1].trim()).equals(map.get("F_CARD_ID"))) {
            log.info((Object)("\u5361\u53f7\uff1a\u6570\u636e\uff1a" + map.get("F_CARD_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[1]));
            sb.append("\u5361\u53f7\uff1a\u6570\u636e\uff1a" + map.get("F_CARD_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[1]).append("|");
            newht.put("F_CARD_ID", str[1]);
            result = false;
        }
        if ((gasLA = Double.parseDouble(str[2].trim())) != (gasCa = Double.parseDouble(map.get("F_PREGAS").toString()))) {
            log.info((Object)("\u6c14\u91cf\uff1a\u6570\u636e\u503c\uff1a" + map.get("F_PREGAS") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[2]));
            sb.append("\u6c14\u91cf\uff1a\u6570\u636e\u503c\uff1a" + map.get("F_PREGAS") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[1]).append("|");
            newht.put("F_PREGAS", gasLA);
            result = false;
        }
        if ((moneyLA = Double.parseDouble(str[3].trim())) != (moneyCa = Double.parseDouble(map.get("F_COLLECTION").toString()))) {
            log.info((Object)("\u91d1\u989d\uff1a\u6570\u636e\u503c\uff1a" + map.get("F_COLLECTION") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[3]));
            sb.append("\u91d1\u989d\uff1a\u6570\u636e\u503c\uff1a" + map.get("F_COLLECTION") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[3]).append("|");
            newht.put("F_COLLECTION", moneyLA);
            result = false;
        }
        if (!str[5].trim().equals(map.get("F_TERMINAL_NUM"))) {
            log.info((Object)("\u64cd\u4f5c\u5730\u70b9\uff1a\u6570\u636e\u503c\uff1a" + map.get("F_TERMINAL_NUM") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[5]));
            sb.append("\u64cd\u4f5c\u5730\u70b9\uff1a\u6570\u636e\u503c\uff1a" + map.get("F_TERMINAL_NUM") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[5]).append("|");
            newht.put("F_TERMINAL_NUM", str[5]);
            result = false;
        }
        if (!str[6].trim().equals(map.get("OP_ID"))) {
            log.info((Object)("\u64cd\u4f5c\u5458\uff1a\u6570\u636e\u503c\uff1a" + map.get("OP_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[6]));
            sb.append("\u64cd\u4f5c\u5458\uff1a\u6570\u636e\u503c\uff1a" + map.get("OP_ID") + ";\u822a\u5929\u4ee3\u552e\uff1a" + str[6]).append("|");
            newht.put("OP_ID", str[6]);
            result = false;
        }
        if (!(temp = (temp = str[7].trim()).equals("0") ? "\u6709\u6548" : "\u51b2\u6b63").equals(map.get("F_STATE"))) {
            result = false;
        }
        return result;
    }

    private void writeFile(String content) {
        try {
            if (this.bw == null) {
                String path = FilePath.GetOldFilePath("spaceflightfilepath") + this.FileName;
                FileWriter fw = new FileWriter(path);
                this.bw = new BufferedWriter(fw);
                this.bw.write(content);
            } else {
                this.bw.write(content);
            }
            this.bw.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException("\u5199\u9519\u8bef\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    public void delete() throws Exception {
        try {
            boolean t;
            File file = new File(this.Path);
            if (file.isFile() && file.exists() && !(t = file.delete())) {
                file.deleteOnExit();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void copyFile(String oldPath, String newPath) {
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    System.out.println(bytesum += byteread);
                    fs.write(buffer, 0, byteread);
                }
                fs.flush();
                fs.close();
                ((InputStream)inStream).close();
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            throw new RuntimeException(e);
        }
    }

    @POST
    @Transactional
    @Produces(value={"application/json"})
    public String deal(String values) {
        try {
            this.FileName = values;
            this.readfile();
            return "\u6210\u529f";
        }
        catch (Exception e) {
            log.error((Object)("\u5f02\u5e38:" + e.getMessage().toString()));
            return "\u5931\u8d25";
        }
    }
}

