/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.StringHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="archives")
@Component
@Transactional
public class ArchivesCreate {
    static Logger log = Logger.getLogger(ArchivesCreate.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private HibernateTemplate hibernateTemplate;
    @Autowired
    private SessionPool sessionPool;
    public Session assignedSession;

    @POST
    @Produces(value={"application/json"})
    public String Create(String jsonstr) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            String result = "\u63a5\u6536\u6210\u529f";
            JSONObject json = new JSONObject(jsonstr);
            JSONObject objdata = new JSONObject();
            String areaid = json.getString("areaid");
            JSONObject areajson = new JSONObject();
            areajson.put("id", (Object)areaid);
            JSONArray arealist = this.sqlServer.query("import_getAreaMsg", areajson);
            if (arealist.length() != 1) {
                return "\u672a\u627e\u5230\u5c0f\u533a\u4fe1\u606f";
            }
            objdata = arealist.getJSONObject(0);
            long begin = System.currentTimeMillis();
            String man = json.getString("man");
            String op_id = json.getString("op_id");
            String op_spot = json.getString("op_spot");
            String f_subunit = json.getString("f_subunit");
            objdata.put("f_subunit", (Object)f_subunit);
            objdata.put("op_spot", (Object)op_spot);
            objdata.put("man", (Object)man);
            objdata.put("op_id", (Object)op_id);
            Integer building_min = json.getInt("building_min");
            Integer building_max = json.getInt("building_max");
            Integer unit_min = json.getInt("unit_min");
            Integer unit_max = json.getInt("unit_max");
            Integer floor_min = json.getInt("floor_min");
            Integer floor_max = json.getInt("floor_max");
            Integer room_min = json.getInt("room_min");
            Integer room_max = json.getInt("room_max");
            Integer sum = (building_max - building_min + 1) * (unit_max - unit_min + 1) * (floor_max - floor_min + 1) * (room_max - room_min + 1);
            log.error((Object)("\u603b\u5171\u6279\u91cf\u63d2\u5165\u6237\u6570\u662f\uff1a" + sum));
            List<Object> address_seq = this.getSeqList("seq_user_address_id", sum);
            List<Object> userinfo_seq = this.getSeqList("seq_userinfo_id", sum);
            List<Object> userfiles_seq = this.getSeqList("seq_userfiles_id", sum);
            ArrayList cradarry = this.getCardList1(areaid, sum);
            ArrayList<HashMap<String, Object>> addressarry = this.getAddressList(objdata, json, address_seq, userinfo_seq);
            Boolean addressflag = this.InsertData(addressarry, "t_user_address");
            if (!addressflag.booleanValue()) {
                return "\u5730\u5740\u63d2\u5165\u5931\u8d25";
            }
            ArrayList<HashMap<String, Object>> userinfoarry = this.getUserinfoList(objdata, json, address_seq, userinfo_seq, cradarry);
            Boolean userinfoflag = this.InsertData(userinfoarry, "t_userinfo");
            if (!userinfoflag.booleanValue()) {
                return "\u6237\u6863\u6848\u63d2\u5165\u5931\u8d25";
            }
            ArrayList<HashMap<String, Object>> userfilesarry = this.getUserfilesList(objdata, json, address_seq, userinfo_seq, userfiles_seq, cradarry);
            Boolean userfilesflag = this.InsertData(userfilesarry, "t_userfiles");
            if (!userfilesflag.booleanValue()) {
                return "\u8868\u6863\u6848\u6863\u6848\u63d2\u5165\u5931\u8d25";
            }
            long end = System.currentTimeMillis();
            log.debug((Object)("\u603b\u4f53\uff1a" + (end - begin) + "ms"));
            return result;
        }
        catch (Exception e) {
            this.hibernateTemplate.getSessionFactory().getCurrentSession().getTransaction().rollback();
            log.error((Object)("\u6279\u91cf\u63d2\u5165\u4fdd\u5b58" + e.getMessage()));
            return "02|;";
        }
    }

    private Boolean InsertData(ArrayList<HashMap<String, Object>> arry, String tablename) {
        Boolean flag = false;
        int p = 0;
        p = arry.size() % 1000 == 0 ? arry.size() / 1000 : arry.size() / 1000 + 1;
        log.debug((Object)("\u5171" + p + "\u6279"));
        for (int k = 1; k <= p; ++k) {
            HashMap<String, Object> one;
            int l;
            String headstr = "( ";
            String sqlstr = "";
            String valuestr = "";
            HashMap<String, Object> head = arry.get(0);
            for (String key : head.keySet()) {
                headstr = headstr + "" + key + ",";
            }
            headstr = headstr.substring(0, headstr.length() - 1) + ")";
            if (k == p) {
                log.debug((Object)("\u7b2c" + k + "\u6279\u76841000\u6761\u5f00\u59cb"));
                sqlstr = "INSERT INTO " + tablename + " ";
                valuestr = "select ";
                for (l = (k - 1) * 1000; l < arry.size(); ++l) {
                    one = arry.get(l);
                    for (String key : one.keySet()) {
                        if (one.get(key) instanceof Integer) {
                            valuestr = valuestr + "" + one.get(key) + ",";
                            continue;
                        }
                        valuestr = valuestr + "'" + one.get(key) + "',";
                    }
                    valuestr = l == arry.size() - 1 ? valuestr.substring(0, valuestr.length() - 1) + "from dual " : valuestr.substring(0, valuestr.length() - 1) + "from dual union select ";
                }
                this.executeSQL(sqlstr + headstr + "  " + valuestr);
                log.debug((Object)("\u7b2c" + k + "\u6279\u76841000\u6761\u7ed3\u675f"));
                continue;
            }
            log.debug((Object)("\u7b2c" + k + "\u6279\u76841000\u6761\u5f00\u59cb"));
            sqlstr = "INSERT INTO " + tablename + " ";
            valuestr = "select ";
            for (l = (k - 1) * 1000; l < k * 1000; ++l) {
                one = arry.get(l);
                for (String key : one.keySet()) {
                    if (one.get(key) instanceof Integer) {
                        valuestr = valuestr + "" + one.get(key) + ",";
                        continue;
                    }
                    valuestr = valuestr + "'" + one.get(key) + "',";
                }
                valuestr = l == k * 1000 - 1 ? valuestr.substring(0, valuestr.length() - 1) + "from dual " : valuestr.substring(0, valuestr.length() - 1) + "from dual union select ";
            }
            sqlstr = sqlstr + headstr + "  " + valuestr;
            this.executeSQL(sqlstr);
            log.debug((Object)("\u7b2c" + k + "\u6279\u76841000\u6761\u7ed3\u675f"));
        }
        flag = true;
        return flag;
    }

    private ArrayList<HashMap<String, Object>> getAddressList(JSONObject objdata, JSONObject json, List<Object> address_seq, List<Object> userinfo_seq) throws Exception {
        ArrayList<HashMap<String, Object>> addressarry = new ArrayList<HashMap<String, Object>>();
        Integer building_min = json.getInt("building_min");
        Integer building_max = json.getInt("building_max");
        Integer unit_min = json.getInt("unit_min");
        Integer unit_max = json.getInt("unit_max");
        Integer floor_min = json.getInt("floor_min");
        Integer floor_max = json.getInt("floor_max");
        Integer room_min = json.getInt("room_min");
        Integer room_max = json.getInt("room_max");
        int h = 0;
        for (int i = building_min.intValue(); i <= building_max; ++i) {
            for (int j = unit_min.intValue(); j <= unit_max; ++j) {
                for (int m = floor_min.intValue(); m <= floor_max; ++m) {
                    for (int n = room_min.intValue(); n <= room_max; ++n) {
                        HashMap<String, Object> addmap = new HashMap<String, Object>();
                        addmap.put("f_pcd", objdata.get("f_pcd"));
                        addmap.put("op_id", objdata.get("op_id"));
                        addmap.put("op_spot", objdata.get("op_spot"));
                        addmap.put("f_create_person", objdata.get("man"));
                        addmap.put("f_street", objdata.get("f_street"));
                        addmap.put("f_pcd_id", objdata.get("f_pcd_id"));
                        addmap.put("f_street_id", objdata.get("f_street_id"));
                        addmap.put("f_slice_area", objdata.get("f_slice_area"));
                        addmap.put("f_residential_area_id", objdata.get("f_residential_area_id"));
                        addmap.put("f_residential_area", objdata.get("f_residential_area"));
                        addmap.put("oldareaid", objdata.get("oldareaid"));
                        addmap.put("f_building", i);
                        addmap.put("f_unit", j);
                        addmap.put("f_floor", m);
                        addmap.put("f_room", n);
                        addmap.put("f_building_suffix", "\u680b");
                        addmap.put("f_unit_suffix", "\u5355\u5143");
                        addmap.put("f_floor_suffix", "\u5c42");
                        addmap.put("f_room_suffix", "\u5ba4");
                        addmap.put("f_address", objdata.getString("f_pcd") + objdata.getString("f_street") + objdata.getString("f_residential_area") + i + "\u680b" + j + "\u5355\u5143" + m + "\u5c42" + n + "\u5ba4");
                        addmap.put("id", ((HashMap)address_seq.get(h)).get("SEQID"));
                        addmap.put("f_userinfo_id", ((HashMap)userinfo_seq.get(h)).get("SEQID"));
                        addressarry.add(addmap);
                        ++h;
                    }
                }
            }
        }
        return addressarry;
    }

    private ArrayList<HashMap<String, Object>> getUserinfoList(JSONObject objdata, JSONObject json, List<Object> address_seq, List<Object> userinfo_seq, List<Object> cardlist) throws Exception {
        ArrayList<HashMap<String, Object>> userinfoarry = new ArrayList<HashMap<String, Object>>();
        Integer building_min = json.getInt("building_min");
        Integer building_max = json.getInt("building_max");
        Integer unit_min = json.getInt("unit_min");
        Integer unit_max = json.getInt("unit_max");
        Integer floor_min = json.getInt("floor_min");
        Integer floor_max = json.getInt("floor_max");
        Integer room_min = json.getInt("room_min");
        Integer room_max = json.getInt("room_max");
        int h = 0;
        for (int i = building_min.intValue(); i <= building_max; ++i) {
            for (int j = unit_min.intValue(); j <= unit_max; ++j) {
                for (int m = floor_min.intValue(); m <= floor_max; ++m) {
                    for (int n = room_min.intValue(); n <= room_max; ++n) {
                        HashMap<String, Object> addmap = new HashMap<String, Object>();
                        addmap.put("f_subunit", objdata.get("f_subunit"));
                        addmap.put("f_credentials", objdata.get("f_credentials"));
                        addmap.put("op_id", objdata.get("op_id"));
                        addmap.put("op_spot", objdata.get("op_spot"));
                        addmap.put("f_createfile_person", objdata.get("man"));
                        addmap.put("f_operator", objdata.get("man"));
                        addmap.put("f_subunit", objdata.get("f_subunit"));
                        addmap.put("f_subordinate_company", objdata.get("f_residential_area"));
                        addmap.put("f_use_company", objdata.get("f_residential_area"));
                        addmap.put("f_userinfo_code", cardlist.get(h));
                        addmap.put("f_cost_type", objdata.get("f_cost_type"));
                        addmap.put("f_user_state", objdata.get("f_user_state"));
                        addmap.put("f_useraddress_id", ((HashMap)address_seq.get(h)).get("SEQID"));
                        addmap.put("f_userinfo_id", ((HashMap)userinfo_seq.get(h)).get("SEQID"));
                        userinfoarry.add(addmap);
                        ++h;
                    }
                }
            }
        }
        return userinfoarry;
    }

    private ArrayList<HashMap<String, Object>> getUserfilesList(JSONObject objdata, JSONObject json, List<Object> address_seq, List<Object> userinfo_seq, List<Object> userfiles_seq, List<Object> cardlist) throws Exception {
        ArrayList<HashMap<String, Object>> userfilesoarry = new ArrayList<HashMap<String, Object>>();
        Integer building_min = json.getInt("building_min");
        Integer building_max = json.getInt("building_max");
        Integer unit_min = json.getInt("unit_min");
        Integer unit_max = json.getInt("unit_max");
        Integer floor_min = json.getInt("floor_min");
        Integer floor_max = json.getInt("floor_max");
        Integer room_min = json.getInt("room_min");
        Integer room_max = json.getInt("room_max");
        int h = 0;
        for (int i = building_min.intValue(); i <= building_max; ++i) {
            for (int j = unit_min.intValue(); j <= unit_max; ++j) {
                for (int m = floor_min.intValue(); m <= floor_max; ++m) {
                    for (int n = room_min.intValue(); n <= room_max; ++n) {
                        HashMap<String, Object> addmap = new HashMap<String, Object>();
                        addmap.put("f_user_id", ((HashMap)userfiles_seq.get(h)).get("SEQID"));
                        addmap.put("f_userinfo_id", ((HashMap)userinfo_seq.get(h)).get("SEQID"));
                        addmap.put("f_useraddress_id", ((HashMap)address_seq.get(h)).get("SEQID"));
                        addmap.put("f_card_id", cardlist.get(h));
                        addmap.put("op_id", objdata.get("op_id"));
                        addmap.put("op_spot", objdata.get("op_spot"));
                        addmap.put("f_input_person", objdata.get("man"));
                        addmap.put("f_operator", objdata.get("man"));
                        addmap.put("f_subunit", objdata.get("f_subunit"));
                        addmap.put("f_price_id", objdata.getInt("f_price_id"));
                        addmap.put("f_user_type", objdata.getString("f_user_type"));
                        addmap.put("f_gasproperties", objdata.getString("f_gasproperties"));
                        addmap.put("f_whether_hairpin", objdata.getString("f_whether_hairpin"));
                        addmap.put("f_meter_classify", objdata.get("f_meter_classify"));
                        addmap.put("f_gasbrand_id", objdata.getInt("f_gasbrand_id"));
                        addmap.put("f_gasmodel_id", objdata.getInt("f_gasmodel_id"));
                        addmap.put("f_table_state", objdata.get("f_table_state"));
                        addmap.put("alarm", objdata.getInt("alarm"));
                        addmap.put("constant", objdata.get("constant"));
                        addmap.put("is_close", objdata.get("is_close"));
                        addmap.put("is_close_one", objdata.getInt("is_close_one"));
                        addmap.put("is_close_two", objdata.getInt("is_close_two"));
                        addmap.put("is_tablelimit", objdata.getString("is_tablelimit"));
                        addmap.put("is_tablelimit_gas", objdata.getInt("is_tablelimit_gas"));
                        addmap.put("price_type", objdata.getString("price_type"));
                        addmap.put("anjianyear", objdata.getInt("anjianyear"));
                        addmap.put("baofeiyear", objdata.getInt("baofeiyear"));
                        addmap.put("onealarm", objdata.getInt("onealarm"));
                        addmap.put("twoalarm", objdata.getInt("twoalarm"));
                        addmap.put("f_isic", objdata.getString("f_isic"));
                        userfilesoarry.add(addmap);
                        ++h;
                    }
                }
            }
        }
        return userfilesoarry;
    }

    private List<Object> executeSQLData(final String sql) {
        List list = (List)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                SQLQuery query = session.createSQLQuery(sql);
                return query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
            }
        });
        return list;
    }

    private void executeSQL(final String sql) {
        int list = (Integer)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                long begin = System.currentTimeMillis();
                SQLQuery query = session.createSQLQuery(sql);
                int result = query.executeUpdate();
                long end = System.currentTimeMillis();
                log.debug((Object)("\u6267\u884cSQL:{\n" + sql + "\n}\u8017\u65f6\uff1a" + (end - begin) + "ms"));
                return result;
            }
        });
    }

    private List<Object> getSeqList(String seqstr, Integer num) {
        String sql = "select " + seqstr + ".nextval seqid from (select 1 from all_objects where rownum <= " + num + ")";
        List<Object> list = this.executeSQLData(sql);
        return list;
    }

    public ArrayList getCardList1(String key, int num) throws Exception {
        ArrayList<String> arry = new ArrayList<String>();
        BigDecimal card_size = new BigDecimal(0);
        String card_start = "";
        String newcard_start = "";
        String sql = "";
        sql = "select * from t_area where id='" + key + "' for update";
        JSONArray array = this.sqlServer.query(sql);
        if (array.length() > 0) {
            JSONObject json = array.getJSONObject(0);
            card_start = json.getString("card_start");
            card_size = json.getBigDecimal("card_size");
            newcard_start = Integer.parseInt(card_start) + num + "";
            while (newcard_start.length() < 10) {
                newcard_start = "0" + newcard_start;
            }
            json.put("card_start", (Object)newcard_start);
            json.put("card_size", (Object)card_size.subtract(BigDecimal.valueOf(num)));
            JSONObject data = new JSONObject();
            data.put("data", (Object)json);
            this.entityServer.save("t_area", data.toString());
        }
        for (int i = Integer.parseInt(card_start); i < Integer.parseInt(newcard_start); ++i) {
            String cardnum = i + "";
            while (cardnum.length() < 10) {
                cardnum = "0" + cardnum;
            }
            arry.add(cardnum);
        }
        return arry;
    }

    public ArrayList getCardList(String key, int len, int num) throws Exception {
        ArrayList<String> arry = new ArrayList<String>();
        long value = 0L;
        long newvalue = 0L;
        int id = -1;
        String sql = "";
        sql = this.entityServer.findDialect() == "SqlServer" ? "select id, f_key, f_value from t_sequence with(updlock,rowlock) where f_key='" + key + "'" : "select id, f_key, f_value from t_sequence where f_key='" + key + "' for update";
        JSONArray array = this.sqlServer.query(sql);
        if (array.length() > 0) {
            newvalue = array.getJSONObject(0).getLong("f_value");
            value = array.getJSONObject(0).getLong("f_value");
            id = array.getJSONObject(0).getInt("id");
        }
        newvalue = (long)num + newvalue;
        if (id == -1) {
            this.entityServer.save("t_sequence", "{data: {f_key: '" + key + "', f_value: " + newvalue + "}}");
        } else {
            this.entityServer.save("t_sequence", "{data: {id: " + id + ", f_key: '" + key + "', f_value: " + newvalue + "}}");
        }
        int i = (int)value;
        while ((long)i <= newvalue) {
            String result = i + "";
            int resultLen = result.length();
            if (len != 0 && resultLen < len) {
                result = key + StringHelper.repeate((char)'0', (int)(len - resultLen)) + result;
            }
            arry.add(result);
            ++i;
        }
        return arry;
    }
}

