/*
 * Decompiled with CFR 0.152.
 */
package com.aote.helper;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class BSCalendar {
    private Calendar calendar = null;

    public BSCalendar(String time, String format) {
        time = this.clear(time);
        format = this.clear(format);
        int index = format.indexOf("yyyy");
        int year = 0;
        if (index != -1) {
            year = Integer.parseInt(time.substring(index, index + 4));
        }
        index = format.indexOf("mm");
        int month = 0;
        if (index != -1) {
            month = Integer.parseInt(time.substring(index, index + 2));
        }
        index = format.indexOf("dd");
        int dd = 0;
        if (index != -1) {
            dd = Integer.parseInt(time.substring(index, index + 2));
        }
        index = format.indexOf("hh");
        int hour = 0;
        if (index != -1) {
            hour = Integer.parseInt(time.substring(index, index + 2));
        }
        index = format.indexOf("tt");
        int minutes = 0;
        if (index != -1) {
            minutes = Integer.parseInt(time.substring(index, index + 2));
        }
        index = format.indexOf("ss");
        int second = 0;
        if (index != -1) {
            second = Integer.parseInt(time.substring(index, index + 2));
        }
        this.calendar = new GregorianCalendar(year, month, dd, hour, minutes, second);
    }

    private String clear(String format) {
        if (format.indexOf("-") != -1) {
            format = format.replaceAll("-", "");
        }
        if (format.indexOf(" ") != -1) {
            format = format.replaceAll(" ", "");
        }
        if (format.indexOf(":") != -1) {
            format = format.replaceAll(":", "");
        }
        return format;
    }

    public BSCalendar(String format) {
        int year = Integer.parseInt(format.substring(0, 4));
        int month = Integer.parseInt(format.substring(4, 6)) - 1;
        int day = 1;
        try {
            day = Integer.parseInt(format.substring(6, 8));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.calendar = new GregorianCalendar(year, month, day);
    }

    public Object clone() {
        BSCalendar result = new BSCalendar();
        result.calendar = (Calendar)this.calendar.clone();
        return result;
    }

    private BSCalendar() {
    }

    public static BSCalendar now() {
        return new BSCalendar(GregorianCalendar.getInstance());
    }

    public static BSCalendar nowMonth() {
        String nowmonth = new BSCalendar(GregorianCalendar.getInstance()).toString().substring(0, 6);
        return new BSCalendar(nowmonth);
    }

    private BSCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public void setYear(int year) {
        this.calendar.set(year, this.getMonth() - 1, this.getDay());
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public void setMonth(int month) {
        this.calendar.set(this.getYear(), month - 1, this.getDay());
    }

    public void setDay(int day) {
        this.calendar.set(this.getYear(), this.getMonth() - 1, day);
    }

    public void setHour(int hour) {
        this.calendar.set(this.getYear(), this.getMonth() - 1, this.getDay(), hour, this.getMinute());
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public void setMinute(int minute) {
        this.calendar.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getHour(), minute);
    }

    public int getMonthDispersion(BSCalendar other) {
        int month1 = this.getYear() * 12 + this.getMonth();
        int month2 = other.getYear() * 12 + other.getMonth();
        return month1 - month2;
    }

    public int getYearDispersion(BSCalendar other) {
        return this.getYear() - other.getYear();
    }

    public int getDayDispersion(BSCalendar other) {
        long time1 = this.getTime();
        int day1 = (int)(time1 / 86400000L);
        long time2 = other.getTime();
        int day2 = (int)(time2 / 86400000L);
        return day1 - day2;
    }

    public long getTime() {
        return this.calendar.getTimeInMillis();
    }

    public BSCalendar getCalendarAfterDay(int day) {
        BSCalendar result = (BSCalendar)this.clone();
        result.calendar.add(5, day);
        return result;
    }

    public BSCalendar getCalendarAfterMonth(int month) {
        BSCalendar result = (BSCalendar)this.clone();
        result.calendar.add(2, month);
        return result;
    }

    public BSCalendar getCalendarAfterYear(int year) {
        BSCalendar result = (BSCalendar)this.clone();
        result.calendar.add(1, year);
        return result;
    }

    public String toString() {
        int year = this.calendar.get(1);
        int month = this.calendar.get(2) + 1;
        int day = this.calendar.get(5);
        String strMonth = Integer.toString(month + 100);
        String strDay = Integer.toString(day + 100);
        String result = Integer.toString(year) + strMonth.substring(1) + strDay.substring(1);
        return result;
    }

    public String toString(String format) {
        String result = null;
        format = format.toUpperCase();
        int year = this.calendar.get(1);
        int month = this.calendar.get(2) + 1;
        int day = this.calendar.get(5);
        int weekday = this.calendar.get(7) - 1;
        int hour = this.getHour();
        int minute = this.getMinute();
        int second = this.getSceond();
        format = this.getYearInFormat(format, year);
        format = this.getMonthInFormat(format, month);
        format = this.getDayInFormat(format, day);
        format = this.getHourInFormat(format, hour);
        format = this.getMinuteInFormat(format, minute);
        format = this.getSecondInFormat(format, second);
        result = this.getWeekDayInFormat(format, weekday);
        return result;
    }

    private String getYearInFormat(String format, int year) {
        String result = null;
        String longyear = Integer.toString(year);
        format = format.replaceAll("YYYY", longyear);
        String shortyear = longyear.substring(2);
        result = format.replaceAll("YY", shortyear);
        return result;
    }

    private String getMonthInFormat(String format, int month) {
        String result = null;
        String longMonth = Integer.toString(100 + month);
        longMonth = longMonth.substring(1);
        format = format.replaceAll("MM", longMonth);
        result = format.replaceAll("M", Integer.toString(month));
        return result;
    }

    private String getDayInFormat(String format, int day) {
        String result = null;
        String longday = Integer.toString(100 + day);
        longday = longday.substring(1);
        format = format.replaceAll("DD", longday);
        result = format.replaceAll("D", Integer.toString(day));
        return result;
    }

    private String getWeekDayInFormat(String format, int weekday) {
        String result = null;
        format = format.replaceAll("CW", this.getChinaDayOfWeek(weekday));
        result = format.replaceAll("EW", this.getEnglishDayOfWeek(weekday));
        return result;
    }

    private String getHourInFormat(String format, int hour) {
        String result = null;
        String longday = Integer.toString(100 + hour);
        longday = longday.substring(1);
        format = format.replaceAll("HH", longday);
        result = format.replaceAll("H", Integer.toString(hour));
        return result;
    }

    private String getMinuteInFormat(String format, int minute) {
        String result = null;
        String longday = Integer.toString(100 + minute);
        longday = longday.substring(1);
        format = format.replaceAll("TT", longday);
        result = format.replaceAll("T", Integer.toString(minute));
        return result;
    }

    private String getSecondInFormat(String format, int second) {
        String result = "";
        String longday = Integer.toString(100 + second);
        longday = longday.substring(1);
        format = format.replaceAll("SS", longday);
        result = format.replaceAll("S", Integer.toString(second));
        return result;
    }

    public int getSceond() {
        return this.calendar.get(13);
    }

    public String getChinaDayOfWeek(int myweekday) {
        String weekday = null;
        if (myweekday == 0) {
            weekday = " \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ";
        } else if (myweekday == 1) {
            weekday = " \ufffd\ufffd\ufffd\ufffd\u04bb ";
        } else if (myweekday == 2) {
            weekday = " \ufffd\ufffd\ufffd\u06b6\ufffd ";
        } else if (myweekday == 3) {
            weekday = " \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ";
        } else if (myweekday == 4) {
            weekday = " \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ";
        } else if (myweekday == 5) {
            weekday = " \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ";
        } else if (myweekday == 6) {
            weekday = " \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ";
        }
        return weekday;
    }

    public String getEnglishDayOfWeek(int myweekday) {
        String weekday = null;
        if (myweekday == 0) {
            weekday = " Sunday ";
        } else if (myweekday == 1) {
            weekday = " Monday ";
        } else if (myweekday == 2) {
            weekday = " Tuesday ";
        } else if (myweekday == 3) {
            weekday = " Wednesday ";
        } else if (myweekday == 4) {
            weekday = " Thursday ";
        } else if (myweekday == 5) {
            weekday = " Friday ";
        } else if (myweekday == 6) {
            weekday = " Saturday ";
        }
        return weekday;
    }
}

