package eticket;

import org.json.JSONArray;
import org.json.JSONObject;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class EticketPlugin {

    public String getSerial() {
        LocalDateTime now = LocalDateTime.now();
        return now.format(DateTimeFormatter.ofPattern("yyyyMMddhhmmssSSSS"));
    }

    public JSONArray getBillArr (JSONArray arr) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < arr.length(); i++) {
            JSONObject o = arr.getJSONObject(i);
            JSONObject bill = getBillInfo(o);
            result.put(bill);
        }
        return result;
    }

    // 获取发票所需的单值参数信息
    public JSONObject getBillInfo (JSONObject object) {
        JSONObject result = new JSONObject();

        /**
         * 获取发票非货物信息
         */
        // 售方地址及电话
        result.put("InfoSellerAddressPhone", object.getString("sfdzdh"));
        // 售方开户行及账号
        result.put("InfoSellerBankAccount", object.getString("sfyhzh"));
        // 收款人
        result.put("InfoCashier", object.getString("skr"));
        // 复核人
        result.put("InfoChecker", object.getString("fhr"));
        // 发票类型
        result.put("InfoKind", "51");


        // 流水号，一般传操作id
        result.put("SerialNumber", object.getString("fpqqlsh"));

        // 售方纳税人识别号
        result.put("SellTaxCode", object.getString("sfsbh"));
        // 用户名
        result.put("InfoClientName", !object.isNull("ghdwmc") ? object.getString("ghdwmc") : "");
        // 用户税号
        result.put("InfoClientTaxCode",  !object.isNull("ghdwsbh") ? object.getString("ghdwsbh") : "");
        // 用户开户行及账号
        result.put("InfoClientBankAccount",  !object.isNull("ghdwyhzh") ? object.getString("ghdwyhzh") : "");
        // 用户地址电话
        result.put("InfoClientAddressPhone",  !object.isNull("ghdwdzdh") ? object.getString("ghdwdzdh") : "");

        // 操作人
        result.put("InfoInvoicer", object.getString("kpr"));
        // 发票备注
        result.put("InfoNotes", object.has("Notes") ? object.getString("Notes") : "");
        // 发票总金额
        result.put("totalmoney", object.getBigDecimal("totalmoney"));
        // 发票不含税金额
        result.put("taxmoney", object.getBigDecimal("taxmoney"));
        // 发票类型
        result.put("KPLX", "0");

        /**
         * 获取发票货物信息
         */
        JSONArray detail = reCombine(object.getJSONArray("detail"));
        result.put("Details", detail);
        return result;
    }

    /**
     * 重新组织数据
     * @param arr
     * @return
     */
    public JSONArray reCombine (JSONArray arr) {
        JSONArray newArr = new JSONArray();
        for (int i = 0; i < arr.length(); i++) {
            newArr.put(getGoods(arr.getJSONObject(i)));;
        }
        return newArr;
    }
    /**
     * 按发票要求组织数据
     * @param object
     * @return
     */
    public JSONObject getGoods (JSONObject object) {
        JSONObject result = new JSONObject();
        result.put("ListGoodsName", object.getString("spmc"));
        result.put("ListStandard", "");
        result.put("ListPrice", object.getBigDecimal("dj").setScale(2));
        result.put("ListUnit", object.getString("dw"));
        result.put("ListNumber", object.getBigDecimal("spsl").setScale(2));
        result.put("ListPriceKind", "1");
        result.put("InfoTaxRate", object.getBigDecimal("sl").setScale(2));
        return result;
    }
}
