package com.aote.rs;

import java.io.*;
import java.math.BigDecimal;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.helper.FilePath;
import com.aote.logic.LogicServer;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.stereotype.Component;
import com.aote.helper.BSCalendar;
import com.aote.helper.StringHelper;
import org.springframework.transaction.annotation.Transactional;

@Path("XABank")
@Component
@Transactional
/**
 * 西安银行代理收费业务服务
 */
public class XABankService {


    static Logger log = Logger.getLogger(XABankService.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private HibernateTemplate hibernateTemplate;

    // 获取各种实体的属性信息
    @POST
    @Transactional
    @Produces(MediaType.APPLICATION_JSON)
    public String xtSavebusiness(String values) {
        try {
            String result = "";
            // 请求字符串格式: data=01|卡号|网点号|卡类型|卡参数|;
            values = values.replace("%7C", "|");
            values = values.replace("%3B", ";");
            values = values.replace("%3A", ":");
            values = values.replace("+", " ");
            log.info("西银收到请求:" + values);
            // 得到操作标识,进行业务处理
            Iterator iter = this.getDataIter(values);
            double oper = Double.parseDouble((String) iter.next());
            // 查询操作 01|卡号|网点号|验证码|;
            if (oper == 1) {
                log.info("西银查询处理..........................");
                result = query(iter);
                log.info("西银查询返回" + result);
            }
            // 阶梯运算02|卡号|gas(money)|购气量|购气金额;
            else if (oper == 2) {
                log.info("西银阶梯运算...........................");
                result = stairPrice(iter);
                log.info("西银阶梯返回" + result);
            }
            // 售气操作 03|流水号|卡号|气量|金额|日期|网点号|柜员号|起始日期|终止日期|金额|;
            else if (oper == 3) {
                log.info("西银售气处理..........................");
                result = sale(iter);
                log.info("西银售气返回" + result);
            }
            // 冲账操作
            else if (oper == 4) {
                log.info("西银冲账处理..........................");
                result = chongzhang(iter);
                log.info("西银冲账返回" + result);
            }
            // 取密码
            else if (oper == 5) {
                log.info("西银取密码.........................");
                result = encryp(iter);
                log.info("西银取密码返回" + result);
            }
            // 对账操作
            else if (oper == 6) {
                log.info("西银对账处理..........................");
                result = duizhang(iter);
                log.info("西银对账返回" + result);
            }
            String len = String.format("%04d", result.getBytes("gbk").length);
            result = len + result;
            return URLEncoder.encode(result, "UTF-8");
        } catch (Exception e) {
            log.error("西银处理业务出错" + e.getMessage());
            return "000499|;";
        }
    }

    // 得到请求数据迭代
    private Iterator getDataIter(String data) {
        String str = (String) StringHelper.stringToLinkedList(data, '=').get(1);
        Iterator iter = StringHelper.stringToLinkedList(str, '|').iterator();
        return iter;
    }

    /**
     * 执行sql返回数据
     *
     * @param sql
     * @return
     */
    private List<Object> executeSQL(String sql) {
        List<Object> list = (List<Object>) hibernateTemplate
                .execute(new HibernateCallback() {
                    public Object doInHibernate(Session session)
                            throws HibernateException {
                        SQLQuery query = session.createSQLQuery(sql);
                        return (List) query.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).list();
                    }
                });
        return list;
    }


    /**
     * 根据卡号划价
     *
     * @param card_id    卡号
     * @param value      传入气量或者金额
     * @param isGasValue '0/1'  // 0表示气量，1表示金额
     * @return
     */
    private Object callcommonCal(String card_id, BigDecimal value, int isGasValue) throws Exception{
        //初始化准备数据
        JSONObject data = new JSONObject();
        JSONObject model = new JSONObject();
        model.put("f_card_id", card_id);
        data.put("model", model);
        data.put("isGasValue", isGasValue);
        data.put("value", value);
        return logicServer.run("commonCal", data.toString());
    }

    /**
     * 保留小数
     *
     * @param a
     * @param i
     * @return
     */
    private BigDecimal KeepDecimal(BigDecimal a, int i) {
        if (a.scale() > i) {
            return a.setScale(i, BigDecimal.ROUND_HALF_UP);
        } else {
            return a;
        }
    }

    /**
     * 处理气价查询函数
     *
     * @param json
     * @return
     */
    private JSONObject dealprice(JSONObject json) {
        //累计购气量
        JSONObject result = new JSONObject();
        JSONArray chargeprice = json.getJSONArray("chargeprice");
        if (chargeprice.length() == 1) {
            result.put("nowprice", KeepDecimal(chargeprice.getJSONObject(0).getBigDecimal("f_price"), 2));
            result.put("qijia", KeepDecimal(chargeprice.getJSONObject(0).getBigDecimal("f_price_name"), 2));
        } else {
            if (json.getInt("f_surplus1amount") != 0) {
                result.put("nowprice", json.getBigDecimal("f_stair1price"));
            } else if (json.getInt("f_surplus1amount") == 0 && json.getInt("f_surplus2amount") != 0) {
                result.put("nowprice", json.getBigDecimal("f_stair2price"));
            } else {
                result.put("nowprice", json.getBigDecimal("f_stair3price"));
            }
            String qijiamsg = json.getBigDecimal("f_stair1price") + "/"
                    + json.getBigDecimal("f_stair1ceiling") + "/"
                    + json.getBigDecimal("f_stair2price") + "/"
                    + json.getBigDecimal("f_stair2ceiling") + "/"
                    + json.getBigDecimal("f_stair3price");
            result.put("qijia", qijiamsg);
        }
        return result;
    }

    // 查询单价
    private String query(Iterator iter)throws Exception {
        String errorStr = "01|1|民用|2.60|0|0|0|0|;";
        // 卡号,网点号,卡类型,卡参数
        String cardId = (String) iter.next();
        cardId = cardId.trim();
        String port = (String) iter.next();
        port = port.trim();
        String isMoney = (String) iter.next();
        isMoney = isMoney.trim();
        String cardInfo = (String) iter.next();
        cardInfo = cardInfo.trim();
        // 查询站点是否存在
        String portHql = "from t_ic_sellspot where SELLSPOT_ID='" + port + "'";
        List<Object> portlist = (List<Object>) this.hibernateTemplate.find(portHql);
        // 未找到站点
        if (portlist.size() != 1) {
            return errorStr;
        }
        // 查询用户
        String userSql = "SELECT\n" +
                "\tU .f_card_id,\n" +
                "\tsp.F_PRICE_TYPE,\n" +
                "\tsp.F_PRICE_NAME,\n" +
                "\ti.F_USER_NAME,\n" +
                "\ti.f_userinfo_id,\n" +
                "\tU .alarm,\n" +
                "\tU .f_table_state,\n" +
                "\tU .f_user_id,\n" +
                "\tU . CONSTANT,\n" +
                "\tU .f_card_password,\n" +
                "\tU .f_times,\n" +
                "\tdp.f_price PRICE,\n" +
                "\tU .f_jb_table_code,\n" +
                "\tU .pricenew,\n" +
                "\tU .pricemodify,\n" +
                "\tU .pricedate,\n" +
                "\tU .f_price_id,\n" +
                "\tU .f_gasproperties,\n" +
                "\tU .f_initial_base,\n" +
                "\tU .is_close,\n" +
                "\tU .is_close_one,\n" +
                "\tU .is_close_two,\n" +
                "\tU .is_tablelimit,\n" +
                "\tU .is_tablelimit_gas,\n" +
                "\tU .price_type,\n" +
                "\tU .f_whether_hairpin,\n" +
                "\tU .anjianyear,\n" +
                "\tU .baofeiyear,\n" +
                "\tU .onealarm,\n" +
                "\tU .twoalarm,\n" +
                "\tgb.f_meter_brand,\n" +
                "\tsp.F_SPRICE_PROGRAMME JTPLAN,\n" +
                "\tsp.F_SPRICE_CODE JTPLANSTR\n" +
                "FROM\n" +
                "\tt_userfiles U\n" +
                "LEFT JOIN t_userinfo i ON U .f_userinfo_id = i.f_userinfo_id\n" +
                "LEFT JOIN t_gasbrand gb ON U .f_gasbrand_id = gb. ID\n" +
                "LEFT JOIN (\n" +
                "\tSELECT\n" +
                "\t\t*\n" +
                "\tFROM\n" +
                "\t\tT_STAIRPRICE\n" +
                "\tWHERE\n" +
                "\t\tf_state = '有效'\n" +
                ") sp ON U .f_price_id = sp.f_price_id\n" +
                "LEFT JOIN (\n" +
                "\tSELECT\n" +
                "\t\t*\n" +
                "\tFROM\n" +
                "\t\tt_detailprice\n" +
                "\tWHERE\n" +
                "\t\tF_PRICE_NAME = '1'\n" +
                ") dp ON sp. ID = dp.f_stairprice_id\n" +
                "WHERE\n" +
                "\tf_card_id = '"+cardId+"'";
        List<Object> userlist = executeSQL(userSql);
        // 未找到用户
        if (userlist.size() != 1) {
            return errorStr;
        }
        Map<String, Object> userMap = (Map<String, Object>) userlist.get(0);
        String isIssue = (String) userMap.get("F_TABLE_STATE");
        // 用户未启用
        if (!isIssue.equals("正常")) {
            return errorStr;
        }
        // 非民用不允许购气
        String MTN = (String) userMap.get("F_METER_BRAND");
        if (MTN.equals("秦港工业无线") || MTN.equals("秦港工业") || MTN.equals("赛福工业") || MTN.equals("天然气无线")) {
            return errorStr;
        }
        // 限购气量 暂时做限购
        String limitGas = "14900.00";
        // 维管费 暂时不收取维管费
        String wfgStr = "0|0|0|12";
        // 返回数据
        StringBuffer sb = new StringBuffer();
        sb.append("00").append("|");
        // 民用非民用返回的数据不同
        String userName = (String) userMap.get("F_USER_NAME");
        if (userName == null || userName.equals("")) {
            userName = "0";
        }
        sb.append(userName).append("|");
        String userType = (String) userMap.get("F_GASPROPERTIES");
        sb.append(userType).append("|");
        //调用划价业务逻辑
        //得到累购，阶梯等等
        JSONObject pricemsg = this.dealprice((JSONObject) this.callcommonCal(cardId, new BigDecimal(0), 0));
        //处理气价数据
        sb.append(pricemsg.getBigDecimal("nowprice")).append("|");
        //气价名称
        String pricename = userMap.get("F_PRICE_NAME").toString();
        sb.append(pricename);
        //气价详细信息
        sb.append(pricemsg.getString("qijia")).append("|");
        sb.append(limitGas).append("|");
        sb.append(wfgStr).append("|");
        // 保存射频参数
        if ("1".equals(isMoney)) {
            cardInfo = cardInfo.replaceAll("%25", "%");
            cardInfo = cardInfo.replaceAll("%40", "@");
            cardInfo = cardInfo.replaceAll("%0D", "=");
            cardInfo = cardInfo.replaceAll("%0A", ":");
            cardInfo = cardInfo.replaceAll("%00", "0");
            String result = saveRFInfo(cardInfo);
            log.info("射频卡信息存储" + result);
        }
        // 拼接写卡参数
        if ("0".equals(isMoney)) {
            sb.append("0|");
        } else if ("1".equals(isMoney) || "2".equals(isMoney)) {
            String cardParams = queryForRF(userMap, isMoney);
            if (cardParams.equals("01|;")) {
                return errorStr;
            }
            sb.append(cardParams);
        }
        sb.append(";");
        return sb.toString();
    }

    // 射频卡信息存储
    private String saveRFInfo(String values) {
        try {
            String str = values.substring(values.indexOf("=") + 1, values
                    .length());
            if (!str.startsWith("9999") && !str.startsWith("8888")) {
                if (str.indexOf("8888") != -1) {
                    str = "8888|" + str;
                } else {
                    str = "9999|" + str;
                }
            }
            log.info("保存射频卡回读信息:" + str);
            String[] strs = str.split("@");
            String firstStr = strs[0];
            JSONObject sale = null;
            // 两种格式解析
            if (firstStr.startsWith("8888")) {
                sale = this.parseRF8888(strs);
            } else if (firstStr.startsWith("9999")) {
                sale = this.parseRF9999(strs);
            }
            entityServer.partialSave("t_rf_info", sale);
            return "00|;";
        } catch (Exception e) {
            log.error("保存射频卡信息错误" + e.toString());
            return "01|;";
        }
    }

    // 射频回传数据8888解析
    private static JSONObject parseRF8888(String[] strs) {
        String str1 = strs[0];
        Iterator iter = StringHelper.stringToLinkedList(str1, '|').iterator();
        iter.next();
        String priceCopy = "";
        String priceOneCopy = "";
        String gasOneCopy = "";
        String priceTwoCopy = "";
        String gasTwoCopy = "";
        String priceThreeCopy = "";
        String monthTotalCopy = "";
        String newPriceCopy = "";
        String priceModifyDateCopy = "";
        String newPriceOneCopy = "";
        String newGasOneCopy = "";
        String newPriceTwoCopy = "";
        String newGasTwoCopy = "";
        String newPriceThreeCopy = "";

        // 剩余金额 f_zhye
        String zhye = (String) iter.next();
        zhye = zhye.trim();
        // 累计用气量 f_total_gas
        String totalGas = (String) iter.next();
        totalGas = totalGas.trim();
        // 累计购气金额 f_total_gas_account
        String totalGasAccount = (String) iter.next();
        totalGasAccount = totalGasAccount.trim();
        // 购气次数 f_buy_times
        String buyTimes = (String) iter.next();
        buyTimes = buyTimes.trim();
        // 当前气价 f_gas_price
        String gasPrice = (String) iter.next();
        gasPrice = gasPrice.trim();
        // 表时间 f_meter_time
        String meterTime = (String) iter.next();
        meterTime = meterTime.trim();
        // 无用气天数 f_not_use_day
        String notUseDay = (String) iter.next();
        notUseDay = notUseDay.trim();
        // 无用气秒数 f_not_use_second
        String notUseSecond = (String) iter.next();
        notUseSecond = notUseSecond.trim();
        // 防死表功能 f_avoid_dead_meter
        String avoidDeadMeter = (String) iter.next();
        avoidDeadMeter = avoidDeadMeter.trim();
        // 死表天数1 f_dead_meter_day_one
        String deadMeterDayOne = (String) iter.next();
        deadMeterDayOne = deadMeterDayOne.trim();
        // 死表天数2 f_dead_meter_day_two
        String deadMeterDayTwo = (String) iter.next();
        deadMeterDayTwo = deadMeterDayTwo.trim();
        // 限购功能 f_restriction
        String restriction = (String) iter.next();
        restriction = restriction.trim();
        // 限购金额 f_restriction_account
        String restrictionAccount = (String) iter.next();
        restrictionAccount = restrictionAccount.trim();
        // 用户卡号 f_card
        String card = (String) iter.next();
        card = card.trim();
        // 表状态 f_meter_state
        String meterState = (String) iter.next();
        meterState = meterState.trim();
        // 开户标志 f_account_flag
        String accountFlag = (String) iter.next();
        accountFlag = accountFlag.trim();
        // 单价类型 f_price_type
        String priceType = (String) iter.next();
        priceType = priceType.trim();
        double type = Double.parseDouble(priceType);
        if (type == 0) {
            // 单价 f_price
            String price = (String) iter.next();
            price = price.trim();
            priceCopy = price;
        } else {
            // 单价1 f_price_one
            String priceOne = (String) iter.next();
            priceOne = priceOne.trim();
            priceOneCopy = priceOne;
            // 用量1 f_gas_one
            String gasOne = (String) iter.next();
            gasOne = gasOne.trim();
            gasOneCopy = gasOne;
            // 单价2 f_price_two
            String priceTwo = (String) iter.next();
            priceTwo = priceTwo.trim();
            priceTwoCopy = priceTwo;
            // 用量2 f_gas_two
            String gasTwo = (String) iter.next();
            gasTwo = gasTwo.trim();
            gasTwoCopy = gasTwo;
            // 单价3 f_price_three
            String priceThree = (String) iter.next();
            priceThree = priceThree.trim();
            priceThreeCopy = priceThree;
        }
        // 单价修改标志 f_price_modify_flag
        String priceModifyFlag = (String) iter.next();
        priceModifyFlag = priceModifyFlag.trim();
        double type1 = Double.parseDouble(priceModifyFlag);
        if (type == 0 && type1 == 1) {
            // 单价修改日期 f_price_modify_date
            String priceModifyDate = (String) iter.next();
            priceModifyDate = priceModifyDate.trim();
            priceModifyDateCopy = priceModifyDate;
            // 新单价 f_new_price
            String newPrice = (String) iter.next();
            newPrice = newPrice.trim();
            newPriceCopy = newPrice;
        } else if (type == 1 && type1 == 1) {
            // 单价修改日期 f_price_modify_date
            String priceModifyDate = (String) iter.next();
            priceModifyDate = priceModifyDate.trim();
            priceModifyDateCopy = priceModifyDate;
            // 新单价1 f_new_price_one
            String newPriceOne = (String) iter.next();
            newPriceOne = newPriceOne.trim();
            newPriceOneCopy = newPriceOne;
            // 新用量1 f_new_gas_one
            String newGasOne = (String) iter.next();
            newGasOne = newGasOne.trim();
            newGasOneCopy = newGasOne;
            // 新单价2 f_new_price_two
            String newPriceTwo = (String) iter.next();
            newPriceTwo = newPriceTwo.trim();
            newPriceTwoCopy = newPriceTwo;
            // 新用量2 f_new_gas_two
            String newGasTwo = (String) iter.next();
            newGasTwo = newGasTwo.trim();
            newGasTwoCopy = newGasTwo;
            // 新单价3 f_new_price_three
            String newPriceThree = (String) iter.next();
            newPriceThree = newPriceThree.trim();
            newPriceThreeCopy = newPriceThree;
        }
        if (type == 1) {
            // 当前月累计 f_month_total
            String monthTotal = (String) iter.next();
            monthTotal = monthTotal.trim();
            monthTotalCopy = monthTotal;
        }

        // 解析str2
        String str2 = strs[1];
        iter = StringHelper.stringToLinkedList(str2, '|').iterator();
        // 所属月份 f_belong_to_month
        String belongToMonth = (String) iter.next();
        belongToMonth = belongToMonth.trim();
        // 月累计量1 f_month_one
        String monthOne = (String) iter.next();
        monthOne = monthOne.trim();
        // 月累计量2 f_month_two
        String monthTwo = (String) iter.next();
        monthTwo = monthTwo.trim();
        // 月累计量3 f_month_three
        String monthThree = (String) iter.next();
        monthThree = monthThree.trim();
        // 月累计量4 f_month_four
        String monthFour = (String) iter.next();
        monthFour = monthFour.trim();
        // 月累计量5 f_month_five
        String monthFive = (String) iter.next();
        monthFive = monthFive.trim();
        // 月累计量6 f_month_six
        String monthSix = (String) iter.next();
        monthSix = monthSix.trim();
        // 月累计量7 f_month_seven
        String monthSeven = (String) iter.next();
        monthSeven = monthSeven.trim();
        // 月累计量8 f_month_eight
        String monthEight = (String) iter.next();
        monthEight = monthEight.trim();
        // 月累计量9 f_month_nine
        String monthNine = (String) iter.next();
        monthNine = monthNine.trim();
        // 月累计量10 f_month_ten
        String monthTen = (String) iter.next();
        monthTen = monthTen.trim();
        // 月累计量11 f_month_eleven
        String monthEleven = (String) iter.next();
        monthEleven = monthEleven.trim();
        // 月累计量12 f_month_twelve
        String monthTwelve = (String) iter.next();
        monthTwelve = monthTwelve.trim();
        // 月累计量13 f_month_thirteen
        String monthThirteen = (String) iter.next();
        monthThirteen = monthThirteen.trim();
        // 月累计量14 f_month_fourteen
        String monthFourteen = (String) iter.next();
        monthFourteen = monthFourteen.trim();
        // 月累计量15 f_month_fifteen
        String monthFifteen = (String) iter.next();
        monthFifteen = monthFifteen.trim();
        // 月累计量16 f_month_sixteen
        String monthSixteen = (String) iter.next();
        monthSixteen = monthSixteen.trim();
        // 月累计量17 f_month_seventeen
        String monthSeventeen = (String) iter.next();
        monthSeventeen = monthSeventeen.trim();
        // 月累计量18 f_month_eighteen
        String monthEighteen = (String) iter.next();
        monthEighteen = monthEighteen.trim();
        // 月累计量19 f_month_nineteen
        String monthNineteen = (String) iter.next();
        monthNineteen = monthNineteen.trim();
        // 月累计量20 f_month_twenty
        String monthTwenty = (String) iter.next();
        monthTwenty = monthTwenty.trim();
        // 月累计量21 f_month_twenty_one
        String monthTwentyOne = (String) iter.next();
        monthTwentyOne = monthTwentyOne.trim();
        // 月累计量22 f_month_twenty_two
        String monthTwentyTwo = (String) iter.next();
        monthTwentyTwo = monthTwentyTwo.trim();
        // 月累计量23 f_month_twenty_three
        String monthTwentyThree = (String) iter.next();
        monthTwentyThree = monthTwentyThree.trim();
        // 月累计量24 f_month_twenty_four
        String monthTwentyFour = (String) iter.next();
        monthTwentyFour = monthTwentyFour.trim();

        JSONObject sale = new JSONObject();
        sale.put("f_zhye", zhye);
        sale.put("f_total_gas", totalGas);
        sale.put("f_total_gas_account", totalGasAccount);
        sale.put("f_buy_times", buyTimes);
        sale.put("f_gas_price", gasPrice);
        sale.put("f_meter_time", meterTime);
        sale.put("f_not_use_day", notUseDay);
        sale.put("f_not_use_second", notUseSecond);
        sale.put("f_avoid_dead_meter", avoidDeadMeter);
        sale.put("f_dead_meter_day_one", deadMeterDayOne);
        sale.put("f_dead_meter_day_two", deadMeterDayTwo);
        sale.put("f_restriction", restriction);
        sale.put("f_restriction_account", restrictionAccount);
        sale.put("f_card", card);
        sale.put("f_meter_state", meterState);
        sale.put("f_account_flag", accountFlag);
        sale.put("f_price_type", priceType);
        sale.put("f_price", priceCopy);
        sale.put("f_price_one", priceOneCopy);
        sale.put("f_gas_one", gasOneCopy);
        sale.put("f_price_two", priceTwoCopy);
        sale.put("f_gas_two", gasTwoCopy);
        sale.put("f_price_three", priceThreeCopy);
        sale.put("f_price_modify_flag", priceModifyFlag);
        sale.put("f_price_modify_date", priceModifyDateCopy);
        sale.put("f_new_price", newPriceCopy);
        sale.put("f_new_price_one", newPriceOneCopy);
        sale.put("f_new_gas_one", newGasOneCopy);
        sale.put("f_new_price_two", newPriceTwoCopy);
        sale.put("f_new_gas_two", newGasTwoCopy);
        sale.put("f_new_price_three", newPriceThreeCopy);
        sale.put("f_month_total", monthTotalCopy);
        sale.put("f_belong_to_month", belongToMonth);
        sale.put("f_month_one", monthOne);
        sale.put("f_month_two", monthTwo);
        sale.put("f_month_three", monthThree);
        sale.put("f_month_four", monthFour);
        sale.put("f_month_five", monthFive);
        sale.put("f_month_six", monthSix);
        sale.put("f_month_seven", monthSeven);
        sale.put("f_month_eight", monthEight);
        sale.put("f_month_nine", monthNine);
        sale.put("f_month_ten", monthTen);
        sale.put("f_month_eleven", monthEleven);
        sale.put("f_month_twelve", monthTwelve);
        sale.put("f_month_thirteen", monthThirteen);
        sale.put("f_month_fourteen", monthFourteen);
        sale.put("f_month_fifteen", monthFifteen);
        sale.put("f_month_sixteen", monthSixteen);
        sale.put("f_month_seventeen", monthSeventeen);
        sale.put("f_month_eighteen", monthEighteen);
        sale.put("f_month_nineteen", monthNineteen);
        sale.put("f_month_twenty", monthTwenty);
        sale.put("f_month_twenty_one", monthTwentyOne);
        sale.put("f_month_twenty_two", monthTwentyTwo);
        sale.put("f_month_twenty_three", monthTwentyThree);
        sale.put("f_month_twenty_four", monthTwentyFour);
        return sale;
    }

    // 射频回传数据9999解析
    private JSONObject parseRF9999(String[] strs) {
        String str1 = strs[0];
        String[] allStr1s = str1.split("\\|");
        Iterator iter = StringHelper.stringToLinkedList(str1, '|').iterator();
        iter.next();
        JSONObject sale = new JSONObject();
        iter.next();
        // 剩余金额 f_zhye
        String zhye = (String) iter.next();
        zhye = zhye.trim();
        // 累计用气量 f_total_gas
        String totalGas = (String) iter.next();
        totalGas = totalGas.trim();

        // 累计购气金额 f_total_gas_account
        String totalGasAccount = (String) iter.next();
        totalGasAccount = totalGasAccount.trim();
        // 购气次数 f_buy_times
        String buyTimes = (String) iter.next();
        buyTimes = buyTimes.trim();
        // 当前气价 f_gas_price
        String gasPrice = (String) iter.next();
        gasPrice = gasPrice.trim();
        // 表时间 f_meter_time
        String meterTime = (String) iter.next();
        meterTime = meterTime.trim();
        // 无用气天数 f_not_use_day
        String notUseDay = (String) iter.next();
        notUseDay = notUseDay.trim();
        // 无用气秒数 f_not_use_second
        String notUseSecond = (String) iter.next();
        notUseSecond = notUseSecond.trim();
        // 防死表功能 f_avoid_dead_meter
        String avoidDeadMeter = (String) iter.next();
        avoidDeadMeter = avoidDeadMeter.trim();
        String deadMeterDayOne = "";
        String deadMeterDayTwo = "";
        // 死表天数1 f_dead_meter_day_one
        deadMeterDayOne = (String) iter.next();
        deadMeterDayOne = deadMeterDayOne.trim();
        // 死表天数2 f_dead_meter_day_two
        deadMeterDayTwo = (String) iter.next();
        deadMeterDayTwo = deadMeterDayTwo.trim();
        // 限购功能 f_restriction
        String restriction = (String) iter.next();
        restriction = restriction.trim();
        // 限购金额 f_restriction_account
        String restrictionAccount = (String) iter.next();
        restrictionAccount = restrictionAccount.trim();
        // 用户卡号 f_card
        String card = (String) iter.next();
        card = card.trim();
        // 表状态 f_meter_state
        String meterState = (String) iter.next();
        meterState = meterState.trim();
        // 开户标志 f_account_flag
        String accountFlag = (String) iter.next();
        accountFlag = accountFlag.trim();
        // 单价类型 f_price_type
        String priceType = (String) iter.next();
        priceType = priceType.trim();
        double type = Double.parseDouble(priceType);
        // 单价修改标志 f_price_modify_flag
        String priceModifyFlag = (String) iter.next();
        priceModifyFlag = priceModifyFlag.trim();
        double type1 = Double.parseDouble(priceModifyFlag);
        // 单价修改日期(YY-MM-dd HH)
        String priceModifyDate = (String) iter.next();
        priceModifyDate = priceModifyDate.trim();
        sale.put("f_meter_state", meterState);
        sale.put("f_account_flag", accountFlag);
        sale.put("f_price_type", priceType);
        sale.put("f_price_modify_flag", priceModifyFlag);
        sale.put("f_price_modify_date", priceModifyDate);
        String price = "";
        String newprice = "";
        if (type == 0 && type1 == 0) {
            // 单价 f_price
            price = (String) iter.next();
            price = price.trim();
        } else if (type == 0 && type1 == 1) {
            // 单价 f_price
            price = (String) iter.next();
            price = price.trim();
            // 新单价
            newprice = (String) iter.next();
            newprice = newprice.trim();
        } else if (type == 1) {
            // 开始处理启用日期，只要解析字符串中含有-，认为是启用
            int jtQiYongNum = Integer.parseInt(iter.next().toString(), 16);
            for (int i = 1; i <= jtQiYongNum; i++) {
                String str = (String) iter.next();
                sale.put("f_date_" + i, str);
            }

            // 日期启用个数
            int count = Integer.parseInt(iter.next() + "");

            // 单价
            for (int i = 1; i <= count; i++) {
                // 兼容以前的，第一个没有数字名字
                if (i == 1) {
                    sale.put("f_price_one", iter.next());
                    sale.put("f_gas_one", iter.next());
                    sale.put("f_price_two", iter.next());
                    sale.put("f_gas_two", iter.next());
                    sale.put("f_price_three", iter.next());
                    // sale.put("f_gas_three", iter.next());
                    if (type1 == 1) {
                        sale.put("f_new_price_one", iter.next());
                        sale.put("f_new_gas_one", iter.next());
                        sale.put("f_new_price_two", iter.next());
                        sale.put("f_new_gas_two", iter.next());
                        sale.put("f_new_price_three", iter.next());
                        // sale.put("f_new_gas_three", iter.next());
                    }
                } else {
                    sale.put("f_price_one" + i, iter.next());
                    sale.put("f_gas_one" + i, iter.next());
                    sale.put("f_price_two" + i, iter.next());
                    sale.put("f_gas_two" + i, iter.next());
                    sale.put("f_price_three" + i, iter.next());
                    // sale.put("f_gas_three"+i, iter.next());

                    if (type1 == 1) {
                        sale.put("f_new_price_one" + i, iter.next());
                        sale.put("f_new_gas_one" + i, iter.next());
                        sale.put("f_new_price_two" + i, iter.next());
                        sale.put("f_new_gas_two" + i, iter.next());
                        sale.put("f_new_price_three" + i, iter.next());
                        // sale.put("f_new_gas_three"+i, iter.next());
                    }
                }
            }
            // 当前月累计
            sale.put("f_month_total", iter.next());
        }

        // 解析str2
        String str2 = strs[1];
        iter = StringHelper.stringToLinkedList(str2, '|').iterator();
        // 所属月份 f_belong_to_month
        String belongToMonth = (String) iter.next();
        belongToMonth = belongToMonth.trim();
        // 月累计量1 f_month_one
        String monthOne = (String) iter.next();
        monthOne = monthOne.trim();
        // 月累计量2 f_month_two
        String monthTwo = (String) iter.next();
        monthTwo = monthTwo.trim();
        // 月累计量3 f_month_three
        String monthThree = (String) iter.next();
        monthThree = monthThree.trim();
        // 月累计量4 f_month_four
        String monthFour = (String) iter.next();
        monthFour = monthFour.trim();
        // 月累计量5 f_month_five
        String monthFive = (String) iter.next();
        monthFive = monthFive.trim();
        // 月累计量6 f_month_six
        String monthSix = (String) iter.next();
        monthSix = monthSix.trim();
        // 月累计量7 f_month_seven
        String monthSeven = (String) iter.next();
        monthSeven = monthSeven.trim();
        // 月累计量8 f_month_eight
        String monthEight = (String) iter.next();
        monthEight = monthEight.trim();
        // 月累计量9 f_month_nine
        String monthNine = (String) iter.next();
        monthNine = monthNine.trim();
        // 月累计量10 f_month_ten
        String monthTen = (String) iter.next();
        monthTen = monthTen.trim();
        // 月累计量11 f_month_eleven
        String monthEleven = (String) iter.next();
        monthEleven = monthEleven.trim();
        // 月累计量12 f_month_twelve
        String monthTwelve = (String) iter.next();
        monthTwelve = monthTwelve.trim();
        // 月累计量13 f_month_thirteen
        String monthThirteen = (String) iter.next();
        monthThirteen = monthThirteen.trim();
        // 月累计量14 f_month_fourteen
        String monthFourteen = (String) iter.next();
        monthFourteen = monthFourteen.trim();
        // 月累计量15 f_month_fifteen
        String monthFifteen = (String) iter.next();
        monthFifteen = monthFifteen.trim();
        // 月累计量16 f_month_sixteen
        String monthSixteen = (String) iter.next();
        monthSixteen = monthSixteen.trim();
        // 月累计量17 f_month_seventeen
        String monthSeventeen = (String) iter.next();
        monthSeventeen = monthSeventeen.trim();
        // 月累计量18 f_month_eighteen
        String monthEighteen = (String) iter.next();
        monthEighteen = monthEighteen.trim();
        // 月累计量19 f_month_nineteen
        String monthNineteen = (String) iter.next();
        monthNineteen = monthNineteen.trim();
        // 月累计量20 f_month_twenty
        String monthTwenty = (String) iter.next();
        monthTwenty = monthTwenty.trim();
        // 月累计量21 f_month_twenty_one
        String monthTwentyOne = (String) iter.next();
        monthTwentyOne = monthTwentyOne.trim();
        // 月累计量22 f_month_twenty_two
        String monthTwentyTwo = (String) iter.next();
        monthTwentyTwo = monthTwentyTwo.trim();
        // 月累计量23 f_month_twenty_three
        String monthTwentyThree = (String) iter.next();
        monthTwentyThree = monthTwentyThree.trim();
        // 月累计量24 f_month_twenty_four
        String monthTwentyFour = (String) iter.next();
        monthTwentyFour = monthTwentyFour.trim();

        sale.put("f_zhye", zhye);
        sale.put("f_total_gas", totalGas);
        sale.put("f_total_gas_account", totalGasAccount);
        sale.put("f_buy_times", buyTimes);
        sale.put("f_gas_price", gasPrice);
        sale.put("f_meter_time", meterTime);
        sale.put("f_not_use_day", notUseDay);
        sale.put("f_not_use_second", notUseSecond);
        sale.put("f_avoid_dead_meter", avoidDeadMeter);
        sale.put("f_dead_meter_day_one", deadMeterDayOne);
        sale.put("f_dead_meter_day_two", deadMeterDayTwo);
        sale.put("f_restriction", restriction);
        sale.put("f_restriction_account", restrictionAccount);
        sale.put("f_card", card);
        sale.put("f_price", price);
        sale.put("f_new_price", newprice);
        sale.put("f_belong_to_month", belongToMonth);
        sale.put("f_month_one", monthOne);
        sale.put("f_month_two", monthTwo);
        sale.put("f_month_three", monthThree);
        sale.put("f_month_four", monthFour);
        sale.put("f_month_five", monthFive);
        sale.put("f_month_six", monthSix);
        sale.put("f_month_seven", monthSeven);
        sale.put("f_month_eight", monthEight);
        sale.put("f_month_nine", monthNine);
        sale.put("f_month_ten", monthTen);
        sale.put("f_month_eleven", monthEleven);
        sale.put("f_month_twelve", monthTwelve);
        sale.put("f_month_thirteen", monthThirteen);
        sale.put("f_month_fourteen", monthFourteen);
        sale.put("f_month_fifteen", monthFifteen);
        sale.put("f_month_sixteen", monthSixteen);
        sale.put("f_month_seventeen", monthSeventeen);
        sale.put("f_month_eighteen", monthEighteen);
        sale.put("f_month_nineteen", monthNineteen);
        sale.put("f_month_twenty", monthTwenty);
        sale.put("f_month_twenty_one", monthTwentyOne);
        sale.put("f_month_twenty_two", monthTwentyTwo);
        sale.put("f_month_twenty_three", monthTwentyThree);
        sale.put("f_month_twenty_four", monthTwentyFour);
        return sale;
    }

    // 射频卡写卡、冲正参数查询
    private String queryForRF(Map<String, Object> userMap, String isMoney) {
        try {
            String priceModify = "";
            if (userMap.containsKey("PRICEMODIFY")
                    && null != userMap.get("PRICEMODIFY")) {
                priceModify = (String) userMap.get("PRICEMODIFY");
            }
            String priceDate = "";
            if (userMap.containsKey("PRICEDATE")
                    && null != userMap.get("PRICEDATE")) {
                priceDate = userMap.get("PRICEDATE").toString();
            }
            priceDate = priceDate.replace("-", "");
            priceDate = priceDate.replace(" ", "");
            priceDate = priceDate.replace(":", "");
            priceDate = priceDate.replace(".", "");
            if (priceDate.length() < 14) {
                priceDate = priceDate + "000000";
            }
            if (priceDate.length() > 14) {
                priceDate = priceDate.substring(0,14);
            }
            String priceNew = "";
            if (userMap.containsKey("PRICENEW")
                    && null != userMap.get("PRICENEW")) {
                priceNew = userMap.get("PRICENEW").toString();
            }
            String isClose = "";
            if (userMap.containsKey("IS_CLOSE")
                    && null != userMap.get("IS_CLOSE")) {
                isClose = userMap.get("IS_CLOSE").toString();
            }
            isClose = isClose.replace("是", "1");
            isClose = isClose.replace("否", "0");
            String isCloseOne = "";
            if (userMap.containsKey("IS_CLOSE_ONE")
                    && null != userMap.get("IS_CLOSE_ONE")) {
                isCloseOne = userMap.get("IS_CLOSE_ONE").toString();
            }
            String isCloseTwo = "";
            if (userMap.containsKey("IS_CLOSE_TWO")
                    && null != userMap.get("IS_CLOSE_TWO")) {
                isCloseTwo = userMap.get("IS_CLOSE_TWO").toString();
            }
            String isTableLimit = "";
            if (userMap.containsKey("IS_TABLELIMIT")
                    && null != userMap.get("IS_TABLELIMIT")) {
                isTableLimit = (String) userMap.get("IS_TABLELIMIT");
            }
            isTableLimit = isTableLimit.replace("是", "1");
            isTableLimit = isTableLimit.replace("否", "0");
            String isTableLimitGas = "";
            if (userMap.containsKey("IS_TABLELIMIT_GAS")
                    && null != userMap.get("IS_TABLELIMIT_GAS")) {
                isTableLimitGas = userMap.get("IS_TABLELIMIT_GAS").toString();
            }
            String priceType = (String) userMap.get("PRICE_TYPE");
            StringBuilder para = new StringBuilder();
            para.append(priceModify).append("|").append(priceDate).append("|")
                    .append(priceNew).append("|");
            if ("2".equals(isMoney)) {
                return para.toString();
            }
            para.append(isClose).append("|").append(isCloseOne).append("|")
                    .append(isCloseTwo).append("|").append(isTableLimit)
                    .append("|").append(isTableLimitGas).append("|");
            if ("普通单价".equals(priceType)) {
                para.append("0").append("|");
            } else if ("阶梯单价".equals(priceType)) {
                para.append("1").append("|");
                String JTPlan = "";
                if (userMap.containsKey("JTPLAN")
                        && null != userMap.get("JTPLAN")) {
                    JTPlan = (String) userMap.get("JTPLAN");
                }
                String jtplanstr = "";
                if (userMap.containsKey("JTPLANSTR")
                        && null != userMap.get("JTPLANSTR")) {
                    jtplanstr = (String) userMap.get("JTPLANSTR");
                }
                Map<String, Object> jtdateAndCount = getJTPlanDateAndCOunt(JTPlan);
                // 启用个数
                para.append(jtdateAndCount.get("usecount").toString()).append(
                        "|");
                // 启用日期
                para.append(jtdateAndCount.get("usedate").toString()).append(
                        "|");
                // 启动阶梯单价个数
                para.append("4").append("|");
                Map<String, Object> jtprice = this.getJTPrice(jtplanstr);
                para.append(jtprice.get("jtprice1") + "|");
                para.append(jtprice.get("jtprice2") + "|");
                para.append(jtprice.get("jtprice3") + "|");
                para.append(jtprice.get("jtprice4") + "|");
            } else {
                return "01|;";
            }
            return para.toString();
        } catch (Exception e) {
            log.error("射频卡写卡、冲正参数查询出错" + e.getMessage());
            return "01|;";
        }
    }
    // 阶梯方案月份，个数
    private Map<String, Object> getJTPrice(String str) throws Exception {
        Map<String, Object> result = new HashMap<String, Object>();
        String sql="SELECT\n" +
                "\t*\n" +
                "FROM\n" +
                "\t(\n" +
                "\t\tSELECT\n" +
                "\t\t\tJT_CODE,\n" +
                "\t\t\tdbms_lob. SUBSTR (\n" +
                "\t\t\t\twm_concat (\n" +
                "\t\t\t\t\tD .JT_OLD_PRICE_ONE || '|' || D .JT_OLD_GAS_ONE || '|' || D .JT_OLD_PRICE_TWO || '|' || D .JT_OLD_GAS_TWO || '|' || D .JT_OLD_PRICE_THREE || '|' || D .JT_NEW_PRICE_ONE || '|' || D .JT_NEW_GAS_ONE || '|' || D .JT_NEW_PRICE_TWO || '|' || D .JT_NEW_GAS_TWO || '|' || D .JT_NEW_PRICE_THREE\n" +
                "\t\t\t\t)\n" +
                "\t\t\t) AS pricestr,\n" +
                "\t\t\tCOUNT (*) AS c\n" +
                "\t\tFROM\n" +
                "\t\t\tT_IC_JT_TYPE D\n" +
                "\t\tGROUP BY\n" +
                "\t\t\tJT_CODE\n" +
                "\t)\n" +
                "WHERE\n" +
                "\tJT_CODE IN ( "+str+" )";
        List<Object> jtlist = executeSQL(sql);
        String[] arr = str.split(",");
        if(arr.length==4&&jtlist.size()==4){
            Map<String, Object> jtmap= new HashMap<String, Object>();
            for (int i = 0; i < jtlist.size(); i++) {
                Map<String, Object> one=(Map<String, Object>)jtlist.get(i);
                jtmap.put(one.get("JT_CODE").toString(),one.get("PRICESTR"));
            }
            result.put("jtprice1",jtmap.get(arr[0].toString()));
            result.put("jtprice2",jtmap.get(arr[1].toString()));
            result.put("jtprice3",jtmap.get(arr[2].toString()));
            result.put("jtprice4",jtmap.get(arr[3].toString()));
        }
        return result;
    }

    // 阶梯方案月份，个数
    private Map<String, Object> getJTPlanDateAndCOunt(String planName) {
        Map<String, Object> result = new HashMap<String, Object>();
        final String sql = "select usedate_code,  replace( max(a) ,',','|')  as dstr ,count(*) from (select usedate_code, dbms_lob.substr(wm_concat(usedate || '-' ||  JT_CODE)  over(partition BY usedate_code order by usedate))  a  from t_ic_jt_uesdate where usedate_code='"
                + planName + "' )  group by usedate_code";
        List gasSumlist = (List) hibernateTemplate
                .execute(new HibernateCallback() {
                    public Object doInHibernate(Session session)
                            throws HibernateException {
                        return session.createSQLQuery(sql).list();
                    }
                });
        Object[] c = (Object[]) gasSumlist.get(0);
        result.put("usedate", c[1] + "");
        result.put("usecount", c[2] + "");
        return result;
    }



    // 得到维管费
    public String getWGF(Map user) {
        String result = "0|0|0|12";
        // 如果是非民用
        String useClass = (String) user.get("USER_CLASS");
        if (useClass.equals("非民用")) {
            result = "0|0|0|12";
            return result;
        }
        String wgfType = (String) user.get("ISPAY_WGF");
        // 如果字段值为 "是",不处理
        if (wgfType != null && wgfType.equals("否")) {
            result = "0|0|0|12";
            return result;
        }
        // 获取维管费收费标准
        String wgfPrice = (String) user.get("WGFUSERTYPE");
        Date wgflastDate = (Date) user.get("WGFLASTDATE");
        String wgflastDateStr = "";
        if (wgflastDate == null) {
            wgflastDateStr = "2009-04-10";
        } else {
            wgflastDateStr = wgflastDate.toString();
        }

        // 当前日期大于围观费日期，交，否则不需交
        String nowDateStr = BSCalendar.now().toString("yyyy-mm-dd");
        if (nowDateStr.compareTo(wgflastDateStr) > 0) {
            BSCalendar lastDate = BSCalendar.now();
            int year = Integer.parseInt(wgflastDateStr.substring(0, 4));
            int month = Integer.parseInt(wgflastDateStr.substring(5, 7));
            int day = Integer.parseInt(wgflastDateStr.substring(8, 10));
            lastDate.setYear(year);
            lastDate.setMonth(month);
            lastDate.setDay(day);
            BSCalendar nowDate = BSCalendar.now();
            int yearCount = nowDate.getYearDispersion(lastDate);
            String endDateStr = lastDate.getCalendarAfterYear(yearCount)
                    .toString("yyyy-mm-dd");
            if (nowDateStr.compareTo(endDateStr) > 0) {
                yearCount++;
                BSCalendar bEndDaet = lastDate.getCalendarAfterYear(yearCount);
                endDateStr = bEndDaet.toString("yyyy-mm-dd");
                result = wgflastDateStr + "|" + endDateStr + "|" + yearCount
                        + "|" + wgfPrice;
            } else if (nowDateStr.compareTo(endDateStr) <= 0 && yearCount > 0) {
                result = wgflastDateStr + "|" + endDateStr + "|" + yearCount
                        + "|" + wgfPrice;
            } else {
                result = 0 + "|" + 0 + "|" + yearCount + "|" + wgfPrice;
            }
        }
        return result;
    }

    // 阶梯运算
    private String stairPrice(Iterator iter) {
        StringBuilder result = new StringBuilder();
        try {
            //拿到卡号
            String cardid = (String) iter.next();
            cardid = cardid.trim();
            //拿到划价类型
            String type = (String) iter.next();
            //划价类型 0表示气量，1表示金额
            int flag = 0;
            if (type.equals("0")) {
                type = "气量";
                flag = 0;
            }
            if (type.equals("1")) {
                type = "金额";
                flag = 1;
            }
            if (type.equals("2")) {
                type = "金额";
                flag = 1;
            }
            // 查询用户
            String userSql = "SELECT\n" +
                    "\tgb.f_alias\n" +
                    "FROM\n" +
                    "\tt_userfiles U\n" +
                    "LEFT JOIN t_gasbrand gb ON U .f_gasbrand_id = gb. ID\n" +
                    "WHERE\n" +
                    "\tU .F_CARD_ID = '" + cardid + "'";
            List<Object> userlist = executeSQL(userSql);
            Map<String, Object> userMap = (Map<String, Object>) userlist.get(0);
            String gas = (String) iter.next();
            String money = (String) iter.next();
            //初始化划价返回值
            JSONObject pricingobj = new JSONObject();

            if (flag == 0) {
                //气量计算
                pricingobj = (JSONObject) this.callcommonCal(cardid, new BigDecimal(gas), flag);
            } else {
                //金额计算
                pricingobj = (JSONObject) this.callcommonCal(cardid, new BigDecimal(money), flag);
            }
            log.info(pricingobj);
            // 返回结果
            result.append("00").append("|");
            //预留时间插入
            BSCalendar now = BSCalendar.now();
            result.append(now.getYear() + "-01-01").append("|");
            result.append(now.getCalendarAfterYear(1).getYear() + "-01-01").append("|");

            //预留时间插入
            result.append(this.delagasPrice(pricingobj, flag,userMap));
        } catch (Exception e) {
            return "02|;";
        }
        return result.toString();
    }

    /**
     * @param pricingobj
     * @return
     */
    private String delagasPrice(JSONObject pricingobj, int flag,Map<String, Object> user) {
        StringBuilder pricemsg = new StringBuilder();
        // 周期内累购气量
        BigDecimal hisamount = KeepDecimal(pricingobj.getBigDecimal("hisamount"), 2);
        // 本次金额
        BigDecimal nowfee = KeepDecimal(pricingobj.getBigDecimal("nowfee"), 2);
        // 本次气量
        BigDecimal nowamont = KeepDecimal(pricingobj.getBigDecimal("nowamont"), 2);
        // 阶梯1最大可购气量
        BigDecimal f_stair1ceiling = KeepDecimal(pricingobj.getBigDecimal("f_stair1ceiling"), 2);
        // 阶梯2最大可购气量
        BigDecimal f_stair2ceiling = KeepDecimal(pricingobj.getBigDecimal("f_stair2ceiling"), 2);
        //阶梯1剩余购气量
        BigDecimal f_surplus1amount = KeepDecimal(pricingobj.getBigDecimal("f_surplus1amount"), 2);
        //阶梯2剩余购气量
        BigDecimal f_surplus2amount = KeepDecimal(pricingobj.getBigDecimal("f_surplus2amount"), 2);
        //阶梯1本次购气量
        BigDecimal f_stair1amount = KeepDecimal(pricingobj.getBigDecimal("f_stair1amount"), 2);
        //阶梯2本次购气量
        BigDecimal f_stair2amount = KeepDecimal(pricingobj.getBigDecimal("f_stair2amount"), 2);
        //阶梯3本次购气量
        BigDecimal f_stair3amount = KeepDecimal(pricingobj.getBigDecimal("f_stair3amount"), 2);
        //阶梯1本次购气金额
        BigDecimal f_stair1fee = KeepDecimal(pricingobj.getBigDecimal("f_stair1fee"), 2);
        //阶梯2本次购气金额
        BigDecimal f_stair2fee = KeepDecimal(pricingobj.getBigDecimal("f_stair2fee"), 2);
        //阶梯3本次购气金额
        BigDecimal f_stair3fee = KeepDecimal(pricingobj.getBigDecimal("f_stair3fee"), 2);
        //阶梯1气价
        BigDecimal f_stair1price = KeepDecimal(pricingobj.getBigDecimal("f_stair1price"), 2);
        //阶梯2气价
        BigDecimal f_stair2price = KeepDecimal(pricingobj.getBigDecimal("f_stair2price"), 2);
        //阶梯3气价
        BigDecimal f_stair3price = KeepDecimal(pricingobj.getBigDecimal("f_stair3price"), 2);
        //追加|周期内累购气量
        pricemsg.append(hisamount + "").append("|");
        //追加|阶梯1最大可购气量
        pricemsg.append(f_stair1ceiling + "").append("|");
        //追加|阶梯2最大可购气量
        pricemsg.append(f_stair2ceiling + "").append("|");
        //追加|阶梯1已购
        //阶梯1最大可购气量-阶梯1剩余购气量-阶梯1本次购气金额
        BigDecimal f_stair1use = f_stair1ceiling.subtract(f_surplus1amount).subtract(f_stair1amount);
        pricemsg.append(f_stair1use + "").append("|");
        //追加|阶梯2已购
        //阶梯2最大可购气量-阶梯1最大可购气量-阶梯2剩余购气量-阶梯2本次购气金额
        BigDecimal f_stair2use = f_stair2ceiling.subtract(f_stair1ceiling).subtract(f_surplus2amount).subtract(f_stair2amount);
        pricemsg.append(f_stair2use + "").append("|");
        //追加|阶梯3已购
        if (hisamount.compareTo(f_stair2ceiling) < 1) {
            //周期内累购小于阶梯2最大
            //追加|阶梯3已购气量0
            pricemsg.append(new BigDecimal("0")).append("|");
        } else {
            BigDecimal f_stair3use = hisamount.subtract(f_stair2ceiling);
            pricemsg.append(f_stair3use + "").append("|");
        }
        //追加|阶梯1本次气量
        pricemsg.append(f_stair1amount + "").append("|");
        //追加|阶梯2本次气量
        pricemsg.append(f_stair2amount + "").append("|");
        //追加|阶梯3本次气量
        pricemsg.append(f_stair3amount + "").append("|");
        //追加|阶梯1气价
        pricemsg.append(f_stair1price + "").append("|");
        //追加|阶梯2气价
        pricemsg.append(f_stair2price + "").append("|");
        //追加|阶梯3气价
        pricemsg.append(f_stair3price + "").append("|");
        //追加|阶梯1本次金额
        pricemsg.append(f_stair1fee + "").append("|");
        //追加|阶梯2本次金额
        pricemsg.append(f_stair2fee + "").append("|");
        //追加|阶梯3本次金额
        pricemsg.append(f_stair3fee + "").append("|");
        //追加|总气量
        pricemsg.append(nowamont + "").append("|");
        //追加|总金额
        pricemsg.append(nowfee + "").append("|");
        //追加|差额
        if(f_surplus1amount.compareTo(BigDecimal.ZERO)== 0&&((user.get("F_ALIAS").equals("21")||user.get("F_ALIAS").equals("15")))){
            pricemsg.append(f_stair1price.multiply(nowamont)+"").append("|;");
        }else {
            pricemsg.append("0").append("|;");
        }
        return pricemsg.toString();

    }

	/*{"data":{
				"f_card_id":10004405,
				"f_terminal_num":"CA10182102",
				"f_pregas":48.78,
				"f_preamount":100.0,
				"isGasValue":0,
				"f_serial_id":"2019070116123183",
				"f_collection":100.0,
				"f_user_id":1,
	}}*/

    /**
     * 第三方支付卡表收费
     *
     * @param user           表档案
     * @param card_id        卡号
     * @param lsId           流水
     * @param f_pregas       购气量
     * @param f_preamount    购气金额
     * @param f_terminal_num 终端号
     * @return
     */
    private Object callthirdPay(Map<String, Object> user, String card_id, String lsId, BigDecimal f_pregas, BigDecimal f_preamount, String f_terminal_num, String opid,String f_actualamount) throws Exception {
        //先准备获取用户相关信息
        JSONObject data = new JSONObject();
        //表号
        data.put("f_user_id", user.get("f_user_id"));
        //卡号
        data.put("f_card_id", card_id);
        //终端号
        data.put("f_terminal_num", f_terminal_num);
        //柜员号
        data.put("opid", opid);
        //购气量
        data.put("f_pregas", f_pregas);
        //购气金额
        data.put("f_preamount", f_preamount);
        // yuan/fen,如果不传按分处理
        data.put("f_unit", "yuan");
        //流水
        data.put("f_serial_id", lsId);
        //付款金额
        data.put("f_collection", f_preamount);
        //实际金额
        data.put("f_actualamount", f_actualamount);
        // 0,1 （0-按气量, 1-按金额）（划价获取价格明细）
        data.put("isGasValue", 0);
        return logicServer.run("thirdPay", data.toString());
    }
    // 冲账

    // 售气
    private String sale(Iterator iter) {
        try {
            String errorStr = "03|;";
            // 02|流水号|卡号|气量|金额|日期|网点号|柜员号|起始日期|终止日期|维管费金额|;
            String lsId = (String) iter.next();
            lsId = lsId.trim();
            String cardId = (String) iter.next();
            cardId = cardId.trim();
            String gas = (String) iter.next();
            gas = gas.trim();
            String money = (String) iter.next();
            money = money.trim();
            String opDate = (String) iter.next();
            opDate = opDate.trim();
            String port = (String) iter.next();
            port = port.trim();
            String opId = (String) iter.next();
            opId = opId.trim();
            String startDate = (String) iter.next();
            startDate = startDate.trim();
            String endDate = (String) iter.next();
            endDate = endDate.trim();
            String wgfMoney = (String) iter.next();
            wgfMoney = wgfMoney.trim();
            // 阶梯123，单价，气量，金额
            String jt1price = (String) iter.next();
            jt1price = jt1price.trim();
            String jt1gas = (String) iter.next();
            jt1gas = jt1gas.trim();
            String jt1money = (String) iter.next();
            jt1money = jt1money.trim();
            String jt2price = (String) iter.next();
            jt2price = jt2price.trim();
            String jt2gas = (String) iter.next();
            jt2gas = jt2gas.trim();
            String jt2money = (String) iter.next();
            jt2money = jt2money.trim();
            String jt3price = (String) iter.next();
            jt3price = jt3price.trim();
            String jt3gas = (String) iter.next();
            jt3gas = jt3gas.trim();
            String jt3money = (String) iter.next();
            jt3money = jt3money.trim();
            String invermoney = (String) iter.next();
            invermoney = invermoney.trim();
            // 查询用户信息
            String userSql = "from t_userfiles where F_CARD_ID='" + cardId
                    + "'";
            List<Object> userlist = (List<Object>) this.hibernateTemplate.find(userSql);
            // 未找到用户
            if (userlist.size() != 1) {
                return errorStr;
            }
            Map<String, Object> userMap = (Map<String, Object>) userlist.get(0);
            JSONObject selllogic = (JSONObject) this.callthirdPay(userMap, cardId, lsId, new BigDecimal(gas), new BigDecimal(money), port, opId,invermoney);
            log.info("售气成功，售气记录id是:" + selllogic.getString("id"));
            return "00|;";
        } catch (Exception e) {
            log.error("处理售气业务出错" + e.getMessage());
            return "03|;";
        }
    }

    /**
     * 调用第三方冲正业务逻辑
     * @param f_serial_id
     * @return
     * @throws Exception
     */
    private Object callcommonCancel(String f_serial_id,String f_serial_id_new) throws Exception {
        //先准备获取用户相关信息
        JSONObject data = new JSONObject();
        //旧流水号
        data.put("f_serial_id", f_serial_id);
        //新流水号
        data.put("f_serial_id_new", f_serial_id_new);
        return logicServer.run("commonCancel", data.toString());
    }
    // 冲账
    private String chongzhang(Iterator iter) {
        try {
            String errorStr = "04|;";
            // 03|流水号|卡号|气量|金额|日期|网点号|柜员号|起始日期|终止日期|金额|冲账方式|;
            String lsId = (String) iter.next();
            lsId = lsId.trim();
            String cardId = (String) iter.next();
            cardId = cardId.trim();
            String gas = (String) iter.next();
            gas = gas.trim();
            String money = (String) iter.next();
            money = money.trim();
            String opDate = (String) iter.next();
            opDate = opDate.trim();
            String port = (String) iter.next();
            port = port.trim();
            String opId = (String) iter.next();
            opId = opId.trim();
            String startDate = (String) iter.next();
            startDate = startDate.trim();
            String endDate = (String) iter.next();
            endDate = endDate.trim();
            String wgfMoney = (String) iter.next();
            wgfMoney = wgfMoney.trim();
            String chongzhangType = "有卡冲账 ";
            String oldLsid = (String) iter.next();
            oldLsid = oldLsid.trim();
            // 查询用户信息
            String userSql = "from t_userfiles where F_CARD_ID='" + cardId
                    + "'";
            List<Object> userlist = (List<Object>) this.hibernateTemplate.find(userSql);
            // 未找到用户
            if (userlist.size() != 1) {
                return errorStr;
            }
            JSONObject selllogic = (JSONObject) this.callcommonCancel(oldLsid,lsId);
            log.info("冲正成功,");
            return "00|;";
        } catch (Exception e) {
            log.error("处理售气业务出错" + e.getMessage());
            return "04|;";
        }
    }

    // 验证码计算
    private String encryp(Iterator iter) {
        String code = (String) iter.next();
        code = code.trim();
        String password = (String) iter.next();
        password = password.trim();
        try {
            Socket socket = new Socket("192.168.2.59", 5000);
            OutputStream os = socket.getOutputStream();
            String encrypStr = code + "|" + password + "|;";
            os.write(encrypStr.getBytes());
            os.flush();
            byte[] bs = new byte[1000];
            int len = socket.getInputStream().read(bs);
            password = new String(bs, 0, len);
            if (password.equals("55AA")) {
                return "05|;";
            }
            return password;
        } catch (IOException ex) {
            return "05|;";
        }
    }
    // 检查文件是否存在
    public boolean isExist(String FileName) {
        String fPath = FilePath.GetPath("xabankfilepath") + "" + FileName;
        File fr = new File(fPath);
        return fr.exists();
    }
    // 对账
    private String duizhang(Iterator iter) {
        try {
            // 06|文件名
            String fileName = (String) iter.next();
            fileName = fileName.trim();
            if (isExist(fileName)) {
                Thread thread = new sendDataXA();
                ((sendDataXA) thread).setFilepath(fileName);
                thread.start();
                return "00|;";
            } else {
                return "06|未找到名称为" + fileName + "的文件|;";
            }
        } catch (Exception e) {
            log.error("处理对账出错" + e.getMessage());
            return "06|;";
        }
    }
    public class sendDataXA extends Thread{
        public void setFilepath(String name){
            this.filepath=name;
        }
        String filepath;
        public void run() {
            String result=RestTools.post("http://127.0.0.1:5004/rs/XABankDuizhang",filepath);
        }
    }
}
