package com.aote.rs;

import com.aote.helper.FilePath;
import com.aote.helper.NumberHelper;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.io.*;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 接收银行文件处理过程。模仿手工操作，步骤如下： 1. 对账，看银行各项合计是否正确。不正确，抛异常。 2. 产生交费记录，从用户档案里带值到交费记录。
 * 3. 处理抄表记录，选择出要交费的记录。计算合计，最大值，最小值等， 放进交费记录里。 4. 银行总合计金额记为实交金额。根据表达式计算交费记录其它数据。
 * 5. 保存交费记录，回写用户档案，给抄表记录打标记。
 */
@Path("HTDuizhang")
@Component
public class SpaceFlightFileEntity{

	@Autowired
	private LogicServer logicServer;
	@Autowired
	private SqlServer sqlServer;
	@Autowired
	private HibernateTemplate hibernateTemplate;

	private static final Logger log = Logger
			.getLogger(SpaceFlightFileEntity.class);

	public HibernateTemplate getHibernateTemplate() {
		return hibernateTemplate;
	}

	public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}

	/**
	 *
	 */
	private static final long serialVersionUID = -1404439164923599184L;

	private BufferedWriter bw = null;

	public SpaceFlightFileEntity() {

	}

	private String Path;

	public String FileName;

	/*// 检查文件是否存在
	public boolean isExist() {
		String fPath = FilePath.GetPath("spaceflightfilepath") + "" + FileName;
		File fr = new File(fPath);
		System.out.println("航天对账文件"+fPath+"|"+fr.exists());
		return fr.exists();
	}*/

	public void readfile() throws Exception {
		// 如果数据已经导入,提示不要重复导入
		Path = FilePath.GetPath("spaceflightfilepath") + "" + FileName;
		FileReader fr = new FileReader(Path);
		BufferedReader br = new BufferedReader(fr);
		String content = "";
		log.info("开始对账,文件名:" + FileName);
		// 根据内容对系统用户数据进行处理
		while ((content = br.readLine()) != null) {
			try {
				xtSavedisposeData(content);
			} catch (Exception e) {
				log.error(e.getMessage().toString());
				continue;
			}
		}
		if (this.bw != null) {
			this.bw.close();
		}
		if (br != null) {
			br.close();
		}
		if (fr != null) {
			fr.close();
		}
		// 当天没有表示为 已对账的记录需要设置未无效
		SetNotExistFileInvaild(FileName);
		// 移动已对账文件到其他文件夹
		copyFile(Path, FilePath.GetOldFilePath("spaceflightfilepath") + FileName);
		// 删除已对账文件
		delete();
		log.info("对账结束,文件名:" + FileName);
	}

	// 设置对账完成后表示为未结账的西安银行数据为无效
	public void SetNotExistFileInvaild(String fileName) {
		String date = fileName.substring(2, 10);
		//拼接条件
		String con=" F_BANK_NAME='航天代售' "
				+ " and TRUNC (f_operate_date)=to_date('"
				+ date
				+ "','yyyy-mm-dd') and  (f_isduizhang <>'已对账' or f_isduizhang is null)"
				+ " and f_state='有效' ";
		String t_recordsql = "update t_record set f_state='无效' where id in (select id from t_sellinggas where "+con+" )";
		sqlServer.run(t_recordsql);
		String t_chargepricesql = "update t_chargeprice set f_state='无效' where f_charge_id in (select id from t_sellinggas where "+con+" )";
		sqlServer.run(t_chargepricesql);
		String t_sellinggassql = "update t_sellinggas set f_state='无效' where "+con;
		sqlServer.run(t_sellinggassql);
		log.info("更新" + date + "未对账的航天代售数据为无效,sql:" );
	}

	/**
	 * 看数据是否重复导入
	 */
	private boolean isRepeate(String filename) {
		try {
			String sql = "from t_revicebankfile where filename='" + filename
					+ "'";
			List<Object> list = (List<Object>)this.hibernateTemplate.find(sql);
			if (list.size() > 1) {
				return true;
			}
			return false;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 处理一条数据
	 */
	private void xtSavedisposeData(String content) throws Exception {

		log.info("<--------------------------------------->");
		log.info("航天代售记录:" + content);
		String[] str = content.split("\\|");
		try {
			if (str.length == 12 || str.length == 21) {
				log.info("开始对账------");
				// 流水号
				String LSID = str[0].trim();
				// 根据对账流水号然后去数据库找一条(对过账的数据不查找)
				String sql = "from t_sellinggas where f_serial_id='"
						+ LSID
						+ "' and  (f_isduizhang <> '已对账' or f_isduizhang is null)";
				log.info("查找系统收费数据" + sql);
				List<Object> list = (List<Object>)this.hibernateTemplate.find(sql);
				// 利安数据
				Map<String, Object> data = getmap(str);
				// 如果数据库中找不到数据，直接插入文本数据
				if (list.size() != 1) {
					log.info("找到收费数据");
					// 查找是否有已对账记录，如果有,不执行插入
					if (!hasDuiZhang(LSID)) {
						log.info("未找到记录插入航天代售数据:" + content);
						Map<String, Object> sellgas = getSellInfos(data);
						if (sellgas == null) {
							log.info("未找到用户档案无法插入售气数据:" + content);
							return;
						}
						// 插入收费信息
						JSONObject selllogic=(JSONObject)this.callthirdPay(sellgas);
						String yiduizhang = "update t_sellinggas set f_isduizhang='已对账' where f_serial_id='"+LSID+"' and id= '"+selllogic.getString("id")+"'";
						//更新为依据对账
						this.hibernateTemplate.bulkUpdate(yiduizhang);
						// 如果是冲账记录，插入副记录
						String czType = (String) sellgas.get("CHONGZHANGTYPE");
						if (czType != null && czType.indexOf("冲账") != -1) {
							Map<String, Object> fuso = getFuSellInfos(data);
							this.hibernateTemplate.save("T_IC_SELLGAS", fuso);
						}
						// 保存到对账表
						data.put("f_biaoshi", "插入航天代售数据");
						data.put("ldata", content);
						data.put("localdata", "本地无此记录");
						this.hibernateTemplate.save("t_ic_checking", data);
					}
				} else {
					// 对比数据
					HashMap localht = (HashMap) list.get(0);
					// 按西安银行格式整理数据
					String laformatdata = dataFromatla(localht);
					// 数据备份
					HashMap savenewHt = new HashMap();
					savenewHt.putAll(localht);
					StringBuilder differStr = new StringBuilder();
					boolean f = dui(str, localht, savenewHt, differStr);
					// 对账不一致
					if (!f) {
						log.info("记录不一致:");
						log.info("航天代售数据:" + content);
						log.info("本地数据:" + laformatdata);
						// 保存数据库信息到对账表
						data.put("f_biaoshi", "数据不一致");
						data.put("ladata", content);
						data.put("localdata", laformatdata);
						data.put("diffs", differStr.toString());
						this.hibernateTemplate.save("t_ic_checking", data);
						// 然后更新数据库中记录为文本记录，数据库数据加入是否对过账标记，
						// 更新购气记录
						savenewHt.put("f_isduizhang", "已对账");
						this.hibernateTemplate.saveOrUpdate("t_sellinggas",
								savenewHt);
					} else {
						log.info("记录相同:" + content);
						localht.put("f_isduizhang", "已对账");
						this.hibernateTemplate.saveOrUpdate("t_sellinggas",
								localht);
					}
				}
			}
		} catch (Exception e) {
			log.error("核对航天代售数据报错" + e.getMessage());
		}
	}
	/**
	 * 第三方支付卡表收费
	 * @param user 表档案
	 * @return
	 */
	private Object callthirdPay(Map<String, Object> user) throws  Exception{
		//先准备获取用户相关信息
		JSONObject data=new JSONObject();
		//表号
		data.put("f_user_id",user.get("f_user_id"));
		//卡号
		data.put("f_card_id",user.get("CARD_ID"));
		//终端号
		data.put("f_terminal_num",user.get("OP_SPOT"));
		//柜员号
		data.put("opid",user.get("OP_ID"));
		// yuan/fen,如果不传按分处理
		data.put("f_unit","yuan");
		//购气金额
		data.put("f_preamount",new BigDecimal(user.get("MONEY").toString()));
		//流水
		data.put("f_serial_id",user.get("LSID"));
		//付款金额
		data.put("f_collection",new BigDecimal(user.get("MONEY").toString()));
		//购气量
		data.put("f_pregas", new BigDecimal(user.get("SELLGAS_GAS").toString()));
		// 0,1 （0-按气量, 1-按金额）（划价获取价格明细）
		data.put("isGasValue",0);
		return logicServer.run("thirdPay", data.toString());

	}

	// 将本地售气数据组织为西安银行格式
	public String dataFromatla(Map localht) {
		String lsid = (String) localht.get("F_SERIAL_ID");
		String cardId = (String) localht.get("F_CARD_ID");
		String gas = localht.get("F_PREGAS").toString();
		String money = localht.get("F_COLLECTION").toString();
		Date d = (Date)localht.get("F_OPERATE_DATE");

		String op_spot = (String) localht.get("F_TERMINAL_NUM");
		String op_id = (String) localht.get("F_OPERATOR");
		String chongzhangtype = (String) localht.get("F_STATE");
		String write_card = (String) localht.get("F_WRITE_CARD");
		if (chongzhangtype == null || chongzhangtype.equals("有效")) {
			chongzhangtype = "0";
		} else if (chongzhangtype.equals("无卡冲账")&&write_card != null) {
			chongzhangtype = "1";
		} else if (chongzhangtype.equals("有卡冲账")&&write_card == null) {
			chongzhangtype = "2";
		}
		String wgfStartDate = "0";
		String wgfEndDate = "0";
		String wgfMoney = "0";
		StringBuilder sb = new StringBuilder();
		sb.append(lsid).append("|");
		sb.append(cardId).append("|");
		sb.append(gas).append("|");
		sb.append(money).append("|");
		sb.append(d).append("|");
		sb.append(op_spot).append("|");
		sb.append(op_id).append("|");
		sb.append(chongzhangtype).append("|");
		sb.append(wgfStartDate).append("|");
		sb.append(wgfEndDate).append("|");
		sb.append(wgfMoney).append("|");
		return sb.toString();
	}

	// 将本地售气数据组织为西安银行格式
	public String dataWGFFromatla(Map localht) {
		String lsid = (String) localht.get("LSID");
		String cardId = (String) localht.get("CARD_ID");
		String money = localht.get("MONEY").toString();

		Date opdate = (Date) localht.get("OPERATE_DATE");
		Date optime = (Date) localht.get("OPERATE_TIME");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String operate_date = sdf.format(opdate);
		String operate_time = sdf.format(optime);
		String d = operate_date.substring(0, 10) + " "
				+ operate_time.substring(11, operate_time.length());

		String op_spot = (String) localht.get("OP_SPOT");
		String op_id = (String) localht.get("OP_ID");
		String chongzhangtype = (String) localht.get("CHONGZHANGTYPE");
		if (chongzhangtype == null || chongzhangtype.equals("成功")) {
			chongzhangtype = "0";
		} else if (chongzhangtype.equals("无卡冲账")) {
			chongzhangtype = "1";
		} else if (chongzhangtype.equals("有卡冲账")) {
			chongzhangtype = "2";
		}
		SimpleDateFormat ddf1 = new SimpleDateFormat("yyyy-MM-dd");

		Date wgfStartDate = (Date) localht.get("STARTDATE");
		String startStr = ddf1.format(wgfStartDate);
		Date wgfEndDate = (Date) localht.get("ENDDATE");
		String endStr = ddf1.format(wgfEndDate);
		double wgfMoney = Double.parseDouble(localht.get("MONEY").toString());
		StringBuilder sb = new StringBuilder();
		sb.append(lsid).append("|");
		sb.append(cardId).append("|");
		sb.append(money).append("|");
		sb.append(d).append("|");
		sb.append(op_spot).append("|");
		sb.append(op_id).append("|");
		sb.append(chongzhangtype).append("|");
		sb.append(startStr).append("|");
		sb.append(endStr).append("|");
		sb.append(wgfMoney + "").append("|");
		return sb.toString();
	}

	public boolean hasDuiZhang(String lsid) {
		String sql = "from t_sellinggas where f_serial_id='" + lsid
				+ "' and  f_isduizhang = '已对账'";
		List<Object> list = (List<Object>)this.hibernateTemplate.find(sql);
		if (list.size() >= 1) {
			return true;
		} else {
			return false;
		}

	}

	public boolean hasWgfDuiZhang(String lsid) {
		String sql = "from T_IC_MYWGF where LSID='" + lsid
				+ "' and  f_isduizhang = '已对账'";
		List<Object> list = (List<Object>)this.hibernateTemplate.find(sql);
		if (list.size() >= 1) {
			return true;
		} else {
			return false;
		}

	}

	// 组织售气记录
	public Map<String, Object> getSellInfos(Map data) {
		String cardId = (String) data.get("CARD_ID");
		// 查询用户信息
		String userSql = "from t_userfiles where F_CARD_ID='" + cardId + "'";
		List<Object> userlist = (List<Object>)this.hibernateTemplate.find(userSql);
		// 未找到用户
		if (userlist.size() != 1) {
			return null;
		}
		Map<String, Object> userMap = (Map<String, Object>) userlist.get(0);
		Map<String, Object> sale = new HashMap<String, Object>();
		sale.put("LSID", data.get("LSID"));
		sale.put("CARD_ID", data.get("CARD_ID"));
		sale.put("OP_DATE", data.get("OPERATE_DATE"));
		sale.put("OP_TIME", data.get("OPERATE_DATE"));
		sale.put("OPERATE_DATE", data.get("OPERATE_DATE"));
		sale.put("OPERATE_TIME", data.get("OPERATE_DATE"));
		sale.put("SELLGAS_GAS", data.get("SELLGAS_GAS"));
		sale.put("MONEY", data.get("MONEY"));
		sale.put("OP_ID", data.get("OP_ID"));
		sale.put("OP_SPOT", data.get("OP_SPOT"));
		sale.put("CHONGZHANGTYPE", data.get("f_success"));
		sale.put("COME", "航天代售");
		sale.put("COME_DEP", "自助设备");
		sale.put("SUBUNIT", userMap.get("SUBUNIT"));
		sale.put("USER_NATURE", userMap.get("USER_NATURE"));
		sale.put("USER_TYPE", userMap.get("USER_TYPE"));
		sale.put("USER_EQUIPMENT", userMap.get("USER_EQUIPMENT"));
		sale.put("PRICE", userMap.get("PRICE"));
		sale.put("METER_TYPES_NAME", userMap.get("METER_TYPES_NAME"));
		sale.put("DATA_VAILD", "是");
		sale.put("IS_BILL", "是");
		String meterTypes = (String) userMap.get("METER_TYPES_ID");
		if (meterTypes != null
				&& (meterTypes.equals("15") || meterTypes.equals("16"))) {
			sale.put("measure_way", "金额");
		} else {
			sale.put("measure_way", "气量");
		}
		sale.put("f_isduizhang", "已对账");
		return sale;
	}

	// 组织负售气记录
	public Map<String, Object> getFuSellInfos(Map data) {
		String cardId = (String) data.get("CARD_ID");
		// 查询用户信息
		String userSql = "from T_IC_USERFILE where CARD_ID='" + cardId + "'";
		List<Object> userlist = (List<Object>)this.hibernateTemplate.find(userSql);
		// 未找到用户
		if (userlist.size() != 1) {
			return null;
		}
		Map<String, Object> userMap = (Map<String, Object>) userlist.get(0);
		Map<String, Object> sale = new HashMap<String, Object>();
		sale.put("LSID", data.get("LSID"));
		sale.put("CARD_ID", data.get("CARD_ID"));
		sale.put("OP_DATE", data.get("OPERATE_DATE"));
		sale.put("OP_TIME", data.get("OPERATE_DATE"));
		sale.put("OPERATE_DATE", data.get("OPERATE_DATE"));
		sale.put("OPERATE_TIME", data.get("OPERATE_DATE"));
		double d = Double.parseDouble(data.get("SELLGAS_GAS").toString());
		sale.put("SELLGAS_GAS", -d);
		double m = Double.parseDouble(data.get("MONEY").toString());
		sale.put("MONEY", -m);
		sale.put("OP_ID", data.get("OP_ID"));
		sale.put("OP_SPOT", data.get("OP_SPOT"));
		sale.put("CHONGZHANGTYPE", data.get("f_success"));
		sale.put("COME", "航天代售");
		sale.put("COME_DEP", "自助设备");
		sale.put("SUBUNIT", userMap.get("SUBUNIT"));
		sale.put("USER_NATURE", userMap.get("USER_NATURE"));
		sale.put("USER_TYPE", userMap.get("USER_TYPE"));
		sale.put("USER_EQUIPMENT", userMap.get("USER_EQUIPMENT"));
		sale.put("PRICE", userMap.get("PRICE"));
		sale.put("METER_TYPES_NAME", userMap.get("METER_TYPES_NAME"));
		sale.put("DATA_VAILD", "是");
		sale.put("IS_BILL", "是");
		String meterTypes = (String) userMap.get("METER_TYPES_ID");
		if (meterTypes != null
				&& (meterTypes.equals("15") || meterTypes.equals("16"))) {
			sale.put("measure_way", "金额");
		} else {
			sale.put("measure_way", "气量");
		}
		sale.put("f_isduizhang", "已对账");
		return sale;
	}

	/**
	 * 对账维管费
	 *
	 * @param data
	 */
	private void checkWGF(String content, Map<String, Object> data) {
		log.info("比对维管费" + content);
		String lsid = (String) data.get("LSID");
		String sql = "from T_IC_MYWGF where LSID='" + data.get("LSID")
				+ "'  and  (f_isduizhang <> '已对账' or f_isduizhang is null)";
		List<Object> list = (List<Object>)this.hibernateTemplate.find(sql);
		// 没有维管费信息，直接插入表
		if (list.size() != 1) {
			// 判断是会否有记录
			if (!hasWgfDuiZhang(lsid)) {
				log.info("维管费无记录,插入" + content);
				data.put("f_isduizhang", "已对账");
				Map<String, Object> wgfinfo = getWgfInfo(data);
				// 插入对账信息
				this.hibernateTemplate.save("T_IC_MYWGF", wgfinfo);
				// 如果是冲账记录，插入副记录
				String czType = (String) wgfinfo.get("CHONGZHANGTYPE");
				if (czType != null && czType.indexOf("冲账") != -1) {
					Map<String, Object> fuso = getFuWgfInfo(data);
					this.hibernateTemplate.save("T_IC_MYWGF", fuso);
				}
				// 保存到对账表
				data.put("f_biaoshi", "插入");
				// 保存到对账表
				data.put("f_biaoshi", "插入航天代售数据");
				data.put("ladata", content);
				data.put("localdata", "本地无此记录");
				this.hibernateTemplate.save("T_IC_WGFCHECKING", data);
			}
		} else {
			// 对比数据
			HashMap ht = (HashMap) list.get(0);
			String wgfLaFormat = dataWGFFromatla(ht);
			HashMap newHt = new HashMap();
			newHt.putAll(ht);
			StringBuilder diffs = new StringBuilder();
			boolean f = wgfdui(data, ht, newHt, diffs);
			if (!f) {
				String laformatdata = dataWGFFromatla(ht);
				// 不一致的数据把两条数据都保存在单独表(单独表加入标识，是插入，还是不一致)
				log.info("维管费记录不一致:");
				log.info("航天代售数据:" + content);
				log.info("本地数据:" + laformatdata);
				// 保存数据库信息到对账表
				ht.put("f_biaoshi", "数据不一致");
				ht.put("ladata", content);
				ht.put("localdata", laformatdata);
				ht.put("diffs", diffs.toString());
				this.hibernateTemplate.save("T_IC_WGFCHECKING", ht);
				// 加入已经对账标示
				newHt.put("f_isduizhang", "已对账");
				this.hibernateTemplate.saveOrUpdate("T_IC_MYWGF", newHt);
			} else {
				log.info("维管费相同" + content);
				ht.put("f_isduizhang", "已对账");
				this.hibernateTemplate.saveOrUpdate("T_IC_MYWGF", ht);
			}
		}
		// 如果是冲账数据更新档案表
		// String czType = (String) data.get("f_success");
		// if (czType != null && czType.indexOf("冲账") != -1) {
		// String card_id = (String) data.get("CARD_ID");
		// Date d = (Date) data.get("WGFLASTDATE");
		// this.updateUserWGFDate(card_id,d);
		// }
	}

	// 冲账维修管理费更新用户档案日期
	public void updateUserWGFDate(String card_id, Date d) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String wdate = sdf.format(d);
		String sql = "update T_IC_USERFILE set WGFLASTDATE=to_date('" + wdate
				+ "','yyyy-mm-dd') where CARD_ID='" + card_id + "'";
		log.info("用户档案维管费日期回撤更新,执行sql" + sql);
		this.hibernateTemplate.bulkUpdate(sql);
	}

	// 组织维修管理费数据
	public Map<String, Object> getWgfInfo(Map data) {
		Map<String, Object> wgf = new HashMap<String, Object>();
		wgf.put("LSID", data.get("LSID"));
		wgf.put("CARD_ID", data.get("CARD_ID"));
		wgf.put("OP_DATE", data.get("OPERATE_TIME"));
		wgf.put("OP_TIME", data.get("OPERATE_TIME"));
		wgf.put("OPERATE_DATE", data.get("OPERATE_TIME"));
		wgf.put("OPERATE_TIME", data.get("OPERATE_TIME"));
		wgf.put("MONEY", data.get("WGFMONEY"));
		wgf.put("OP_ID", data.get("OP_ID"));
		wgf.put("OP_SPOT", data.get("OP_SPOT"));
		wgf.put("STARTDATE", data.get("WGFLASTDATE"));
		wgf.put("ENDDATE", data.get("WGFLASTDATE2"));
		wgf.put("COME", "航天代售");
		wgf.put("COME_DEP", "自助设备");
		wgf.put("DATA_VAILD", "是");
		wgf.put("IS_BILL", "是");
		// 冲账方式
		wgf.put("CHONGZHANGTYPE", data.get("f_success"));
		wgf.put("f_isduizhang", "已对账");
		return wgf;
	}

	// 组织负维修管理费数据
	public Map<String, Object> getFuWgfInfo(Map data) {
		Map<String, Object> wgf = new HashMap<String, Object>();
		wgf.put("LSID", data.get("LSID"));
		wgf.put("CARD_ID", data.get("CARD_ID"));
		wgf.put("OP_DATE", data.get("OPERATE_TIME"));
		wgf.put("OP_TIME", data.get("OPERATE_TIME"));
		wgf.put("OPERATE_DATE", data.get("OPERATE_TIME"));
		wgf.put("OPERATE_TIME", data.get("OPERATE_TIME"));
		double d = Double.parseDouble(data.get("WGFMONEY").toString());
		wgf.put("MONEY", -d);
		wgf.put("OP_ID", data.get("OP_ID"));
		wgf.put("OP_SPOT", data.get("OP_SPOT"));
		wgf.put("STARTDATE", data.get("WGFLASTDATE"));
		wgf.put("ENDDATE", data.get("WGFLASTDATE2"));
		wgf.put("COME", "航天代售");
		wgf.put("COME_DEP", "自助设备");
		wgf.put("DATA_VAILD", "是");
		wgf.put("IS_BILL", "是");
		// 冲账方式
		wgf.put("CHONGZHANGTYPE", data.get("f_success"));
		wgf.put("f_isduizhang", "已对账");
		return wgf;
	}

	/**
	 * 维管费对比数据
	 *
	 * @param wgf
	 *            文本信息
	 * @param ht
	 *            数据库信息
	 * @return
	 */
	private boolean wgfdui(Map<String, Object> wgf, Map<String, Object> ht,
						   Map newHt, StringBuilder diffs) {
		boolean result = true;
		// 流水号
		if (!wgf.get("LSID").equals(ht.get("LSID"))) {
			log.info("流水号：数据：" + ht.get("LSID") + ";航天代售：" + wgf.get("LSID"));
			diffs.append("流水号：数据：" + ht.get("LSID") + ";航天代售：" + wgf.get("LSID"))
					.append("|");
			result = false;
		}
		// 卡号
		if (!wgf.get("CARD_ID").equals(ht.get("CARD_ID"))) {
			log.info("卡号：数据值：" + ht.get("CARD_ID") + ";航天代售："
					+ wgf.get("CARD_ID"));
			diffs.append(
					"卡号：数据：" + ht.get("CARD_ID") + ";航天代售：" + wgf.get("CARD_ID"))
					.append("|");
			newHt.put("CARD_ID", wgf.get("CARD_ID"));
			result = false;
		}
		// 操作日期
		String wgfDateCA = ht.get("OPERATE_DATE").toString();
		Date d = (Date) wgf.get("OPERATE_DATE");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String wgfDateLA = sdf.format(d);
		if (!wgfDateLA.equals(wgfDateCA)) {
			log.info("操作日期：数据：" + ht.get("OP_DATE") + ";航天代售：" + wgfDateLA);
			diffs.append("操作日期：数据：" + ht.get("OP_DATE") + ";航天代售：" + wgfDateLA)
					.append("|");
			newHt.put("OPERATE_DATE", wgf.get("OP_DATE"));
			result = false;
		}
		// 操作地点
		if (!wgf.get("OP_SPOT").equals(ht.get("OP_SPOT"))) {
			log.info("操作地点：数据：" + ht.get("OP_SPOT") + ";航天代售："
					+ wgf.get("OP_SPOT"));
			diffs.append(
					"操作地点：数据：" + ht.get("OP_SPOT") + ";航天代售："
							+ wgf.get("OP_SPOT")).append("|");

			newHt.put("OP_SPOT", wgf.get("OP_SPOT"));
			result = false;
		}
		// 操作员编号
		if (!wgf.get("OP_ID").equals(ht.get("OP_ID"))) {
			log
					.debug("操作员编号：数据：" + ht.get("OP_ID") + ";航天代售："
							+ wgf.get("OP_ID"));
			diffs.append(
					"操作员编号：数据：" + ht.get("OP_ID") + ";航天代售：" + wgf.get("OP_ID"))
					.append("|");
			newHt.put("OP_ID", wgf.get("OP_ID"));
			result = false;
		}
		// 开始日期
		SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
		Date sd1 = (Date) wgf.get("WGFLASTDATE");
		String sDateLA = formatDate.format(sd1);
		Date sd2 = (Date) ht.get("STARTDATE");
		String sDataCa = formatDate.format(sd2);
		if (!sDateLA.equals(sDataCa)) {
			log.info("开始日期：数据：" + ht.get("STARTDATE") + ";航天代售："
					+ wgf.get("STARTDATE"));
			diffs.append(
					"开始日期：数据：" + ht.get("STARTDATE") + ";航天代售："
							+ wgf.get("STARTDATE")).append("|");

			ht.put("STARTDATE", wgf.get("STARTDATE"));
			result = false;
		}
		// 结束日期
		Date ed1 = (Date) wgf.get("WGFLASTDATE2");
		Date ed2 = (Date) ht.get("ENDDATE");
		String eDateLA = formatDate.format(ed1);
		String eDataCa = formatDate.format(ed2);
		if (!eDateLA.equals(eDataCa)) {
			log.info("结束日期：数据：" + ht.get("ENDDATE") + ";航天代售："
					+ wgf.get("ENDDATE"));
			diffs.append(
					"结束日期：数据：" + ht.get("ENDDATE") + ";航天代售："
							+ wgf.get("ENDDATE")).append("|");

			newHt.put("ENDDATE", wgf.get("ENDDATE"));
			result = false;
		}
		// 金额
		double moneyLA = Double.parseDouble(wgf.get("WGFMONEY").toString());
		double moneyCa = Double.parseDouble(ht.get("MONEY").toString());
		if (moneyLA != moneyCa) {
			log.info("金额：数据：" + ht.get("MONEY") + ";航天代售：" + wgf.get("MONEY"));
			diffs
					.append(
							"金额：数据：" + ht.get("MONEY") + ";航天代售："
									+ wgf.get("MONEY")).append("|");

			newHt.put("MONEY", moneyLA);
			result = false;
		}
		// 如果是冲账，该记录改为无效
		String f_success = (String) wgf.get("f_success");
		if (f_success != null
				&& (f_success.equals("无卡冲账") || f_success.equals("有卡冲账"))) {
			// newHt.put("DATA_VAILD", "否");
			// log.info("冲账记录,改记录标示为否：西安银行：" + f_success);
			// diffs.append("冲账记录,改记录标示为否：西安银行：" + f_success).append("|");
			result = false;
		}
		return result;
	}

	/**
	 * 获得维管费保存对象
	 *
	 * @param data
	 * @return
	 */
	private Map<String, Object> getWGF(Map<String, Object> data) {
		Map<String, Object> map = new HashMap<String, Object>();
		// 流水号
		map.put("LSID", data.get("LSID"));
		// 卡号
		map.put("CARD_ID", data.get("CARD_ID"));
		// 操作日期
		map.put("OP_DATE", data.get("OPERATE_DATE"));
		map.put("OPERATE_DATE", data.get("OPERATE_DATE"));
		// 操作地点
		map.put("OP_SPOT", data.get("OP_SPOT"));
		// 操作员编号
		map.put("OP_ID", data.get("OP_CODE"));
		// 是否有效
		map.put("DATA_VAILD", "是");
		// 开始日期
		map.put("STARTDATE", data.get("WGFLASTDATE"));
		// 结束日期
		map.put("ENDDATE", data.get("WGFLASTDATE2"));
		// 金额
		map.put("MONEY", data.get("WGFMONEY"));
		// 冲账方式
		map.put("CHONGZHANGTYPE", data.get("f_success"));
		return map;
	}

	// 没有流水信息，直接插入表
	private Map<String, Object> getmap(String[] str) throws ParseException {
		Map<String, Object> map = new HashMap<String, Object>();
		// 流水号
		map.put("LSID", str[0].trim());
		// 卡号
		map.put("CARD_ID", str[1].trim());
		// 气量
		map.put("SELLGAS_GAS", Double.parseDouble(str[2].trim()));
		// 金额
		map.put("MONEY", Double.parseDouble(str[3].trim()));
		// 日期
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date d1 = (Date) sdf.parse(str[4].trim());
		map.put("OPERATE_DATE", d1);
		map.put("OPERATE_TIME", d1);
		// 操作地点
		map.put("OP_SPOT", str[5].trim());
		// 操作员
		map.put("OP_ID", str[6].trim());
		// 是否成功
		String temp = str[7].trim();
		if (temp.equals("0")) {
			map.put("f_success", "成功");
		} else if (temp.equals("1")) {
			map.put("f_success", "无卡冲账");
		} else if (temp.equals("2")) {
			map.put("f_success", "有卡冲账");
		}
		// 维修管理费起始日期
		temp = str[8].trim();
		// 维管费金额
		map.put("WGFMONEY", Double.parseDouble(str[10].trim()));
		// 阶梯信息
		if (str.length > 12) {
			map.put("f_stair1amount", NumberHelper.strToDouble(str[11]));
			map.put("f_stair2amount", NumberHelper.strToDouble(str[12]));
			map.put("f_stair3amount", NumberHelper.strToDouble(str[13]));

			map.put("f_stair1price", NumberHelper.strToDouble(str[14]));
			map.put("f_stair2price", NumberHelper.strToDouble(str[15]));
			map.put("f_stair3price", NumberHelper.strToDouble(str[16]));

			map.put("f_stair1fee", NumberHelper.strToDouble(str[17]));
			map.put("f_stair2fee", NumberHelper.strToDouble(str[18]));
			map.put("f_stair3fee", NumberHelper.strToDouble(str[19]));
		}
		return map;
	}

	/**
	 * 对账
	 *
	 * @param str
	 * @param map
	 * @return true对账成功，false对账不一致
	 */
	private boolean dui(String[] str, Map<String, Object> map, Map newht,
						StringBuilder sb) {
		boolean result = true;
		// 流水号
		String lsid = str[0].trim();
		if (!lsid.equals(map.get("F_SERIAL_ID"))) {
			log.info("流水号：数据值：" + map.get("F_SERIAL_ID") + ";航天代售：" + str[0]);
			sb.append("流水号：数据值：" + map.get("F_SERIAL_ID") + ";航天代售：" + str[0]).append(
					"|");
			newht.put("F_SERIAL_ID", str[0]);
			result = false;
		}
		// 卡号
		String cardId = str[1].trim();
		if (!cardId.equals(map.get("F_CARD_ID"))) {
			log.info("卡号：数据：" + map.get("F_CARD_ID") + ";航天代售：" + str[1]);
			sb.append("卡号：数据：" + map.get("F_CARD_ID") + ";航天代售：" + str[1]).append(
					"|");
			newht.put("F_CARD_ID", str[1]);
			result = false;
		}
		// 气量
		double gasLA = Double.parseDouble(str[2].trim());
		double gasCa = Double.parseDouble(map.get("F_PREGAS").toString());
		if (gasLA != gasCa) {
			log.info("气量：数据值：" + map.get("F_PREGAS") + ";航天代售：" + str[2]);
			sb.append("气量：数据值：" + map.get("F_PREGAS") + ";航天代售：" + str[1])
					.append("|");
			newht.put("F_PREGAS", gasLA);
			result = false;
		}
		// 金额
		double moneyLA = Double.parseDouble(str[3].trim());
		double moneyCa = Double.parseDouble(map.get("F_COLLECTION").toString());
		if (moneyLA != moneyCa) {
			log.info("金额：数据值：" + map.get("F_COLLECTION") + ";航天代售：" + str[3]);
			sb.append("金额：数据值：" + map.get("F_COLLECTION") + ";航天代售：" + str[3]).append(
					"|");
			newht.put("F_COLLECTION", moneyLA);
			result = false;
		}
		// 操作地点
		if (!str[5].trim().equals(map.get("F_TERMINAL_NUM"))) {
			log.info("操作地点：数据值：" + map.get("F_TERMINAL_NUM") + ";航天代售：" + str[5]);
			sb.append("操作地点：数据值：" + map.get("F_TERMINAL_NUM") + ";航天代售：" + str[5])
					.append("|");
			newht.put("F_TERMINAL_NUM", str[5]);
			result = false;
		}
		// 操作员
		if (!str[6].trim().equals(map.get("OP_ID"))) {
			log.info("操作员：数据值：" + map.get("OP_ID") + ";航天代售：" + str[6]);
			sb.append("操作员：数据值：" + map.get("OP_ID") + ";航天代售：" + str[6])
					.append("|");
			newht.put("OP_ID", str[6]);
			result = false;
		}
		// 是否成功
		String temp = str[7].trim();
		if (temp.equals("0")) {
			temp = "有效";
		} else{
			temp = "冲正";
		}
		// 如果是冲正，核对
		if (!temp.equals(map.get("F_STATE"))) {
			result = false;
		}
		return result;
	}

	private void writeFile(String content) {
		try {
			if (this.bw == null) {
				String path = FilePath.GetOldFilePath("spaceflightfilepath") + FileName;
				FileWriter fw = new FileWriter(path);
				this.bw = new BufferedWriter(fw);
				this.bw.write(content);
			} else {
				this.bw.write(content);
			}
			this.bw.newLine();
		} catch (IOException e) {
			throw new RuntimeException("写错误文件失败", e);
		}
	}

	// 删除原文件
	public void delete() throws Exception {
		try {
			File file = new File(Path);
			if (file.isFile() && file.exists()) {
				boolean t = file.delete();
				if (!t) {
					file.deleteOnExit();
				}
			}
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}

	public void copyFile(String oldPath, String newPath) {
		try {
			int bytesum = 0;
			int byteread = 0;
			File oldfile = new File(oldPath);
			if (oldfile.exists()) { // 文件存在时
				InputStream inStream = new FileInputStream(oldPath); // 读入原文件
				FileOutputStream fs = new FileOutputStream(newPath);
				byte[] buffer = new byte[1444];
				int length;
				while ((byteread = inStream.read(buffer)) != -1) {
					bytesum += byteread; // 字节数 文件大小
					System.out.println(bytesum);
					fs.write(buffer, 0, byteread);
				}
				fs.flush();
				fs.close();
				inStream.close();
			}
		} catch (Exception e) {
			System.out.println("复制单个文件操作出错");
			throw new RuntimeException(e);

		}

	}
	@POST
	@Transactional
	@Produces(MediaType.APPLICATION_JSON)
	public String deal(String values) {
		try {
			FileName=values;
			this.readfile();
			return "成功";
		} catch (Exception e) {
			log.error("异常:" + e.getMessage().toString());
			//throw new RuntimeException();
			return "失败";
		}

	}

}
