package com.aote.rs;


import com.aote.entity.EntityServer;
import com.aote.helper.StringHelper;
import org.apache.log4j.Logger;

import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


import javax.ws.rs.POST;
import javax.ws.rs.Path;

import java.util.*;


// 射频卡服务
@Path("rf")
@Component
/**
 * 射频卡服务
 */
public class RfService {

	static Logger log = Logger.getLogger(RfService.class);
	@Autowired
	private EntityServer entityServer;

	/***
	 * 收费系统，保存射频卡信息
	 *
	 * @param str
	 *            :需要解析的字符串，第一项为str3，用于判断两种格式， 按照str3@str1@str2,拼接后传递
	 * @return
	 */
	@POST
	@Path("save")
	public String saveRF(String str) {
		String result = "{result:'ok'}";
		try {
			Iterator iter = StringHelper.stringToLinkedList(str, '@')
					.iterator();
			String str3 = iter.next().toString();

			JSONObject sale =  new JSONObject();
			// 两种格式解析
			if (str3.startsWith("8888")) {
				sale = RFTools.p8888(iter);
			} else if (str3.startsWith("9999")) {
				RFTools rf = new RFTools();
				sale = rf.p9999(iter);
			}
			// 处理后加数据
			LinkedList data = StringHelper.stringToLinkedList(str, '@');
			String anjiandatas = data.get(data.size() - 1) + "";
			if (!anjiandatas.startsWith("8888")
					&& !anjiandatas.startsWith("9999")) {
				LinkedList anjianlist = StringHelper.stringToLinkedList(
						anjiandatas, '|');
				// <!--安检年数[设置/读取 卡上]-->
				String ajyear = anjianlist.get(0) + "";
				sale.put("ajyear", ajyear);
				// <!--报废年数[设置/读取 卡上]-->
				String bfyear = anjianlist.get(1) + "";
				sale.put("bfyear", bfyear);
				// <!-- 第一档报警气量-->
				String alarm1 = anjianlist.get(2) + "";
				sale.put("alarm1", alarm1);
				// <!-- 第二档报警气量 -->
				String alarm2 = anjianlist.get(3) + "";
				sale.put("alarm2", alarm2);
				// <!--若下面变量都为“0”表示表是老表，没有下面的功能-->
				// <!--安检年数[表反写]-->
				String fxajyear = anjianlist.get(4) + "";
				sale.put("fxajyear", fxajyear);
				// <!--报废年数[表反写]-->
				String fxbfyear = anjianlist.get(5) + "";
				sale.put("fxbfyear", fxbfyear);
				// <!--第一档报警气量[表反写]-->
				String fxalarm1 = anjianlist.get(6) + "";
				sale.put("fxalarm1", fxalarm1);
				// <!--第二档报警气量[表反写]-->
				String fxalarm2 = anjianlist.get(7) + "";
				sale.put("fxalarm2", fxalarm2);
				// <!-- 表已用安检天数-->
				String yiyognajyear = anjianlist.get(8) + "";
				sale.put("yiyognajyear", yiyognajyear);
				// <!-- 表已用报废天数-->
				String yiyongbfyear = anjianlist.get(9) + "";
				sale.put("yiyongbfyear", yiyongbfyear);
				// <!-- 表透支总量-->
				String touzhi = anjianlist.get(10) + "";
				sale.put("touzhi", touzhi);
				// <!-- 表最后处理透支量-->
				String lasttouzhi = anjianlist.get(11) + "";
				sale.put("lasttouzhi", lasttouzhi);
				// <!--表最后处理日期-->

				String lastchulidate = anjianlist.get(12) + "";
				sale.put("lastchulidate", lastchulidate);

			}
			entityServer.partialSave("t_rf_info", sale);
		} catch (Exception e) {
			log.debug("保存射频卡信息错误：" + e.getMessage());
			return result;
		}
		return result;
	}
}
