package com.aote.rs;

import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.helper.FilePath;
import com.aote.helper.NumberHelper;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import com.aote.util.ResourceHelper;
import kafka.utils.json.JsonArray;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.io.*;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 接收银行文件处理过程。模仿手工操作，步骤如下： 1. 对账，看银行各项合计是否正确。不正确，抛异常。 2. 产生交费记录，从用户档案里带值到交费记录。
 * 3. 处理抄表记录，选择出要交费的记录。计算合计，最大值，最小值等， 放进交费记录里。 4. 银行总合计金额记为实交金额。根据表达式计算交费记录其它数据。
 * 5. 保存交费记录，回写用户档案，给抄表记录打标记。
 */
@Path("LiAnDuizhang")
@Component
public class ReviceBankFileEntity {

	@Autowired
	public HibernateTemplate hibernateTemplate;
	@Autowired
	private LogicServer logicServer;
	@Autowired
	private EntityServer entityServer;
	@Autowired
	private SqlServer sqlServer;
	//电子发票服务地址
	static String invoice_url;
	private static final Logger log = Logger
			.getLogger(ReviceBankFileEntity.class);
	/**
	 *
	 */
	private static final long serialVersionUID = -1404439164923599184L;

	private BufferedWriter bw = null;

	public ReviceBankFileEntity() {

	}
	/**
	 * 构造函数后处理方法
	 * @throws Exception
	 */
	@PostConstruct
	public void init()throws Exception {
		JSONObject configJson=new JSONObject(ResourceHelper.getString("config.json"));
		invoice_url=configJson.getString("invoiceurl");
	}

	private String Path;

	public String FileName;

	public void readfile() throws Exception {
		// 如果数据已经导入,提示不要重复导入
		Path = FilePath.GetPath("lianfilepath") + "" + FileName;
		FileReader fr = new FileReader(Path);
		BufferedReader br = new BufferedReader(fr);
		String content = "";
		log.info("开始对账,文件名:" + FileName);
		// 根据内容对系统用户数据进行处理
		while ((content = br.readLine()) != null) {
			try {
				xtSavedisposeData(content);
			} catch (Exception e) {
				log.error(e.getMessage().toString());
				continue;
			}

		}
		if (this.bw != null) {
			this.bw.close();
		}
		if (br != null) {
			br.close();
		}
		if (fr != null) {
			fr.close();
		}
		// 当天没有表示为 已对账的记录需要设置未无效
		SetNotExistFileInvaild(FileName);
		// 移动已对账文件到其他文件夹
		copyFile(Path, FilePath.GetOldFilePath("lianfilepath") + FileName);
		// 删除已对账文件
		delete();
		log.info("对账结束,文件名:" + FileName);
	}

	// 设置对账完成后表示为未结账的利安数据为无效
	public void SetNotExistFileInvaild(String fileName) {
		String date = fileName.substring(2, 10);
		//拼接条件
		String con = " F_BANK_NAME='利安公司' "
				+ " and TRUNC (f_operate_date)=to_date('"
				+ date
				+ "','yyyy-mm-dd') and  (f_isduizhang <>'已对账' or f_isduizhang is null)"
				+ " and f_state='有效' ";
		String t_recordsql = "update t_record set f_state='无效' where id in (select id from t_sellinggas where " + con + " )";
		sqlServer.run(t_recordsql);
		String t_chargepricesql = "update t_chargeprice set f_state='无效' where f_charge_id in (select id from t_sellinggas where " + con + " )";
		sqlServer.run(t_chargepricesql);
		String t_sellinggassql = "update t_sellinggas set f_state='无效' where " + con;
		sqlServer.run(t_sellinggassql);
		log.info("更新" + date + "未对账的利安数据为无效,sql:");
	}


	/**
	 * 第三方支付卡表收费
	 *
	 * @param user 表档案
	 * @return
	 */
	private Object callthirdPay(Map<String, Object> user) throws Exception {
		//先准备获取用户相关信息
		JSONObject data = new JSONObject();
		//表号
		data.put("f_user_id", user.get("f_user_id"));
		//卡号
		data.put("f_card_id", user.get("CARD_ID"));
		//终端号
		data.put("f_terminal_num", user.get("OP_SPOT"));
		//柜员号
		data.put("opid", user.get("OP_ID"));
		// yuan/fen,如果不传按分处理
		data.put("f_unit", "yuan");
		//购气金额
		data.put("f_preamount", new BigDecimal(user.get("MONEY").toString()));
		//流水
		data.put("f_serial_id", user.get("LSID"));
		//付款金额
		data.put("f_collection", new BigDecimal(user.get("MONEY").toString()));
		//购气量
		data.put("f_pregas", new BigDecimal(user.get("SELLGAS_GAS").toString()));
		// 0,1 （0-按气量, 1-按金额）（划价获取价格明细）
		data.put("isGasValue", 0);
		data.put("f_bill_style", "电子发票");
		return logicServer.run("thirdPay", data.toString());

	}

	/**
	 * 执行sql返回数据
	 *
	 * @param sql
	 * @return
	 */
	private List<Object> executeSQL(String sql) {
		List<Object> list = (List<Object>) hibernateTemplate
				.execute(new org.springframework.orm.hibernate4.HibernateCallback() {
					public Object doInHibernate(Session session)
							throws HibernateException {
						SQLQuery query = session.createSQLQuery(sql);
						return (List) query.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).list();
					}
				});
		return list;
	}

	/**
	 * 处理一条数据
	 */
	private void xtSavedisposeData(String content) throws Exception {

		log.info("<--------------------------------------->");
		log.info("利安记录:" + content);
		String[] str = content.split("\\|");
		try {
			if (str.length == 12 || str.length == 21) {
				log.info("开始对账------");
				// 流水号
				String LSID = str[0].trim();
				// 根据对账流水号然后去数据库找一条(对过账的数据不查找)
				String sql = "select * from t_sellinggas where f_serial_id='" + LSID + "' and  (f_isduizhang <> '已对账' or f_isduizhang is null)";
				log.info("查找系统收费数据" + sql);
				List<Object> list = executeSQL(sql);
				// 利安数据
				JSONObject data = getmap(str);
				// 如果数据库中找不到数据，直接插入文本数据
				if (list.size() == 0) {
					log.info("开始插入利安的收费记录...");
					// 查询用户信息
					Map<String, Object> sellgas = getSellInfos(data);
					JSONObject selllogic = (JSONObject) this.callthirdPay(sellgas);
					//更新为已对账
					String yiduizhang = "update t_sellinggas set f_isduizhang='已对账' where f_serial_id='" + LSID + "' and id= '" + selllogic.getString("id") + "'";
					sqlServer.run(yiduizhang);
					data.put("f_biaoshi", "插入利安数据");
					data.put("ldata", content);
					data.put("localdata", "本地无此记录");
					entityServer.partialSave("t_ic_checking", data);
				}
				//如果有一条记录进行比对
				if (list.size() == 1) {
					log.info("找到一条收费记录，开始对比数据...");
					// 对比数据
					HashMap localht = (HashMap) list.get(0);
					// 按利安格式整理数据
					String laformatdata = dataFromatla(localht);
					// 数据备份
					HashMap savenewHt = new HashMap();
					savenewHt.putAll(localht);
					StringBuilder differStr = new StringBuilder();
					boolean f = dui(str, localht, savenewHt, differStr);
					if (!f) {
						log.info("记录不一致:");
						log.info("利安数据:" + content);
						log.info("本地数据:" + laformatdata);
						// 保存数据库信息到对账表
						data.put("f_biaoshi", "数据不一致");
						data.put("ladata", content);
						data.put("localdata", laformatdata);
						data.put("diffs", differStr.toString());
						entityServer.partialSave("t_ic_checking", data);
						savenewHt.put("F_ISDUIZHANG", "已对账");
						String updtasql = "update t_sellinggas " + "set " +
								"f_isduizhang='已对账', " +
								"F_CARD_ID='" + savenewHt.get("F_CARD_ID") + "', " +
								"F_PREGAS=" + savenewHt.get("F_PREGAS") + ", " +
								"F_COLLECTION=" + savenewHt.get("F_COLLECTION") + ", " +
								"F_TERMINAL_NUM='" + savenewHt.get("F_TERMINAL_NUM") + "', " +
								"F_OPERATOR='" + savenewHt.get("F_OPERATOR") + "' " +
								"where f_serial_id='" + LSID + "'";
						sqlServer.run(updtasql);

					} else {
						log.info("记录相同:" + content);
						String updtasql = "update t_sellinggas set f_isduizhang='已对账' where f_serial_id='" + LSID + "'";
						sqlServer.run(updtasql);
					}
					this.openInvoice(localht.get("ID").toString());
				}
			}
		} catch (Exception e) {
			log.error("核对利安数据报错" + e.getMessage());
		}
	}

	/**
	 * 根据收费记录开票
	 * @param sellid
	 * @throws Exception
	 */
	private void openInvoice(String sellid) throws Exception {
		try {
			//查询到收费记录
			JSONArray sellarry =sqlServer.query("select * from T_SELLINGGAS where id="+sellid+" and f_state='有效' and  is_bill is null");
			if(sellarry.length()>0){
				JSONObject sellobj=sellarry.getJSONObject(0);
				sellobj.put("sellid",sellobj.get("id"));
				sellobj.put("printtype",sellobj.get("f_bill_style"));
				sellobj.put("f_operator",sellobj.get("f_operator"));
				sellobj.put("op_id",sellobj.get("op_id"));
				sellobj.put("op_spot",sellobj.get("op_spot"));
				sellobj.put("f_filiale",sellobj.get("f_filiale"));
				sellobj.put("f_outlets",sellobj.get("f_outlets"));
				sellobj.put("op_spot",sellobj.get("op_spot"));
				//获取发票信息
				JSONObject res=(JSONObject) logicServer.run("getticketmsg", sellobj.toString());
				//第一步先开票
				JSONObject openjson=new JSONObject(RestTools.post(invoice_url+"/rs/aisino/openInvoice",res.toString()));
				log.info("利安开票请求返回数据:"+openjson);
				if(openjson.get("state").toString().equals("成功")){
					res.put("f_bill_state","打票成功");
					res.put("invoiceserialnum",openjson.get("invoiceserialnum"));
					res.put("orderno",openjson.get("orderno"));
					res.put("senid",openjson.get("senid"));
					//休眠三秒再去查询
					Thread.sleep(5000);
					JSONObject serchjosn=new JSONObject();
					serchjosn.put("invoiceserialnum",res.get("invoiceserialnum"));
					serchjosn.put("salerTaxNum",res.get("salerTaxNum"));
					JSONObject queryjson=new JSONObject(RestTools.post(invoice_url+"/rs/aisino/queryInvoice",res.toString()));
					log.info("利安查询请求返回数据:"+queryjson);
					res.put("f_bill_state","打票失败");
					if(queryjson.get("state").toString().indexOf("开票完成")>-1){
						res.put("f_bill_id",queryjson.getJSONObject("result").get("invoiceno"));
						res.put("invoicecode",queryjson.getJSONObject("result").get("invoicecode"));
						res.put("f_bill_state","打票成功");
					}else {
						res.put("f_bill_state","查询失败");
					}
					logicServer.run("saveBilldetail", res.toString());
				}else {
					res.put("f_bill_state","打票失败");
					logicServer.run("saveBilldetail", res.toString());
				}

			}
		} catch(Exception e)
		{
		    log.error("利安银行开电子发票出错" + e.getMessage());
		}
}

	// 将本地售气数据组织为利安格式
	public String dataFromatla(Map localht) {
		String lsid = (String) localht.get("F_SERIAL_ID");
		String cardId = (String) localht.get("F_CARD_ID");
		String gas = localht.get("F_PREGAS").toString();
		String money = localht.get("F_COLLECTION").toString();
		Date d = (Date)localht.get("F_OPERATE_DATE");
		String op_spot = (String) localht.get("F_TERMINAL_NUM");
		String op_id = (String) localht.get("F_OPERATOR");
		String chongzhangtype = (String) localht.get("F_STATE");
		String write_card = (String) localht.get("F_WRITE_CARD");
		String wgfStartDate = "0";
		String wgfEndDate = "0";
		String wgfMoney = "0";
		StringBuilder sb = new StringBuilder();
		sb.append(lsid).append("|");
		sb.append(cardId).append("|");
		sb.append(gas).append("|");
		sb.append(money).append("|");
		sb.append(d).append("|");
		sb.append(op_spot).append("|");
		sb.append(op_id).append("|");
		sb.append(chongzhangtype).append("|");
		sb.append(wgfStartDate).append("|");
		sb.append(wgfEndDate).append("|");
		sb.append(wgfMoney).append("|");
		return sb.toString();
	}

	// 将本地售气数据组织为利安格式
	public String dataWGFFromatla(Map localht) {
		String lsid = (String) localht.get("LSID");
		String cardId = (String) localht.get("CARD_ID");
		String money = localht.get("MONEY").toString();

		Date opdate = (Date) localht.get("OPERATE_DATE");
		Date optime = (Date) localht.get("OPERATE_TIME");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String operate_date = sdf.format(opdate);
		String operate_time = sdf.format(optime);
		String d = operate_date.substring(0, 10) + " "
				+ operate_time.substring(11, operate_time.length());

		String op_spot = (String) localht.get("OP_SPOT");
		String op_id = (String) localht.get("OP_ID");
		String chongzhangtype = (String) localht.get("CHONGZHANGTYPE");
		if (chongzhangtype == null || chongzhangtype.equals("成功")) {
			chongzhangtype = "0";
		} else if (chongzhangtype.equals("无卡冲账")) {
			chongzhangtype = "1";
		} else if (chongzhangtype.equals("有卡冲账")) {
			chongzhangtype = "2";
		}
		SimpleDateFormat ddf1 = new SimpleDateFormat("yyyy-MM-dd");

		Date wgfStartDate = (Date) localht.get("STARTDATE");
		String startStr = ddf1.format(wgfStartDate);
		Date wgfEndDate = (Date) localht.get("ENDDATE");
		String endStr = ddf1.format(wgfEndDate);
		double wgfMoney = Double.parseDouble(localht.get("MONEY").toString());
		StringBuilder sb = new StringBuilder();
		sb.append(lsid).append("|");
		sb.append(cardId).append("|");
		sb.append(money).append("|");
		sb.append(d).append("|");
		sb.append(op_spot).append("|");
		sb.append(op_id).append("|");
		sb.append(chongzhangtype).append("|");
		sb.append(startStr).append("|");
		sb.append(endStr).append("|");
		sb.append(wgfMoney + "").append("|");
		return sb.toString();
	}

	public boolean hasWgfDuiZhang(String lsid) {
		String sql = "from T_IC_MYWGF where LSID='" + lsid
				+ "' and  f_isduizhang = '已对账'";
		List<Object> list = (List<Object>)this.hibernateTemplate.find(sql);
		if (list.size() >= 1) {
			return true;
		} else {
			return false;
		}

	}

	// 组织售气记录
	public Map<String, Object> getSellInfos(JSONObject data) {
		String cardId = (String) data.get("CARD_ID");
		// 查询用户信息
		String userSql = "from t_userfiles where F_CARD_ID='" + cardId + "'";
		List<Object> userlist = (List<Object>)this.hibernateTemplate.find(userSql);
		// 未找到用户
		if (userlist.size() != 1) {
			return null;
		}
		Map<String, Object> userMap = (Map<String, Object>) userlist.get(0);
		Map<String, Object> sale = new HashMap<String, Object>();
		sale.putAll(userMap);
		sale.put("LSID", data.get("LSID"));
		sale.put("CARD_ID", data.get("CARD_ID"));
	/*	sale.put("OP_DATE", data.get("OPERATE_DATE"));
		sale.put("OP_TIME", data.get("OPERATE_DATE"));
		sale.put("OPERATE_DATE", data.get("OPERATE_DATE"));
		sale.put("OPERATE_TIME", data.get("OPERATE_DATE"));*/
		sale.put("SELLGAS_GAS", data.get("SELLGAS_GAS"));
		sale.put("MONEY", data.get("MONEY"));
		sale.put("OP_ID", data.get("OP_ID"));
		sale.put("OP_SPOT", data.get("OP_SPOT"));
		sale.put("CHONGZHANGTYPE", data.get("f_success"));
		sale.put("COME", "利安公司");
		sale.put("COME_DEP", "利安公司营业厅");
		sale.put("DATA_VAILD", "是");
		sale.put("IS_BILL", "是");
		return sale;
	}

	// 组织负售气记录
	public Map<String, Object> getFuSellInfos(Map data) {
		String cardId = (String) data.get("CARD_ID");
		// 查询用户信息
		String userSql = "from T_IC_USERFILE where CARD_ID='" + cardId + "'";
		List<Object> userlist = (List<Object>)this.hibernateTemplate.find(userSql);
		// 未找到用户
		if (userlist.size() != 1) {
			return null;
		}
		Map<String, Object> userMap = (Map<String, Object>) userlist.get(0);
		Map<String, Object> sale = new HashMap<String, Object>();
		sale.put("LSID", data.get("LSID"));
		sale.put("CARD_ID", data.get("CARD_ID"));
		sale.put("OP_DATE", data.get("OPERATE_DATE"));
		sale.put("OP_TIME", data.get("OPERATE_DATE"));
		sale.put("OPERATE_DATE", data.get("OPERATE_DATE"));
		sale.put("OPERATE_TIME", data.get("OPERATE_DATE"));
		double d = Double.parseDouble(data.get("SELLGAS_GAS").toString());
		sale.put("SELLGAS_GAS", -d);
		double m = Double.parseDouble(data.get("MONEY").toString());
		sale.put("MONEY", -m);
		sale.put("OP_ID", data.get("OP_ID"));
		sale.put("OP_SPOT", data.get("OP_SPOT"));
		sale.put("CHONGZHANGTYPE", data.get("f_success"));
		sale.put("COME", "利安公司");
		sale.put("COME_DEP", "利安公司营业厅");
		sale.put("SUBUNIT", userMap.get("SUBUNIT"));
		sale.put("USER_NATURE", userMap.get("USER_NATURE"));
		sale.put("USER_TYPE", userMap.get("USER_TYPE"));
		sale.put("USER_EQUIPMENT", userMap.get("USER_EQUIPMENT"));
		sale.put("PRICE", userMap.get("PRICE"));
		sale.put("METER_TYPES_NAME", userMap.get("METER_TYPES_NAME"));
		sale.put("DATA_VAILD", "是");
		sale.put("IS_BILL", "是");
		String meterTypes = (String) userMap.get("METER_TYPES_ID");
		if (meterTypes != null
				&& (meterTypes.equals("15") || meterTypes.equals("16"))) {
			sale.put("measure_way", "金额");
		} else {
			sale.put("measure_way", "气量");
		}
		sale.put("f_isduizhang", "已对账");
		return sale;
	}


	// 组织维修管理费数据
	public Map<String, Object> getWgfInfo(Map data) {
		Map<String, Object> wgf = new HashMap<String, Object>();
		wgf.put("LSID", data.get("LSID"));
		wgf.put("CARD_ID", data.get("CARD_ID"));
		wgf.put("OP_DATE", data.get("OPERATE_TIME"));
		wgf.put("OP_TIME", data.get("OPERATE_TIME"));
		wgf.put("OPERATE_DATE", data.get("OPERATE_TIME"));
		wgf.put("OPERATE_TIME", data.get("OPERATE_TIME"));
		wgf.put("MONEY", data.get("WGFMONEY"));
		wgf.put("OP_ID", data.get("OP_ID"));
		wgf.put("OP_SPOT", data.get("OP_SPOT"));
		wgf.put("STARTDATE", data.get("WGFLASTDATE"));
		wgf.put("ENDDATE", data.get("WGFLASTDATE2"));
		wgf.put("COME", "利安公司");
		wgf.put("COME_DEP", "利安公司营业厅");
		wgf.put("DATA_VAILD", "是");
		wgf.put("IS_BILL", "是");
		// 冲账方式
		wgf.put("CHONGZHANGTYPE", data.get("f_success"));
		wgf.put("f_isduizhang", "已对账");
		return wgf;
	}

	// 组织负维修管理费数据
	public Map<String, Object> getFuWgfInfo(Map data) {
		Map<String, Object> wgf = new HashMap<String, Object>();
		wgf.put("LSID", data.get("LSID"));
		wgf.put("CARD_ID", data.get("CARD_ID"));
		wgf.put("OP_DATE", data.get("OPERATE_TIME"));
		wgf.put("OP_TIME", data.get("OPERATE_TIME"));
		wgf.put("OPERATE_DATE", data.get("OPERATE_TIME"));
		wgf.put("OPERATE_TIME", data.get("OPERATE_TIME"));
		double d = Double.parseDouble(data.get("WGFMONEY").toString());
		wgf.put("MONEY", -d);
		wgf.put("OP_ID", data.get("OP_ID"));
		wgf.put("OP_SPOT", data.get("OP_SPOT"));
		wgf.put("STARTDATE", data.get("WGFLASTDATE"));
		wgf.put("ENDDATE", data.get("WGFLASTDATE2"));
		wgf.put("COME", "利安公司");
		wgf.put("COME_DEP", "利安公司营业厅");
		wgf.put("DATA_VAILD", "是");
		wgf.put("IS_BILL", "是");
		// 冲账方式
		wgf.put("CHONGZHANGTYPE", data.get("f_success"));
		wgf.put("f_isduizhang", "已对账");
		return wgf;
	}

	// 没有流水信息，直接插入表
	private  JSONObject  getmap(String[] str) throws ParseException {
		JSONObject map = new JSONObject();
		// 流水号
		map.put("LSID", str[0].trim());
		// 卡号
		map.put("CARD_ID", str[1].trim());
		// 气量
		map.put("SELLGAS_GAS", Double.parseDouble(str[2].trim()));
		// 金额
		map.put("MONEY", Double.parseDouble(str[3].trim()));
		// 日期
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date d1 = (Date) sdf.parse(str[4].trim());
//		map.put("OPERATE_DATE", d1);
//		map.put("OPERATE_TIME", d1);
		// 操作地点
		map.put("OP_SPOT", str[5].trim());
		// 操作员
		map.put("OP_ID", str[6].trim());
		// 是否成功
		String temp = str[7].trim();
		if (temp.equals("0")) {
			map.put("f_success", "成功");
		} else if (temp.equals("1")) {
			map.put("f_success", "无卡冲账");
		} else if (temp.equals("2")) {
			map.put("f_success", "有卡冲账");
		}
		// 维修管理费起始日期
		temp = str[8].trim();
		// 维管费金额
		map.put("WGFMONEY", Double.parseDouble(str[10].trim()));
		// 阶梯信息
		if (str.length > 12) {
			map.put("f_stair1amount", NumberHelper.strToDouble(str[11]));
			map.put("f_stair2amount", NumberHelper.strToDouble(str[12]));
			map.put("f_stair3amount", NumberHelper.strToDouble(str[13]));

			map.put("f_stair1price", NumberHelper.strToDouble(str[14]));
			map.put("f_stair2price", NumberHelper.strToDouble(str[15]));
			map.put("f_stair3price", NumberHelper.strToDouble(str[16]));

			map.put("f_stair1fee", NumberHelper.strToDouble(str[17]));
			map.put("f_stair2fee", NumberHelper.strToDouble(str[18]));
			map.put("f_stair3fee", NumberHelper.strToDouble(str[19]));
		}
		return map;
	}

	/**
	 * 对账
	 *
	 * @param str
	 * @param map
	 * @return true对账成功，false对账不一致
	 */
	private boolean dui(String[] str, Map<String, Object> map, Map newht,
						StringBuilder sb) {
		boolean result = true;
		// 流水号
		String lsid = str[0].trim();
		if (!lsid.equals(map.get("F_SERIAL_ID"))) {
			log.info("流水号：数据值：" + map.get("F_SERIAL_ID") + ";利安：" + str[0]);
			sb.append("流水号：数据值：" + map.get("F_SERIAL_ID") + ";利安：" + str[0]).append(
					"|");
			newht.put("F_SERIAL_ID", str[0]);
			result = false;
		}
		// 卡号
		String cardId = str[1].trim();
		if (!cardId.equals(map.get("F_CARD_ID"))) {
			log.info("卡号：数据：" + map.get("F_CARD_ID") + ";利安：" + str[1]);
			sb.append("卡号：数据：" + map.get("F_CARD_ID") + ";利安：" + str[1]).append(
					"|");
			newht.put("F_CARD_ID", str[1]);
			result = false;
		}
		// 气量
		double gasLA = Double.parseDouble(str[2].trim());
		double gasCa = Double.parseDouble(map.get("F_PREGAS").toString());
		if (gasLA != gasCa) {
			log.info("气量：数据值：" + map.get("F_PREGAS") + ";利安：" + str[2]);
			sb.append("卡号：数据值：" + map.get("F_PREGAS") + ";利安：" + str[1])
					.append("|");
			newht.put("F_PREGAS", gasLA);
			result = false;
		}
		// 金额
		double moneyLA = Double.parseDouble(str[3].trim());
		double moneyCa = Double.parseDouble(map.get("F_COLLECTION").toString());
		if (moneyLA != moneyCa) {
			log.info("金额：数据值：" + map.get("F_COLLECTION") + ";利安：" + str[3]);
			sb.append("金额：数据值：" + map.get("F_COLLECTION") + ";利安：" + str[3]).append(
					"|");
			newht.put("F_COLLECTION", moneyLA);
			result = false;
		}
		// 操作地点
		if (!str[5].trim().equals(map.get("F_TERMINAL_NUM"))) {
			log.info("操作地点：数据值：" + map.get("F_TERMINAL_NUM") + ";利安：" + str[5]);
			sb.append("操作地点：数据值：" + map.get("F_TERMINAL_NUM") + ";利安：" + str[5])
					.append("|");
			newht.put("F_TERMINAL_NUM", str[5]);
			result = false;
		}
		// 操作员
		if (!str[6].trim().equals(map.get("OP_ID"))) {
			log.info("操作员：数据值：" + map.get("OP_ID") + ";利安：" + str[6]);
			sb.append("操作员：数据值：" + map.get("OP_ID") + ";利安：" + str[6])
					.append("|");
			newht.put("OP_ID", str[6]);
			result = false;
		}
		// 是否成功
		String temp = str[7].trim();
		if (temp.equals("0")) {
			temp = "有效";
		} else{
			temp = "冲正";
		}
		// 如果是冲正，核对
		if (!temp.equals(map.get("F_STATE"))) {
			result = false;
		}
		return result;
	}

	private void writeFile(String content) {
		try {
			if (this.bw == null) {
				String path = FilePath.GetOldFilePath(null) + FileName;
				FileWriter fw = new FileWriter(path);
				this.bw = new BufferedWriter(fw);
				this.bw.write(content);
			} else {
				this.bw.write(content);
			}
			this.bw.newLine();
		} catch (IOException e) {
			throw new RuntimeException("写错误文件失败", e);
		}
	}

	// 删除原文件
	public void delete() throws Exception {
		try {
			File file = new File(Path);
			if (file.isFile() && file.exists()) {
				boolean t = file.delete();
				if (!t) {
					file.deleteOnExit();
				}
			}
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}

	public void copyFile(String oldPath, String newPath) {
		try {
			int bytesum = 0;
			int byteread = 0;
			File oldfile = new File(oldPath);
			if (oldfile.exists()) { // 文件存在时
				InputStream inStream = new FileInputStream(oldPath); // 读入原文件
				FileOutputStream fs = new FileOutputStream(newPath);
				byte[] buffer = new byte[1444];
				int length;
				while ((byteread = inStream.read(buffer)) != -1) {
					bytesum += byteread; // 字节数 文件大小
					System.out.println(bytesum);
					fs.write(buffer, 0, byteread);
				}
				fs.flush();
				fs.close();
				inStream.close();
			}
		} catch (Exception e) {
			System.out.println("复制单个文件操作出错");
			throw new RuntimeException(e);

		}

	}

	@POST
	@Transactional
	@Produces(MediaType.APPLICATION_JSON)
	public String deal(String values) {
		try {
			FileName=values;
			this.readfile();
			return "成功";
		} catch (Exception e) {
			log.error("异常:" + e.getMessage().toString());
			//throw new RuntimeException();
			return "失败";
		}

	}

}
