package com.aote.rs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;


import com.aote.helper.StringHelper;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateTemplate;

public class RFTools {
	@Autowired
	private HibernateTemplate hibernateTemplate;
	private static final Logger log = Logger
			.getLogger(RFTools.class);
	public String saveRF(String str) {
		String result = "{result:'ok'}";
		try {
			Iterator iter = StringHelper.stringToLinkedList(str, '@')
					.iterator();
			String str3 = iter.next().toString();
			JSONObject sale = null;
			// 两种格式解析
			if (str3.startsWith("8888")) {
				sale = RFTools.p8888(iter);
			} else if (str3.startsWith("9999")) {
				RFTools rf = new RFTools();
				sale = rf.p9999(iter);
			}
			// 处理后加数据
			LinkedList data = StringHelper.stringToLinkedList(str, '@');
			String anjiandatas = data.get(data.size() - 1) + "";
			if (!anjiandatas.startsWith("8888")
					&& !anjiandatas.startsWith("9999")) {
				LinkedList anjianlist = StringHelper.stringToLinkedList(
						anjiandatas, '|');
				// <!--安检年数[设置/读取 卡上]-->
				String ajyear = anjianlist.get(0) + "";
				sale.put("ajyear", ajyear);
				// <!--报废年数[设置/读取 卡上]-->
				String bfyear = anjianlist.get(1) + "";
				sale.put("bfyear", bfyear);
				// <!-- 第一档报警气量-->
				String alarm1 = anjianlist.get(2) + "";
				sale.put("alarm1", alarm1);
				// <!-- 第二档报警气量 -->
				String alarm2 = anjianlist.get(3) + "";
				sale.put("alarm2", alarm2);
				// <!--若下面变量都为“0”表示表是老表，没有下面的功能-->
				// <!--安检年数[表反写]-->
				String fxajyear = anjianlist.get(4) + "";
				sale.put("fxajyear", fxajyear);
				// <!--报废年数[表反写]-->
				String fxbfyear = anjianlist.get(5) + "";
				sale.put("fxbfyear", fxbfyear);
				// <!--第一档报警气量[表反写]-->
				String fxalarm1 = anjianlist.get(6) + "";
				sale.put("fxalarm1", fxalarm1);
				// <!--第二档报警气量[表反写]-->
				String fxalarm2 = anjianlist.get(7) + "";
				sale.put("fxalarm2", fxalarm2);
				// <!-- 表已用安检天数-->
				String yiyognajyear = anjianlist.get(8) + "";
				sale.put("yiyognajyear", yiyognajyear);
				// <!-- 表已用报废天数-->
				String yiyongbfyear = anjianlist.get(9) + "";
				sale.put("yiyongbfyear", yiyongbfyear);
				// <!-- 表透支总量-->
				String touzhi = anjianlist.get(10) + "";
				sale.put("touzhi", touzhi);
				// <!-- 表最后处理透支量-->
				String lasttouzhi = anjianlist.get(11) + "";
				sale.put("lasttouzhi", lasttouzhi);
				// <!--表最后处理日期-->

				String lastchulidate = anjianlist.get(12) + "";
				sale.put("lastchulidate", lastchulidate);

			}
			this.hibernateTemplate.save("t_rf_info", sale);
		} catch (Exception e) {
			log.debug("保存射频卡信息错误：" + e.getMessage());
			return result;
		}
		return result;
	}


	/**
	 * 解析8888格式
	 *
	 * @param str
	 * @return
	 */
	public static JSONObject p8888(Iterator iter_all) {
		String str1 = iter_all.next().toString();
		Iterator iter = StringHelper.stringToLinkedList(str1, '|').iterator();
		String priceCopy = "";
		String priceOneCopy = "";
		String gasOneCopy = "";
		String priceTwoCopy = "";
		String gasTwoCopy = "";
		String priceThreeCopy = "";
		String monthTotalCopy = "";
		String newPriceCopy = "";
		String priceModifyDateCopy = "";
		String newPriceOneCopy = "";
		String newGasOneCopy = "";
		String newPriceTwoCopy = "";
		String newGasTwoCopy = "";
		String newPriceThreeCopy = "";

		// 剩余金额 f_zhye
		String zhye = (String) iter.next();
		zhye = zhye.trim();
		// 累计用气量 f_total_gas
		String totalGas = (String) iter.next();
		totalGas = totalGas.trim();
		// 累计购气金额 f_total_gas_account
		String totalGasAccount = (String) iter.next();
		totalGasAccount = totalGasAccount.trim();
		// 购气次数 f_buy_times
		String buyTimes = (String) iter.next();
		buyTimes = buyTimes.trim();
		// 当前气价 f_gas_price
		String gasPrice = (String) iter.next();
		gasPrice = gasPrice.trim();
		// 表时间 f_meter_time
		String meterTime = (String) iter.next();
		meterTime = meterTime.trim();
		// 无用气天数 f_not_use_day
		String notUseDay = (String) iter.next();
		notUseDay = notUseDay.trim();
		// 无用气秒数 f_not_use_second
		String notUseSecond = (String) iter.next();
		notUseSecond = notUseSecond.trim();
		// 防死表功能 f_avoid_dead_meter
		String avoidDeadMeter = (String) iter.next();
		avoidDeadMeter = avoidDeadMeter.trim();
		// 死表天数1 f_dead_meter_day_one
		String deadMeterDayOne = (String) iter.next();
		deadMeterDayOne = deadMeterDayOne.trim();
		// 死表天数2 f_dead_meter_day_two
		String deadMeterDayTwo = (String) iter.next();
		deadMeterDayTwo = deadMeterDayTwo.trim();
		// 限购功能 f_restriction
		String restriction = (String) iter.next();
		restriction = restriction.trim();
		// 限购金额 f_restriction_account
		String restrictionAccount = (String) iter.next();
		restrictionAccount = restrictionAccount.trim();
		// 用户卡号 f_card
		String card = (String) iter.next();
		card = card.trim();
		// 表状态 f_meter_state
		String meterState = (String) iter.next();
		meterState = meterState.trim();
		// 开户标志 f_account_flag
		String accountFlag = (String) iter.next();
		accountFlag = accountFlag.trim();
		// 单价类型 f_price_type
		String priceType = (String) iter.next();
		priceType = priceType.trim();
		double type = Double.parseDouble(priceType);
		if (type == 0) {
			// 单价 f_price
			String price = (String) iter.next();
			price = price.trim();
			priceCopy = price;
		} else {
			// 单价1 f_price_one
			String priceOne = (String) iter.next();
			priceOne = priceOne.trim();
			priceOneCopy = priceOne;
			// 用量1 f_gas_one
			String gasOne = (String) iter.next();
			gasOne = gasOne.trim();
			gasOneCopy = gasOne;
			// 单价2 f_price_two
			String priceTwo = (String) iter.next();
			priceTwo = priceTwo.trim();
			priceTwoCopy = priceTwo;
			// 用量2 f_gas_two
			String gasTwo = (String) iter.next();
			gasTwo = gasTwo.trim();
			gasTwoCopy = gasTwo;
			// 单价3 f_price_three
			String priceThree = (String) iter.next();
			priceThree = priceThree.trim();
			priceThreeCopy = priceThree;
		}
		// 单价修改标志 f_price_modify_flag
		String priceModifyFlag = (String) iter.next();
		priceModifyFlag = priceModifyFlag.trim();
		double type1 = Double.parseDouble(priceModifyFlag);
		if (type == 0 && type1 == 1) {
			// 单价修改日期 f_price_modify_date
			String priceModifyDate = (String) iter.next();
			priceModifyDate = priceModifyDate.trim();
			priceModifyDateCopy = priceModifyDate;
			// 新单价 f_new_price
			String newPrice = (String) iter.next();
			newPrice = newPrice.trim();
			newPriceCopy = newPrice;
		} else if (type == 1 && type1 == 1) {
			// 单价修改日期 f_price_modify_date
			String priceModifyDate = (String) iter.next();
			priceModifyDate = priceModifyDate.trim();
			priceModifyDateCopy = priceModifyDate;
			// 新单价1 f_new_price_one
			String newPriceOne = (String) iter.next();
			newPriceOne = newPriceOne.trim();
			newPriceOneCopy = newPriceOne;
			// 新用量1 f_new_gas_one
			String newGasOne = (String) iter.next();
			newGasOne = newGasOne.trim();
			newGasOneCopy = newGasOne;
			// 新单价2 f_new_price_two
			String newPriceTwo = (String) iter.next();
			newPriceTwo = newPriceTwo.trim();
			newPriceTwoCopy = newPriceTwo;
			// 新用量2 f_new_gas_two
			String newGasTwo = (String) iter.next();
			newGasTwo = newGasTwo.trim();
			newGasTwoCopy = newGasTwo;
			// 新单价3 f_new_price_three
			String newPriceThree = (String) iter.next();
			newPriceThree = newPriceThree.trim();
			newPriceThreeCopy = newPriceThree;
		}
		if (type == 1) {
			// 当前月累计 f_month_total
			String monthTotal = (String) iter.next();
			monthTotal = monthTotal.trim();
			monthTotalCopy = monthTotal;
		}

		// 解析str2
		String str2 = iter_all.next().toString();
		iter = StringHelper.stringToLinkedList(str2, '|').iterator();
		// 所属月份 f_belong_to_month
		String belongToMonth = (String) iter.next();
		belongToMonth = belongToMonth.trim();
		// 月累计量1 f_month_one
		String monthOne = (String) iter.next();
		monthOne = monthOne.trim();
		// 月累计量2 f_month_two
		String monthTwo = (String) iter.next();
		monthTwo = monthTwo.trim();
		// 月累计量3 f_month_three
		String monthThree = (String) iter.next();
		monthThree = monthThree.trim();
		// 月累计量4 f_month_four
		String monthFour = (String) iter.next();
		monthFour = monthFour.trim();
		// 月累计量5 f_month_five
		String monthFive = (String) iter.next();
		monthFive = monthFive.trim();
		// 月累计量6 f_month_six
		String monthSix = (String) iter.next();
		monthSix = monthSix.trim();
		// 月累计量7 f_month_seven
		String monthSeven = (String) iter.next();
		monthSeven = monthSeven.trim();
		// 月累计量8 f_month_eight
		String monthEight = (String) iter.next();
		monthEight = monthEight.trim();
		// 月累计量9 f_month_nine
		String monthNine = (String) iter.next();
		monthNine = monthNine.trim();
		// 月累计量10 f_month_ten
		String monthTen = (String) iter.next();
		monthTen = monthTen.trim();
		// 月累计量11 f_month_eleven
		String monthEleven = (String) iter.next();
		monthEleven = monthEleven.trim();
		// 月累计量12 f_month_twelve
		String monthTwelve = (String) iter.next();
		monthTwelve = monthTwelve.trim();
		// 月累计量13 f_month_thirteen
		String monthThirteen = (String) iter.next();
		monthThirteen = monthThirteen.trim();
		// 月累计量14 f_month_fourteen
		String monthFourteen = (String) iter.next();
		monthFourteen = monthFourteen.trim();
		// 月累计量15 f_month_fifteen
		String monthFifteen = (String) iter.next();
		monthFifteen = monthFifteen.trim();
		// 月累计量16 f_month_sixteen
		String monthSixteen = (String) iter.next();
		monthSixteen = monthSixteen.trim();
		// 月累计量17 f_month_seventeen
		String monthSeventeen = (String) iter.next();
		monthSeventeen = monthSeventeen.trim();
		// 月累计量18 f_month_eighteen
		String monthEighteen = (String) iter.next();
		monthEighteen = monthEighteen.trim();
		// 月累计量19 f_month_nineteen
		String monthNineteen = (String) iter.next();
		monthNineteen = monthNineteen.trim();
		// 月累计量20 f_month_twenty
		String monthTwenty = (String) iter.next();
		monthTwenty = monthTwenty.trim();
		// 月累计量21 f_month_twenty_one
		String monthTwentyOne = (String) iter.next();
		monthTwentyOne = monthTwentyOne.trim();
		// 月累计量22 f_month_twenty_two
		String monthTwentyTwo = (String) iter.next();
		monthTwentyTwo = monthTwentyTwo.trim();
		// 月累计量23 f_month_twenty_three
		String monthTwentyThree = (String) iter.next();
		monthTwentyThree = monthTwentyThree.trim();
		// 月累计量24 f_month_twenty_four
		String monthTwentyFour = (String) iter.next();
		monthTwentyFour = monthTwentyFour.trim();

		JSONObject sale = new JSONObject();
		sale.put("f_zhye", zhye);
		sale.put("f_total_gas", totalGas);
		sale.put("f_total_gas_account", totalGasAccount);
		sale.put("f_buy_times", buyTimes);
		sale.put("f_gas_price", gasPrice);
		sale.put("f_meter_time", meterTime);
		sale.put("f_not_use_day", notUseDay);
		sale.put("f_not_use_second", notUseSecond);
		sale.put("f_avoid_dead_meter", avoidDeadMeter);
		sale.put("f_dead_meter_day_one", deadMeterDayOne);
		sale.put("f_dead_meter_day_two", deadMeterDayTwo);
		sale.put("f_restriction", restriction);
		sale.put("f_restriction_account", restrictionAccount);
		sale.put("f_card", card);
		sale.put("f_meter_state", meterState);
		sale.put("f_account_flag", accountFlag);
		sale.put("f_price_type", priceType);
		sale.put("f_price", priceCopy);
		sale.put("f_price_one", priceOneCopy);
		sale.put("f_gas_one", gasOneCopy);
		sale.put("f_price_two", priceTwoCopy);
		sale.put("f_gas_two", gasTwoCopy);
		sale.put("f_price_three", priceThreeCopy);
		sale.put("f_price_modify_flag", priceModifyFlag);
		sale.put("f_price_modify_date", priceModifyDateCopy);
		sale.put("f_new_price", newPriceCopy);
		sale.put("f_new_price_one", newPriceOneCopy);
		sale.put("f_new_gas_one", newGasOneCopy);
		sale.put("f_new_price_two", newPriceTwoCopy);
		sale.put("f_new_gas_two", newGasTwoCopy);
		sale.put("f_new_price_three", newPriceThreeCopy);
		sale.put("f_month_total", monthTotalCopy);
		sale.put("f_belong_to_month", belongToMonth);
		sale.put("f_month_one", monthOne);
		sale.put("f_month_two", monthTwo);
		sale.put("f_month_three", monthThree);
		sale.put("f_month_four", monthFour);
		sale.put("f_month_five", monthFive);
		sale.put("f_month_six", monthSix);
		sale.put("f_month_seven", monthSeven);
		sale.put("f_month_eight", monthEight);
		sale.put("f_month_nine", monthNine);
		sale.put("f_month_ten", monthTen);
		sale.put("f_month_eleven", monthEleven);
		sale.put("f_month_twelve", monthTwelve);
		sale.put("f_month_thirteen", monthThirteen);
		sale.put("f_month_fourteen", monthFourteen);
		sale.put("f_month_fifteen", monthFifteen);
		sale.put("f_month_sixteen", monthSixteen);
		sale.put("f_month_seventeen", monthSeventeen);
		sale.put("f_month_eighteen", monthEighteen);
		sale.put("f_month_nineteen", monthNineteen);
		sale.put("f_month_twenty", monthTwenty);
		sale.put("f_month_twenty_one", monthTwentyOne);
		sale.put("f_month_twenty_two", monthTwentyTwo);
		sale.put("f_month_twenty_three", monthTwentyThree);
		sale.put("f_month_twenty_four", monthTwentyFour);
		return sale;
	}

	/***
	 * 解析9999格式
	 *
	 * @param iter_all
	 * @return
	 */
	public static JSONObject p9999(Iterator iter_all) {
		String str1 = iter_all.next().toString();
		String[] strs = str1.split("\\|");
		Iterator iter = StringHelper.stringToLinkedList(str1, '|').iterator();
		JSONObject sale = new JSONObject();
		// 剩余金额 f_zhye
		String zhye = (String) iter.next();
		zhye = zhye.trim();
		// 累计用气量 f_total_gas
		String totalGas = (String) iter.next();
		totalGas = totalGas.trim();
		// 累计购气金额 f_total_gas_account
		String totalGasAccount = (String) iter.next();
		totalGasAccount = totalGasAccount.trim();
		// 购气次数 f_buy_times
		String buyTimes = (String) iter.next();
		buyTimes = buyTimes.trim();
		// 当前气价 f_gas_price
		String gasPrice = (String) iter.next();
		gasPrice = gasPrice.trim();
		// 表时间 f_meter_time
		String meterTime = (String) iter.next();
		meterTime = meterTime.trim();
		// 无用气天数 f_not_use_day
		String notUseDay = (String) iter.next();
		notUseDay = notUseDay.trim();
		// 无用气秒数 f_not_use_second
		String notUseSecond = (String) iter.next();
		notUseSecond = notUseSecond.trim();
		// 防死表功能 f_avoid_dead_meter
		String avoidDeadMeter = (String) iter.next();
		avoidDeadMeter = avoidDeadMeter.trim();
		// 死表天数1 f_dead_meter_day_one
		String deadMeterDayOne = (String) iter.next();
		deadMeterDayOne = deadMeterDayOne.trim();
		// 死表天数2 f_dead_meter_day_two
		String deadMeterDayTwo = (String) iter.next();
		deadMeterDayTwo = deadMeterDayTwo.trim();
		// 限购功能 f_restriction
		String restriction = (String) iter.next();
		restriction = restriction.trim();
		// 限购金额 f_restriction_account
		String restrictionAccount = (String) iter.next();
		restrictionAccount = restrictionAccount.trim();
		// 用户卡号 f_card
		String card = (String) iter.next();
		card = card.trim();
		// 表状态 f_meter_state
		String meterState = (String) iter.next();
		meterState = meterState.trim();
		// 开户标志 f_account_flag
		String accountFlag = (String) iter.next();
		accountFlag = accountFlag.trim();
		// 单价类型 f_price_type
		String priceType = (String) iter.next();
		priceType = priceType.trim();
		double type = Double.parseDouble(priceType);
		// 单价修改标志 f_price_modify_flag
		String priceModifyFlag = (String) iter.next();
		priceModifyFlag = priceModifyFlag.trim();
		double type1 = Double.parseDouble(priceModifyFlag);
		// 单价修改日期(YY-MM-dd HH)
		String priceModifyDate = (String) iter.next();
		priceModifyDate = priceModifyDate.trim();
		sale.put("f_meter_state", meterState);
		sale.put("f_account_flag", accountFlag);
		sale.put("f_price_type", priceType);
		sale.put("f_price_modify_flag", priceModifyFlag);
		sale.put("f_price_modify_date", priceModifyDate);
		String price = "";
		String newprice = "";
		if (type == 0 && type1 == 0) {
			// 单价 f_price
			price = (String) iter.next();
			price = price.trim();
		} else if (type == 0 && type1 == 1) {
			// 单价 f_price
			price = (String) iter.next();
			price = price.trim();
			// 新单价
			newprice = (String) iter.next();
			newprice = newprice.trim();
		} else if (type == 1) {
			// 开始处理启用日期，只要解析字符串中含有-，认为是启用
			int jtQiYongNum = Integer.parseInt(iter.next().toString(), 16);
			for (int i = 1; i <= jtQiYongNum; i++) {
				String str = (String) iter.next();
				sale.put("f_date_" + i, str);
			}

			// 日期启用个数
			int count = Integer.parseInt(iter.next() + "");

			// 单价
			for (int i = 1; i <= count; i++) {
				//兼容以前的，第一个没有数字名字
				if(i==1)
				{
					sale.put("f_price_one", iter.next());
					sale.put("f_gas_one", iter.next());
					sale.put("f_price_two", iter.next());
					sale.put("f_gas_two", iter.next());
					sale.put("f_price_three", iter.next());
					//sale.put("f_gas_three", iter.next());
					if(type1==1)
					{
						sale.put("f_new_price_one", iter.next());
						sale.put("f_new_gas_one", iter.next());
						sale.put("f_new_price_two", iter.next());
						sale.put("f_new_gas_two", iter.next());
						sale.put("f_new_price_three", iter.next());
						//sale.put("f_new_gas_three", iter.next());
					}				}
				else
				{
					sale.put("f_price_one"+i, iter.next());
					sale.put("f_gas_one"+i, iter.next());
					sale.put("f_price_two"+i, iter.next());
					sale.put("f_gas_two"+i, iter.next());
					sale.put("f_price_three"+i, iter.next());
					//sale.put("f_gas_three"+i, iter.next());

					if(type1==1)	{
						sale.put("f_new_price_one"+i, iter.next());
						sale.put("f_new_gas_one"+i, iter.next());
						sale.put("f_new_price_two"+i, iter.next());
						sale.put("f_new_gas_two"+i, iter.next());
						sale.put("f_new_price_three"+i, iter.next());
						//sale.put("f_new_gas_three"+i, iter.next());
					}
				}
			}

			// 当前月累计
			sale.put("f_month_total", iter.next());
		}

		// 解析str2
		String str2 = iter_all.next().toString();
		iter = StringHelper.stringToLinkedList(str2, '|').iterator();
		// 所属月份 f_belong_to_month
		String belongToMonth = (String) iter.next();
		belongToMonth = belongToMonth.trim();
		// 月累计量1 f_month_one
		String monthOne = (String) iter.next();
		monthOne = monthOne.trim();
		// 月累计量2 f_month_two
		String monthTwo = (String) iter.next();
		monthTwo = monthTwo.trim();
		// 月累计量3 f_month_three
		String monthThree = (String) iter.next();
		monthThree = monthThree.trim();
		// 月累计量4 f_month_four
		String monthFour = (String) iter.next();
		monthFour = monthFour.trim();
		// 月累计量5 f_month_five
		String monthFive = (String) iter.next();
		monthFive = monthFive.trim();
		// 月累计量6 f_month_six
		String monthSix = (String) iter.next();
		monthSix = monthSix.trim();
		// 月累计量7 f_month_seven
		String monthSeven = (String) iter.next();
		monthSeven = monthSeven.trim();
		// 月累计量8 f_month_eight
		String monthEight = (String) iter.next();
		monthEight = monthEight.trim();
		// 月累计量9 f_month_nine
		String monthNine = (String) iter.next();
		monthNine = monthNine.trim();
		// 月累计量10 f_month_ten
		String monthTen = (String) iter.next();
		monthTen = monthTen.trim();
		// 月累计量11 f_month_eleven
		String monthEleven = (String) iter.next();
		monthEleven = monthEleven.trim();
		// 月累计量12 f_month_twelve
		String monthTwelve = (String) iter.next();
		monthTwelve = monthTwelve.trim();
		// 月累计量13 f_month_thirteen
		String monthThirteen = (String) iter.next();
		monthThirteen = monthThirteen.trim();
		// 月累计量14 f_month_fourteen
		String monthFourteen = (String) iter.next();
		monthFourteen = monthFourteen.trim();
		// 月累计量15 f_month_fifteen
		String monthFifteen = (String) iter.next();
		monthFifteen = monthFifteen.trim();
		// 月累计量16 f_month_sixteen
		String monthSixteen = (String) iter.next();
		monthSixteen = monthSixteen.trim();
		// 月累计量17 f_month_seventeen
		String monthSeventeen = (String) iter.next();
		monthSeventeen = monthSeventeen.trim();
		// 月累计量18 f_month_eighteen
		String monthEighteen = (String) iter.next();
		monthEighteen = monthEighteen.trim();
		// 月累计量19 f_month_nineteen
		String monthNineteen = (String) iter.next();
		monthNineteen = monthNineteen.trim();
		// 月累计量20 f_month_twenty
		String monthTwenty = (String) iter.next();
		monthTwenty = monthTwenty.trim();
		// 月累计量21 f_month_twenty_one
		String monthTwentyOne = (String) iter.next();
		monthTwentyOne = monthTwentyOne.trim();
		// 月累计量22 f_month_twenty_two
		String monthTwentyTwo = (String) iter.next();
		monthTwentyTwo = monthTwentyTwo.trim();
		// 月累计量23 f_month_twenty_three
		String monthTwentyThree = (String) iter.next();
		monthTwentyThree = monthTwentyThree.trim();
		// 月累计量24 f_month_twenty_four
		String monthTwentyFour = (String) iter.next();
		monthTwentyFour = monthTwentyFour.trim();

		sale.put("f_zhye", zhye);
		sale.put("f_total_gas", totalGas);
		sale.put("f_total_gas_account", totalGasAccount);
		sale.put("f_buy_times", buyTimes);
		sale.put("f_gas_price", gasPrice);
		sale.put("f_meter_time", meterTime);
		sale.put("f_not_use_day", notUseDay);
		sale.put("f_not_use_second", notUseSecond);
		sale.put("f_avoid_dead_meter", avoidDeadMeter);
		sale.put("f_dead_meter_day_one", deadMeterDayOne);
		sale.put("f_dead_meter_day_two", deadMeterDayTwo);
		sale.put("f_restriction", restriction);
		sale.put("f_restriction_account", restrictionAccount);
		sale.put("f_card", card);
		sale.put("f_price", price);
		sale.put("f_new_price", newprice);
		sale.put("f_belong_to_month", belongToMonth);
		sale.put("f_month_one", monthOne);
		sale.put("f_month_two", monthTwo);
		sale.put("f_month_three", monthThree);
		sale.put("f_month_four", monthFour);
		sale.put("f_month_five", monthFive);
		sale.put("f_month_six", monthSix);
		sale.put("f_month_seven", monthSeven);
		sale.put("f_month_eight", monthEight);
		sale.put("f_month_nine", monthNine);
		sale.put("f_month_ten", monthTen);
		sale.put("f_month_eleven", monthEleven);
		sale.put("f_month_twelve", monthTwelve);
		sale.put("f_month_thirteen", monthThirteen);
		sale.put("f_month_fourteen", monthFourteen);
		sale.put("f_month_fifteen", monthFifteen);
		sale.put("f_month_sixteen", monthSixteen);
		sale.put("f_month_seventeen", monthSeventeen);
		sale.put("f_month_eighteen", monthEighteen);
		sale.put("f_month_nineteen", monthNineteen);
		sale.put("f_month_twenty", monthTwenty);
		sale.put("f_month_twenty_one", monthTwentyOne);
		sale.put("f_month_twenty_two", monthTwentyTwo);
		sale.put("f_month_twenty_three", monthTwentyThree);
		sale.put("f_month_twenty_four", monthTwentyFour);
		return sale;
	}
}
