package com.aote.rs;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.transaction.Transactional;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

/**
 * @author szm
 *
 */
@SuppressWarnings("deprecation")
@Transactional
public class LastUser {

	static Logger log = Logger.getLogger(LastUser.class);
	@Autowired
	private HibernateTemplate hibernateTemplate;

	public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}

	String serviceEpr = "/rs/sql/UserResetData";
	String Updatestr = "/rs/logic/updateBackups";
	/**
	 * 1.设置 【同步地址】 单值 ，获取服务器地址
	 * 2.设置 【最后档案同步日期】 单值 ，每次同步从单值到 当前日期，同步结束更新单值内容为当天，便于下次同步
	 * 3.定时器设置在 applicationContext.xml 执行invoke()方法
	 */
	public void invoke() {
		try {
			log.debug("开始同步数据");
			//获取访问地址，最后档案同步时间
			String url = getSingleValueByName("同步地址");
			String beginDate = getSingleValueByName("最后档案同步日期");
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			java.util.Date date = new java.util.Date();
			String endDate = sdf.format(date);

			// 调用接口访问
			String ret = callWebServiceByAixs(url, beginDate,endDate,serviceEpr);
			JSONArray array = new JSONArray(ret);
//			System.out.print(array.length());
			for (int i = 0; i < array.length(); i++) {
				JSONObject obj = array.getJSONObject(i);

				if(obj.get("f_changetype").toString().equals("添加")||obj.get("f_sell_changetype").toString().equals("添加"))
				{
					String userid = getUserinfoidName();
					//插入户档案信息
					Map user1 = InsertUserInfo(obj,userid);
					log.debug("添加户档案信息Map:"+user1);
					this.hibernateTemplate.save("t_userinfo", user1);
					//插入表档案信息

					Map userfiles = InsertUserFiles(obj,userid);
					log.debug("添加表档案信息   Map:"+userfiles);
					this.hibernateTemplate.save("t_userfiles", userfiles);
					//插入设备信息
					InsertDevices(obj,userid);
					UpdateWebService(url,beginDate,endDate,obj.get("oldid").toString().trim(),obj.get("sell_id").toString(),Updatestr);
				}
				else if((obj.get("f_changetype").toString()).equals("修改")||obj.get("f_sell_changetype").toString().equals("修改"))
				{
					//更新户档案信息
					String sql=UpdateUserInfo(obj);
					sql =  sql.substring(0,sql.length()-1) + " where oldid='"+obj.get("oldid")+"'";
					log.debug("更新户档案信息   sql:"+sql);
					this.hibernateTemplate.bulkUpdate(sql);
					//更新表档案信息
					String filessql=UpdateUserFiles(obj);
					filessql = filessql.substring(0,filessql.length()-1) + " where oldid='"+obj.get("oldid")+"'";
					log.debug("更新表档案信息   sql:"+filessql);
					this.hibernateTemplate.bulkUpdate(filessql);
					UpdateWebService(url,beginDate,endDate,obj.get("oldid").toString().trim(),obj.get("sell_id").toString(),Updatestr);
				}
			}

			log.debug("更新档案信息结束，更新单值【最后档案同步日期】便于下次同步");
			String sql = "update t_singlevalue  set value='" + endDate
					+ "' where name='最后档案同步日期'";
			this.hibernateTemplate.bulkUpdate(sql);
			log.debug("同步数据结束");
		} catch (DataAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.debug(e.toString());
		}
	}

	/**
	 *
	 * JSONObject进行迭代取出key值，并取出相应key的value值，
	 * 放入Map对象中并返回，执行保存
	 */


	@SuppressWarnings("unchecked")
	public static Map InsertUserInfo(JSONObject obj , String userid)
	{
		Map user = new HashMap();
		 try {

			//唯一标识
			user.put("version", 1);
			user.put("f_userinfo_code", obj.get("card_id").toString());
			//2.用户状态
			user.put("f_user_state", obj.get("f_state").toString());
			//3.用户账户结余
			user.put("f_balance",   new BigDecimal("0"));
			//4.缴费类型
			user.put("f_cost_type", "现金缴费");
			//5.用户姓名/单位名称
			user.put("f_user_name", obj.get("f_unit").toString());
			user.put("f_address", obj.get("f_unitaddr").toString()) ;
				//34.地址(详细地址,针对非民用)
			user.put("f_address_detail", obj.get("f_unitaddr").toString());
			//7.区域
			user.put("f_area", "长安区");
			//8.街道
			if(!"null".equals(obj.get("f_road").toString())){
				user.put("f_street", obj.get("f_road").toString());
			}
			//用气区域
			if(!"null".equals(obj.get("f_gasarea").toString())){
				user.put("f_gas_area", obj.get("f_gasarea").toString());
			}
			//用气点
			if(!"null".equals(obj.get("f_area").toString())){
				user.put("f_point_name", obj.get("f_area").toString());
			}
			//8.街道

			//9.小区
			if(!"null".equals(obj.get("unit_name").toString())){
				user.put("f_residential_area", obj.get("unit_name").toString());
			}
			//10.单元号
			if(!"null".equals(obj.get("cus_dy").toString())&& ! " ".equals(obj.get("cus_dy").toString())){
				user.put("f_unit", obj.get("cus_dy").toString());
			}
			//11.楼号
			if(!"null".equals(obj.get("cus_dom").toString())){
				user.put("f_building", obj.get("cus_dom").toString());
			}
			//12.楼层
			if(!"null".equals(obj.get("cus_floor").toString())){
				user.put("f_floor", obj.get("cus_floor").toString());
			}
			//13.门牌号
			if(!"null".equals(obj.get("cus_room").toString()) && ! " ".equals(obj.get("cus_dy").toString())){
				user.put("f_room", obj.get("cus_room").toString());
			}
			user.put("f_credentials", "身份证");
			//15.证件号码
			if(!"null".equals(obj.get("user_idnumber").toString())){
				user.put("f_idnumber", obj.get("user_idnumber").toString());
			}
			//16.电话
			user.put("f_user_phone", obj.get("user_link").toString());
			//17.用户类型
			user.put("f_user_type", obj.get("f_usertype").toString());
			//18.用气性质
			user.put("f_gasproperties", obj.get("f_gasequipment").toString());
			//19.建档日期
			if(!"null".equals(obj.get("cus_date").toString())){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				java.util.Date date = sdf.parse(obj.get("cus_date").toString());
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_createfile_date", datetime);
			}else{
				java.util.Date date = new java.util.Date();
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_createfile_date", datetime);
			}

			//20.建档人
			user.put("f_operator", obj.get("op_code").toString());
			//22.营业网点
			user.put("f_outlets", obj.get("op_depart").toString());
			//23.分公司
			user.put("f_filiale", "长安天然气");
			//24.合同编号
			if(!"null".equals(obj.get("gq_htbh").toString())){
				user.put("f_contract_id", obj.get("gq_htbh").toString());
			}
			//25.纳税人识别号
			if(!"null".equals(obj.get("taxcode").toString())){
				user.put("f_taxpayer_id", obj.get("taxcode").toString());
			}
			//26.地址电话
			if(!"null".equals(obj.get("user_link").toString())){
				user.put("f_address_phone", obj.get("user_link").toString());
			}
			//27.名称
			if(!"null".equals(obj.get("bankaccount").toString())){
				user.put("f_paper_name", obj.get("bankaccount").toString());
			}
			//28.开户行及账号
			if(!"null".equals(obj.get("bankaccount").toString())){
				user.put("f_paper_account", obj.get("bankaccount").toString());
			}
			//29.票据类型
				user.put("f_paper_type", "电子票");
			//30.微信绑定标识
				if(!"null".equals(obj.get("f_open_id").toString())){
					user.put("f_open_id", obj.get("f_open_id").toString());
				}
			//31.备注信息
			if(!"null".equals(obj.get("f_reamk").toString())){
				user.put("f_reason",  obj.get("f_reamk").toString());
			}
			//32.oldid
			user.put("oldid", obj.get("oldid").toString());
			//33.实际账户结余(现有账户结余 - 欠费金额)
			user.put("f_real_balance", new BigDecimal("0"));
			//35.片区
			user.put("f_slice_area", obj.get("f_ic_distinct").toString());
			//36.租户电话
			user.put("f_rent_phone", obj.get("f_areaphone").toString());
			//37.调压箱
			if(!"null".equals(obj.get("tank_code").toString())){
				user.put("f_adjustable_id", Integer.parseInt(obj.get("tank_code").toString())  );
			}

//			//38.人口数
//			user.put("f_people_num", 0);
			//39.组织机构
			user.put("f_orgstr", null);
			//40.applyid对应报建id
			if(!"null".equals(obj.get("applyid").toString())){
				user.put("applyid", obj.get("applyid").toString());
			}
			//41.安装户
				user.put("f_installnum", null);
			//42.申请人姓名
				user.put("f_petitionuser",  obj.get("userlevel_type").toString());
			//43.报建编号
			if(!"null".equals(obj.get("applycode").toString())){
				user.put("f_applycode", obj.get("applycode").toString());
			}
			//44.气价编号
			String priceid= getPriceId(obj);
			if(!priceid.equals("")){
				user.put("f_price_id",Integer.parseInt(priceid));
			}
			//45.最后安检日期
			user.put("f_last_check_date", null);
			//46.最后安检状态
			user.put("f_last_check_state", null);
			//47.公司机构id(单独的分公司id)
			user.put("f_filialeid", 0);
			//48.公司机构id(单独的分公司id)
			user.put("f_filialeids", "150.");
			//49.银行
			user.put("infobank", null);
			//50.报建流程编号
			user.put("f_process_id", null);
			//51.用户剩余气量
			user.put("f_userinfo_balance_gas", 0);
			//52.地址机构 (单独的分公司id)
			user.put("f_address_str", null);
			//53.门牌号
			user.put("f_room_id", null);
			//54.联系人
			user.put("f_linkname", obj.get("f_linkname").toString());
		    } catch (Exception e) {
		          log.debug(e.toString());
			}

		return user;
	}


	public  Map InsertUserFiles(JSONObject obj,String userid)
	{
		 Map user = new HashMap();
		 try {
			//1.版本号
			user.put("version", 1);
			//2.用户编号
			user.put("f_userinfo_id", Integer.toString((Integer.parseInt(userid)+1)));
			//3.表安装位置
			user.put("f_position", obj.get("f_basetablelocal").toString());
			//4.气表底数
			if("null".equals(obj.get("f_tablemargin").toString())){
				user.put("f_meter_base", new BigDecimal("0"));
			}else{
				user.put("f_meter_base", new BigDecimal(obj.get("f_tablemargin").toString()));
			}
			if("null".equals(obj.get("f_tablemargin").toString())){
				user.put("f_real_base", new BigDecimal("0"));
			}else{
				user.put("f_real_base", new BigDecimal(obj.get("f_tablemargin").toString()));
			}

			//5.初始气表底数
			if("null".equals(obj.get("f_basetablenum").toString())){
				user.put("f_initial_base", new BigDecimal("0"));
			}else{
				user.put("f_initial_base", new BigDecimal(obj.get("f_basetablenum").toString()));
			}
			//6.表号
			user.put("f_meternumber", obj.get("f_tablesn").toString()) ;
			//7.条码号
			user.put("f_barcode", obj.get("f_barcode").toString());
			//8.卡号
			if(!"null".equals(obj.get("f_icsn").toString())){
				user.put("f_card_id", obj.get("f_icsn").toString());
			}
			//9.左 右 表
			if(!"null".equals(obj.get("table_spot").toString())){
				user.put("f_aroundmeter", obj.get("table_spot").toString());
			}
			//10.卡密码
				user.put("f_card_password",null);
			//11.写卡次数
				if(!"null".equals(obj.get("buy_count").toString())){
					user.put("f_times", Integer.parseInt(obj.get("buy_count").toString()));
				}else{
					user.put("f_times", 0);
				}

			//12.是否发卡
			user.put("f_whether_hairpin", "是");
			//13.气表分类
			user.put("f_meter_classify", obj.get("f_basetablesn").toString());
			//14.气价关联id
			String priceid= getPriceId(obj);
			if(!priceid.equals("")){
				user.put("f_price_id",Integer.parseInt(priceid));
			}
			//15.抄表员
			user.put("f_inputtor", obj.get("f_screeners").toString());
			//16.表状态（物联表状态是待发送/已发送/正常/停用）
			user.put("f_table_state", "启用");
			//17.录入日期
			if(!"null".equals(obj.get("f_intotime").toString())){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				java.util.Date date = sdf.parse(obj.get("f_intotime").toString());
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_input_date", datetime);
			}else{
				java.util.Date date = new java.util.Date();
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_input_date", datetime);
			}
			//18.气表品牌关联id
			String gasbrandid= getGasbrandId(obj);
			if(!gasbrandid.equals("")){
				user.put("f_gasbrand_id", Integer.parseInt(gasbrandid));
			}
			//19.气表型号关联id
			String gasmodelid= getGasmodelId(obj);
			if(!gasmodelid.equals("")){
				user.put("f_gasmodel_id", Integer.parseInt(gasmodelid));
			}
			//21.通气日期
			//19.点火日期
			if(!"null".equals(obj.get("f_runtime").toString())){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				java.util.Date date = sdf.parse(obj.get("f_runtime").toString());
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_fire_date", datetime);
			}else{
				java.util.Date date = new java.util.Date();
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_fire_date", datetime);
			}
			//22.通气人
			user.put("f_gas_person", null);
			//23.安装人
				user.put("f_install_person", null);
			//24.表营业网点
			user.put("f_outlets", obj.get("op_depart").toString());
			//25.表分公司
			user.put("f_filiale", "长安天然气");
//			//26.剩余补气量
			user.put("f_remanent_gas", new BigDecimal("0"));
			//27表用户类型
			user.put("f_user_type", obj.get("user_type").toString());
			//28.表用气性质
			user.put("f_gasproperties", obj.get("user_equipment").toString());
			//29.点火状态
			user.put("f_fire_state", "是");
			//30.oldid
			user.put("oldid", obj.get("oldid").toString());
			//31.表累购气量
			if("null".equals(obj.get("table_sum_gas").toString())){
				user.put("f_total_gas", new BigDecimal("0"));
			}else{
				user.put("f_total_gas", new BigDecimal(obj.get("table_sum_gas").toString()));
			}
			//32.表累购金额
			user.put("f_total_fee", new BigDecimal("0"));
			//33.户总累购气量
			//34.户总累购金额
			user.put("f_user_total_fee", new BigDecimal("0"));
			//35.总表ID
			user.put("f_meter_id", null);
			//36.总分表类型
			user.put("f_totalsplit_type", null);
			//37.承担系数
			user.put("f_share_ratio", new BigDecimal("0"));
			//38.表封号
			user.put("f_metertitles", obj.get("biaofeng").toString());
			//39.用户号
			user.put("f_meterid", null);
			//40.阀门状态（开阀/关阀）
			user.put("f_valve_state", null);
			//41.组织机构
			user.put("f_orgstr", null);
			//42.安装日期
			user.put("f_install_date", null);
			//43.通气人2
			user.put("f_gas_person_2", null);
			//44.通气日期2
			if(!"null".equals(obj.get("startdate2").toString())){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				java.util.Date date = sdf.parse(obj.get("startdate2").toString());
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_gas_date_2", datetime);
			}else{
				user.put("f_gas_date_2", null);
			}

			//45.改管人
			user.put("f_changetube_person", null);
			//46.改管日期
			user.put("f_changetube_date", null);
			//47.表具图片
			user.put("f_picture", null);
			//48.剩余气量
			user.put("f_balance_gas", new BigDecimal("0"));
			//49.显示方式
			user.put("f_show_way", "按气量");
			//50.发送状态
			user.put("f_sendsuccess", null);
			//51.剩余金额
			user.put("f_balance_amount", new BigDecimal("0"));
			//52.阶梯1气量
			//user.put("f_stair1_amount", obj.get("f_stair1_amount").toString());
			//53.阶梯2气量
			///user.put("f_stair2_amount", obj.get("f_stair2_amount").toString());
			//54.限购气量
			//user.put("f_purchaselimit", new BigDecimal( obj.get("f_customgas").toString()));
			//55.混合比率
			//user.put("f_price_ratio",  obj.get("f_myfenzhi").toString());
			//56.净气量
			user.put("f_input_gas", null);
			//长安新增字段
			//1.表上期量

			//2.卡上期量
			if("null".equals(obj.get("f_icmargin").toString())){
				user.put("f_icmargin", new BigDecimal("0"));
			}else{
				user.put("f_icmargin", new BigDecimal(obj.get("f_icmargin").toString()));
			}
			//3.是否是周检表
			user.put("f_weekcheck",  obj.get("f_weekcheck").toString());
			//4.周检表表号
			user.put("f_weekchecksn",  obj.get("f_weekchecksn").toString());
			//5.周检表安装时间
			if(!"null".equals(obj.get("f_weekchecktime").toString())){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				java.util.Date date = sdf.parse(obj.get("f_weekchecktime").toString());
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_weekchecktime", datetime);
			}else{
				user.put("f_weekchecktime", null);
			}
			//6.周检表 安装时底数
			if("null".equals(obj.get("f_weekchecknum").toString())){
				user.put("f_weekchecknum", new BigDecimal("0"));
			}else{
				user.put("f_weekchecknum", new BigDecimal(obj.get("f_weekchecknum").toString()));
			}
//			//7.周检表 IC卡号
			if(!"null".equals(obj.get("f_weekcheckicsn").toString())){
				user.put("f_weekcheckicsn",  obj.get("f_weekcheckicsn").toString());
			}
			//8.周期表读数
			if("null".equals(obj.get("f_weekcheckdishu").toString())){
				user.put("f_weekcheckdishu", new BigDecimal("0"));
			}else{
				user.put("f_weekcheckdishu", new BigDecimal(obj.get("f_weekcheckdishu").toString()));
			}
			//9.周检表 IC卡读
			if("null".equals(obj.get("f_weekcheckicdishu").toString())){
				user.put("f_weekcheckicdishu", new BigDecimal("0"));
			}else{
				user.put("f_weekcheckicdishu", new BigDecimal(obj.get("f_weekcheckicdishu").toString()));
			}
			//10.周检表安装时IC余量
			if("null".equals(obj.get("f_weekcheckicnum").toString())){
				user.put("f_weekcheckicnum", new BigDecimal("0"));
			}else{
				user.put("f_weekcheckicnum", new BigDecimal(obj.get("f_weekcheckicnum").toString()));
			}
			//11.上次抄表时间
			if(!"null".equals(obj.get("f_lasttimecb").toString())){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				java.util.Date date = sdf.parse(obj.get("f_lasttimecb").toString());
				java.sql.Date datetime = new java.sql.Date(date.getTime());
				user.put("f_lasttimecb", datetime);
			}else{
				user.put("f_lasttimecb", null);
			}
			//12.上次剩余金额
			if("null".equals(obj.get("f_iclastmoney").toString())){
				user.put("f_iclastmoney", new BigDecimal("0"));
			}else{
				user.put("f_iclastmoney", new BigDecimal(obj.get("f_iclastmoney").toString()));
			}
			//13.表前球阀钢丝锁
			user.put("f_biaoqianqiu",  obj.get("f_biaoqianqiu").toString());
			//14.表后球阀钢丝锁
			user.put("f_biaohouqiu",  obj.get("f_biaohouqiu").toString());
			//15.计量表钢丝锁
			user.put("f_jiliangbiaosuo",  obj.get("f_jiliangbiaosuo").toString());
			//16.表拿子卡锁
			user.put("f_biaokasuo",  obj.get("f_biaokasuo").toString());
			//17.计数器卡锁
			user.put("f_jishuqisuo",  obj.get("f_jishuqisuo").toString());
			//18.表具误差值
			if("null".equals(obj.get("f_tablewitherrorvalue").toString())){
				user.put("f_tablewitherrorvalue", new BigDecimal("0"));
			}else{
				user.put("f_tablewitherrorvalue", new BigDecimal(obj.get("f_tablewitherrorvalue").toString()));
			}
			//19.上次购气未充值
			if("null".equals(obj.get("f_nogasvalue").toString())){
				user.put("f_nogasvalue", new BigDecimal("0"));
			}else{
				user.put("f_nogasvalue", new BigDecimal(obj.get("f_nogasvalue").toString()));
			}
			//20.是否ic卡
			user.put("f_isic",  obj.get("f_isic").toString());
		    } catch (Exception e) {
		          e.printStackTrace();
		          log.debug(e.toString());
			}
		return user;
	}

	public void  InsertDevices(JSONObject obj,String userid)
	{
		java.util.Date date = new java.util.Date();
		java.sql.Date datetime = new java.sql.Date(date.getTime());
		try {

				 Map device = new HashMap();
				 device.put("f_devices_type", obj.get("user_equipment").toString());
				 device.put("f_devices_state", "正常");
//				 device.put("f_install_date", datetime);
//				 device.put("f_operate_date", datetime);
//				 device.put("f_userinfo_id", userid);
				 device.put("f_userinfo_id", Integer.toString((Integer.parseInt(userid)+1)));
				 device.put("oldid", obj.get("oldid").toString());
				 device.put("f_ratedflow", obj.get("f_ratedflow").toString());
				 device.put("f_consumption", obj.get("f_consumption").toString());
				 device.put("f_equipmentload", obj.get("f_equipmentload").toString());
				 device.put("f_daytime", obj.get("f_daytime").toString());
				 log.debug("添加采暖炉   Map:"+device);
				 this.hibernateTemplate.save("t_devices", device);

		} catch (Exception e) {
	          e.printStackTrace();
	          log.debug(e.toString());
		}
	}


	private void execSQL(final String sql) {
        hibernateTemplate.execute(new HibernateCallback() {
            public Object doInHibernate(Session session)
                    throws HibernateException {
                session.createSQLQuery(sql).executeUpdate();
                return null;
            }
        });
	}

	/**
	 * JSONObject进行迭代取出key值，并取出相应key的value值，
	 * 进行拼接sql并返回执行修改
	 */
	public static String UpdateUserInfo(JSONObject obj)
	{
		//气价关联id
		String priceid= getPriceId(obj);
		String sql = "update t_userinfo  set ";
		 try {

			 	//1.唯一标识  		version
				//21.用户编号 	f_userinfo_id
				//2.用户状态	 	f_user_state
				//3.用户账户结余  		f_balance
				//4.缴费类型  		f_cost_type
				//5.用户姓名/单位名称   	f_user_name
//				if(!"null".equals(obj.get("f_state").toString())){
//			 		sql = sql + "f_user_state ='" +obj.get("f_state").toString()+"',";
//				}
			 	if(!"null".equals(obj.get("f_unit").toString())){
			 		sql = sql + "f_user_name ='" +obj.get("f_unit").toString()+"',";
				}
			 	if(!"null".equals(obj.get("use_flag").toString())){
			 		sql = sql + "f_user_state ='" +obj.get("f_state").toString()+"',";
				}

			 		//6.地址  	f_address
				 	if(!"null".equals(obj.get("f_unitaddr").toString())){
				 		sql = sql + "f_address ='" +obj.get("f_unitaddr").toString()+"',";
				 	}
					//34.地址(详细地址,针对非民用)		f_address_detail
					if(!"null".equals(obj.get("f_unitaddr").toString())){
						sql = sql + "f_address_detail ='" +obj.get("f_unitaddr").toString()+"',";
					}
				//7.区域   	f_area  默认：长安区
				//8.街道 		f_street
				if(!"null".equals(obj.get("f_road").toString())){
					sql = sql + "f_street ='" +obj.get("f_road").toString()+"',";
				}
				//9.小区  	f_residential_area
				if(!"null".equals(obj.get("f_unit").toString())){
					sql = sql + "f_residential_area ='" +obj.get("f_unit").toString()+"',";
				}
				//10.单元号 	f_unit
				if(!"null".equals(obj.get("cus_dy").toString())){
					sql = sql + "f_unit ='" +obj.get("cus_dy").toString()+"',";
				}
				//11.楼号 	f_building
				if(!"null".equals(obj.get("cus_dom").toString())){
					sql = sql + "f_building ='" +obj.get("cus_dom").toString()+"',";
				}
				//12.楼层 	f_floor
				if(!"null".equals(obj.get("cus_floor").toString())){
					sql = sql + "f_floor ='" +obj.get("cus_floor").toString()+"',";
				}
				//13.门牌号 	f_room
				if(!"null".equals(obj.get("cus_room").toString())){
					sql = sql + "f_room ='" +obj.get("cus_room").toString()+"',";
				}
//				//14.证件类型  	f_credentials 默认：身份证
//				//15.证件号码  	f_idnumber
				if(!"null".equals(obj.get("user_idnumber").toString())){
					sql = sql + "f_idnumber ='" +obj.get("user_idnumber").toString()+"',";
				}
				//16.电话	f_user_phone
				if(!"null".equals(obj.get("f_areaphone").toString())){
					sql = sql + "f_user_phone ='" +obj.get("f_areaphone").toString()+"',";
				}
				//17.用户类型		f_user_type
				if(!"null".equals(obj.get("f_usertype").toString())){
					sql = sql + "f_user_type ='" +obj.get("f_usertype").toString()+"',";
				}
				//18.用气性质		f_gasproperties
				if(!"null".equals(obj.get("f_gasequipment").toString())){
					sql = sql + "f_gasproperties ='" +obj.get("f_gasequipment").toString()+"',";
				}
				//19.建档日期		f_createfile_date
				if(!"null".equals(obj.get("f_intotime").toString())){
					sql = sql + "f_createfile_date =to_date('" +obj.get("f_intotime").toString()+"','yyyy-MM-dd hh24:mi:ss'),";
				}
				//20.建档人		f_operator
				if(!"null".equals(obj.get("f_customers").toString())){
					sql = sql + "f_operator ='" +obj.get("f_customers").toString()+"',";
				}
				//22.营业网点		f_outlets
				if(!"null".equals(obj.get("op_depart").toString())){
					sql = sql + "f_outlets ='" +obj.get("op_depart").toString()+"',";
				}
				//23.分公司		f_filiale 默认：榆林榆川天然气有限责任公司
				//24.合同编号		f_contract_id
				if(!"null".equals(obj.get("gq_htbh").toString())){
					sql = sql + "f_taxpayer_id ='" +obj.get("gq_htbh").toString()+"',";
				}
				//25.纳税人识别号		f_taxpayer_id
				if(!"null".equals(obj.get("taxcode").toString())){
					sql = sql + "f_taxpayer_id ='" +obj.get("taxcode").toString()+"',";
				}
				//26.地址电话		f_address_phone
				if(!"null".equals(obj.get("f_unitphone").toString())){
					sql = sql + "f_address_phone ='" +obj.get("f_unitphone").toString()+"',";
				}
				//27.名称	f_paper_name
				if(!"null".equals(obj.get("bankaccount").toString())){
					sql = sql + "f_paper_name ='" +obj.get("bankaccount").toString()+"',";
				}
				//28.开户行及账号		f_paper_account
				if(!"null".equals(obj.get("bankaccount").toString())){
					sql = sql + "f_paper_account ='" +obj.get("bankaccount").toString()+"',";
				}
				//30.微信绑定标识 		f_open_id
				if(!"null".equals(obj.get("f_open_id").toString())){
					sql = sql + "f_open_id ='" +obj.get("f_open_id").toString()+"',";
				}
				//31.备注信息 f_reason
				if(!"null".equals(obj.get("f_reamk").toString())){
					sql = sql + "f_paper_type ='" +obj.get("f_reamk").toString()+"',";
				}
				//33.实际账户结余(现有账户结余 - 欠费金额)	f_real_balance
				//35.片区	f_slice_area
				if(!"null".equals(obj.get("f_ic_distinct").toString())){
					sql = sql + "f_slice_area ='" +obj.get("f_ic_distinct").toString()+"',";
				}
				//36.租户电话		f_rent_phone
				//37.调压箱 		f_adjustable_id
				//38.人口数		f_people_num
				//39.组织机构 	f_orgstr
				//40.applyid对应报建id
				if(!"null".equals(obj.get("applyid").toString())){
					sql = sql + "applyid ='" +obj.get("applyid").toString()+"',";
				}
				//41.安装户数 	f_installnum
				//42.申请人姓名	f_petitionuser

				//43.报建编号	f_applycode
				if(!"null".equals(obj.get("applycode").toString())){
					sql = sql + "f_applycode ='" +obj.get("applycode").toString()+"',";
				}
				//44.气价编号
             if(!priceid.equals("")){
                 sql = sql + "f_price_id =" +Integer.parseInt(priceid)+",";
             }


				//45.最后安检日期
				//46.最后安检状态
				//47.公司机构id(单独的分公司id)
				//48.公司机构id(单独的分公司id)
				//49.银行
				//50.报建流程编号
				//51.用户剩余气量
				//52.地址机构 (单独的分公司id)
				//53.门牌号
		    } catch (JSONException e) {
		          e.printStackTrace();
		          log.debug(e.toString());
			}
		return sql;
	}

	public static String UpdateUserFiles(JSONObject obj)
	{
		//气表品牌关联id
		String gasbrandid= getGasbrandId(obj);
		//气表型号关联id
		String gasmodelid= getGasmodelId(obj);
		//气价关联id
		String priceid= getPriceId(obj);
		String sql = "update t_userfiles  set ";
		 try {
				//1.版本号	version
				//2.用户编号	f_userinfo_id
				//3.表安装位置	f_position
				//4.气表底数		f_meter_base
				if(!"null".equals(obj.get("f_tablemargin").toString())){
			 		sql = sql + "f_meter_base =" +Double.parseDouble(obj.get("f_tablemargin").toString())+",";
				}
				if(!"null".equals(obj.get("f_tablemargin").toString())){
			 		sql = sql + "f_real_base =" +Double.parseDouble(obj.get("f_tablemargin").toString())+",";
				}
				//5.初始气表底数	f_initial_base
				//6.表号
				if(!"null".equals(obj.get("f_tablesn").toString())){
			 		sql = sql + "f_meternumber ='" +obj.get("f_tablesn").toString()+"',";
				}
				//7.条码号	f_barcode
				if(!"null".equals(obj.get("f_barcode").toString())){
			 		sql = sql + "f_barcode ='" +obj.get("f_barcode").toString()+"',";
				}
				//8.卡号		f_card_id
				if(!"null".equals(obj.get("f_icsn").toString())){
					sql = sql + "f_card_id ='" +obj.get("f_icsn").toString()+"',";
				}
				//9.左 右 表	f_aroundmeter
				if(!"null".equals(obj.get("table_spot").toString())){
					sql = sql + "f_aroundmeter ='" +obj.get("table_spot").toString()+"',";
				}
				//10.卡密码	f_card_password
				//11.写卡次数		f_times
				if(!"null".equals(obj.get("buy_count").toString())){
					sql = sql + "f_times =" +Integer.parseInt(obj.get("buy_count").toString())+",";
				}
				//12.是否发卡		f_whether_hairpin
				if(!"null".equals(obj.get("use_notka").toString())){
					sql = sql + "f_whether_hairpin ='" +obj.get("use_notka").toString()+"',";
				}
				//13.气表分类		f_meter_classify
				if(!"null".equals(obj.get("f_basetablesn").toString())){
					sql = sql + "f_meter_classify ='" +obj.get("f_basetablesn").toString()+"',";
				}
				//14.气价关联id
				sql = sql + "f_price_id=" +Integer.parseInt(priceid)+",";
				//15.抄表员	f_inputtor
				if(!"null".equals(obj.get("f_screeners").toString())){
					sql = sql + "f_inputtor ='" +obj.get("f_screeners").toString()+"',";
				}
				//16.表状态（物联表状态是待发送/已发送/正常/停用）		f_table_state
				if(!"null".equals(obj.get("f_state").toString())){
					sql = sql + "f_table_state ='" +obj.get("f_state").toString()+"',";
				}else{
					sql = sql + "f_table_state ='启用',";
				}
				//17.录入日期		f_input_date
				if(!"null".equals(obj.get("cus_date").toString())){
					sql = sql + "f_input_date=to_date('" +obj.get("cus_date").toString()+"','yyyy-MM-dd hh24:mi:ss'),";
				}
				//18.气表品牌关联id f_gasbrand_id

				sql = sql + "f_gasbrand_id=" + Integer.parseInt(gasbrandid)+",";
				//19.气表型号关联id f_gasmodel_id
				sql = sql + "f_gasmodel_id=" + Integer.parseInt(gasmodelid)+",";
				//21.通气日期		f_gas_date
				//22.通气人		f_gas_person
				//23.安装人

				//24.表营业网点 	f_outlets
				if(!"null".equals(obj.get("op_depart").toString())){
					sql = sql + "f_outlets='" +obj.get("op_depart").toString()+"',";
				}
				//25.表分公司		f_filiale 默认:榆林榆川天然气有限责任公司
				//26.剩余补气量	f_remanent_gas
				if(!"null".equals(obj.get("user_type").toString())){
					//表用户类型 	f_user_type
					sql = sql + "f_user_type='" +obj.get("user_type").toString()+"',";
					//表用气性质	f_gasproperties
					sql = sql + "f_gasproperties='" +obj.get("user_equipment").toString()+"',";
				}
				//29.点火状态		f_fire_state
				//31.表累购气量	f_total_gas
				if(!"null".equals(obj.get("table_sum_gas").toString())){
			 		sql = sql + "f_total_gas =" +Double.parseDouble(obj.get("table_sum_gas").toString())+",";
				}

				//32.表累购金额	f_total_fee
				//33.户总累购气量		f_user_total_gas
				//34.户总累购金额		f_user_total_fee
				//35.总表ID		f_meter_id
				//36.总分表类型	f_meter_id
				//37.承担系数		f_share_ratio
				//38.表封号		f_metertitles
				//39.用户号		f_meterid
				//40.阀门状态（开阀/关阀）		f_valve_state
				//41.组织机构		f_orgstr
				//42.安装日期		f_install_date
				//43.通气人2		f_gas_person_2
				//44.通气日期2	f_gas_date_2
				//45.改管人		f_changetube_person
				//46.改管日期		f_changetube_date
				//47.表具图片		f_picture
				//48.剩余气量		f_balance_gas
				//49.显示方式		f_show_way
				//50.发送状态		f_sendsuccess
				//51.剩余金额		f_balance_amount
				//52.阶梯1气量	f_stair1_amount
				//53.阶梯2气量	f_stair2_amount
				//54.限购气量		f_purchaselimit
				//55.混合比率		f_price_ratio
				//56.净气量		f_input_gas
				//长安新增字段
				//1.表上期量

				//2.卡上期量
				if(!"null".equals(obj.get("f_icmargin").toString())){
			 		sql = sql + "f_icmargin =" +Double.parseDouble(obj.get("f_icmargin").toString())+",";
				}
				//3.是否是周检表
				if(!"null".equals(obj.get("f_weekcheck").toString())){
					sql = sql + "f_weekcheck ='" +obj.get("f_weekcheck").toString()+"',";
				}
				//4.周检表表号
				if(!"null".equals(obj.get("f_weekchecksn").toString())){
					sql = sql + "f_weekchecksn ='" +obj.get("f_weekchecksn").toString()+"',";
				}
				//5.周检表安装时间
				if(!"null".equals(obj.get("f_weekchecktime").toString())){
					sql = sql + "f_weekchecktime = to_date('" +obj.get("f_weekchecktime").toString()+"','yyyy-MM-dd hh24:mi:ss'),";
				}
				//6.周检表 安装时底数
				if(!"null".equals(obj.get("f_weekchecknum").toString())){
			 		sql = sql + "f_weekchecknum =" +Double.parseDouble(obj.get("f_weekchecknum").toString())+",";
				}
				//7.周检表 IC卡号
				if(!"null".equals(obj.get("f_weekcheckicsn").toString())){
			 		sql = sql + "f_weekcheckicsn =" +Double.parseDouble(obj.get("f_weekcheckicsn").toString())+",";
				}
				//8.周期表读数
				if(!"null".equals(obj.get("f_weekcheckdishu").toString())){
			 		sql = sql + "f_weekcheckdishu =" +Double.parseDouble(obj.get("f_weekcheckdishu").toString())+",";
				}
				//9.周检表 IC卡读
				if(!"null".equals(obj.get("f_weekcheckicdishu").toString())){
			 		sql = sql + "f_weekcheckicdishu =" +Double.parseDouble(obj.get("f_weekcheckicdishu").toString())+",";
				}
				//10.周检表安装时IC余量
				if(!"null".equals(obj.get("f_weekcheckicnum").toString())){
			 		sql = sql + "f_weekcheckicnum =" +Double.parseDouble(obj.get("f_weekcheckicnum").toString())+",";
				}
				//11.上次抄表时间
				if(!"null".equals(obj.get("f_lasttimecb").toString())){
					sql = sql + "f_lasttimecb = to_date('" +obj.get("f_lasttimecb").toString()+"','yyyy-MM-dd hh24:mi:ss'),";
				}
				//12.上次剩余金额
				if(!"null".equals(obj.get("f_iclastmoney").toString())){
			 		sql = sql + "f_iclastmoney =" +Double.parseDouble(obj.get("f_iclastmoney").toString())+",";
				}
				//13.表前球阀钢丝锁
				if(!"null".equals(obj.get("f_biaoqianqiu").toString())){
					sql = sql + "f_biaoqianqiu ='" +obj.get("f_biaoqianqiu").toString()+"',";
				}
				//14.表后球阀钢丝锁
				if(!"null".equals(obj.get("f_biaohouqiu").toString())){
					sql = sql + "f_biaohouqiu ='" +obj.get("f_biaohouqiu").toString()+"',";
				}
				//15.计量表钢丝锁
				if(!"null".equals(obj.get("f_jiliangbiaosuo").toString())){
					sql = sql + "f_jiliangbiaosuo ='" +obj.get("f_jiliangbiaosuo").toString()+"',";
				}
				//16.表拿子卡锁
				if(!"null".equals(obj.get("f_biaokasuo").toString())){
					sql = sql + "f_biaokasuo ='" +obj.get("f_biaokasuo").toString()+"',";
				}
				//17.计数器卡锁
				if(!"null".equals(obj.get("f_jishuqisuo").toString())){
					sql = sql + "f_jishuqisuo ='" +obj.get("f_jishuqisuo").toString()+"',";
				}
				//18.表具误差值
				if(!"null".equals(obj.get("f_tablewitherrorvalue").toString())){
			 		sql = sql + "f_tablewitherrorvalue =" +Double.parseDouble(obj.get("f_tablewitherrorvalue").toString())+",";
				}
				//19.上次购气未充值
				if(!"null".equals(obj.get("f_nogasvalue").toString())){
			 		sql = sql + "f_nogasvalue =" +Double.parseDouble(obj.get("f_nogasvalue").toString())+",";
				}
		    } catch (JSONException e) {
		          e.printStackTrace();
		          log.debug(e.toString());
			}
		return sql;
	}




	/**
	 * @param 气表品牌关联id
	 * @return
	 */
	private static String getGasbrandId(JSONObject obj) {
		String f_gasbrand_id = "";
		if(obj.get("meter_types_name").toString().equals("华捷加密(10)")){
			f_gasbrand_id = "466761";
		}else if(obj.get("meter_types_name").toString().equals("华捷普通(10)")){
			f_gasbrand_id = "466763";
		}else if(obj.get("meter_types_name").toString().equals("秦港")){
			f_gasbrand_id = "466766";
		}else if(obj.get("meter_types_name").toString().equals("秦川")){
			f_gasbrand_id = "466769";
		}else if(obj.get("meter_types_name").toString().equals("天庆")){
			f_gasbrand_id = "466771";
		}else if(obj.get("meter_types_name").toString().equals("致力老表")){
			f_gasbrand_id = "466774";
		}else if(obj.get("meter_types_name").toString().equals("赛福")){
			f_gasbrand_id = "466776";
		}else if(obj.get("meter_types_name").toString().equals("秦港工业")){
			f_gasbrand_id = "466805";
		}else if(obj.get("meter_types_name").toString().equals("华捷加密(12)")){
			f_gasbrand_id = "466808";
		}else if(obj.get("meter_types_name").toString().equals("华捷普通(12)")){
			f_gasbrand_id = "466783";
		}else if(obj.get("meter_types_name").toString().equals("天然气无线")){
			f_gasbrand_id = "466785";
		}else if(obj.get("meter_types_name").toString().equals("工业无线")){
			f_gasbrand_id = "466787";
		}else if(obj.get("meter_types_name").toString().equals("秦港民用无线")){
			f_gasbrand_id = "466789";
		}else if(obj.get("meter_types_name").toString().equals("秦港工业无线")){
			f_gasbrand_id = "466791";
		}else if(obj.get("meter_types_name").toString().equals("手抄表")){
			f_gasbrand_id = "466794";
		}else if(obj.get("meter_types_name").toString().equals("067非接触")){
			f_gasbrand_id = "466796";
		}else if(obj.get("meter_types_name").toString().equals("莱德非接触")){
			f_gasbrand_id = "466798";
		}else if(obj.get("meter_types_name").toString().equals("秦岭山水莱德普表")){
			f_gasbrand_id = "466801";
		}else{
			f_gasbrand_id = "466794";
		}
		return f_gasbrand_id;
	}


	/**
	 * @param 气表型号关联id
	 * @return
	 */
	private static String getGasmodelId(JSONObject obj) {
		String f_gasmodel_id = "";
		if(obj.get("meter_types_name").toString().equals("华捷加密(10)")){
			f_gasmodel_id = "466773";
		}else if(obj.get("meter_types_name").toString().equals("华捷普通(10)")){
			f_gasmodel_id = "466782";
		}else if(obj.get("meter_types_name").toString().equals("秦港")){
			f_gasmodel_id = "466768";
		}else if(obj.get("meter_types_name").toString().equals("秦川")){
			f_gasmodel_id = "466770";
		}else if(obj.get("meter_types_name").toString().equals("天庆")){
			f_gasmodel_id = "466772";
		}else if(obj.get("meter_types_name").toString().equals("致力老表")){
			f_gasmodel_id = "466775";
		}else if(obj.get("meter_types_name").toString().equals("赛福")){
			f_gasmodel_id = "466777";
		}else if(obj.get("meter_types_name").toString().equals("秦港工业")){
			f_gasmodel_id = "466807";
		}else if(obj.get("meter_types_name").toString().equals("华捷加密(12)")){
			f_gasmodel_id = "466809";
		}else if(obj.get("meter_types_name").toString().equals("华捷普通(12)")){
			f_gasmodel_id = "466784";
		}else if(obj.get("meter_types_name").toString().equals("天然气无线")){
			f_gasmodel_id = "466786";
		}else if(obj.get("meter_types_name").toString().equals("工业无线")){
			f_gasmodel_id = "466788";
		}else if(obj.get("meter_types_name").toString().equals("秦港民用无线")){
			f_gasmodel_id = "466790";
		}else if(obj.get("meter_types_name").toString().equals("秦港工业无线")){
			f_gasmodel_id = "466793";
		}else if(obj.get("meter_types_name").toString().equals("手抄表")){
			f_gasmodel_id = "466795";
		}else if(obj.get("meter_types_name").toString().equals("067非接触")){
			f_gasmodel_id = "466797";
		}else if(obj.get("meter_types_name").toString().equals("莱德非接触")){
			f_gasmodel_id = "466799";
		}else if(obj.get("meter_types_name").toString().equals("秦岭山水莱德普表")){
			f_gasmodel_id = "466802";
		}else{
			f_gasmodel_id = "466795";
		}
	return f_gasmodel_id;
	}


	/**
	 * @param 气价类型关联id
	 * @return
	 */
	private static String getPriceId(JSONObject obj) {
		String f_price_id = "";
		if(obj.get("f_usertype").toString().equals("工业")){
			f_price_id = "21";
		}else if(obj.get("f_usertype").toString().equals("商业")){
			f_price_id = "21";
		}else if(obj.get("f_usertype").toString().equals("加气站")){
			f_price_id = "21";
		}else if(obj.get("f_usertype").toString().equals("合表用户")){
			f_price_id = "21";
		}else {
			f_price_id = "22";
		}
		return f_price_id;
	}

	/**
	 * 获取户档案用户编号
	 * @param 单值名
	 * @return
	 */
//	private String getUserinfoidName(String name) {
//		String hql = "from t_userinfo where oldid='" + name + "'";
//		List<Map<String, Object>> list = this.hibernateTemplate.find(hql);
//		if (list.size() == 0) {
//			return null;
//		}
//		Map<String, Object> map = (Map<String, Object>) list.get(0);
//		return map.get("f_userinfo_id").toString();
//	}
	private String getUserinfoidName() {
		final String sql =  "select seq_userinfo_id.nextval from dual";
		List list = (List) hibernateTemplate
				.execute(new HibernateCallback() {
					public Object doInHibernate(Session session)
							throws HibernateException {
						SQLQuery query = session.createSQLQuery(sql);
						return query.list();
					}
				});
		if (list.size() == 0) {
			return null;
		}
		String userid = list.get(0).toString();
		return userid;
	}

	/**
	 * 产生post请求调取resetData接口获取t_usersback表中未提取的数据
	 */
	public static String callWebServiceByAixs(String url,
			String statedate,String endstate,String serviceEpr) {
		try {
			log.debug("请求地址"+url);
			log.debug("请求地址"+serviceEpr);
			String posturl =url+serviceEpr;
			log.debug("请求地址"+posturl);
			// 产生post请求
			HttpPost post = new HttpPost(posturl);

			String userdata = "{data:{startDate:"+statedate+",endDate:"+endstate+"}}";
			StringEntity se = new StringEntity(userdata, "UTF-8");
			post.setEntity(se);

			// 执行post请求
			HttpClient client = new DefaultHttpClient();
			HttpResponse response = client.execute(post);
			// 获取返回结果
			HttpEntity entity = response.getEntity();
			byte[] buf = EntityUtils.toByteArray(entity);
			String result = new String(buf, "UTF-8");
			log.debug(result);
			return result;
		} catch (Exception e) {
			return e.getMessage();
		}
	}

	/**
	 * 档案同步保存或修改完成，发送Update的post请求，
	 * 调取updateBackups接口修改t_usersback表的状态
	 */
	public static String UpdateWebService(String url,
			String statedate,String endstate,String oldid, String sell_id, String serviceEpr) {
		try {
			String posturl = url+serviceEpr;
			// 产生post请求
			HttpPost post = new HttpPost(posturl);

			String userdata = "{data:{flag:1,startDate:"+statedate+",endDate:"+endstate+",oldid:"+oldid+",sell_id:"+sell_id+"}}";
			StringEntity se = new StringEntity(userdata, "UTF-8");
			post.setEntity(se);

			// 执行post请求
			HttpClient client = new DefaultHttpClient();
			HttpResponse response = client.execute(post);
			// 获取返回结果
			HttpEntity entity = response.getEntity();
			byte[] buf = EntityUtils.toByteArray(entity);
			String result = new String(buf, "UTF-8");
			log.debug(result);
			return null;
		} catch (Exception e) {
			return e.getMessage();
		}
	}
	/**
	 * @param 单值名
	 * @return
	 */
	private String getSingleValueByName(String name) {
		String hql = "from t_singlevalue where name='" + name + "'";
		List<Map<String, Object>> list = (List<Map<String, Object>>) this.hibernateTemplate.find(hql);
		if (list.size() == 0) {
			return null;
		}
		Map<String, Object> map = (Map<String, Object>) list.get(0);
		return map.get("value").toString();
	}

	class HibernateSQLCall implements HibernateCallback {
		String sql;

		public HibernateSQLCall(String sql) {
			this.sql = sql;
		}

		public Object doInHibernate(Session session) {
			Query q = session.createSQLQuery(sql);
			q.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
			List result = q.list();
			return result;
		}
	}

}
