package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonTransfer;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import java.math.BigDecimal;
import java.util.Map;

/**
 * 长安发票服务
 */
@Path("caInvoice")
@Singleton
@Component
public class CAInvoiceService {

	static Logger log = Logger.getLogger(CAInvoiceService.class);
	@Autowired
	private SqlServer sqlServer;
	@Autowired
	private LogicServer logicServer;
	@Autowired
	private EntityServer entityServer;
	@POST
	@Path("searchcard")
	public String searchcard(String f_card_id)
			throws Exception {
		JSONObject res=new JSONObject();
		try {
			String statusmsg="查询成功";
			log.info("查询发票数据:" + f_card_id);
			//获取得到数据
			JSONObject json = new JSONObject();
			JSONObject data = new JSONObject();
			data.put("condition"," f_card_id='"+f_card_id+"' ");
			json.put("data",data);
			JSONArray invoice_list = sqlServer.query("get_invoice_state", json.toString());
			JSONArray arry=new JSONArray();
			if(invoice_list.length()==0){
				statusmsg="无此卡号信息";
			}
			for (int i=0;i<invoice_list.length();i++){
				JSONObject one= new JSONObject();
				JSONObject two=invoice_list.getJSONObject(i);
				if(two.has("f_bill_style")&&two.get("f_bill_style").toString().equals("电子发票")&&two.has("f_bill_state")&&two.get("f_bill_state").toString().equals("打票成功")){
					one.put("f_card_id",two.get("f_card_id"));
					one.put("f_operate_date",two.get("f_operate_date"));
					one.put("f_operator",two.get("f_operator"));
					one.put("op_spot",two.get("op_spot"));
					one.put("f_filiale",two.get("f_filiale"));
					one.put("f_outlets",two.get("f_outlets"));
					one.put("gas",two.get("f_pregas"));
					one.put("extaxamount",two.get("extaxamount"));
					one.put("taxamount",two.get("taxamount"));
					one.put("money",two.get("f_preamount"));
					one.put("statusmsg",two.get("statusmsg"));
					one.put("status",two.get("status"));
					one.put("f_serial_id",two.get("f_serial_id"));
					one.put("pdfurl",two.get("pdfurl"));
					one.put("pictureurl",two.get("pictureurl"));
					one.put("payername",two.get("payername"));
					one.put("orderno",two.get("orderno"));
					one.put("qrcode",two.get("qrcode"));
					one.put("serialno",two.get("serialno"));
					one.put("invoicekind",two.get("invoicekind"));
					one.put("f_bill_style",two.get("f_bill_style"));
					one.put("invoicecode",two.get("invoicecode"));
					one.put("invoiceno",two.get("invoiceno"));
					arry.put(one);
				}
			}
			res.put("data",arry);
			res.put("statusmsg",statusmsg);
			return  res.toString();
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			res.put("statusmsg","查询失败");
			return  res.toString();
		}
	}

}
